/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.server.ejb.container.codegen;

import com.evermind.compiler.Compilable;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.oracle.server.ejb.container.codegen.JasperConstants;
import com.oracle.server.ejb.container.codegen.JasperUtils;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import oracle.aurora.ncomp.java.ClassDeclaration;
import oracle.aurora.ncomp.java.Environment;
import oracle.aurora.ncomp.java.FieldDefinition;
import oracle.aurora.ncomp.java.Identifier;
import oracle.aurora.ncomp.java.Type;
import oracle.aurora.ncomp.javac.ClassDeclarationStack;
import oracle.aurora.ncomp.javac.ExpressionStack;
import oracle.aurora.ncomp.javac.ExtensibleBatchEnvironment;
import oracle.aurora.ncomp.javac.IdentifierStack;
import oracle.aurora.ncomp.javac.SourceClass;
import oracle.aurora.ncomp.javac.SourceField;
import oracle.aurora.ncomp.javac.SourcePrintStream;
import oracle.aurora.ncomp.javac.StatementStack;
import oracle.aurora.ncomp.javac.TypeStack;
import oracle.aurora.ncomp.tree.AndExpression;
import oracle.aurora.ncomp.tree.AssignExpression;
import oracle.aurora.ncomp.tree.BooleanExpression;
import oracle.aurora.ncomp.tree.CastExpression;
import oracle.aurora.ncomp.tree.CatchStatement;
import oracle.aurora.ncomp.tree.CompoundStatement;
import oracle.aurora.ncomp.tree.CompoundStatementSplicer;
import oracle.aurora.ncomp.tree.DeclarationStatement;
import oracle.aurora.ncomp.tree.EqualExpression;
import oracle.aurora.ncomp.tree.ExprExpression;
import oracle.aurora.ncomp.tree.Expression;
import oracle.aurora.ncomp.tree.ExpressionStatement;
import oracle.aurora.ncomp.tree.FieldExpression;
import oracle.aurora.ncomp.tree.FinallyStatement;
import oracle.aurora.ncomp.tree.IdentifierExpression;
import oracle.aurora.ncomp.tree.IfStatement;
import oracle.aurora.ncomp.tree.InstanceOfExpression;
import oracle.aurora.ncomp.tree.MethodExpression;
import oracle.aurora.ncomp.tree.NewInstanceExpression;
import oracle.aurora.ncomp.tree.Node;
import oracle.aurora.ncomp.tree.NotEqualExpression;
import oracle.aurora.ncomp.tree.NotExpression;
import oracle.aurora.ncomp.tree.NullExpression;
import oracle.aurora.ncomp.tree.ReturnStatement;
import oracle.aurora.ncomp.tree.Statement;
import oracle.aurora.ncomp.tree.ThrowStatement;
import oracle.aurora.ncomp.tree.TryStatement;
import oracle.aurora.ncomp.tree.TypeExpression;
import oracle.aurora.ncomp.tree.documentation.Documentation;

public abstract class JasperAbstractGenerator
implements JasperConstants,
Compilable {
    static String[] importClasses = new String[]{"java.rmi.RemoteException", "com.evermind.server.ThreadState", "com.evermind.server.ejb.interceptor.MethodState", "com.evermind.server.ejb.deployment.ExposableBeanDescriptor"};
    static String[] importPackages = new String[]{"com.evermind.server.ejb.*", "javax.ejb.*"};
    static Environment env = new ExtensibleBatchEnvironment();
    private ByteString m_source;
    protected Vector m_dependentClasses = new Vector();

    public void cleanSource() {
        this.m_source = null;
    }

    public ByteString getSource() {
        if (null == this.m_source) {
            this.m_source = this.generateSource();
        }
        return this.m_source;
    }

    public abstract String getName();

    protected abstract ByteString generateSource();

    static SourceField makeBeanOrHomeMethodDelegation(Method method, ContainerEntityDescriptor ed, boolean home, boolean local, String delegateMethodName) {
        Identifier methodStateName = Identifier.lookup((String)JasperUtils.gensym("methodState"));
        ExpressionStatement businessMethodBody = null;
        if (Void.TYPE != method.getReturnType()) {
            String returnTypeName = ClassUtils.getSourceNotation(method.getReturnType().getName(), 0, true);
            if (method.getReturnType().isPrimitive()) {
                String nonPrimitiveName = ClassUtils.getNonPrimitiveName(returnTypeName);
                String createPrimitiveMethodName = returnTypeName + "Value()";
                businessMethodBody = new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")), (Expression)new FieldExpression(0, (Expression)new ExprExpression(0, (Expression)new CastExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)nonPrimitiveName)), (Expression)new MethodExpression(0, null, Identifier.lookup((String)"OC4J_invokeMethod"), new ExpressionStack(3).push((Expression)new IdentifierExpression(0, methodStateName)).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"params"))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread"))).toArray()))), Identifier.lookup((String)createPrimitiveMethodName))));
            } else {
                businessMethodBody = method.getReturnType().getName() != "java.lang.Object" ? new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")), (Expression)new CastExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)returnTypeName)), (Expression)new MethodExpression(0, null, Identifier.lookup((String)"OC4J_invokeMethod"), new ExpressionStack(3).push((Expression)new IdentifierExpression(0, methodStateName)).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"params"))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread"))).toArray())))) : new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")), (Expression)new MethodExpression(0, null, Identifier.lookup((String)"OC4J_invokeMethod"), new ExpressionStack(3).push((Expression)new IdentifierExpression(0, methodStateName)).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"params"))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread"))).toArray())));
            }
        } else {
            businessMethodBody = new ExpressionStatement(0, (Expression)new MethodExpression(0, null, Identifier.lookup((String)"OC4J_invokeMethod"), new ExpressionStack(3).push((Expression)new IdentifierExpression(0, methodStateName)).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"params"))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread"))).toArray()));
        }
        return JasperAbstractGenerator.makeInterceptorBusinessMethod(method, methodStateName, ed, home, local, true, (Statement)businessMethodBody);
    }

    static SourceField makeInterceptorBusinessMethod(Method method, Identifier methodStateName, ContainerEntityDescriptor ed, boolean home, boolean local, boolean cloneReturn, Statement businessMethodBody) {
        Identifier methodName = Identifier.lookup((String)method.getName());
        Type returnType = Type.tType((String)JasperUtils.getJVMTypeString(method.getReturnType()));
        Identifier[] paramNames = JasperAbstractGenerator.makeBusinessMethodDeclarationArgListNames(method, "argument");
        Type[] paramTypes = JasperAbstractGenerator.makeBusinessMethodDeclarationArgListTypes(method);
        Class[] paramClasses = method.getParameterTypes();
        Identifier[] exceptions = JasperAbstractGenerator.makeBusinessMethodExceptions(method);
        businessMethodBody = JasperAbstractGenerator.addInitMethodState(local, home, method, paramNames, methodStateName, JasperAbstractGenerator.addArgumentAndResponseCloning(method, ed, home, local, cloneReturn, paramNames, paramClasses, JasperAbstractGenerator.addParamsToObjectArray(method, paramNames, JasperAbstractGenerator.addExceptionHandling(method, businessMethodBody))));
        return JasperUtils.extractFields(new SourceClass(env, 0, new ClassDeclaration(Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((String)"com"), (Identifier)Identifier.lookup((String)"oracle")), (Identifier)Identifier.lookup((String)"server")), (Identifier)Identifier.lookup((String)"ejb")), (Identifier)Identifier.lookup((String)"container")), (Identifier)Identifier.lookup((String)"codegen")), (Identifier)Identifier.lookup((String)"tmp"))), new Documentation("generated"), 0, new ClassDeclaration(Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((String)"java"), (Identifier)Identifier.lookup((String)"lang")), (Identifier)Identifier.lookup((String)"Object"))), new ClassDeclarationStack(0).toArray(), null, Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((Identifier)Identifier.lookup((String)"com"), (Identifier)Identifier.lookup((String)"oracle")), (Identifier)Identifier.lookup((String)"server")), (Identifier)Identifier.lookup((String)"ejb")), (Identifier)Identifier.lookup((String)"container")), (Identifier)Identifier.lookup((String)"codegen"))).add(env, (FieldDefinition)new SourceField(0, null, null, 10, Type.tType((Identifier)Identifier.lookup((String)"MethodState")), methodStateName, null, null, null)).add(env, (FieldDefinition)new SourceField(env, null, null, 1, Type.tMethod((Type)returnType, (Type[])new TypeStack(1).push(paramTypes).toArray()), methodName, new IdentifierStack(1).push(paramNames).toArray(), new IdentifierStack(1).push(exceptions).toArray(), (Node)new CompoundStatement(0, new StatementStack(3).push((Statement)new DeclarationStatement(0, 0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"ThreadState")), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), (Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"ThreadState")), Identifier.lookup((String)"getCurrentState"), new ExpressionStack(0).toArray()))).toArray())).push(JasperUtils.removeExtraBrackets(businessMethodBody)).push((Statement)new ExpressionStatement(0, null)).toArray()))));
    }

    static Identifier[] makeBusinessMethodExceptions(Method method) {
        Class<?>[] excs = method.getExceptionTypes();
        Identifier[] exIds = new Identifier[excs.length];
        for (int i = 0; i < excs.length; ++i) {
            exIds[i] = Identifier.lookup((String)JasperUtils.getSourceTypeString(excs[i]));
        }
        return exIds;
    }

    static Statement addInitMethodState(boolean local, boolean home, Method method, Identifier[] paramNames, Identifier methodStateName, Statement body) {
        String methodName = "\"" + method.getName() + ClassUtils.getCodedArguments(method) + "\"";
        return new CompoundStatement(0, new StatementStack(3).push((Statement)new IfStatement(0, (Expression)new EqualExpression(0, (Expression)new IdentifierExpression(0, methodStateName), (Expression)new NullExpression(0)), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, methodStateName), (Expression)new MethodExpression(0, (Expression)new ExprExpression(0, (Expression)new CastExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"ExposableBeanDescriptor")), (Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, JasperUtils.makeHomeReference(home)), Identifier.lookup((String)"getBeanDescriptor"), new ExpressionStack(0).toArray()))), Identifier.lookup((String)"getMethodState"), new ExpressionStack(3).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)(local ? "true" : "false")))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)(home ? "true" : "false")))).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)methodName))).toArray())))).toArray()), null)).push(body).push((Statement)new ExpressionStatement(0, null)).toArray());
    }

    private static Statement addArgumentAndResponseCloning(Method method, ContainerEntityDescriptor ed, boolean home, boolean local, boolean doClone, Identifier[] parameterNames, Class[] parameterClasses, Statement body) {
        Class<?> returnType = method.getReturnType();
        DeclarationStatement initResponseStatement = null;
        Object cloneResponseStatement = null;
        if (returnType != Void.TYPE) {
            initResponseStatement = new DeclarationStatement(0, 0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)JasperUtils.getSourceTypeString(method.getReturnType()))), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")), JasperUtils.getDefaultValueExpression(method.getReturnType()))).toArray());
            cloneResponseStatement = doClone && !local && ed.getEntityBeanDescriptor().isCopyByValue() && JasperAbstractGenerator.needsCloneToPassByValue(returnType) ? JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(2).push((Statement)new IfStatement(0, (Expression)new NotEqualExpression(0, (Expression)new NullExpression(0), (Expression)new FieldExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), Identifier.lookup((String)"contextContainer"))), (Statement)new CompoundStatement(0, new StatementStack(2).push(JasperAbstractGenerator.maybeCloneVariable(Identifier.lookup((String)"response"), method.getReturnType(), home, local)).push((Statement)new ExpressionStatement(0, null)).toArray()), null)).push((Statement)new ReturnStatement(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")))).toArray())) : new ReturnStatement(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"response")));
        }
        return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(9).push(JasperUtils.codeGenDebug("BEGIN: Argument/Response Cloning")).push((Statement)new ExpressionStatement(0, null)).push(initResponseStatement).push((Statement)new ExpressionStatement(0, null)).push((Statement)new DeclarationStatement(0, 0, (Expression)new TypeExpression(0, Type.tType((String)"Z")), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnStack")), (Expression)new BooleanExpression(0, false))).toArray())).push((Statement)new DeclarationStatement(0, 0, (Expression)new TypeExpression(0, Type.tType((String)"Z")), new ExpressionStack(1).push((Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnRMIStack")), (Expression)new BooleanExpression(0, false))).toArray())).push((Statement)new FinallyStatement(0, (Statement)new CompoundStatement(0, new StatementStack(6).push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnStack")), (Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), Identifier.lookup((String)"getAndReset_firstEJBOnStack"), new ExpressionStack(0).toArray())))).push((Statement)new IfStatement(0, (Expression)new AndExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnStack")), (Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), Identifier.lookup((String)"isRMICall"), new ExpressionStack(0).toArray())), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnRMIStack")), (Expression)new BooleanExpression(0, true)))).toArray()), null)).push(!doClone ? null : JasperAbstractGenerator.makeArgumentCloningBlock(parameterNames, parameterClasses, ed, home, local)).push((Statement)new ExpressionStatement(0, null)).push(body).push((Statement)new ExpressionStatement(0, null)).toArray()), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new IfStatement(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnStack")), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ExpressionStatement(0, (Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), Identifier.lookup((String)"set_firstEJBOnStack"), new ExpressionStack(0).toArray()))).toArray()), null)).toArray()))).push((Statement)cloneResponseStatement).push((Statement)new ExpressionStatement(0, null)).toArray()));
    }

    static Statement addParamsToObjectArray(Method method, Identifier[] paramNames, Statement body) {
        return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(4).push(JasperUtils.makeObjectArrayInit(Identifier.lookup((String)"params"), paramNames, method)).push((Statement)new ExpressionStatement(0, null)).push(body).push((Statement)new ExpressionStatement(0, null)).toArray()));
    }

    static boolean needsCloneToPassByValue(Class type) {
        if (JasperUtils.isPrimitiveOrBoxed(type)) {
            return false;
        }
        for (int i = 0; i < DONT_CLONE_WHEN_PASSING_BY_VALUE.length; ++i) {
            if (!DONT_CLONE_WHEN_PASSING_BY_VALUE[i].isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    static Statement maybeCloneVariable(Identifier argumentName, Class type, boolean home, boolean local) {
        Statement cloneStatement = null;
        if (!(!JasperAbstractGenerator.needsCloneToPassByValue(type) || javax_ejb_EJBLocalObject_CLASS.isAssignableFrom(type) && javax_ejb_EJBLocalHome_CLASS.isAssignableFrom(type))) {
            if (java_util_Date_CLASS.isAssignableFrom(type) || java_sql_Date_CLASS.isAssignableFrom(type) || java_sql_Timestamp_CLASS.isAssignableFrom(type)) {
                return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new IfStatement(0, (Expression)new NotEqualExpression(0, (Expression)new NullExpression(0), (Expression)new IdentifierExpression(0, argumentName)), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, argumentName), (Expression)new NewInstanceExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)type.getName())), new ExpressionStack(1).push((Expression)new MethodExpression(0, (Expression)new IdentifierExpression(0, argumentName), Identifier.lookup((String)"getTime"), new ExpressionStack(0).toArray())).toArray())))).toArray()), null)).toArray()));
            }
            return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new IfStatement(0, (Expression)new NotEqualExpression(0, (Expression)new NullExpression(0), (Expression)new IdentifierExpression(0, argumentName)), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ExpressionStatement(0, (Expression)new AssignExpression(0, (Expression)new IdentifierExpression(0, argumentName), (Expression)new CastExpression(0, (Expression)new IdentifierExpression(0, JasperUtils.getSourceTypeString(type)), (Expression)new MethodExpression(0, null, Identifier.lookup((String)("EJBUtils.clone" + (local ? "LocalObject" : "Object"))), new ExpressionStack(2).push((Expression)new IdentifierExpression(0, argumentName)).push((Expression)new IdentifierExpression(0, JasperUtils.makeHomeReference(home))).toArray()))))).toArray()), null)).toArray()));
        }
        return cloneStatement;
    }

    static Statement makeArgumentCloningBlock(Identifier[] names, Class[] args, ContainerEntityDescriptor ed, boolean home, boolean local) {
        if (!local && ed.getEntityBeanDescriptor().isCopyByValue()) {
            StatementStack cloneStatements = new StatementStack(args.length);
            for (int i = 0; i < args.length; ++i) {
                Statement clone = JasperAbstractGenerator.maybeCloneVariable(names[i], args[i], home, local);
                if (null == clone) continue;
                cloneStatements.push(clone);
            }
            if (cloneStatements.size() > 0) {
                return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new IfStatement(0, (Expression)new AndExpression(0, (Expression)new ExprExpression(0, (Expression)new NotEqualExpression(0, (Expression)new NullExpression(0), (Expression)new FieldExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"thread")), Identifier.lookup((String)"contextContainer")))), (Expression)new NotExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"firstEJBOnRMIStack")))), (Statement)new CompoundStatement(0, new StatementStack(2).push((Statement)new CompoundStatementSplicer(0, cloneStatements.toArray())).push((Statement)new ExpressionStatement(0, null)).toArray()), null)).toArray()));
            }
        }
        return null;
    }

    static Type[] makeBusinessMethodDeclarationArgListTypes(Method method) {
        Class<?>[] methodArgs = method.getParameterTypes();
        Type[] types = new Type[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            types[i] = Type.tType((String)JasperUtils.getJVMTypeString(methodArgs[i]));
        }
        return types;
    }

    static Identifier[] makeBusinessMethodDeclarationArgListNames(Method method, String prefix) {
        Identifier[] ids = new Identifier[method.getParameterTypes().length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Identifier.lookup((String)(prefix + i));
        }
        return ids;
    }

    static String stringify(Vector forms) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        SourcePrintStream sps = new SourcePrintStream((OutputStream)s);
        sps.printIdentifiers = 1;
        JasperUtils.print(forms, sps);
        return s.toString();
    }

    protected static void createListOfNamesOfPrivateClasses(Vector src, Vector list) {
        Enumeration enumeration = src.elements();
        while (enumeration.hasMoreElements()) {
            SourceClass tmp = (SourceClass)enumeration.nextElement();
            if (tmp == null) continue;
            String fullClassName = tmp.getName().toString();
            String name = fullClassName.substring(fullClassName.lastIndexOf(46) + 1, fullClassName.length());
            list.add(name);
        }
    }

    public Vector getDependentClasses() {
        return this.m_dependentClasses;
    }

    static Statement addExceptionHandling(Method method, Statement body) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        StatementStack bag = new StatementStack(exceptionTypes.length + 5);
        for (int i = 0; i < exceptionTypes.length; ++i) {
            bag.push(JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new IfStatement(0, (Expression)new InstanceOfExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"e")), (Expression)new IdentifierExpression(0, Identifier.lookup((String)exceptionTypes[i].getName()))), (Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new ThrowStatement(0, (Expression)new CastExpression(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)exceptionTypes[i].getName())), (Expression)new IdentifierExpression(0, Identifier.lookup((String)"e"))))).toArray()), null)).toArray())));
        }
        return JasperUtils.removeExtraBrackets((Statement)new CompoundStatement(0, new StatementStack(1).push((Statement)new TryStatement(0, (Statement)new CompoundStatement(0, new StatementStack(2).push(body).push((Statement)new ExpressionStatement(0, null)).toArray()), new StatementStack(1).push((Statement)new CatchStatement(0, (Expression)new IdentifierExpression(0, Identifier.lookup((String)"Exception")), Identifier.lookup((String)"e"), (Statement)new CompoundStatement(0, new StatementStack(3).push((Statement)new CompoundStatementSplicer(0, bag.toArray())).push((Statement)new ExpressionStatement(0, null)).push((Statement)new ExpressionStatement(0, (Expression)new MethodExpression(0, null, Identifier.lookup((String)"__throwUncheckedException"), new ExpressionStack(1).push((Expression)new IdentifierExpression(0, Identifier.lookup((String)"e"))).toArray()))).toArray()))).toArray())).toArray()));
    }
}

