/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.util.EJBProperties;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import oracle.oc4j.corba.util.LocalStringManagerImpl;

public final class PersistenceDescriptor
extends Descriptor {
    public static final String DELETE_ROW = "deleteRow";
    public static final String CREATE_ROW = "createRow";
    public static final String LOAD_ROW = "loadRow";
    public static final String STORE_ROW = "storeRow";
    public static final String CREATE_TABLE = "createTable";
    public static final String DELETE_TABLE = "deleteTable";
    public static final String FINDBYPRIMARYKEY = "findByPrimaryKey";
    public static final String FINDBYSOURCEKEY = "findBySourceKey";
    public static final String FINDBYSINKKEY = "findBySinkKey";
    private Set cmpFields = new HashSet();
    private Set pkeyFields = new HashSet();
    private boolean pkeyIsOneField = false;
    private boolean pkeyFieldSpecified = true;
    private String primaryKeyClassName;
    private boolean pkeyStuffInitialized = false;
    private boolean pkeyFieldsAllPrimitive = false;
    private Set allSqlStatementedMethods;
    private Hashtable methodSqlMap = new Hashtable();
    private boolean createTableOnDeployment = true;
    private boolean deleteTableOnUndeployment = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PersistenceDescriptor.class);
    private Descriptor parentDesc;
    private Class persistentClass;
    private Class stateClass;
    private Class primaryKeyClass;
    private PersistentFieldInfo[] persFieldInfo;
    private PersistentFieldInfo[] persNoPkeyFieldInfo;
    private PersistentFieldInfo[] pkeyFieldInfo;
    private boolean fieldInfoInitialized = false;
    private PersistentFieldInfo[] fkeyFields;
    private CMRFieldInfo[] cmrFieldInfo;
    private Field[] pkeyClassPkeyFields;
    private Hashtable queries = new Hashtable();
    private HashSet allQueriedMethods;
    private String tableName;
    static String unspecifiedPkeyFieldName = "<<auto id>>";
    private EntityBeanDescriptor oc4jEntity;

    public PersistenceDescriptor() {
    }

    public PersistenceDescriptor(PersistenceDescriptor pers) {
        super(pers);
        this.getCMPFields().addAll(pers.getCMPFields());
        this.methodSqlMap = new Hashtable(pers.getMethodSqlMap());
        this.createTableOnDeployment = pers.createTableOnDeployment;
        this.deleteTableOnUndeployment = pers.deleteTableOnUndeployment;
    }

    public String getCMRFieldReturnType(String field) {
        String returnType;
        block3: {
            returnType = "java.util.Collection";
            try {
                if (!field.trim().equals("")) {
                    Class persClass = this.getPersistentClass();
                    String methodName = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
                    Method method = TypeUtil.getMethod(persClass, persClass.getClassLoader(), methodName, new String[0]);
                    returnType = method.getReturnType().getName();
                }
            }
            catch (Throwable t) {
                if (!EJBProperties.getEJBQLDebugPersistenceDescriptor()) break block3;
                t.printStackTrace();
            }
        }
        return returnType;
    }

    public boolean classesChanged() {
        FieldDescriptor primKeyFieldDesc;
        FieldDescriptor next;
        Iterator iter;
        this.persistentClass = null;
        this.stateClass = null;
        Class persClass = this.getPersistentClass();
        EjbCMPEntityDescriptor ejb = (EjbCMPEntityDescriptor)this.parentDesc;
        Vector fieldDescriptors = ejb.getFieldDescriptors();
        if (this.cmpFields != null) {
            iter = this.cmpFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if (this.pkeyFields != null) {
            iter = this.pkeyFields.iterator();
            while (iter.hasNext()) {
                next = (FieldDescriptor)iter.next();
                if (fieldDescriptors.contains(next)) continue;
                iter.remove();
            }
        }
        if ((primKeyFieldDesc = ejb.getPrimaryKeyFieldDesc()) != null && !fieldDescriptors.contains(primKeyFieldDesc)) {
            ejb.setPrimaryKeyFieldDesc(null);
        }
        Hashtable queriesClone = (Hashtable)this.queries.clone();
        this.queries = new Hashtable();
        this.initializeAllQueriedMethods();
        Iterator it = queriesClone.keySet().iterator();
        while (it.hasNext()) {
            Method oldMethod = (Method)it.next();
            Method newMethod = this.findEquivalentMethod(this.allQueriedMethods, oldMethod);
            if (newMethod == null) continue;
            QueryDescriptor oldQuery = (QueryDescriptor)queriesClone.get(oldMethod);
            QueryDescriptor newQuery = new QueryDescriptor(oldQuery, newMethod);
            this.queries.put(newMethod, newQuery);
        }
        this.invalidate();
        return false;
    }

    private Method findEquivalentMethod(Collection methods, Method methodToMatch) {
        Method matchedMethod = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            if (!this.methodsEqual(next, methodToMatch, false)) continue;
            matchedMethod = next;
            break;
        }
        return matchedMethod;
    }

    private boolean methodsEqual(Method m1, Method m2, boolean compareDeclaringClass) {
        String m2Name;
        boolean equal = false;
        String m1Name = m1.getName();
        if (m1Name.equals(m2Name = m2.getName())) {
            Class<?>[] m2ParamTypes;
            Class<?>[] m1ParamTypes;
            String m1DeclaringClass = m1.getDeclaringClass().getName();
            String m2DeclaringClass = m2.getDeclaringClass().getName();
            if ((!compareDeclaringClass || m1DeclaringClass.equals(m2DeclaringClass)) && (m1ParamTypes = m1.getParameterTypes()).length == (m2ParamTypes = m2.getParameterTypes()).length) {
                equal = true;
                for (int pIndex = 0; pIndex < m1ParamTypes.length; ++pIndex) {
                    String m2ParamClass;
                    String m1ParamClass = m1ParamTypes[pIndex].getName();
                    if (m1ParamClass.equals(m2ParamClass = m2ParamTypes[pIndex].getName())) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    public void setParentDescriptor(Descriptor parentDesc) {
        this.parentDesc = parentDesc;
    }

    public Descriptor getParentDescriptor() {
        return this.parentDesc;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        EjbBundleDescriptor bundleDescriptor;
        if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor beanDesc = (EjbCMPEntityDescriptor)this.parentDesc;
            bundleDescriptor = beanDesc.getEjbBundleDescriptor();
        } else {
            JoinObjectDescriptor jDesc = (JoinObjectDescriptor)this.parentDesc;
            bundleDescriptor = jDesc.getEjbBundleDescriptor();
        }
        return bundleDescriptor;
    }

    public Set getRelationships() {
        Set allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationshipDescriptor> myRelationships = new HashSet<RelationshipDescriptor>();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            RelationshipDescriptor next = (RelationshipDescriptor)iter.next();
            if (!next.hasParticipant(this.parentDesc)) continue;
            myRelationships.add(next);
        }
        return myRelationships;
    }

    public Set getSourceRoles() {
        Set allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationRoleDescriptor> myRoles = new HashSet<RelationRoleDescriptor>();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            RelationshipDescriptor next = (RelationshipDescriptor)iter.next();
            RelationRoleDescriptor role = next.getSource();
            if (role.getOwner() != this.parentDesc) continue;
            myRoles.add(role);
        }
        return myRoles;
    }

    public Set getSinkRoles() {
        Set allRelationships = this.getEjbBundleDescriptor().getRelationships();
        HashSet<RelationRoleDescriptor> myRoles = new HashSet<RelationRoleDescriptor>();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            RelationshipDescriptor next = (RelationshipDescriptor)iter.next();
            RelationRoleDescriptor role = next.getSink();
            if (role.getOwner() != this.parentDesc) continue;
            myRoles.add(role);
        }
        return myRoles;
    }

    public CMRFieldInfo[] getCMRFieldInfo() {
        if (this.cmrFieldInfo == null) {
            try {
                this.initCMRFieldStuff();
            }
            catch (Exception ex) {
                if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
                    ex.printStackTrace();
                }
                Log.err.println(ex);
                throw new EJBException(ex);
            }
        }
        return this.cmrFieldInfo;
    }

    public CMRFieldInfo getCMRFieldInfoByName(String fieldName) {
        CMRFieldInfo[] cmrf = this.getCMRFieldInfo();
        for (int i = 0; i < cmrf.length; ++i) {
            if (!cmrf[i].name.equals(fieldName)) continue;
            return cmrf[i];
        }
        throw new EJBException("CMRFieldInfo not found for field " + fieldName);
    }

    public void invalidate() {
        this.cmrFieldInfo = null;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        this.pkeyStuffInitialized = false;
    }

    private void initCMRFieldStuff() throws Exception {
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            this.cmrFieldInfo = new CMRFieldInfo[0];
            return;
        }
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        boolean isRuntime = false;
        if (this.getPersistentClass() != null && !Modifier.isAbstract(this.getPersistentClass().getModifiers())) {
            isRuntime = true;
        }
        Set relationships = this.getRelationships();
        Iterator it = relationships.iterator();
        this.cmrFieldInfo = new CMRFieldInfo[relationships.size()];
        int count = 0;
        while (it.hasNext()) {
            String type;
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor myrole = source.getPersistenceDescriptor() == this ? source : rd.getSink();
            CMRFieldInfo finfo = new CMRFieldInfo();
            this.cmrFieldInfo[count++] = finfo;
            PersistenceDescriptor partnerPers = myrole.getPartner().getPersistenceDescriptor();
            EjbCMPEntityDescriptor partner = myrole.getPartner().getOwner();
            if (!partner.isLocalInterfacesSupported() && myrole.getCMRField() != null) {
                throw new RuntimeException("No local interface for target bean of CMR field");
            }
            if (!myrole.getPartner().getIsMany()) {
                type = partner.isLocalInterfacesSupported() ? partner.getLocalClassName() : partner.getPrimaryKeyClassName();
            } else {
                type = myrole.getCMRFieldType();
                if (type == null) {
                    type = "java.util.Collection";
                }
            }
            finfo.type = this.getClass(type);
            finfo.name = myrole.getCMRField();
            if (finfo.name == null) {
                finfo.name = PersistenceDescriptor.makeReverseFkeyName(myrole);
            }
            finfo.role = myrole;
            myrole.setCMRFieldInfo(finfo);
            if (isRuntime) {
                finfo.field = this.getStateClass().getField(finfo.name);
            }
            if (!this.roleMapsToAForeignKey(myrole) || this.fkeyFields == null) continue;
            PersistentFieldInfo[] partnerPkeyFields = partnerPers.getPkeyFieldInfo();
            PersistentFieldInfo[] cmrFkeyFields = new PersistentFieldInfo[partnerPkeyFields.length];
            for (int i = 0; i < partnerPkeyFields.length; ++i) {
                String fkeyName = PersistenceDescriptor.makeFkeyName(finfo, partnerPkeyFields[i], i, partnerPkeyFields.length);
                for (int j = 0; j < this.fkeyFields.length; ++j) {
                    if (!this.fkeyFields[j].name.equals(fkeyName)) continue;
                    cmrFkeyFields[i] = this.fkeyFields[j];
                }
            }
            finfo.fkeyFields = cmrFkeyFields;
        }
        for (int i = this.cmrFieldInfo.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.cmrFieldInfo[j].name.compareTo(this.cmrFieldInfo[j + 1].name) <= 0) continue;
                CMRFieldInfo tmp = this.cmrFieldInfo[j];
                this.cmrFieldInfo[j] = this.cmrFieldInfo[j + 1];
                this.cmrFieldInfo[j + 1] = tmp;
            }
        }
    }

    public void clearCMPFields() {
        this.cmpFields.clear();
        this.setCMPFields(this.cmpFields);
    }

    public void addCMPField(String field) {
        this.addCMPField(new FieldDescriptor(field));
    }

    public void addCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.add(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void removeCMPField(String field) {
        this.removeCMPField(new FieldDescriptor(field));
    }

    public void removeCMPField(FieldDescriptor fieldDesc) {
        this.cmpFields.remove(fieldDesc);
        this.setCMPFields(this.cmpFields);
    }

    public void setCMPFields(Set cmpFields) {
        this.cmpFields = cmpFields;
        this.persFieldInfo = null;
        this.fieldInfoInitialized = false;
        super.changed();
    }

    public boolean isCMPField(String field) {
        return this.getCMPFields().contains(new FieldDescriptor(field));
    }

    public Set getCMPFields() {
        return this.cmpFields;
    }

    public void setPkeyFields(Set pkeyFields) {
        this.pkeyFields = pkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        this.pkeyStuffInitialized = false;
        super.changed();
    }

    public Set getPkeyFields() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFields;
    }

    public boolean isPkeyField(String field) {
        return this.isPkeyField(new FieldDescriptor(field));
    }

    public boolean isPkeyField(FieldDescriptor fieldDesc) {
        return this.getPkeyFields().contains(fieldDesc);
    }

    private void initPkeyInfo() {
        try {
            this.pkeyIsOneField = false;
            this.pkeyFieldSpecified = true;
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor dd = (EjbCMPEntityDescriptor)this.parentDesc;
                this.primaryKeyClassName = dd.getPrimaryKeyClassName();
                FieldDescriptor fd = dd.getPrimaryKeyFieldDesc();
                if (this.pkeyFields == null || this.pkeyFields.size() == 0) {
                    this.pkeyFields = new HashSet();
                    if (fd != null) {
                        this.pkeyFields.add(fd);
                    } else if (!this.primaryKeyClassName.equals("java.lang.Object")) {
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        Field[] fields = this.primaryKeyClass.getFields();
                        this.pkeyFieldsAllPrimitive = true;
                        for (int i = 0; i < fields.length; ++i) {
                            int m = fields[i].getModifiers();
                            if (Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
                            if (!fields[i].getType().isPrimitive()) {
                                this.pkeyFieldsAllPrimitive = false;
                            }
                            this.pkeyFields.add(new FieldDescriptor(fields[i].getName()));
                        }
                    } else {
                        this.primaryKeyClassName = "java.lang.Long";
                        this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                        this.pkeyIsOneField = true;
                        this.pkeyFieldSpecified = false;
                    }
                }
                if (fd != null) {
                    this.pkeyIsOneField = true;
                }
            } else {
                JoinObjectDescriptor dd = (JoinObjectDescriptor)this.parentDesc;
                this.primaryKeyClassName = dd.getJoinObjectClass();
                try {
                    this.primaryKeyClass = this.getClass(this.primaryKeyClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.pkeyStuffInitialized = true;
        }
        catch (Exception ex) {
            if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
                ex.printStackTrace();
            }
            Log.err.println(ex);
            throw new EJBException(ex);
        }
    }

    public boolean primaryKeyIsOneField() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyIsOneField;
    }

    public boolean primaryKeyIsSpecified() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldSpecified;
    }

    public boolean primaryKeyFieldsAllPrimitive() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.pkeyFieldsAllPrimitive;
    }

    public Class getPrimaryKeyClass() {
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        return this.primaryKeyClass;
    }

    public Class getPersistentClass() {
        if (this.persistentClass == null) {
            if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(entd.getEjbClassName());
            } else {
                JoinObjectDescriptor dd = (JoinObjectDescriptor)this.parentDesc;
                this.persistentClass = this.getClass(dd.getJoinObjectClass());
            }
        }
        return this.persistentClass;
    }

    public Class getStateClass() {
        if (this.stateClass == null) {
            EjbCMPEntityDescriptor entd;
            this.stateClass = this.getPersistentClass();
            if (this.parentDesc instanceof EjbCMPEntityDescriptor && (entd = (EjbCMPEntityDescriptor)this.parentDesc).isEJB20()) {
                String stateClassName = entd.getStateImplClassName();
                this.stateClass = this.getClass(stateClassName);
            }
        }
        return this.stateClass;
    }

    private Class getClass(String className) {
        try {
            EjbBundleArchivist arch = (EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist();
            return arch.getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void setFkeyFields(PersistentFieldInfo[] fkeyFields) {
        this.fkeyFields = fkeyFields;
        this.fieldInfoInitialized = false;
        this.persFieldInfo = null;
        super.changed();
    }

    public PersistentFieldInfo[] getFkeyFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.fkeyFields;
    }

    public PersistentFieldInfo[] getPersistentFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persFieldInfo;
    }

    public PersistentFieldInfo getPersistentFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.persFieldInfo.length; ++i) {
            if (!this.persFieldInfo[i].name.equals(fieldName)) continue;
            return this.persFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for field " + fieldName);
    }

    public PersistentFieldInfo[] getNonPkeyPersFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.persNoPkeyFieldInfo;
    }

    public PersistentFieldInfo[] getPkeyFieldInfo() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyFieldInfo;
    }

    public PersistentFieldInfo getPkeyFieldInfoByName(String fieldName) {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        for (int i = 0; i < this.pkeyFieldInfo.length; ++i) {
            if (!this.pkeyFieldInfo[i].name.equals(fieldName)) continue;
            return this.pkeyFieldInfo[i];
        }
        throw new EJBException("PersistentFieldInfo not found for pkey field " + fieldName);
    }

    public Field[] getPkeyClassFields() {
        if (!this.fieldInfoInitialized) {
            this.initializeFieldInfo();
        }
        return this.pkeyClassPkeyFields;
    }

    public static String makeJoinFieldSource(RelationRoleDescriptor source, PersistentFieldInfo sourcePkeyField, int idx) {
        String cmrName = PersistenceDescriptor.makeCMRName(source);
        if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
            System.out.println("-- cmrName: " + cmrName);
        }
        String joinField = ContainerManagedField.getAssocTableFieldCanonicalName(source.getOwner().getName(), cmrName, sourcePkeyField.name);
        return joinField;
    }

    public static String makeJoinFieldSink(RelationRoleDescriptor sink, PersistentFieldInfo sinkPkeyField, int idx) {
        String cmrName = PersistenceDescriptor.makeCMRName(sink);
        if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
            System.out.println("-- cmrName: " + cmrName);
        }
        String joinField = ContainerManagedField.getAssocTableFieldCanonicalName(sink.getOwner().getName(), cmrName, sinkPkeyField.name);
        return joinField;
    }

    public static String makeFkeyName(CMRFieldInfo finfo, PersistentFieldInfo pkeyField, int idx, int size) {
        return PersistenceDescriptor.makeFkeyName(finfo.name, pkeyField, idx, size);
    }

    public static String makeFkeyName(String finfoName, PersistentFieldInfo pkeyField, int idx, int size) {
        if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
            System.out.println("-- finfoName: " + finfoName);
            System.out.println("-- size: " + size);
        }
        if (size == 1) {
            return finfoName;
        }
        return finfoName + "_" + pkeyField.name;
    }

    public static String makeCMRName(RelationRoleDescriptor myrole) {
        String cmrName = myrole.getCMRField();
        if (cmrName == null) {
            cmrName = PersistenceDescriptor.makeReverseFkeyName(myrole);
        }
        return cmrName;
    }

    public static String makeReverseFkeyName(RelationRoleDescriptor myrole) {
        String partnerName = myrole.getPartner().getOwner().getName();
        String partnerCMRFieldName = myrole.getPartner().getCMRField();
        String result = "";
        if (partnerName != null) {
            result = result + partnerName + "_";
        }
        if (partnerCMRFieldName != null) {
            result = result + partnerCMRFieldName;
        }
        return result;
    }

    private void initializeFieldInfo() {
        int i;
        int i2;
        if (!this.pkeyStuffInitialized) {
            this.initPkeyInfo();
        }
        int cmpFieldCount = this.cmpFields.size();
        if (!this.pkeyFieldSpecified) {
            ++cmpFieldCount;
        }
        int fkeyCount = 0;
        if (this.fkeyFields != null) {
            fkeyCount = this.fkeyFields.length;
        }
        this.persFieldInfo = new PersistentFieldInfo[cmpFieldCount + fkeyCount];
        int fcount = 0;
        Iterator itr = this.cmpFields.iterator();
        while (itr.hasNext()) {
            this.persFieldInfo[fcount] = new PersistentFieldInfo();
            this.persFieldInfo[fcount].name = ((FieldDescriptor)itr.next()).getName();
            ++fcount;
        }
        if (this.fkeyFields != null) {
            for (i2 = 0; i2 < this.fkeyFields.length; ++i2) {
                this.persFieldInfo[fcount] = this.fkeyFields[i2];
                ++fcount;
            }
        }
        if (!this.pkeyFieldSpecified) {
            PersistentFieldInfo pkField = new PersistentFieldInfo();
            pkField.name = unspecifiedPkeyFieldName;
            this.persFieldInfo[fcount] = pkField;
        }
        for (i2 = this.persFieldInfo.length - 1; i2 > 0; --i2) {
            for (int j = 0; j < i2; ++j) {
                if (this.persFieldInfo[j].name.compareTo(this.persFieldInfo[j + 1].name) <= 0) continue;
                PersistentFieldInfo tmp = this.persFieldInfo[j];
                this.persFieldInfo[j] = this.persFieldInfo[j + 1];
                this.persFieldInfo[j + 1] = tmp;
            }
        }
        if (this.pkeyFieldSpecified) {
            this.pkeyFieldInfo = new PersistentFieldInfo[this.pkeyFields.size()];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - this.pkeyFieldInfo.length];
            int pkeyCount = 0;
            int noPkeyCount = 0;
            for (int i3 = 0; i3 < this.persFieldInfo.length; ++i3) {
                boolean isPkey = false;
                Iterator it = this.pkeyFields.iterator();
                while (it.hasNext()) {
                    FieldDescriptor fd = (FieldDescriptor)it.next();
                    if (!fd.getName().equals(this.persFieldInfo[i3].name)) continue;
                    isPkey = true;
                    break;
                }
                if (isPkey) {
                    if (pkeyCount < this.pkeyFields.size()) {
                        this.pkeyFieldInfo[pkeyCount++] = this.persFieldInfo[i3];
                        continue;
                    }
                } else if (noPkeyCount < this.persFieldInfo.length - this.pkeyFieldInfo.length) {
                    this.persNoPkeyFieldInfo[noPkeyCount++] = this.persFieldInfo[i3];
                    continue;
                }
                break;
            }
        } else {
            this.pkeyFieldInfo = new PersistentFieldInfo[1];
            this.persNoPkeyFieldInfo = new PersistentFieldInfo[this.persFieldInfo.length - 1];
            int noPkeys = 0;
            for (int i4 = 0; i4 < this.persFieldInfo.length; ++i4) {
                if (this.persFieldInfo[i4].name.equals(unspecifiedPkeyFieldName)) {
                    this.pkeyFieldInfo[0] = this.persFieldInfo[i4];
                    continue;
                }
                this.persNoPkeyFieldInfo[noPkeys++] = this.persFieldInfo[i4];
            }
        }
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            RelationshipDescriptor rd = ((JoinObjectDescriptor)this.parentDesc).getRelationshipDesc();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
            PersistentFieldInfo[] sourcePkeyFields = sourcePers.getPkeyFieldInfo();
            for (int i5 = 0; i5 < sourcePkeyFields.length; ++i5) {
                String joinField = PersistenceDescriptor.makeJoinFieldSource(source, sourcePkeyFields[i5], i5);
                for (int j = 0; j < this.persFieldInfo.length; ++j) {
                    if (!this.persFieldInfo[j].name.equals(joinField)) continue;
                    this.persFieldInfo[j].type = sourcePkeyFields[i5].type;
                    this.persFieldInfo[j].relatedName = sourcePkeyFields[i5].name;
                    this.persFieldInfo[j].relatedObj = source.getPersistenceDescriptor();
                }
            }
            PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
            PersistentFieldInfo[] sinkPkeyFields = sinkPers.getPkeyFieldInfo();
            for (int i6 = 0; i6 < sinkPkeyFields.length; ++i6) {
                String joinField = PersistenceDescriptor.makeJoinFieldSink(sink, sinkPkeyFields[i6], i6);
                for (int j = 0; j < this.persFieldInfo.length; ++j) {
                    if (!this.persFieldInfo[j].name.equals(joinField)) continue;
                    this.persFieldInfo[j].type = sinkPkeyFields[i6].type;
                    this.persFieldInfo[j].relatedName = sinkPkeyFields[i6].name;
                    this.persFieldInfo[j].relatedObj = sink.getPersistenceDescriptor();
                }
            }
        } else {
            if (this.pkeyIsOneField) {
                this.pkeyFieldInfo[0].type = this.getPrimaryKeyClass();
            }
            for (i2 = 0; i2 < this.persFieldInfo.length; ++i2) {
                if (this.persFieldInfo[i2].type != null) continue;
                this.persFieldInfo[i2].type = this.getCMPFieldType(this.persFieldInfo[i2].name);
            }
        }
        SQLTypeMapper typeMapper = new SQLTypeMapper();
        for (i = 0; i < this.persFieldInfo.length; ++i) {
            this.persFieldInfo[i].jdbcType = typeMapper.getJDBCTypeFor(this.persFieldInfo[i].type);
        }
        try {
            if (this.persistentClass != null && !Modifier.isAbstract(this.persistentClass.getModifiers())) {
                for (i = 0; i < this.persFieldInfo.length; ++i) {
                    this.persFieldInfo[i].field = this.getField(this.getStateClass(), this.persFieldInfo[i].name);
                }
            }
            if (!this.pkeyIsOneField && this.primaryKeyClass != null && !Modifier.isAbstract(this.primaryKeyClass.getModifiers())) {
                this.pkeyClassPkeyFields = new Field[this.pkeyFieldInfo.length];
                for (i = 0; i < this.pkeyFieldInfo.length; ++i) {
                    this.pkeyClassPkeyFields[i] = this.primaryKeyClass.getField(this.pkeyFieldInfo[i].name);
                }
            }
        }
        catch (NoSuchFieldException ex) {
            if (EJBProperties.getEJBQLDebugPersistenceDescriptor()) {
                ex.printStackTrace();
            }
            throw new EJBException((Exception)ex);
        }
        this.fieldInfoInitialized = true;
    }

    private Field getField(final Class c, final String name) throws NoSuchFieldException {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException ex) {
                    return null;
                }
            }
        });
        if (field == null) {
            field = c.getField(name);
        }
        return field;
    }

    private Hashtable getMethodSqlMap() {
        return this.methodSqlMap;
    }

    public boolean hasCMPData() {
        Hashtable map = this.getMethodSqlMap();
        Set sqlMethods = this.getAllSqlStatementedMethods();
        if (map.size() != sqlMethods.size()) {
            return false;
        }
        Iterator methKeys = sqlMethods.iterator();
        while (methKeys.hasNext()) {
            String meth = (String)methKeys.next();
            String sql = (String)map.get(meth);
            if (sql != null && !sql.equals("")) continue;
            return false;
        }
        return true;
    }

    public Set getAllSqlStatementedMethods() {
        if (this.allSqlStatementedMethods == null) {
            try {
                this.allSqlStatementedMethods = new HashSet();
                this.allSqlStatementedMethods.add(CREATE_ROW);
                this.allSqlStatementedMethods.add(DELETE_ROW);
                this.allSqlStatementedMethods.add(STORE_ROW);
                this.allSqlStatementedMethods.add(LOAD_ROW);
                this.allSqlStatementedMethods.add(CREATE_TABLE);
                this.allSqlStatementedMethods.add(DELETE_TABLE);
                this.allSqlStatementedMethods.add(FINDBYPRIMARYKEY);
                if (this.parentDesc instanceof JoinObjectDescriptor) {
                    this.allSqlStatementedMethods.add(FINDBYSOURCEKEY);
                    this.allSqlStatementedMethods.add(FINDBYSINKKEY);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbldngsqlstatementmthds", "Error building allSqlStatementedMethods {0}", new Object[]{ex}));
            }
        }
        return this.allSqlStatementedMethods;
    }

    public Set getSqlStatementedMethods() {
        return this.getMethodSqlMap().keySet();
    }

    public void setSqlStatementFor(String method, String sqlStatement) {
        if (sqlStatement != null) {
            this.getMethodSqlMap().put(method, sqlStatement);
        } else {
            this.getMethodSqlMap().remove(method);
        }
        this.changed();
    }

    public String getSqlStatementFor(String method) {
        Object statement = this.getMethodSqlMap().get(method);
        if (statement == null) {
            statement = "";
        }
        return (String)statement;
    }

    public String getSqlStatementFor(Method method) {
        return this.getSqlStatementFor(method.getName());
    }

    public boolean getCreateTableOnDeployment() {
        return this.createTableOnDeployment;
    }

    public void setCreateTableOnDeployment(boolean createTableOnDeployment) {
        this.createTableOnDeployment = createTableOnDeployment;
        this.changed();
    }

    public boolean getDeleteTableOnUndeployment() {
        return this.deleteTableOnUndeployment;
    }

    public void setDeleteTableOnUndeployment(boolean deleteTableOnUndeployment) {
        this.deleteTableOnUndeployment = deleteTableOnUndeployment;
        this.changed();
    }

    public Class getTypeFor(String field) {
        return this.getCMPFieldType(field);
    }

    private Class getCMPFieldType(String field) {
        Class pclass = this.getPersistentClass();
        if (Modifier.isAbstract(pclass.getModifiers())) {
            String javaBeanName = PersistenceDescriptor.capitalize(field);
            String getter = "get" + javaBeanName;
            try {
                Method method = pclass.getMethod(getter, null);
                return method.getReturnType();
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot find accessor " + getter + " for CMP field " + field);
            }
        }
        try {
            Field f = this.getField(this.getStateClass(), field);
            return f.getType();
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("Cant find CMP field " + field + " in class " + this.getStateClass().getName());
        }
    }

    public static String capitalize(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            throw new EJBException("CMP/CMR field " + name + " must start with a lower case character.");
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public void setQueryFor(Method method, QueryDescriptor query) {
        Method queryMethod = this.findEquivalentMethod(this.queries.keySet(), method);
        if (queryMethod != null) {
            this.queries.put(queryMethod, query);
        } else {
            this.queries.put(method, query);
        }
    }

    public QueryDescriptor getQueryFor(Method method) {
        Method queryMethod = this.findEquivalentMethod(this.queries.keySet(), method);
        return queryMethod != null ? (QueryDescriptor)this.queries.get(queryMethod) : null;
    }

    public Set getQueriedMethods() {
        return this.queries.keySet();
    }

    public Set getAllPossibleQueriedMethods() {
        if (this.allQueriedMethods == null) {
            this.initializeAllQueriedMethods();
        }
        return this.allQueriedMethods;
    }

    private void initializeAllQueriedMethods() {
        this.allQueriedMethods = new HashSet();
        if (this.parentDesc instanceof JoinObjectDescriptor) {
            return;
        }
        Method[] beanMethods = this.getPersistentClass().getMethods();
        for (int i = 0; i < beanMethods.length; ++i) {
            if (!beanMethods[i].getName().startsWith("ejbSelect")) continue;
            this.allQueriedMethods.add(beanMethods[i]);
        }
        if (this.parentDesc instanceof EjbCMPEntityDescriptor) {
            String name;
            int i;
            Method[] homeMethods;
            Class homeIntf;
            EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)this.parentDesc;
            if (entd.isRemoteInterfacesSupported()) {
                homeIntf = this.getClass(entd.getHomeClassName());
                homeMethods = homeIntf.getMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    name = homeMethods[i].getName();
                    if (!name.startsWith("find") || name.equals(FINDBYPRIMARYKEY)) continue;
                    this.allQueriedMethods.add(homeMethods[i]);
                }
            }
            if (entd.isLocalInterfacesSupported()) {
                homeIntf = this.getClass(entd.getLocalHomeClassName());
                homeMethods = homeIntf.getMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    name = homeMethods[i].getName();
                    if (!name.startsWith("find") || name.equals(FINDBYPRIMARYKEY)) continue;
                    this.allQueriedMethods.add(homeMethods[i]);
                }
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setOc4jEntity(EntityBeanDescriptor value) {
        this.oc4jEntity = value;
    }

    public EntityBeanDescriptor getOc4jEntity() {
        return this.oc4jEntity;
    }

    public boolean roleMapsToAForeignKey(RelationRoleDescriptor role) {
        return role.needsForeignColumnInOwnerTable();
    }

    public String toString() {
        String s = "{" + this.getClass() + " " + this.hashCode() + " " + " primaryKeyClassName: " + this.primaryKeyClassName + " tableName: " + this.tableName + " cmpFields: " + this.cmpFields;
        StringBuffer cmrFieldInfoString = new StringBuffer("{");
        if (this.cmrFieldInfo != null) {
            for (int i = 0; i < this.cmrFieldInfo.length; ++i) {
                if (this.cmrFieldInfo[i] == null) continue;
                cmrFieldInfoString.append(this.cmrFieldInfo[i]);
                cmrFieldInfoString.append(" ");
            }
        }
        cmrFieldInfoString.append("}");
        s = s + " getFkeyFields: " + this.getFkeyFields();
        s = s + " cmrFieldInfo: " + cmrFieldInfoString + "}";
        return s;
    }
}

