/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationHandler
extends DefaultHandler {
    private static String[][] mapping = new String[][]{{ApplicationNode.PUBLIC_DTD_ID, "application_1_3.dtd"}, {ApplicationNode.PUBLIC_DTD_ID_12, "application_1_2.dtd"}, {EjbBundleNode.PUBLIC_DTD_ID, "ejb-jar_2_0.dtd"}, {EjbBundleNode.PUBLIC_DTD_ID_12, "ejb-jar_1_1.dtd"}, {ApplicationClientNode.PUBLIC_DTD_ID, "application-client_1_3.dtd"}, {ApplicationClientNode.PUBLIC_DTD_ID_12, "application-client_1_2.dtd"}, {ConnectorNode.PUBLIC_DTD_ID, "connector_1_0.dtd"}, {RuntimeDescriptorNode.PUBLIC_DTD_ID, "sun-j2ee-ri_1_3.dtd"}, {WebBundleNode.PUBLIC_DTD_ID, "web-app_2_3.dtd"}, {WebBundleNode.PUBLIC_DTD_ID_12, "web-app_2_2.dtd"}};
    private boolean throwsException;

    public XMLValidationHandler(boolean bl) {
        this.throwsException = bl;
    }

    public XMLValidationHandler() {
        this.throwsException = true;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            int n = 0;
            while (n < mapping.length) {
                if (mapping[n][0].equals(string)) {
                    return new InputSource(new FileInputStream(new File(this.getAbsoluteFilenameForDTD(mapping[n][1]))));
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("XML Error line : " + sAXParseException.getLineNumber() + " " + sAXParseException.getLocalizedMessage());
        if (this.throwsException) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println(((SAXException)sAXParseException).toString());
        throw sAXParseException;
    }

    protected String getAbsoluteFilenameForDTD(String string) {
        String string2 = FileUtil.getAbsolutePath("lib/dtds");
        File file = new File(string2 + File.separator + string);
        return file.getAbsolutePath();
    }
}

