/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction;

import com.evermind.security.SecuritySensitive;
import com.evermind.server.InvalidConfigurationException;
import oracle.as.j2ee.transaction.CommitCoordinatorConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InDbCoordinatorConfiguration
extends CommitCoordinatorConfiguration {
    public InDbCoordinatorConfiguration(Node root) throws InvalidConfigurationException {
        super(root);
        NodeList elements = ((Element)root).getElementsByTagName("database");
        Element ce = (Element)elements.item(0);
        this.m_location = ce.getAttribute("location");
        NodeList melements = ce.getElementsByTagName("identity");
        ce = (Element)melements.item(0);
        if (ce != null) {
            this.m_userName = ce.getAttribute("user");
            this.m_password = SecuritySensitive.global().decode(ce.getAttribute("password"));
        }
        this.validateDBLoggingUpdate();
    }

    public String getCommitCoordinatorType() {
        return "database";
    }

    public String getLogTypeString() {
        return "";
    }

    public InDbCoordinatorConfiguration(String location, String userName, String password) throws InvalidConfigurationException {
        this.m_location = location;
        this.m_userName = userName;
        this.m_password = password;
        this.validateDBLoggingUpdate();
    }

    protected void validateDBLoggingUpdate() throws InvalidConfigurationException {
        if (this.m_location == null || this.m_location.equals("")) {
            throw new InvalidConfigurationException("Missing location attribute value for database commit-coordinator");
        }
    }
}

