/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction;

import com.evermind.server.InvalidConfigurationException;
import com.evermind.xml.XMLConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.as.j2ee.transaction.CommitCoordinatorConfiguration;
import oracle.as.j2ee.transaction.InDbCoordinatorConfiguration;
import oracle.as.j2ee.transaction.MiddleTierCoordinatorConfiguration;
import oracle.j2ee.transaction.ThresholdEventDetail;
import oracle.j2ee.transaction.TransactionManagerConfigurationDetail;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.transaction.recovery.RecoveryAbandonmentDetail;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransactionManagerConfiguration
extends XMLConfig {
    private static final String SCHEMA_NAMESPACE_LOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION = "http://xmlns.oracle.com/oracleas/schema/transaction-manager-10_0.xsd";
    private static final String TRANSACTIONMANAGER = "transaction-manager";
    private static final String TRANSACTIONTIMEOUT = "transaction-timeout";
    private static final String MAXCONCURRENTTXS = "max-concurrent-transactions";
    private static final String COMMITCOORDINATOR = "commit-coordinator";
    private static final String RETRYCOUNT = "retry-count";
    public static final String DATABASE_COORDINATOR = "database";
    public static final String MIDDLETIER_COORDINATOR = "middle-tier";
    static final String LOG = "log";
    static final String TYPE = "type";
    static final String LOCATION = "location";
    static final String IDENTITY = "identity";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String FILE_LOGGING_PERFORMANCE = "file-logging-performance";
    static final String MIN_POOL_SIZE = "min-pool-size";
    static final String MAX_OPEN_FILES = "max-open-files";
    static final String OLD_FILE_RELEASE_SIZE = "old-file-release-size";
    static final String DATABASE_LOGGING_PERFORMANCE = "database-logging-performance";
    static final String BATCH_CREATE_INTERVAL = "batch-create-interval";
    static final String BATCH_STATE_INTERVAL = "batch-state-interval";
    static final String BATCH_PURGE_INTERVAL = "batch-purge-interval";
    private static final String EVENTS = "events";
    private static final String THRESHOLD_STAT = "threshold-stat";
    private static final String THRESHOLD = "threshold";
    private static final String REPEAT_INTERVAL = "repeat-interval";
    public static final String RECOVERY = "recovery";
    public static final String RETRY_INTERVAL = "retry-interval";
    public static final String RLRC_PURGE_INTERVAL = "rlrc-purge-interval";
    public static final String RLRC_MIN_PURGE_SIZE = "rlrc-min-purge-size";
    public static final String ABANDONMENT = "abandonment";
    public static final String PARTICIPANT_LOCATION = "participant-location";
    public static final String TIME = "time";
    public static final String COUNT = "count";
    public static final int DEFAULT_TX_TIMEOUT = 30;
    public static final int NO_TRANSACTIONS_DUE_TO_SHUTDOWN = 0;
    public static final int UNLIMITED_MAX_CONCURRENT_TRANSACTIONS = -1;
    public static final int DEFAULT_MAX_CONCURRENT_TRANSACTIONS = -1;
    public static final int DEFAULT_MIN_POOL_SIZE = 40;
    public static final int DEFAULT_MAX_OPEN_FILES = 250;
    public static final int DEFAULT_OLD_FILE_RELEASE_SIZE = 20;
    public static final int DEFAULT_BATCH_CREATE_INTERVAL = 10;
    public static final int DEFAULT_BATCH_STATE_INTERVAL = 10;
    public static final int DEFAULT_BATCH_PURGE_INTERVAL = 100;
    public static final int DEFAULT_RETRY_COUNT = 1;
    public static final int DEFAULT_RECOVERY_RETRY_INTERVAL = 300;
    public static final int DEFAULT_RLRC_PURGE_INTERVAL = 10;
    public static final int DEFAULT_RLRC_MIN_PURGE_SIZE = 1000;
    private Node m_rootNode;
    private CommitCoordinatorConfiguration m_configuration;
    private CommitCoordinatorConfiguration m_changedConfiguration;
    private int m_timeout;
    private int m_maxConcurrentTx;
    private boolean m_coordConfigChanged = false;
    private boolean m_shuttingDown = false;
    private Document m_document;
    private Element m_thresholdEventsDom;
    private String[] m_thresholdStatisticName = new String[0];
    private int[] m_threshold = new int[0];
    private int[] m_repeatInterval = new int[0];
    private static final String INVALID_COORD_TYPE = "Invalid coordinator type indicated, 'middle-tier' or 'database' must be specified in transaction-manager.xml";
    private static final String UNABLE_TO_WRITE_FILE = "Unable to write to transaction-manager.xml file";
    private static final String CANNOT_CREATE_PARSER = "Cannot create parser for commmit coordinator factory";
    private static final String CANNOT_CREATE_FACTORY = "Cannot create commmit coordinator factory";
    static final String NO_COORD_TYPE_SPECIFIED = "No coordinator type indicated, 'middle-tier' or 'database' must be specified in transaction-manager.xml";

    public TransactionManagerConfiguration(URL url) throws IOException, SAXException, InstantiationException {
        super(url);
    }

    public void create(URL url) {
    }

    protected void postInit() throws InstantiationException {
        try {
            Element rootElement = this.setTMConfig();
            Element coordElement = this.m_document.createElement(COMMITCOORDINATOR);
            rootElement.appendChild(coordElement);
            if (((Element)this.m_rootNode).getElementsByTagName(DATABASE_COORDINATOR).getLength() > 0) {
                this.m_configuration = new InDbCoordinatorConfiguration(this.m_rootNode);
            } else if (((Element)this.m_rootNode).getElementsByTagName(MIDDLETIER_COORDINATOR).getLength() > 0) {
                this.m_configuration = new MiddleTierCoordinatorConfiguration(this.m_rootNode);
            }
            this.getCoordinatorConfigFromTMConfig(coordElement, this.m_configuration);
            this.setThresholdEventsFromConfig(rootElement);
        }
        catch (ParserConfigurationException e) {
            InstantiationException ie = new InstantiationException(CANNOT_CREATE_PARSER + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (InvalidConfigurationException e) {
            InstantiationException ie = new InstantiationException(CANNOT_CREATE_FACTORY + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private Element setTMConfig() throws ParserConfigurationException, InvalidConfigurationException {
        this.m_document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        if (this.m_rootNode == null) {
            throw new InvalidConfigurationException(NO_COORD_TYPE_SPECIFIED);
        }
        Element rootElement = this.m_document.createElement(TRANSACTIONMANAGER);
        rootElement.setAttribute("xmlns:xsi", SCHEMA_NAMESPACE_LOCATION);
        rootElement.setAttribute("xsi:noNamespaceSchemaLocation", SCHEMA_LOCATION);
        this.setTransactionTimeoutFromConfig();
        rootElement.setAttribute(TRANSACTIONTIMEOUT, "" + this.getTransactionTimeout());
        this.m_maxConcurrentTx = -1;
        this.setMaxConncurrentTxFromConfig();
        rootElement.setAttribute(MAXCONCURRENTTXS, "" + this.m_maxConcurrentTx);
        this.m_document.appendChild(rootElement);
        return rootElement;
    }

    private void setTransactionTimeoutFromConfig() {
        String txTimeout = ((Element)this.m_rootNode).getAttribute(TRANSACTIONTIMEOUT);
        if (txTimeout == null || txTimeout.trim().equals("")) {
            this.setTransactionTimeout(30);
            TransactionMessages.configNoTxTimeoutValueSpecified(this.getTransactionTimeout());
        } else if (new Integer(txTimeout) < 1) {
            this.setTransactionTimeout(30);
            TransactionMessages.configInvalidTxTimeoutValueSpecified(new Long(txTimeout), this.getTransactionTimeout());
        } else {
            this.setTransactionTimeout(new Integer(txTimeout));
            TransactionMessages.configSettingTransactionTimeoutTo(this.getTransactionTimeout());
        }
    }

    private Element getCoordinatorConfigFromTMConfig(Element coordElement, CommitCoordinatorConfiguration coordConfig) throws InvalidConfigurationException {
        if (coordConfig.getCommitCoordinatorType().equals(DATABASE_COORDINATOR)) {
            return this.getInDBCoordElement(coordElement, coordConfig);
        }
        if (coordConfig.getCommitCoordinatorType().equals(MIDDLETIER_COORDINATOR)) {
            return this.getMiddleTierCoordElement(coordElement, (MiddleTierCoordinatorConfiguration)coordConfig);
        }
        throw new InvalidConfigurationException(INVALID_COORD_TYPE);
    }

    private Element getMiddleTierCoordElement(Element coordElement, MiddleTierCoordinatorConfiguration coordConfig) {
        Element middletierCoordPerfElement;
        coordElement.setAttribute(RETRYCOUNT, "" + coordConfig.getRetryCount());
        Element middletierCoordElement = this.m_document.createElement(MIDDLETIER_COORDINATOR);
        coordElement.appendChild(middletierCoordElement);
        Element logElement = this.m_document.createElement(LOG);
        logElement.setAttribute(TYPE, coordConfig.getLogTypeString());
        logElement.setAttribute(LOCATION, coordConfig.getLocation());
        middletierCoordElement.appendChild(logElement);
        if (coordConfig.getUserName() != null && !coordConfig.getUserName().trim().equals("")) {
            Element middletierCoordIdentityElement = this.m_document.createElement(IDENTITY);
            middletierCoordIdentityElement.setAttribute(USER, coordConfig.getUserName());
            middletierCoordIdentityElement.setAttribute(PASSWORD, coordConfig.getPassword());
            logElement.appendChild(middletierCoordIdentityElement);
        }
        if (coordConfig.getLogTypeString().equals("file")) {
            middletierCoordPerfElement = this.m_document.createElement(FILE_LOGGING_PERFORMANCE);
            middletierCoordPerfElement.setAttribute(MAX_OPEN_FILES, "" + coordConfig.getMaxOpenFiles());
            middletierCoordPerfElement.setAttribute(MIN_POOL_SIZE, "" + coordConfig.getMinPoolSize());
            middletierCoordPerfElement.setAttribute(OLD_FILE_RELEASE_SIZE, "" + coordConfig.getOldFileReleaseSize());
            logElement.appendChild(middletierCoordPerfElement);
        } else if (coordConfig.getLogTypeString().equals(DATABASE_COORDINATOR)) {
            middletierCoordPerfElement = this.m_document.createElement(DATABASE_LOGGING_PERFORMANCE);
            middletierCoordPerfElement.setAttribute(BATCH_CREATE_INTERVAL, "" + coordConfig.getBatchCreateInterval());
            middletierCoordPerfElement.setAttribute(BATCH_STATE_INTERVAL, "" + coordConfig.getBatchStateInterval());
            middletierCoordPerfElement.setAttribute(BATCH_PURGE_INTERVAL, "" + coordConfig.getBatchPurgeInterval());
            logElement.appendChild(middletierCoordPerfElement);
        }
        Element recoveryElement = this.m_document.createElement(RECOVERY);
        recoveryElement.setAttribute(RETRY_INTERVAL, "" + coordConfig.getRecoveryRetryInterval());
        recoveryElement.setAttribute(RLRC_PURGE_INTERVAL, "" + coordConfig.getRLRCPurgeInterval());
        recoveryElement.setAttribute(RLRC_MIN_PURGE_SIZE, "" + coordConfig.getRLRCMinPurgeSize());
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetail = coordConfig.getRecoveryAbandonmentDetail();
        if (recoveryAbandonmentDetail != null) {
            for (int i = 0; i < recoveryAbandonmentDetail.length; ++i) {
                Element abandonmentElement = this.m_document.createElement(ABANDONMENT);
                abandonmentElement.setAttribute(TYPE, recoveryAbandonmentDetail[i].getType());
                abandonmentElement.setAttribute(PARTICIPANT_LOCATION, recoveryAbandonmentDetail[i].getParticipantLocation());
                abandonmentElement.setAttribute(TIME, "" + recoveryAbandonmentDetail[i].getTime());
                abandonmentElement.setAttribute(COUNT, "" + recoveryAbandonmentDetail[i].getCount());
                recoveryElement.appendChild(abandonmentElement);
            }
        }
        middletierCoordElement.appendChild(recoveryElement);
        return middletierCoordElement;
    }

    private Element getInDBCoordElement(Element coordElement, CommitCoordinatorConfiguration coordConfig) {
        Element inDBCoordElement = this.m_document.createElement(DATABASE_COORDINATOR);
        inDBCoordElement.setAttribute(LOCATION, coordConfig.getLocation());
        coordElement.appendChild(inDBCoordElement);
        if (coordConfig.getUserName() != null && !coordConfig.getUserName().trim().equals("")) {
            Element inDBCoordIdentityElement = this.m_document.createElement(IDENTITY);
            inDBCoordIdentityElement.setAttribute(USER, coordConfig.getUserName());
            inDBCoordIdentityElement.setAttribute(PASSWORD, coordConfig.getPassword());
            inDBCoordElement.appendChild(inDBCoordIdentityElement);
        }
        return inDBCoordElement;
    }

    private void setThresholdEventsFromConfig(Element rootElement) throws InvalidConfigurationException {
        this.m_thresholdEventsDom = this.m_document.createElement(EVENTS);
        rootElement.appendChild(this.m_thresholdEventsDom);
        NodeList elements = ((Element)this.m_rootNode).getElementsByTagName(THRESHOLD);
        int numberOfThresholdEvents = elements.getLength();
        if (numberOfThresholdEvents <= 0) {
            return;
        }
        this.m_thresholdStatisticName = new String[numberOfThresholdEvents];
        this.m_threshold = new int[numberOfThresholdEvents];
        this.m_repeatInterval = new int[numberOfThresholdEvents];
        for (int i = 0; i < numberOfThresholdEvents; ++i) {
            Element ce = (Element)elements.item(i);
            this.m_thresholdStatisticName[i] = ce.getAttribute(THRESHOLD_STAT);
            this.m_threshold[i] = new Integer(ce.getAttribute(THRESHOLD));
            this.m_repeatInterval[i] = new Integer(ce.getAttribute(REPEAT_INTERVAL));
            this.addOrUpdateThresholdEventToConfigXML(false, this.m_thresholdStatisticName[i], this.m_threshold[i], this.m_repeatInterval[i]);
        }
    }

    public String[] getThresholdStatisticNamesFromConfig() {
        return this.m_thresholdStatisticName;
    }

    public int[] getThresholdsFromConfig() {
        return this.m_threshold;
    }

    public int[] getRepeatIntervalFromConfig() {
        return this.m_repeatInterval;
    }

    protected synchronized void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
    }

    protected synchronized void parseDeploymentMainNode(Node node) throws InstantiationException {
        if (this.m_rootNode == null) {
            this.m_rootNode = node.getParentNode();
        }
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
    }

    private void setMaxConncurrentTxFromConfig() throws InvalidConfigurationException {
        this.m_maxConcurrentTx = this.getValidMaxConcurrentTransactionsValue(((Element)this.m_rootNode).getAttribute(MAXCONCURRENTTXS));
        TransactionMessages.configSettingMaxConcurrentTo(this.m_maxConcurrentTx == -1 ? "unlimited" : "" + this.m_maxConcurrentTx);
    }

    public int getValidMaxConcurrentTransactionsValue(String maxTxs) throws InvalidConfigurationException {
        if (maxTxs == null || maxTxs.trim().equals("")) {
            int currentMaxTxValue = this.getMaxConncurrentTransactions();
            TransactionMessages.configValidGettingMaxConcurrent(currentMaxTxValue + (currentMaxTxValue == -1 ? " (unlimited)" : ""));
            return currentMaxTxValue;
        }
        if (new Integer(maxTxs) < 1 && new Integer(maxTxs) != -1) {
            throw new InvalidConfigurationException("Invalid max-concurrent-transactions value, " + new Long(maxTxs) + ", specified.");
        }
        return new Integer(maxTxs);
    }

    public void setTransactionTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getTransactionTimeout() {
        return this.m_timeout;
    }

    public void setMaxConcurrentTransactions(int maxTx) throws InvalidConfigurationException {
        this.m_maxConcurrentTx = maxTx;
    }

    public int getMaxConncurrentTransactions() {
        return this.m_maxConcurrentTx;
    }

    public boolean isCoordConfigChanged() {
        return this.m_coordConfigChanged;
    }

    public void setCoordConfigChanged(boolean configChanged) {
        this.m_coordConfigChanged = configChanged;
    }

    public boolean isTMShuttingDown() {
        return this.m_shuttingDown;
    }

    public void setTMShuttingDown(boolean changed) {
        this.m_shuttingDown = changed;
    }

    public CommitCoordinatorConfiguration getCommitCoordinatorConfiguration() {
        return this.m_configuration;
    }

    public void addOrUpdateThresholdEventToConfigXML(boolean exists, String thresholdStatisticName, int threshold, int repeatNotificationInterval) throws InvalidConfigurationException {
        if (exists) {
            NodeList thresholdEventNodes = this.m_thresholdEventsDom.getElementsByTagName(THRESHOLD);
            for (int ii = 0; ii < thresholdEventNodes.getLength(); ++ii) {
                Element element = (Element)thresholdEventNodes.item(ii);
                if (!element.getAttribute(THRESHOLD_STAT).equals(thresholdStatisticName)) continue;
                element.setAttribute(THRESHOLD_STAT, thresholdStatisticName);
                element.setAttribute(THRESHOLD, "" + threshold);
                element.setAttribute(REPEAT_INTERVAL, "" + repeatNotificationInterval);
            }
        } else {
            this.appendThresholdEventToEventsElement(thresholdStatisticName, threshold, repeatNotificationInterval);
        }
    }

    private void appendThresholdEventToEventsElement(String thresholdStatisticName, int threshold, int repeatNotificationInterval) {
        Element newThresholdEventElement = this.m_document.createElement(THRESHOLD);
        newThresholdEventElement.setAttribute(THRESHOLD_STAT, thresholdStatisticName);
        newThresholdEventElement.setAttribute(THRESHOLD, "" + threshold);
        newThresholdEventElement.setAttribute(REPEAT_INTERVAL, "" + repeatNotificationInterval);
        this.m_thresholdEventsDom.appendChild(newThresholdEventElement);
    }

    public void setRecoveryRetryInterval(int seconds) throws InvalidConfigurationException {
        this.validateIsMiddleTierConfig("setRecoveryRetryInterval");
        if (seconds <= 0) {
            throw new InvalidConfigurationException("recovery retry-interval must be greater than 0");
        }
        if (!this.isCoordConfigChanged()) {
            this.m_changedConfiguration = new MiddleTierCoordinatorConfiguration((MiddleTierCoordinatorConfiguration)this.m_configuration);
        }
        ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setRecoveryRetryInterval(seconds);
        this.setCoordConfigChanged(!this.m_changedConfiguration.equals(this.m_changedConfiguration, this.m_configuration));
    }

    public int getRecoveryRetryInterval() {
        return ((MiddleTierCoordinatorConfiguration)this.m_configuration).getRecoveryRetryInterval();
    }

    public int getRLRCPurgeInterval() {
        return ((MiddleTierCoordinatorConfiguration)this.m_configuration).getRLRCPurgeInterval();
    }

    public int getRLRCMinPurgeSize() {
        return ((MiddleTierCoordinatorConfiguration)this.m_configuration).getRLRCMinPurgeSize();
    }

    public RecoveryAbandonmentDetail[] getRecoveryAbandonmentDetails() {
        return ((MiddleTierCoordinatorConfiguration)this.m_configuration).getRecoveryAbandonmentDetail();
    }

    public void updateRecoveryAbandonmentToConfigXML(RecoveryAbandonmentDetail[] recoveryAbandonmentDetail, String operationName) throws InvalidConfigurationException {
        this.validateIsMiddleTierConfig(operationName);
        if (!this.isCoordConfigChanged()) {
            this.m_changedConfiguration = new MiddleTierCoordinatorConfiguration((MiddleTierCoordinatorConfiguration)this.m_configuration);
        }
        ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setRecoveryAbandonmentDetail(recoveryAbandonmentDetail);
        this.setCoordConfigChanged(!this.m_changedConfiguration.equals(this.m_changedConfiguration, this.m_configuration));
    }

    public TransactionManagerConfigurationDetail getTransactionManagerConfigurationDetail() throws InvalidConfigurationException {
        return this.getTMConfigDetailForCoordConfigType(this.m_changedConfiguration != null ? this.m_changedConfiguration : this.m_configuration);
    }

    public TransactionManagerConfigurationDetail getTMConfigDetailForCoordConfigType(CommitCoordinatorConfiguration commitCoordinatorConfiguration) throws InvalidConfigurationException {
        String commitCoordinatorType = commitCoordinatorConfiguration.getCommitCoordinatorType();
        boolean isMiddleTier = commitCoordinatorType.equals(MIDDLETIER_COORDINATOR);
        return new TransactionManagerConfigurationDetail(commitCoordinatorType, commitCoordinatorConfiguration.getLogTypeString(), commitCoordinatorConfiguration.getLocation(), commitCoordinatorConfiguration.getUserName(), commitCoordinatorConfiguration.getPassword(), isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getRetryCount() : 0, this.getTransactionTimeout(), this.getMaxConncurrentTransactions(), this.getThresholdEventsForConfigurationDetail(), isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getMinPoolSize() : 0, isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getMaxOpenFiles() : 0, isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getOldFileReleaseSize() : 0, isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getBatchCreateInterval() : 0, isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getBatchStateInterval() : 0, isMiddleTier ? ((MiddleTierCoordinatorConfiguration)commitCoordinatorConfiguration).getBatchPurgeInterval() : 0);
    }

    public ThresholdEventDetail[] getThresholdEventsForConfigurationDetail() throws InvalidConfigurationException {
        ThresholdEventDetail[] thresholdDetails = null;
        NodeList thresholdEventNodes = this.m_thresholdEventsDom.getElementsByTagName(THRESHOLD);
        thresholdDetails = new ThresholdEventDetail[thresholdEventNodes.getLength()];
        for (int ii = 0; ii < thresholdEventNodes.getLength(); ++ii) {
            Element element = (Element)thresholdEventNodes.item(ii);
            thresholdDetails[ii] = new ThresholdEventDetail(element.getAttribute(THRESHOLD_STAT), new Integer(element.getAttribute(THRESHOLD)), new Integer(element.getAttribute(REPEAT_INTERVAL)));
        }
        return thresholdDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureCoordinator(String coordType, String logType, String location, String userName, String password, int retryCount) throws InvalidConfigurationException {
        TransactionManagerConfiguration transactionManagerConfiguration = this;
        synchronized (transactionManagerConfiguration) {
            if (coordType.equals(DATABASE_COORDINATOR)) {
                this.m_changedConfiguration = new InDbCoordinatorConfiguration(location, userName, password);
            } else {
                this.m_changedConfiguration = new MiddleTierCoordinatorConfiguration(logType, location, userName, password);
                if (retryCount < 0) {
                    TransactionMessages.configInvalidRetryCount(retryCount, ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).getRetryCount());
                } else {
                    ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setRetryCount(retryCount);
                }
            }
            this.setCoordConfigChanged(!this.m_changedConfiguration.equals(this.m_changedConfiguration, this.m_configuration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureFileLoggingPerformance(int minPoolSize, int maxOpenFiles, int oldFileReleaseSize) throws InvalidConfigurationException {
        TransactionManagerConfiguration transactionManagerConfiguration = this;
        synchronized (transactionManagerConfiguration) {
            this.validateIsMiddleTierConfig("configureFileLoggingPerformance");
            if (!this.isCoordConfigChanged()) {
                this.m_changedConfiguration = new MiddleTierCoordinatorConfiguration(this.m_configuration, minPoolSize, maxOpenFiles, oldFileReleaseSize, -1, -1, -1);
            } else {
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setMinPoolSize(minPoolSize);
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setMaxOpenFiles(maxOpenFiles);
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setOldFileReleaseSize(oldFileReleaseSize);
            }
            this.setCoordConfigChanged(!this.m_changedConfiguration.equals(this.m_changedConfiguration, this.m_configuration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureDatabaseLoggingPerformance(int batchCreateInterval, int batchStateInterval, int batchPurgeInterval) throws InvalidConfigurationException {
        TransactionManagerConfiguration transactionManagerConfiguration = this;
        synchronized (transactionManagerConfiguration) {
            this.validateIsMiddleTierConfig("configureDatabaseLoggingPerformance");
            if (!this.isCoordConfigChanged()) {
                this.m_changedConfiguration = new MiddleTierCoordinatorConfiguration(this.m_configuration, -1, -1, -1, batchCreateInterval, batchStateInterval, batchPurgeInterval);
            } else {
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setBatchCreateInterval(batchCreateInterval);
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setBatchStateInterval(batchStateInterval);
                ((MiddleTierCoordinatorConfiguration)this.m_changedConfiguration).setBatchPurgeInterval(batchPurgeInterval);
            }
            this.setCoordConfigChanged(!this.m_changedConfiguration.equals(this.m_changedConfiguration, this.m_configuration));
        }
    }

    private void validateIsMiddleTierConfig(String operationName) throws InvalidConfigurationException {
        if (this.isCoordConfigChanged() && this.m_changedConfiguration instanceof InDbCoordinatorConfiguration || this.m_configuration instanceof InDbCoordinatorConfiguration) {
            throw new InvalidConfigurationException(operationName + " operation pertains to middle-tier coordinator only");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        try {
            Element elementTM = (Element)this.m_document.getElementsByTagName(TRANSACTIONMANAGER).item(0);
            elementTM.setAttribute(TRANSACTIONTIMEOUT, "" + this.getTransactionTimeout());
            elementTM.setAttribute(MAXCONCURRENTTXS, "" + this.m_maxConcurrentTx);
            if (this.m_coordConfigChanged && this.m_shuttingDown) {
                Element element = (Element)this.m_document.getElementsByTagName(COMMITCOORDINATOR).item(0);
                Element coordinatorConfigFromTMConfig = this.getCoordinatorConfigFromTMConfig(element, this.m_changedConfiguration);
                element.replaceChild(coordinatorConfigFromTMConfig, element.getChildNodes().item(0));
            }
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.m_document), new StreamResult(writer));
            out.println(writer.getBuffer().toString());
        }
        catch (Exception ioe) {
            IOException ice = new IOException(UNABLE_TO_WRITE_FILE + ioe.getMessage());
            ice.initCause(ioe);
            throw ice;
        }
    }
}

