/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction;

public class TransactionState {
    public static final int ACTIVE = 0;
    public static final int READ_ONLY = 1;
    public static final int ROLLBACK_ONLY = 2;
    public static final int ROLLINGBACK = 3;
    public static final int COMMIT1 = 4;
    public static final int COMMITTING = 5;
    public static final int PREPARING = 6;
    public static final int HEURISTIC_COMMITTING = 7;
    public static final int HEURISTIC_ROLLINGBACK = 8;
    public static final int IN_DOUBT = 9;
    public static final int HEURISTIC_COMMITTED = 10;
    public static final int HEURISTIC_ROLLEDBACK = 11;
    public static final int COMMITTED = 12;
    public static final int ROLLEDBACK = 13;
    public static final int INCONSISTENT = 14;
    public static final int HEURISTIC_INCONSISTENT = 15;
    public static final int INVALID = 16;
    public static final int UNKNOWN = 17;
    public static final int MAX = 16;
    static int LIMIT = 17;
    public static final String ACTIVE_STRING = "ACTIVE";
    public static final String READ_ONLY_STRING = "READ ONLY";
    public static final String ROLLBACK_ONLY_STRING = "ROLLBACK ONLY";
    public static final String ROLLINGBACK_STRING = "ROLLINGBACK";
    public static final String COMMIT1_STRING = "ONE PHASE COMMIT";
    public static final String COMMITTING_STRING = "COMMITTING";
    public static final String PREPARING_STRING = "PREPARING";
    public static final String HEURISTIC_COMMITTING_STRING = "HEURISTIC COMMITTING";
    public static final String HEURISTIC_ROLLINGBACK_STRING = "HEURISTIC ROLLINGBACK";
    public static final String IN_DOUBT_STRING = "IN DOUBT";
    public static final String HEURISTIC_COMMITTED_STRING = "HEURISTIC COMMITTED";
    public static final String HEURISTIC_ROLLEDBACK_STRING = "HEURISTIC ROLLEDBACK";
    public static final String COMMITTED_STRING = "COMMITTED";
    public static final String ROLLEDBACK_STRING = "ROLLEDBACK";
    public static final String INCONSISTENT_STRING = "INCONSISTENT";
    public static final String HEURISTIC_INCONSISTENT_STRING = "HEURISTIC INCONSISTENT";
    public static final String INVALID_STRING = "INVALID";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String RECOVERING_COMMITTING_STRING = "RECOVERING_COMMITTING";
    public static final String RECOVERING_ROLLINGBACK_STRING = "RECOVERING_ROLLINGBACK";
    private static final String JTA_STATUS_ACTIVE_STRING = "STATUS_ACTIVE";
    private static final String JTA_STATUS_MARKED_ROLLBACK_STRING = "STATUS_MARKED_ROLLBACK";
    private static final String JTA_STATUS_PREPARED_STRING = "STATUS_PREPARED";
    private static final String JTA_STATUS_COMMITTED_STRING = "STATUS_COMMITTED";
    private static final String JTA_STATUS_ROLLEDBACK_STRING = "STATUS_ROLLEDBACK";
    private static final String JTA_STATUS_NO_TRANSACTION_STRING = "STATUS_NO_TRANSACTION";
    private static final String JTA_STATUS_PREPARING_STRING = "STATUS_PREPARING";
    private static final String JTA_STATUS_COMMITTING_STRING = "STATUS_COMMITTING";
    private static final String JTA_STATUS_ROLLING_BACK_STRING = "STATUS_ROLLING_BACK";
    private static final String JTA_STATUS_UNKNOWN_STRING = "STATUS_UNKNOWN";

    public static int convertToJTAStatus(int transactionState) {
        switch (transactionState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 8: {
                return 9;
            }
            case 4: 
            case 5: 
            case 7: {
                return 8;
            }
            case 6: {
                return 7;
            }
            case 9: {
                return 2;
            }
            case 10: 
            case 12: {
                return 3;
            }
            case 11: 
            case 13: {
                return 4;
            }
        }
        return 5;
    }

    public static String toString(int state) {
        String str = null;
        switch (state) {
            case 0: {
                str = ACTIVE_STRING;
                break;
            }
            case 1: {
                str = READ_ONLY_STRING;
                break;
            }
            case 2: {
                str = ROLLBACK_ONLY_STRING;
                break;
            }
            case 4: {
                str = COMMIT1_STRING;
                break;
            }
            case 5: {
                str = COMMITTING_STRING;
                break;
            }
            case 6: {
                str = PREPARING_STRING;
                break;
            }
            case 9: {
                str = IN_DOUBT_STRING;
                break;
            }
            case 12: {
                str = COMMITTED_STRING;
                break;
            }
            case 13: {
                str = ROLLEDBACK_STRING;
                break;
            }
            case 3: {
                str = ROLLINGBACK_STRING;
                break;
            }
            case 7: {
                str = HEURISTIC_COMMITTING_STRING;
                break;
            }
            case 8: {
                str = HEURISTIC_ROLLINGBACK_STRING;
                break;
            }
            case 11: {
                str = HEURISTIC_ROLLEDBACK_STRING;
                break;
            }
            case 10: {
                str = HEURISTIC_COMMITTED_STRING;
                break;
            }
            case 14: {
                str = INCONSISTENT_STRING;
                break;
            }
            case 15: {
                str = HEURISTIC_INCONSISTENT_STRING;
                break;
            }
            case 16: {
                str = INVALID_STRING;
                break;
            }
            default: {
                str = UNKNOWN_STRING;
            }
        }
        return str;
    }

    public static String jtaStatusToString(int state) {
        String str = null;
        switch (state) {
            case 0: {
                str = JTA_STATUS_ACTIVE_STRING;
                break;
            }
            case 1: {
                str = JTA_STATUS_MARKED_ROLLBACK_STRING;
                break;
            }
            case 2: {
                str = JTA_STATUS_PREPARED_STRING;
                break;
            }
            case 3: {
                str = JTA_STATUS_COMMITTED_STRING;
                break;
            }
            case 4: {
                str = JTA_STATUS_ROLLEDBACK_STRING;
                break;
            }
            case 5: {
                str = JTA_STATUS_UNKNOWN_STRING;
                break;
            }
            case 6: {
                str = JTA_STATUS_NO_TRANSACTION_STRING;
                break;
            }
            case 7: {
                str = JTA_STATUS_PREPARING_STRING;
                break;
            }
            case 8: {
                str = JTA_STATUS_COMMITTING_STRING;
                break;
            }
            case 9: {
                str = JTA_STATUS_ROLLING_BACK_STRING;
                break;
            }
            default: {
                str = JTA_STATUS_UNKNOWN_STRING;
            }
        }
        return str;
    }

    public static int convertFromJTAStatus(int s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 13;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 17;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Status out of range: " + s);
    }
}

