/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.RecoverableSinglePhaseResource;
import com.evermind.server.SinglePhaseResource;
import com.evermind.server.WrappedXAResource;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.ConnectionLostException;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.LogPresumption;
import oracle.as.j2ee.transaction.tpc.PresumedAbortStrategy;
import oracle.as.j2ee.transaction.tpc.ProtocolError;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.XAState;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.j2ee.transaction.TransactionMessages;

public class Coordinator {
    private GlobalTransaction m_trans;
    private Xid m_xid;
    private LogPresumption m_logPresumption;
    private int m_maxRetries = 1;
    private RecoveryManager m_manager;
    private boolean m_supportsLastResourceCommit = false;
    private final ConcurrentBlock m_block = new ConcurrentBlock();
    private final ProtocolViolationLatch m_protocolLatch = new ProtocolViolationLatch();
    private final RecoveringLatch m_recoveringLatch = new RecoveringLatch();
    private String m_type;
    static final int UNLIMITED_RETRY_COUNT = -1;

    public Coordinator(Xid xid, Store store, RecoveryManager manager, boolean participantRecoverable) {
        this.m_xid = xid;
        this.m_trans = null;
        this.m_manager = manager;
        this.m_logPresumption = new PresumedAbortStrategy(store);
        this.m_supportsLastResourceCommit = store.providesDurability();
    }

    public Coordinator(GlobalTransaction transaction, RecoveryManager manager) {
        this.m_xid = transaction.getXid();
        this.m_trans = transaction;
        this.m_manager = manager;
        this.m_logPresumption = new PresumedAbortStrategy(transaction.getStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(Xid[] xids, XAResource[] resources, boolean rollback) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        ProtocolError err = null;
        try {
            try {
                this.preconditions();
                this.doResolve(xids, resources, rollback);
            }
            catch (ProtocolError e) {
                err = e;
                Object var7_6 = null;
                this.postConditions(err);
                if (err == null) return;
                throw err;
            }
            Object var7_5 = null;
            this.postConditions(err);
            if (err == null) return;
            throw err;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postConditions(err);
            if (err == null) throw throwable;
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare(Xid[] xids, XAResource[] resources, ParentReference pr) throws SystemException, RollbackException {
        ProtocolError err = null;
        try {
            try {
                this.preconditions();
                this.doDiscretePrepare(xids, resources, pr);
            }
            catch (ProtocolError e) {
                err = e;
                Object var7_6 = null;
                this.postConditions(err);
                if (err == null) return;
                throw err;
            }
            Object var7_5 = null;
            this.postConditions(err);
            if (err == null) return;
            throw err;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.postConditions(err);
            if (err == null) throw throwable;
            throw err;
        }
    }

    private void preconditions() {
        this.setInUseFlag();
        this.checkProtocolLatch();
    }

    private void checkProtocolLatch() {
        this.m_protocolLatch.checkViolation();
    }

    private void postConditions(ProtocolError err) {
        if (this.setLatchForError(err)) {
            this.invalidateTransaction();
        }
        this.releaseInUseFlag();
    }

    private void invalidateTransaction() {
        if (this.m_trans != null) {
            this.m_trans.setTransactionState(16);
        }
    }

    private boolean setLatchForError(ProtocolError err) {
        return this.m_protocolLatch.setViolation(err);
    }

    private void doDiscretePrepare(Xid[] xids, XAResource[] resources, ParentReference pr) throws SystemException, RollbackException {
        try {
            this.doPrepare(xids, resources, pr);
        }
        catch (HeuristicRollbackException e) {
            throw new RollbackException();
        }
        catch (HeuristicMixedException e) {
            throw new SystemException("Received a mixed outcome while rolling back resources during prepare");
        }
        catch (SystemException syse) {
            this.m_manager.add(this.m_trans);
            throw syse;
        }
        try {
            this.m_logPresumption.stateEvent(this.m_trans, 9);
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Cannot complete prepare due to error writing to tx log");
            se.initCause((Throwable)e);
            throw se;
        }
        this.m_trans.setTransactionState(9);
    }

    private void doPrepare(Xid[] xids, XAResource[] resources, ParentReference pr) throws SystemException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        try {
            this.initializeGlobalTransaction(xids, resources, 6, pr);
            while (this.actOnEligibleBranch() && this.m_trans.is(6)) {
            }
            if (this.m_trans.is(3)) {
                this.doRollbackWithRollbackException(null);
            }
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Store exception");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private void doRollbackWithRollbackException(String message) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        try {
            this.doRollback(false);
        }
        catch (HeuristicCommitException e) {
            throw new ProtocolErrorWithNotification("Received XAException.XA_HEURCOM after resource voted no from prepare");
        }
        throw new RollbackException(message);
    }

    private void setInUseFlag() {
        this.m_block.acquire();
    }

    private void releaseInUseFlag() {
        this.m_block.release();
    }

    public GlobalTransaction getTransaction() {
        return this.m_trans;
    }

    public int getRetryCount() {
        return this.m_maxRetries;
    }

    public boolean supportsLastResourceCommit() {
        return this.m_supportsLastResourceCommit;
    }

    private void doResolve(Xid[] xids, XAResource[] resources, boolean rollback) throws RollbackException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException, SystemException {
        try {
            if (!rollback) {
                if (this.m_trans == null || this.m_trans.getTransactionState() == 6) {
                    this.doPrepare(xids, resources, null);
                }
                if (this.isCommittable()) {
                    this.doCommit(false);
                } else if (this.m_trans.is(3)) {
                    this.doRollbackWithRollbackException(null);
                }
            } else {
                this.initializeGlobalTransaction(xids, resources, 3, null);
                this.doRollbackWithRollbackException(null);
            }
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Store exception during resolve");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private boolean isCommittable() {
        return (this.m_trans.is(6) || this.m_trans.is(5) || this.m_trans.is(7) || this.m_trans.is(9)) && !this.m_trans.is(3) && !this.m_trans.is(8);
    }

    private void initializeGlobalTransaction(Xid[] xids, XAResource[] resources, int globalState, ParentReference pr) throws Store.StoreException {
        if (this.m_trans == null) {
            this.m_trans = new GlobalTransaction(this.m_logPresumption.getStore(), this.m_xid, globalState, pr);
            this.m_trans.setType(this.m_type);
            ProtocolOptimization optimization = this.determineProtocolOptimization(resources);
            int xaResourceCount = resources.length;
            if (optimization != ProtocolOptimization.NONE) {
                xaResourceCount = resources.length - 1;
            }
            for (int xR = 0; xR < xaResourceCount; ++xR) {
                this.m_trans.addBranch(resources[xR], xids[xR], this.getRMId(resources[xR]), 1);
            }
            if (optimization == ProtocolOptimization.RECOVERABLE_LAST_RESOURCE_COMMIT) {
                this.m_logPresumption.useRLRCOptimization();
                XAResource resource = resources[resources.length - 1];
                this.m_trans.addRecoverableSinglePhaseBranch(resource, xids[resources.length - 1], this.getRMId(resource), 1);
            }
            this.m_logPresumption.creationEvent(this.m_trans);
            if (optimization == ProtocolOptimization.LAST_RESOURCE_COMMIT) {
                this.m_trans.addSinglePhaseBranch(resources[resources.length - 1], xids[resources.length - 1], 1);
            }
        }
    }

    public void setType(String type) {
        this.m_type = type;
    }

    private ProtocolOptimization determineProtocolOptimization(XAResource[] resources) {
        if (!this.supportsLastResourceCommit()) {
            return ProtocolOptimization.NONE;
        }
        XAResource resource = resources[resources.length - 1];
        while (resource instanceof WrappedXAResource) {
            resource = ((WrappedXAResource)((Object)resource)).getWrappedResource();
        }
        if (!(resource instanceof SinglePhaseResource)) {
            return ProtocolOptimization.NONE;
        }
        if (resource instanceof RecoverableSinglePhaseResource) {
            return ProtocolOptimization.RECOVERABLE_LAST_RESOURCE_COMMIT;
        }
        return ProtocolOptimization.LAST_RESOURCE_COMMIT;
    }

    private RMId getRMId(XAResource r) {
        RMId rmId = null;
        if (r instanceof RMId) {
            rmId = (RMId)((Object)r);
        }
        return rmId;
    }

    public void resolve() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        if (this.m_trans.is(5) || this.m_trans.is(7)) {
            this.resolve(null, null, false);
        } else {
            this.resolve(null, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commit(boolean heuristic) throws HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        ProtocolError err = null;
        try {
            try {
                this.preconditions();
                this.verifyNoHeuristic();
                this.doCommit(heuristic);
            }
            catch (ProtocolError e) {
                err = e;
                Object var5_4 = null;
                this.postConditions(err);
                if (err == null) return;
                throw err;
            }
            Object var5_3 = null;
            this.postConditions(err);
            if (err == null) return;
            throw err;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postConditions(err);
            if (err == null) throw throwable;
            throw err;
        }
    }

    private void verifyNoHeuristic() throws HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException {
        if (this.m_trans == null) {
            return;
        }
        switch (this.m_trans.getTransactionState()) {
            case 11: {
                throw new HeuristicRollbackException();
            }
            case 10: {
                throw new HeuristicCommitException();
            }
            case 15: {
                throw new HeuristicMixedException();
            }
        }
    }

    private void doCommit(boolean heuristic) throws HeuristicMixedException, RollbackException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        try {
            if (this.m_trans == null) {
                throw new ProtocolErrorWithNotification("Commit called without prepare.");
            }
            if (!this.isCommittable()) {
                throw new ProtocolErrorWithNotification("Cannot commit transaction " + this.m_trans + " due to illegal state transition");
            }
            if (!this.isCommitting()) {
                this.setCommitState(heuristic);
            }
            this.actOnEligibleBranchForDoCommit();
            this.finished();
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Store exception");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private void actOnEligibleBranchForDoCommit() throws SystemException {
        while (this.actOnEligibleBranch()) {
        }
    }

    private void setCommitState(boolean heuristic) throws Store.StoreException {
        if (heuristic) {
            this.m_logPresumption.stateEvent(this.m_trans, 7);
            this.m_trans.setTransactionState(7);
        } else {
            this.m_logPresumption.stateEvent(this.m_trans, 5);
            this.m_trans.setTransactionState(5);
        }
    }

    boolean isCommitting() {
        return this.m_trans.is(5) || this.m_trans.is(7);
    }

    public void forget() throws SystemException {
        if (this.m_trans == null || !this.m_trans.isHeuristicCompleted()) {
            throw new IllegalStateException();
        }
        this.forgetHeuristicBranches();
        this.forgetTransaction();
        if (this.m_trans.is(10)) {
            this.m_trans.setTransactionState(12);
        } else if (this.m_trans.is(11)) {
            this.m_trans.setTransactionState(13);
        } else if (this.m_trans.is(15)) {
            this.m_trans.setTransactionState(14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void rollback(boolean heuristic) throws HeuristicRollbackException, HeuristicCommitException, HeuristicMixedException, SystemException {
        ProtocolError err = null;
        try {
            try {
                this.preconditions();
                this.verifyNoHeuristic();
                this.doRollback(heuristic);
            }
            catch (ProtocolError e) {
                err = e;
                Object var5_4 = null;
                this.postConditions(err);
                if (err == null) return;
                throw err;
            }
            Object var5_3 = null;
            this.postConditions(err);
            if (err == null) return;
            throw err;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postConditions(err);
            if (err == null) throw throwable;
            throw err;
        }
    }

    private void doRollback(boolean heuristic) throws HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        try {
            if (this.m_trans == null) {
                throw new ProtocolErrorWithNotification("Rollback called without prepare");
            }
            if (!this.isRollingback()) {
                this.setRollbackState(heuristic);
            }
            while (this.actOnEligibleBranch()) {
            }
            this.finished();
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Store exception");
            se.initCause((Throwable)e);
            throw se;
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    private boolean isRollingback() {
        return this.m_trans.getTransactionState() == 3 || this.m_trans.getTransactionState() == 8;
    }

    private void setRollbackState(boolean heuristic) throws Store.StoreException {
        if (heuristic) {
            this.m_logPresumption.stateEvent(this.m_trans, 8);
            this.m_trans.setTransactionState(8);
        } else {
            this.m_logPresumption.stateEvent(this.m_trans, 3);
            this.m_trans.setTransactionState(3);
        }
    }

    private boolean actOnEligibleBranch() throws SystemException {
        boolean acted = false;
        Branch foundBranch = null;
        foundBranch = this.findBranch();
        if (foundBranch != null) {
            this.checkForLostConnection(foundBranch);
            this.doAction(foundBranch);
            acted = true;
        }
        return acted;
    }

    private void doAction(Branch foundBranch) throws SystemException {
        new Action(foundBranch, this.m_trans.associatedAction()).act();
    }

    private void checkForLostConnection(Branch foundBranch) throws SystemException {
        if (foundBranch.xaResource() == null) {
            this.lostResourceCleanup(foundBranch);
        }
    }

    private Branch findBranch() {
        int firstBranch;
        Branch foundBranch = null;
        int action = this.m_trans.associatedAction();
        for (int xBranch = firstBranch = 0; xBranch < this.m_trans.numberOfBranches(); ++xBranch) {
            Branch branch = this.m_trans.getBranch(xBranch);
            if (!branch.getXAState().couldBe(XAState.effective(action))) continue;
            foundBranch = branch;
            break;
        }
        return foundBranch;
    }

    private void lostResourceCleanup(Branch branch) throws SystemException {
        if (this.m_manager != null) {
            TransactionMessages.infoSendingRmfailToRM(this.m_trans, branch);
            branch.setStatus(0);
            this.m_manager.add(this.m_trans);
        } else if (this.m_recoveringLatch.isRecovering()) {
            TransactionMessages.severeCouldNotFindRecoveryMgr(this.m_trans, branch);
        }
        throw new ConnectionLostException("Handing off to RecoveryManager due to lost connection to resource or RMERR. Branch: " + branch);
    }

    private void finished() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, HeuristicCommitException, SystemException {
        try {
            boolean finished = this.checkFinishCommit();
            if (!finished) {
                finished = this.checkFinishRollback();
            }
            if (!finished) {
                if (this.m_trans.hasMixedHeuristicBranches()) {
                    this.finishHeuristicMixed();
                }
                if (this.m_trans.hasInconsistentBranches()) {
                    this.finishInconsistent();
                } else {
                    this.inappropriateFinish();
                }
            }
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Store exception");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    private boolean checkFinishCommit() throws Store.StoreException, HeuristicRollbackException, HeuristicCommitException {
        if (this.m_trans.isCommitting()) {
            if (this.m_trans.allBranchesCommitted()) {
                if (this.m_trans.hasHeuristicCommittedBranches()) {
                    this.finishHeuristicCommit();
                    return true;
                }
                this.finishCommit();
                return true;
            }
            if (this.m_trans.allBranchesHeuristicRolledback()) {
                this.finishHeuristicRollback();
                return true;
            }
        }
        return false;
    }

    private boolean checkFinishRollback() throws Store.StoreException, RollbackException, HeuristicRollbackException, HeuristicCommitException {
        if (this.m_trans.isRollingback()) {
            if (this.m_trans.allBranchesRolledback()) {
                if (this.m_trans.hasHeuristicRolledbackBranches()) {
                    this.finishHeuristicRollback();
                    return true;
                }
                this.finishRollback();
                return true;
            }
            if (this.m_trans.allBranchesHeuristicCommitted()) {
                this.finishHeuristicCommit();
                return true;
            }
        }
        return false;
    }

    private void finishCommit() throws Store.StoreException {
        if (this.m_trans.is(7)) {
            this.m_logPresumption.stateEvent(this.m_trans, 10);
            this.m_trans.setTransactionState(10);
        } else {
            this.m_logPresumption.forgetEvent(this.m_trans);
            this.m_trans.setTransactionState(12);
        }
    }

    private void finishRollback() throws Store.StoreException, RollbackException {
        if (this.m_trans.is(8)) {
            this.m_logPresumption.stateEvent(this.m_trans, 11);
            this.m_trans.setTransactionState(11);
        } else {
            this.m_logPresumption.forgetEvent(this.m_trans);
            this.m_trans.setTransactionState(13);
        }
        throw new RollbackException();
    }

    private void finishHeuristicCommit() throws Store.StoreException, HeuristicCommitException {
        this.m_logPresumption.stateEvent(this.m_trans, 10);
        this.m_trans.setTransactionState(10);
        throw new HeuristicCommitException();
    }

    private void finishHeuristicRollback() throws Store.StoreException, HeuristicRollbackException {
        this.m_logPresumption.stateEvent(this.m_trans, 11);
        this.m_trans.setTransactionState(11);
        throw new HeuristicRollbackException();
    }

    private void finishHeuristicMixed() throws Store.StoreException, HeuristicMixedException {
        this.m_logPresumption.stateEvent(this.m_trans, 15);
        this.m_trans.setTransactionState(15);
        throw new HeuristicMixedException("Inconsistent heuristic end state for transaction " + this.m_trans);
    }

    private void finishInconsistent() throws Store.StoreException, SystemException {
        this.m_logPresumption.stateEvent(this.m_trans, 14);
        this.m_trans.setTransactionState(14);
        throw new SystemException("Inconsistent end state for transaction " + this.m_trans);
    }

    private void inappropriateFinish() throws SystemException {
        throw new SystemException("Unexpected end state for transaction " + this.m_trans);
    }

    private boolean forgetHeuristicBranches() {
        boolean forgotAll = true;
        for (int i = 0; i < this.m_trans.numberOfBranches(); ++i) {
            if (!this.m_trans.getBranch(i).getXAState().couldBe(28)) continue;
            try {
                this.m_trans.getBranch(i).act(4);
                this.m_trans.getBranch(i).getXAState().modelPresumption();
                continue;
            }
            catch (XAException e) {
                if (e.errorCode == -4) continue;
                forgotAll = false;
                TransactionMessages.warningCouldNotForgetBranch(this.m_trans.getBranch(i), this.m_trans);
            }
        }
        return forgotAll;
    }

    private void forgetTransaction() throws SystemException {
        try {
            this.m_logPresumption.forgetEvent(this.m_trans);
        }
        catch (Store.StoreException e) {
            SystemException se = new SystemException("Unable to forget transaction");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    void setMaximumRetryCount(int max) {
        this.m_maxRetries = max;
    }

    public String toString() {
        return "Coordinator:" + this.getTransaction();
    }

    public void setRecovering() {
        this.m_recoveringLatch.setRecovering();
    }

    private static class ProtocolOptimization {
        private final String m_optimization;
        public static final ProtocolOptimization NONE = new ProtocolOptimization("NONE");
        public static final ProtocolOptimization LAST_RESOURCE_COMMIT = new ProtocolOptimization("LAST_RESOURCE_COMMIT");
        public static final ProtocolOptimization RECOVERABLE_LAST_RESOURCE_COMMIT = new ProtocolOptimization("RECOVERABLE_LAST_RESOURCE_COMMIT");

        private ProtocolOptimization(String optimization) {
            this.m_optimization = optimization;
        }

        public String toString() {
            return this.m_optimization;
        }
    }

    private class RecoveringLatch {
        private boolean m_recovering = false;

        private RecoveringLatch() {
        }

        private synchronized void setRecovering() {
            this.m_recovering = true;
        }

        private synchronized boolean isRecovering() {
            return this.m_recovering;
        }
    }

    private class ProtocolViolationLatch {
        private ProtocolError m_error;

        private ProtocolViolationLatch() {
        }

        private synchronized boolean setViolation(ProtocolError e) {
            if (this.m_error == null && e != null) {
                this.m_error = e;
                return true;
            }
            return false;
        }

        private synchronized void checkViolation() {
            if (this.m_error != null) {
                ProtocolErrorWithNotification e = new ProtocolErrorWithNotification("Coordinator not valid");
                e.initCause(this.m_error);
                throw e;
            }
        }
    }

    private class ConcurrentBlock {
        private Thread m_owner = null;

        private ConcurrentBlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire() {
            Thread caller = Thread.currentThread();
            ConcurrentBlock concurrentBlock = this;
            synchronized (concurrentBlock) {
                if (this.m_owner != null) {
                    throw new IllegalStateException("Not reentrant");
                }
                this.m_owner = caller;
            }
        }

        private synchronized void release() {
            if (Thread.currentThread() == this.m_owner) {
                this.m_owner = null;
            }
        }
    }

    class Action {
        Branch branch;
        int action;
        int xaVote = -1;
        XAException xaEx;
        boolean completed;

        public Action(Branch branch, int action) {
            this.branch = branch;
            this.action = action;
        }

        public void act() throws SystemException {
            try {
                int result = this.branch.act(this.action);
                this.completed = true;
                switch (this.action) {
                    case 0: {
                        this.handleSuccessfulPrepare(result);
                        break;
                    }
                    case 1: {
                        this.branch.setStatus(32);
                        break;
                    }
                    case 2: {
                        this.branch.setStatus(32);
                        break;
                    }
                    case 3: {
                        this.branch.setStatus(64);
                        break;
                    }
                    case 4: {
                        this.branch.getXAState().modelPresumption();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (XAException ex) {
                TransactionMessages.warningXAException(this.action, ex, ex.errorCode, this.branch, Thread.currentThread().getName());
                this.xaEx = ex;
                this.completed = true;
                this.processException(ex);
            }
            catch (RuntimeException re) {
                ProtocolErrorWithNotification pe = new ProtocolErrorWithNotification("RuntimeException caught by Coordinator.");
                pe.initCause(re);
                throw pe;
            }
        }

        private void handleSuccessfulPrepare(int result) {
            switch (result) {
                case 0: {
                    this.xaVote = result;
                    if (this.branch.isOnePhase()) {
                        this.branch.setStatus(32);
                        break;
                    }
                    this.branch.setStatus(2);
                    break;
                }
                case 3: {
                    this.xaVote = result;
                    this.branch.setStatus(128);
                    break;
                }
                default: {
                    throw new ProtocolErrorWithNotification("Invalid return " + result + " from prepare for branch " + this.branch);
                }
            }
        }

        private synchronized void processException(XAException xaEx) throws SystemException {
            try {
                this.interpretException(xaEx);
                this.branch.setException(xaEx);
            }
            catch (Store.StoreException e) {
                SystemException se = new SystemException("Store exception");
                se.initCause((Throwable)e);
                throw se;
            }
        }

        private void interpretException(XAException xaException) throws Store.StoreException, SystemException {
            int errorCode = xaException.errorCode;
            switch (errorCode) {
                case 7: {
                    this.processHeuristicCommit();
                    break;
                }
                case 8: {
                    this.processHeuristicHazard(xaException);
                    break;
                }
                case 5: {
                    this.processHeuristicMixed();
                    break;
                }
                case 6: {
                    this.processHeuristicRollback();
                    break;
                }
                case 9: {
                    this.processNoMigrate();
                    break;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.processRB();
                    break;
                }
                case 3: {
                    this.processRDOnly();
                    break;
                }
                case 4: {
                    this.processRetry(xaException);
                    break;
                }
                case -2: {
                    this.processAsynch();
                    break;
                }
                case -8: {
                    this.processDupId();
                    break;
                }
                case -5: {
                    this.processInval();
                    break;
                }
                case -4: {
                    this.processNota();
                    break;
                }
                case -9: {
                    this.processOutside();
                    break;
                }
                case -6: {
                    this.processProto();
                    break;
                }
                case -3: {
                    this.processRMErr(xaException);
                    break;
                }
                case -7: {
                    this.processXaRmFail(xaException);
                    break;
                }
                default: {
                    throw new ProtocolErrorWithNotification("Received nonsensical error code " + errorCode + " from branch " + this.branch + " in transaction " + Coordinator.this.m_trans);
                }
            }
        }

        private void processRB() throws Store.StoreException {
            if (Coordinator.this.isCommitting()) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned RB* during commit.");
            }
            this.branch.setStatus(64);
            if (Coordinator.this.m_trans.is(6)) {
                Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                Coordinator.this.m_trans.setTransactionState(3);
            }
        }

        private void processHeuristicCommit() {
            if (Coordinator.this.m_trans.is(6)) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned HEURCOMM during prepare");
            }
            this.branch.setStatus(4);
        }

        private void processHeuristicHazard(XAException xaException) throws SystemException, Store.StoreException {
            if (Coordinator.this.m_trans.is(6)) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned heuristic hazard during prepare");
            }
            this.branch.setStatus(this.branch.getXAState().getState() | 0x1C);
            this.branch.incrementRetryCount();
            if (this.branch.getRetryCount() > Coordinator.this.m_maxRetries) {
                this.processAnticipatedErrorCode(xaException);
            }
        }

        private void processHeuristicMixed() {
            if (Coordinator.this.m_trans.is(6)) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned heuristic mixed during prepare");
            }
            this.branch.setStatus(28);
        }

        private void processHeuristicRollback() {
            if (Coordinator.this.m_trans.is(6)) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned heuristic rollback during prepare");
            }
            this.branch.setStatus(8);
        }

        private void processNoMigrate() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned NOMIGRATE.");
        }

        private void processRDOnly() {
            if (!Coordinator.this.m_trans.is(6)) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned RDONLY outside of prepare state.");
            }
            this.branch.setStatus(128);
        }

        private void processRetry(XAException xaException) throws Store.StoreException, SystemException {
            if (!Coordinator.this.isCommitting()) {
                throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned RDONLY outside of commit state.");
            }
            this.branch.incrementRetryCount();
            if (this.branch.getRetryCount() > Coordinator.this.m_maxRetries) {
                this.processAnticipatedErrorCode(xaException);
            }
        }

        private void processDupId() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned DUPID.");
        }

        private void processInval() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned XAER_INVAL.");
        }

        private void processOutside() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned XAERR_OUTSIDE.");
        }

        private void processXaRmFail(XAException xaException) throws Store.StoreException {
            if (this.branch.isOnePhase() && this.branch.supportsRecovery()) {
                this.handleTransferOfControlException();
                return;
            }
            if (Coordinator.this.m_trans.getTransactionState() == 6) {
                Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                Coordinator.this.m_trans.setTransactionState(3);
            }
            this.branch.setXaResource(null);
            Coordinator.this.m_trans.reorderBranches(this.branch, xaException);
        }

        private void handleTransferOfControlException() throws Store.StoreException {
            if (Coordinator.this.m_trans.getTransactionState() == 6) {
                boolean canContinue = false;
                int result = 5;
                RMId rmid = Coordinator.this.getRMId(this.branch.xaResource());
                int retryCount = 0;
                while (!(canContinue || Coordinator.this.getRetryCount() <= retryCount && Coordinator.this.getRetryCount() != -1)) {
                    try {
                        XAResource newResource = Coordinator.this.m_manager.acquireXAResource(rmid, true);
                        this.branch.setXaResource(newResource);
                        result = this.branch.act(6);
                    }
                    catch (XAException e) {
                    }
                    catch (TPCException e) {
                        TransactionMessages.warningTPCExeptionDuringHandleTransferOfControlException(rmid, e);
                    }
                    switch (result) {
                        case 3: {
                            this.handleSuccessfulPrepare(0);
                            canContinue = true;
                            break;
                        }
                        case 4: {
                            this.processRB();
                            canContinue = true;
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    if (canContinue) continue;
                    try {
                        ++retryCount;
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private void processAsynch() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned XAER_ASYNCH.");
        }

        private void processProto() {
            throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " returned XAER_PROTO.");
        }

        private void processRMErr(XAException xaException) throws Store.StoreException {
            if (Coordinator.this.m_trans.is(6)) {
                if (Coordinator.this.m_trans.getTransactionState() == 6) {
                    Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                    Coordinator.this.m_trans.setTransactionState(3);
                }
                this.branch.setXaResource(null);
                Coordinator.this.m_trans.reorderBranches(this.branch, xaException);
            } else {
                this.branch.setStatus(64);
                if (Coordinator.this.m_trans.is(5)) {
                    Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                    Coordinator.this.m_trans.setTransactionState(3);
                }
            }
        }

        private void processNota() throws Store.StoreException {
            switch (Coordinator.this.m_trans.getTransactionState()) {
                case 6: {
                    this.branch.getXAState().modelPresumption();
                    Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                    Coordinator.this.m_trans.setTransactionState(3);
                    break;
                }
                case 5: 
                case 7: {
                    if (Coordinator.this.m_recoveringLatch.isRecovering()) {
                        this.branch.setStatus(160);
                        break;
                    }
                    throw new ProtocolErrorWithNotification("Branch " + this.branch + " in transaction " + Coordinator.this.m_trans + " NOTA for prepared branch while in commit state.");
                }
                case 3: 
                case 8: {
                    this.branch.getXAState().modelPresumption();
                    break;
                }
            }
        }

        private void processAnticipatedErrorCode(XAException xaException) throws SystemException, Store.StoreException {
            if (!Coordinator.this.m_trans.reorderBranches(this.branch, xaException)) {
                TransactionMessages.severeCoordinatoreCantProceed(Coordinator.this.m_trans.getXid());
                throw new SystemException("Unable to continue processing after xaerr " + Coordinator.this.m_trans.toString());
            }
            if (Coordinator.this.m_trans.is(6)) {
                TransactionMessages.warningCoordinatorAttemptingRB(Coordinator.this.m_trans.getXid());
                Coordinator.this.m_logPresumption.stateEvent(Coordinator.this.m_trans, 3);
                Coordinator.this.m_trans.setTransactionState(3);
            }
        }
    }
}

