/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.MiddleTierCoordinatorConfiguration;
import oracle.as.j2ee.transaction.tpc.FileChannelPool;
import oracle.as.j2ee.transaction.tpc.FileStoreInputStream;
import oracle.as.j2ee.transaction.tpc.FileStorePooledFileChannel;
import oracle.as.j2ee.transaction.tpc.FileStoreWriteUtils;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.NormalXid;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoveredRMId;
import oracle.as.j2ee.transaction.tpc.Store;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransactionInfo;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JSecurity;

public class MultiFileStore
extends Store {
    static final String DEFAULT_LOG_DIR = "." + File.separator + "persistence" + File.separator + "txlogs";
    static final String ARCHIVE = "archive";
    static final String TAKEOVER = "takeover";
    static final String LOCK_FILE_EXTENSION = ".lock";
    static final String RESOURCES_FILE_EXTENSION = ".resources";
    static final String ARCHIVE_DIR_SUFFIX = File.separator + "archive";
    static final String TAKEOVER_DIR_SUFFIX = File.separator + "takeover";
    static final String DEFAULT_ARCHIVE_DIR = DEFAULT_LOG_DIR + ARCHIVE_DIR_SUFFIX;
    static final String LOG_PREFIX = "tx.";
    static final int SLEEP_BETWEEN_LOCK_ATTEMPTS = 3000;
    static final int K_EOF = -1;
    static final int K_NEWLINE = 0;
    static final int K_PARENT = 1;
    static final int K_TRANS = 2;
    static final int K_BRANCH = 3;
    static final int K_STATE = 4;
    static final int DEFAULT_PREALLOCATED_TO_POOL = 20;
    static final int MAX_LOCK_RETRY = 3;
    private FileChannelPool m_filechannelPool;
    FileStoreWriteUtils m_writeUtils = new FileStoreWriteUtils();
    private static Logger m_logger = TraceLogger.getLogger(MultiFileStore.class);
    private FileLock m_thisStoresLock = null;
    private FileLock m_peerStoresLock = null;
    private String m_parentDirectoryLocation;
    private FileChannel m_resourcesFileChannel;

    public MultiFileStore(MiddleTierCoordinatorConfiguration configuration, String serverId) throws Store.StoreException {
        super(serverId);
        this.m_parentDirectoryLocation = configuration.getLocation() + File.separator + "txlogs" + File.separator;
        this.setupLogDirsAndPool(configuration.getLocation(), serverId, configuration.getMaxOpenFiles(), false);
        this.setupResourcesFile();
        this.moveFilesToActiveDir(this.m_writeUtils.createFile(this.getFileChannelPool().getArchiveLogLocation(), true));
        this.deleteEmptyFiles();
        this.incrementCurrentFileNumberBasedOnExisting();
        this.preallocateToPool(configuration.getMinPoolSize());
    }

    public MultiFileStore(String location) throws Store.StoreException {
        super("offline_analysis");
        this.m_parentDirectoryLocation = location;
        this.setupLogDirsAndPool(location, "", Integer.MAX_VALUE, true);
        this.moveFilesToActiveDir(this.m_writeUtils.createFile(this.m_parentDirectoryLocation + ARCHIVE_DIR_SUFFIX, true));
        this.deleteEmptyFiles();
        this.incrementCurrentFileNumberBasedOnExisting();
    }

    private void setupLogDirsAndPool(String logLocation, String serverId, int maxInPool, boolean isOfflineTool) throws Store.StoreException {
        String logFilePath;
        if (logLocation != null && !"".equals(logLocation)) {
            logFilePath = isOfflineTool ? logLocation : this.setParentDirAndGetLogFilePath(logLocation, serverId);
        } else {
            logFilePath = this.setParentDirAndGetLogFilePath(DEFAULT_LOG_DIR, serverId);
            TransactionMessages.configNoLogPathSpecifiedUsingDefault(logFilePath);
        }
        File archiveDir = this.m_writeUtils.createFile(logFilePath + ARCHIVE_DIR_SUFFIX, true);
        this.m_filechannelPool = new FileChannelPool(logFilePath, new File(logFilePath), archiveDir, maxInPool);
    }

    void lockStore() throws Store.StoreException {
        String lockFileName = this.m_parentDirectoryLocation + File.separator + this.serverId() + LOCK_FILE_EXTENSION;
        int currentLockAttempt = 0;
        while (this.m_thisStoresLock == null) {
            if (currentLockAttempt != 0) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    TransactionMessages.warning("InterruptedException during reattempt of file store lock e=" + e);
                }
            }
            this.m_thisStoresLock = this.obtainLock(lockFileName, true);
            if (this.m_thisStoresLock == null && currentLockAttempt > 3) {
                throw new Store.StoreException("Unable to lock store peer recovery may be in process");
            }
            ++currentLockAttempt;
        }
    }

    void setupResourcesFile() throws Store.StoreException {
        String resourcesFileName = this.m_parentDirectoryLocation + File.separator + this.serverId() + RESOURCES_FILE_EXTENSION;
        try {
            File file = this.m_writeUtils.createFile(resourcesFileName, false);
            FileOutputStream fileOutputStream = OC4JSecurity.newFileOutputStream(file, true);
            this.m_resourcesFileChannel = fileOutputStream.getChannel();
        }
        catch (IOException e) {
            Store.StoreException storeException = new Store.StoreException("IOException occurred while creating or retrieving resources transaction log");
            storeException.initCause(e);
            throw storeException;
        }
    }

    FileLock obtainLock(String lockFileName, boolean isThisStoresLock) throws Store.StoreException {
        FileLock fileLock = null;
        try {
            if (!isThisStoresLock && !new File(lockFileName).exists()) {
                return null;
            }
            FileOutputStream fileOutputStream = OC4JSecurity.newFileOutputStream(this.m_writeUtils.createFile(lockFileName, false));
            fileLock = fileOutputStream.getChannel().tryLock();
            if (fileLock == null || !fileLock.isValid()) {
                fileLock = null;
            }
        }
        catch (OverlappingFileLockException e) {
            if (isThisStoresLock) {
                TransactionMessages.warning("Unable to obtain lock transaction log store due to OverlappingFileLockException : " + e);
            }
        }
        catch (IOException e) {
            TransactionMessages.warning("Unable to obtain lock transaction log store due to IOException : " + e);
        }
        return fileLock;
    }

    boolean recoverPeer() throws Store.StoreException {
        File[] fileStoreLocks = new File(this.m_parentDirectoryLocation).listFiles();
        for (int i = 0; i < fileStoreLocks.length; ++i) {
            if (fileStoreLocks[i].getName().indexOf(LOCK_FILE_EXTENSION) <= -1 || fileStoreLocks[i].getName().indexOf(this.serverId()) > -1) continue;
            TransactionMessages.finer("Attempting to acquire lock of peer " + fileStoreLocks[i].getName());
            this.m_peerStoresLock = this.obtainLock(this.m_parentDirectoryLocation + File.separator + fileStoreLocks[i].getName(), false);
            if (this.m_peerStoresLock == null) continue;
            String peerDirPathName = this.m_parentDirectoryLocation + File.separator + fileStoreLocks[i].getName().replaceAll(LOCK_FILE_EXTENSION, "");
            File peerDir = new File(peerDirPathName);
            if (peerDir.exists()) {
                this.moveFilesToActiveDir(peerDir);
            }
            if (!(peerDir = new File(peerDirPathName + ARCHIVE_DIR_SUFFIX)).exists()) continue;
            this.moveFilesToActiveDir(peerDir);
        }
        return false;
    }

    private void moveFilesToActiveDir(File dir) {
        File[] archiveFiles = dir.listFiles();
        if (archiveFiles != null) {
            for (int i = 0; i < archiveFiles.length; ++i) {
                if (archiveFiles[i].length() == 0L) {
                    archiveFiles[i].delete();
                    continue;
                }
                if (archiveFiles[i].getName().equals(ARCHIVE)) continue;
                archiveFiles[i].renameTo(new File(this.getFileChannelPool().getNextFullFileName()));
            }
        }
    }

    private void deleteEmptyFiles() {
        File[] oldFiles = new File(this.getLogLocation()).listFiles();
        if (oldFiles != null) {
            for (int i = 0; i < oldFiles.length; ++i) {
                if (oldFiles[i].length() != 0L) continue;
                oldFiles[i].delete();
            }
        }
    }

    private void preallocateToPool(int preallocated) throws Store.StoreException {
        for (int i = 0; i < preallocated; ++i) {
            NormalXid xid = new NormalXid(("" + i).getBytes(), i);
            try {
                this.m_filechannelPool.createPooledFileChannelAndPutInMap(xid);
                this.m_filechannelPool.moveFromActiveToPool(xid);
                continue;
            }
            catch (IOException e) {
                Store.StoreException se = new Store.StoreException("Unable to preallocate to the file store pool");
                se.initCause(e);
                throw se;
            }
        }
    }

    private void incrementCurrentFileNumberBasedOnExisting() {
        File[] oldFiles = new File(this.getLogLocation()).listFiles();
        if (oldFiles == null) {
            return;
        }
        for (int i = 0; i < oldFiles.length; ++i) {
            int existingFileNumber = this.getCurrentFileNumber();
            try {
                if (!oldFiles[i].getName().equals(ARCHIVE)) {
                    existingFileNumber = new Integer(oldFiles[i].getName().replaceAll(LOG_PREFIX, ""));
                }
            }
            catch (NumberFormatException nfe) {
                TransactionMessages.warningIgnoringUnexpectedFileInTxLogDir(oldFiles[i]);
            }
            if (existingFileNumber < this.getCurrentFileNumber()) continue;
            this.setCurrentFileNumber(existingFileNumber);
        }
    }

    public FileChannelPool getFileChannelPool() {
        return this.m_filechannelPool;
    }

    void setCurrentFileNumber(int currentFileNumber) {
        this.getFileChannelPool().setCurrentFileNumber(currentFileNumber);
    }

    int getCurrentFileNumber() {
        return this.getFileChannelPool().getCurrentFileNumber();
    }

    String setParentDirAndGetLogFilePath(String logFilePath, String serverId) {
        this.m_parentDirectoryLocation = logFilePath;
        StringBuffer buf = new StringBuffer();
        buf.append(logFilePath);
        if (!logFilePath.endsWith(File.separator)) {
            buf.append(File.separator);
        }
        buf.append(serverId);
        return buf.toString();
    }

    public String getLogLocation() {
        return this.getFileChannelPool().getLogLocation();
    }

    protected void noteTransaction(GlobalTransaction transaction, int newState) throws Store.StoreException {
        try {
            FileStorePooledFileChannel channel = this.m_filechannelPool.getNewPooledFileChannel(transaction.getXid());
            ArrayList buffers = new ArrayList(1);
            this.m_writeUtils.noteTransactionXid(buffers, transaction);
            this.m_writeUtils.noteParentReference(buffers, transaction);
            this.m_writeUtils.noteBranches(buffers, transaction);
            this.m_writeUtils.noteStateWithoutForce(buffers, newState);
            this.m_writeUtils.forceToDisk(buffers, channel);
        }
        catch (IOException e) {
            Store.StoreException se = new Store.StoreException("Could not write transaction log for " + transaction);
            se.initCause(e);
            throw se;
        }
    }

    public void noteState(GlobalTransaction transaction, int state) throws Store.StoreException {
        try {
            FileStorePooledFileChannel channel = this.retrieveFileChannel(transaction.getXid());
            ArrayList buffers = new ArrayList(1);
            this.m_writeUtils.noteStateWithoutForce(buffers, state);
            this.m_writeUtils.forceToDisk(buffers, channel);
        }
        catch (IOException e) {
            Store.StoreException se = new Store.StoreException("Exception writing state to transaction log for " + transaction);
            se.initCause(e);
            throw se;
        }
    }

    public void noteForget(GlobalTransaction transaction) throws Store.StoreException {
        try {
            this.m_filechannelPool.moveFromActiveToPool(transaction.getXid());
        }
        catch (IOException ioException) {
            TransactionMessages.warning("Unable to truncate transaction log file and add it back to the pool: " + ioException);
            throw new Store.StoreException(ioException.getMessage());
        }
    }

    private void setGlobalAndBranchStates(GlobalTransaction tx, FileStoreInputStream in, File file) throws IOException, Store.StoreException {
        int lineTypeCount = 0;
        int lineType = in.nextLineType();
        while (lineType == 3) {
            this.setBranchFromFile(tx, in);
            ++lineTypeCount;
            lineType = in.nextLineType();
        }
        if (lineTypeCount == 0) {
            throw new Store.StoreException(file.getCanonicalPath() + " has no branch information");
        }
        lineTypeCount = 0;
        while (lineType == 4) {
            this.setStateFromFile(tx, in);
            lineType = in.nextLineType();
            ++lineTypeCount;
        }
        if (lineTypeCount == 0) {
            file.delete();
            throw new Store.StoreException(file.getCanonicalPath() + " no state information");
        }
    }

    boolean providesDurability() {
        return true;
    }

    public String toString() {
        return "File store on " + this.getLogLocation();
    }

    void noteResource(RMId rmid, String rlrcName) throws Store.StoreException {
        ArrayList buffers = new ArrayList(1);
        this.m_writeUtils.writeRMIdWithRLRCName(rmid, rlrcName, buffers);
        this.m_writeUtils.forceResourceEntryToDisk(buffers, this.m_resourcesFileChannel);
    }

    public List recover() throws Store.StoreException {
        LinkedList list = new LinkedList();
        try {
            this.addFileTxsToList(this.getFileChannelPool().getActiveDir().listFiles(), list);
        }
        catch (FileNotFoundException e) {
            Store.StoreException se = new Store.StoreException("Log directory " + this.getLogLocation() + " does not exist. ");
            se.initCause(e);
            throw se;
        }
        catch (IOException e) {
            Store.StoreException se = new Store.StoreException("IO failure" + e.getMessage());
            se.initCause(e);
            throw se;
        }
        return list;
    }

    List getRecoveringRMIds() throws Store.StoreException {
        ArrayList<RecoveredRMId> rmidList = new ArrayList<RecoveredRMId>();
        try {
            File resourcesFile = this.m_writeUtils.createFile(this.m_parentDirectoryLocation + File.separator + this.serverId() + RESOURCES_FILE_EXTENSION, false);
            FileStoreInputStream fileStoreInputStream = new FileStoreInputStream(resourcesFile);
            while (!fileStoreInputStream.atEOF()) {
                RecoveredRMId rmid = fileStoreInputStream.readRecoveredRMId();
                if (rmid.getRMFactoryJndiLocation().getJndiLocation() != null && !rmid.getRMFactoryJndiLocation().getJndiLocation().equals("")) {
                    rmidList.add(rmid);
                }
                this.rmIdJndiLocations.add(rmid.getRMFactoryJndiLocation().getJndiLocation() + rmid.getRLRCLocation() == null ? "" : rmid.getRLRCLocation());
            }
        }
        catch (IOException e) {
            Store.StoreException storeException = new Store.StoreException("Unable to get recovering RMIds");
            storeException.initCause(e);
            throw storeException;
        }
        return rmidList;
    }

    public RecoveringTransactionInfo getRecoveringTransactionInfo() throws Store.StoreException {
        return new RecoveringTransactionInfo(this.recover(), this.getRecoveringRMIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileTxsToList(File[] files, List list) throws IOException, Store.StoreException {
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(ARCHIVE) || files[i].length() == 0L) continue;
            FileStoreInputStream in = new FileStoreInputStream(files[i]);
            try {
                String fileName = files[i].getCanonicalPath();
                if (fileName.indexOf(LOG_PREFIX) <= 0) continue;
                GlobalTransaction tx = this.createTransactionFromFile(in, fileName);
                this.setParentReferenceFromFile(tx, in, files[i]);
                this.setGlobalAndBranchStates(tx, in, files[i]);
                list.add(tx);
                this.getFileChannelPool().putInActiveMap(tx.getXid(), new FileStorePooledFileChannel(tx.getXid(), OC4JSecurity.newFileOutputStream(files[i], true), files[i].getName()));
                continue;
            }
            finally {
                in.close();
            }
        }
    }

    private void setParentReferenceFromFile(GlobalTransaction tx, FileStoreInputStream in, File file) throws IOException, Store.StoreException {
        if (in.nextLineType() != 1) {
            throw new Store.StoreException(file.getCanonicalPath() + " has no parent reference entry.");
        }
        tx.setParentReference(in.readParentReference());
    }

    GlobalTransaction createTransactionFromFile(FileStoreInputStream in, String fileName) throws IOException, Store.StoreException {
        GlobalTransaction globalTransaction = new GlobalTransaction(this, this.getFileChannelPool().getXidFromFile(in, fileName));
        globalTransaction.setType(this.getFileChannelPool().getTypeFromFile(in, fileName));
        return globalTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GlobalTransaction recover(Xid xid) throws Store.StoreException {
        FileStoreInputStream in = null;
        File file = null;
        try {
            try {
                GlobalTransaction globalTransaction;
                FileChannelPool fileChannelPool = this.m_filechannelPool;
                synchronized (fileChannelPool) {
                    FileStorePooledFileChannel activePooledFileChannelForXid = this.m_filechannelPool.getActivePooledFileChannelForXid(xid);
                    if (activePooledFileChannelForXid != null) {
                        m_logger.log(Level.FINER, "Active Pool contains file for recover(xid) xid = {0} ", xid);
                        file = new File(this.getLogLocation() + File.separatorChar + activePooledFileChannelForXid.getFileName());
                        if (m_logger.isLoggable(Level.FINER)) {
                            m_logger.log(Level.FINER, "File in active pool for recover(xid) found xid = {0} file = {1}", new Object[]{xid, file});
                        }
                    } else {
                        m_logger.log(Level.FINER, "Active Pool does not contain file for recover(xid), therefore searching archive for xid = {0} ", xid);
                        file = this.m_filechannelPool.getFileFromArchive(xid);
                        if (m_logger.isLoggable(Level.FINER)) {
                            m_logger.log(Level.FINER, "File for recover(xid) found in archive xid = {0} file = {1}", new Object[]{xid, file});
                        }
                    }
                    in = new FileStoreInputStream(file);
                    GlobalTransaction tx = this.createTransactionFromFile(in, file.getCanonicalPath());
                    this.setParentReferenceFromFile(tx, in, file);
                    this.setGlobalAndBranchStates(tx, in, file);
                    globalTransaction = tx;
                }
                Object var10_10 = null;
                try {
                    if (in == null) return globalTransaction;
                    in.close();
                    return globalTransaction;
                }
                catch (IOException e) {
                    TransactionMessages.warningUnableToCloseInputForFile(file, xid);
                }
                return globalTransaction;
            }
            catch (IOException e) {
                Store.StoreException se = new Store.StoreException("Failed to recover " + xid + file == null ? "" : " file : " + file.getAbsolutePath());
                se.initCause(e);
                throw se;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {}
            catch (IOException e) {
                TransactionMessages.warningUnableToCloseInputForFile(file, xid);
                throw throwable;
            }
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
    }

    private void setBranchFromFile(GlobalTransaction transaction, FileStoreInputStream in) throws IOException {
        Xid xId = in.readXid();
        RMId rmId = in.readRMId();
        transaction.addBranch(null, xId, rmId, 0);
    }

    private void setStateFromFile(GlobalTransaction transaction, FileStoreInputStream in) throws IOException {
        int state = in.readInt(Integer.MAX_VALUE);
        transaction.setTransactionState(state);
    }

    FileStorePooledFileChannel retrieveFileChannel(Xid xid) throws Store.StoreException, IOException {
        FileStorePooledFileChannel fileChannel = this.m_filechannelPool.getActivePooledFileChannelForXid(xid);
        if (fileChannel == null) {
            fileChannel = this.m_filechannelPool.checkArchive(xid);
        }
        return fileChannel;
    }

    public boolean shutdown(boolean isClean) {
        if (isClean) {
            try {
                this.m_resourcesFileChannel.truncate(0L);
                this.m_resourcesFileChannel.position(0L);
            }
            catch (IOException e) {
                TransactionMessages.warning("Unable to purge log file during shutdown or restart.  This may result in additional recovery processing checks during server startup, but is generally harmless.");
            }
        }
        this.getFileChannelPool().closeAllFileOutputs();
        try {
            if (this.m_thisStoresLock != null) {
                this.m_thisStoresLock.release();
            }
        }
        catch (IOException e) {
            TransactionMessages.warning("Unable to release file lock on transaction logs.");
        }
        return true;
    }
}

