/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.RecoverableSinglePhaseResource;
import com.evermind.server.WrappedXAResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseBranch;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManager;
import oracle.j2ee.transaction.TransactionMessages;

public class RecoverableSinglePhaseResourceReaperTask
implements Runnable {
    RecoveryManager m_recoveryManager;
    Map m_rmidLocationToRecoverableSinglePhaseResourceMap = new HashMap();
    Map rmidLocationToTransactionSetMap = new HashMap();
    pArrayList m_txList = new pArrayList();
    int m_purgeInterval = 10;
    int m_minBatchSize = 1000;
    boolean m_isCancelled = false;
    boolean m_isShuttingDown = false;

    public RecoverableSinglePhaseResourceReaperTask(RecoveryManager recoveryManager, int purgeInterval, int minBatchSize) {
        this.m_recoveryManager = recoveryManager;
        this.m_purgeInterval = purgeInterval;
        this.m_minBatchSize = minBatchSize;
    }

    public void run() {
        while (!this.m_isCancelled) {
            this.purgeCommitRecords();
            try {
                Thread.sleep(this.m_purgeInterval);
            }
            catch (InterruptedException e) {
                TransactionMessages.warning("InterruptedException during purge of RLRC commit records : " + e);
            }
        }
    }

    void purgeCommitRecords() {
        if (this.m_txList.size() < this.m_minBatchSize && !this.m_isShuttingDown) {
            return;
        }
        int numberOfRecordsToPurge = this.m_isShuttingDown ? this.m_txList.size() : this.m_minBatchSize;
        for (int i = 0; i < numberOfRecordsToPurge; ++i) {
            this.processNextTx(i);
        }
        this.processRecoverableSinglePhaseBranchAndRemoveFromTxList();
    }

    private void processNextTx(int i) {
        GlobalTransaction tx = (GlobalTransaction)this.m_txList.get(i);
        RecoverableSinglePhaseBranch recoverableSinglePhaseBranch = tx.getRecoverableSinglePhaseBranch();
        String rmidLocation = recoverableSinglePhaseBranch.getRmId().getRMFactoryJndiLocation().getJndiLocation();
        if (!this.m_rmidLocationToRecoverableSinglePhaseResourceMap.containsKey(rmidLocation)) {
            try {
                this.m_rmidLocationToRecoverableSinglePhaseResourceMap.put(rmidLocation, this.m_recoveryManager.acquireXAResource(recoverableSinglePhaseBranch.getRmId(), false));
            }
            catch (TPCException e) {
                TransactionMessages.warning("TPCException while acquiring RLRC for purge : " + e);
            }
        }
        if (!this.rmidLocationToTransactionSetMap.containsKey(rmidLocation)) {
            this.rmidLocationToTransactionSetMap.put(rmidLocation, new HashSet());
        }
        ((Set)this.rmidLocationToTransactionSetMap.get(rmidLocation)).add(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecoverableSinglePhaseBranchAndRemoveFromTxList() {
        Iterator iterator = this.rmidLocationToTransactionSetMap.keySet().iterator();
        boolean isAllPurgesSuccessful = true;
        while (iterator.hasNext()) {
            String rmidLocation = (String)iterator.next();
            Set txSet = (Set)this.rmidLocationToTransactionSetMap.get(rmidLocation);
            Xid[] xids = new Xid[txSet.size()];
            Iterator txIterator = txSet.iterator();
            int j = 0;
            while (txIterator.hasNext()) {
                xids[j++] = ((GlobalTransaction)txIterator.next()).getXid();
            }
            RecoverableSinglePhaseResource recoverableSinglePhaseResource = this.unwrapResource((XAResource)this.m_rmidLocationToRecoverableSinglePhaseResourceMap.get(rmidLocation));
            boolean isPurgeCommitRecordsSuccessful = false;
            if (recoverableSinglePhaseResource != null) {
                isPurgeCommitRecordsSuccessful = recoverableSinglePhaseResource.purgeCommitRecords(xids);
            }
            if (isPurgeCommitRecordsSuccessful) {
                ((Set)this.rmidLocationToTransactionSetMap.get(rmidLocation)).clear();
                continue;
            }
            isAllPurgesSuccessful = false;
            this.m_rmidLocationToRecoverableSinglePhaseResourceMap.remove(rmidLocation);
        }
        if (isAllPurgesSuccessful) {
            pArrayList pArrayList2 = this.m_txList;
            synchronized (pArrayList2) {
                this.m_txList.removeRange(0, this.m_isShuttingDown ? this.m_txList.size() : this.m_minBatchSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(GlobalTransaction tx) {
        pArrayList pArrayList2 = this.m_txList;
        synchronized (pArrayList2) {
            this.m_txList.add(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.m_isCancelled = true;
        this.m_isShuttingDown = true;
        pArrayList pArrayList2 = this.m_txList;
        synchronized (pArrayList2) {
            if (!this.m_txList.isEmpty()) {
                this.purgeCommitRecords();
            }
        }
    }

    private RecoverableSinglePhaseResource unwrapResource(XAResource resource) {
        while (resource instanceof WrappedXAResource) {
            resource = ((WrappedXAResource)((Object)resource)).getWrappedResource();
        }
        return (RecoverableSinglePhaseResource)((Object)resource);
    }

    class pArrayList
    extends ArrayList {
        protected void removeRange(int from, int to) {
            super.removeRange(from, to);
        }
    }
}

