/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.j2ee.util.TraceLogger;

public class SinglePhaseBranch
extends Branch {
    private static Logger m_logger = TraceLogger.getLogger(SinglePhaseBranch.class);

    SinglePhaseBranch(GlobalTransaction transaction, XAResource xaResource, Xid xid, int status) {
        super(transaction, xaResource, xid, null, status);
    }

    public int act(int action) throws XAException {
        switch (action) {
            case 0: {
                this.commitSinglePhaseBranch();
                break;
            }
            case 1: {
                throw new XAException(-6);
            }
            case 2: {
                this.logMsg("Commit1");
                this.xaResource().commit(this.getXid(), true);
                break;
            }
            case 3: {
                this.logMsg("Rollback");
                this.xaResource().rollback(this.getXid());
                break;
            }
            case 4: {
                throw new XAException(-6);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    void commitSinglePhaseBranch() throws XAException {
        this.logMsg("Commit1 in Prepare phase");
        try {
            this.xaResource().commit(this.getXid(), true);
        }
        catch (Exception e) {
            this.handleCommitException(e);
        }
    }

    void handleCommitException(Exception e) throws XAException {
        XAException xae = new XAException(100);
        xae.initCause(e);
        throw xae;
    }

    boolean isOnePhase() {
        return true;
    }

    boolean supportsRecovery() {
        return false;
    }

    void logMsg(String method) {
        m_logger.log(Level.FINE, TransactionMessages.getTraceMsgInvokeResource(m_logger, Level.FINE, this.xaResource(), this.getXid(), method));
    }
}

