/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.util.LinkedList;
import java.util.List;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.Branch;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseBranch;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveringTransactionInfo;

public abstract class Store {
    private String m_serverId;
    protected static final int MAX_RMID_LENGTH = 512;
    List rmIdJndiLocations = new LinkedList();

    Store(String serverId) {
        this.m_serverId = serverId;
    }

    String serverId() {
        return this.m_serverId;
    }

    static void validateRMId(RMId rmId, Branch branch) throws StoreException {
        if (rmId == null || rmId.getRMFactoryJndiLocation() == null || rmId.getRMFactoryJndiLocation().getJndiLocation() == null || rmId.getRMFactoryJndiLocation().getJndiLocation().trim().equals("")) {
            throw new StoreException("No " + (rmId == null ? "RMId" : "RMFactoryJNDILocation") + " provided for " + branch + ")\n");
        }
        if (rmId.getRMFactoryJndiLocation().getJndiLocation().length() > 512) {
            throw new StoreException("RMFactoryJNDILocation must be less than 512 char in length but is " + rmId.getRMFactoryJndiLocation().getJndiLocation().length() + " : " + rmId.getRMFactoryJndiLocation());
        }
        if (rmId.getRMFactoryArg() != null && rmId.getRMFactoryArg().length() > 512) {
            throw new StoreException("RMFactoryArg must be less than 512 char in length but is " + rmId.getRMFactoryArg().length());
        }
    }

    public abstract String getLogLocation();

    public abstract void noteForget(GlobalTransaction var1) throws StoreException;

    public abstract void noteState(GlobalTransaction var1, int var2) throws StoreException;

    public void noteResources(GlobalTransaction tx) throws StoreException {
        for (int i = 0; i < tx.numberOfBranches(); ++i) {
            Branch branch = tx.getBranch(i);
            RMId rmid = branch.getRmId();
            Store.validateRMId(rmid, branch);
            RecoverableSinglePhaseBranch recoverableSinglePhaseBranch = tx.getRecoverableSinglePhaseBranch();
            String rlrcName = recoverableSinglePhaseBranch == null ? null : recoverableSinglePhaseBranch.getRmId().getRMFactoryJndiLocation().getJndiLocation();
            String key = rmid.getRMFactoryJndiLocation().getJndiLocation() + (rlrcName == null ? "" : rlrcName) + (rmid.getRMFactoryArg() == null ? "" : rmid.getRMFactoryArg());
            if (this.rmIdJndiLocations.contains(key)) continue;
            this.noteResource(rmid, rlrcName);
            this.rmIdJndiLocations.add(key);
        }
    }

    abstract void noteResource(RMId var1, String var2) throws StoreException;

    public abstract List recover() throws StoreException;

    public abstract GlobalTransaction recover(Xid var1) throws StoreException;

    abstract void noteTransaction(GlobalTransaction var1, int var2) throws StoreException;

    abstract void lockStore() throws StoreException;

    abstract boolean recoverPeer() throws StoreException;

    abstract List getRecoveringRMIds() throws StoreException;

    public abstract RecoveringTransactionInfo getRecoveringTransactionInfo() throws StoreException;

    abstract boolean providesDurability();

    public boolean shutdown(boolean isClean) {
        return true;
    }

    public static class StoreException
    extends TPCException {
        public StoreException(String message) {
            super(message);
        }
    }
}

