/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.deployment.ActivationSpecConfig;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.connector.deployment.InboundResourceAdapter;
import com.evermind.server.connector.deployment.MessageListener;
import com.evermind.server.ejb.deployment.NameValueProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import oracle.as.j2ee.transaction.tpc.ResourceManagerFactory;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.messageinflow.MessageEndpointFactoryImpl;

public class ResourceAdapterWrapper
implements ResourceAdapter,
ResourceManagerFactory,
Serializable {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    private transient ResourceAdapter m_resourceAdapter;
    private transient ConnectorArchive m_connectorArchive;
    private Set m_endpointActivations = new HashSet();
    String m_rmidLocation;
    private boolean m_started = false;

    public ResourceAdapterWrapper(ResourceAdapter resourceAdapter, ConnectorArchive connectorArchive) throws InstantiationException {
        if (resourceAdapter == null) {
            throw new InstantiationException("Unable to create a wrapper for ResourceAdapter: The ResourceAdapter instance is null");
        }
        this.m_resourceAdapter = resourceAdapter;
        this.m_connectorArchive = connectorArchive;
    }

    public ActivationSpec getActivationSpec(String messageListenerType, List configProperties) throws InstantiationException {
        InboundResourceAdapter inboundRA = this.m_connectorArchive.getResourceAdapterDescriptor().getInboundResourceAdapter();
        if (inboundRA == null) {
            throw new InstantiationException("Resource adapter does not support message inflow");
        }
        MessageListener msgListenerDesc = inboundRA.getMessageListener(messageListenerType);
        if (msgListenerDesc == null) {
            throw new InstantiationException("Resource adapter does not support message listener type: " + messageListenerType);
        }
        ActivationSpecConfig asc = msgListenerDesc.getActivationSpecConfig();
        Iterator requiredConfigProperties = asc.getRequiredConfigProperties().iterator();
        while (requiredConfigProperties.hasNext()) {
            NameValueProperty requiredProperty = (NameValueProperty)requiredConfigProperties.next();
            if (this.containsNameValueProperty(configProperties, requiredProperty.getName())) continue;
            throw new InstantiationException("Required config property of name '" + requiredProperty.getName() + "' is missing.");
        }
        String className = asc.getClassName();
        ActivationSpec aSpec = (ActivationSpec)this.m_connectorArchive.createJavaBeanInstance(className, configProperties, "ActivationSpec object");
        if (aSpec != null) {
            try {
                aSpec.setResourceAdapter(this.m_resourceAdapter);
                aSpec.validate();
            }
            catch (UnsupportedOperationException e) {
                System.out.println("Warning! ActivationSpec could not be validated - this might lead to invalid message inflow setup.");
            }
            catch (InvalidPropertyException e) {
                throw new InstantiationException("ActivationSpec class '" + className + "' fails to be validated. Error is: " + e.getMessage());
            }
            catch (ResourceException e) {
                throw new InstantiationException("ActivationSpec class '" + className + "' fails to be created. Error is: " + e.getMessage());
            }
        }
        return aSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActivationSpec getActivationSpec(String endpointName) {
        ActivationSpec aSpec = null;
        if (endpointName != null) {
            Set set = this.m_endpointActivations;
            synchronized (set) {
                Iterator iter = this.m_endpointActivations.iterator();
                boolean done = false;
                while (iter.hasNext() && !done) {
                    EndpointActivation endpoint = (EndpointActivation)iter.next();
                    if (!endpointName.equals(endpoint.m_endpointName)) continue;
                    aSpec = endpoint.m_activationSpec;
                    done = true;
                }
            }
        }
        return aSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEndpointDependentApplicationNames(List apps) {
        boolean existsDependentApps = false;
        Set set = this.m_endpointActivations;
        synchronized (set) {
            Iterator iter = this.m_endpointActivations.iterator();
            while (iter.hasNext()) {
                EndpointActivation ea = (EndpointActivation)iter.next();
                String name = ea.m_endpointName;
                String appName = name.substring(name.indexOf(47) + 1);
                if (apps.contains(appName)) continue;
                apps.add(appName);
                existsDependentApps = true;
            }
        }
        return existsDependentApps;
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.m_resourceAdapter.start(ctx);
        this.m_started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.m_started) {
            return;
        }
        try {
            this.m_resourceAdapter.stop();
        }
        finally {
            this.m_started = false;
        }
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        throw new ResourceException("This variant of the method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointActivation(MessageEndpointFactoryImpl endpointFactory, ActivationSpec spec, String endpointName, String listenerType) throws ResourceException {
        try {
            if (this.m_started) {
                this.activateEndpoint(endpointFactory, spec, endpointName, listenerType);
            }
        }
        finally {
            this.addEndpointActivation(endpointFactory, spec, endpointName, listenerType);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        throw new RuntimeException("This variant of the method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointDeactivation(MessageEndpointFactoryImpl endpointFactory, ActivationSpec spec, String endpointName) {
        try {
            if (this.m_started) {
                this.deactivateEndpoint(endpointFactory, spec, endpointName);
            }
        }
        finally {
            this.removeEndpointActivation(endpointName);
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return this.m_resourceAdapter.getXAResources(specs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateAllEndpoints() {
        if (this.m_started) {
            Set set = this.m_endpointActivations;
            synchronized (set) {
                Iterator iter = this.m_endpointActivations.iterator();
                while (iter.hasNext()) {
                    EndpointActivation endpointActivation = (EndpointActivation)iter.next();
                    this.deactivateEndpoint(endpointActivation.messageEndpointFactory, endpointActivation.m_activationSpec, endpointActivation.m_endpointName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reactivateAllEndpoints() throws ResourceException {
        Set set = this.m_endpointActivations;
        synchronized (set) {
            Iterator iter = this.m_endpointActivations.iterator();
            while (iter.hasNext()) {
                EndpointActivation endpointActivation = (EndpointActivation)iter.next();
                this.activateEndpoint(endpointActivation.messageEndpointFactory, endpointActivation.m_activationSpec, endpointActivation.m_endpointName, endpointActivation.m_listenerType);
            }
        }
    }

    public XAResource connect(String arg) throws TPCException {
        XAResource recoveryXAResource = null;
        ActivationSpec aSpec = this.getActivationSpec(arg);
        if (aSpec == null) {
            throw this.makeTPCException(arg, "No ActivationSpec with the given name found");
        }
        ActivationSpec[] aSpecs = new ActivationSpec[]{aSpec};
        try {
            XAResource[] xaRes = this.m_resourceAdapter.getXAResources(aSpecs);
            if (xaRes == null) {
                throw this.makeTPCException(arg, "The call to getXAResources returned null when one XAResource is expected.");
            }
            if (xaRes.length != 1) {
                throw this.makeTPCException(arg, "The call to getXAResources returned " + xaRes.length + " XAResources when only one is expected.");
            }
            recoveryXAResource = xaRes[0];
        }
        catch (ResourceException e) {
            throw this.makeTPCException(arg, "Exception is: " + e.toString());
        }
        return recoveryXAResource;
    }

    public void setRmIdLocation(String rmidLocation) {
        this.m_rmidLocation = rmidLocation;
    }

    public String getRmIdLocation() {
        return this.m_rmidLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointActivation removeEndpointActivation(String endpointName) {
        EndpointActivation removedEndpt = null;
        if (endpointName != null) {
            Set set = this.m_endpointActivations;
            synchronized (set) {
                Iterator iter = this.m_endpointActivations.iterator();
                while (iter.hasNext()) {
                    EndpointActivation endpoint = (EndpointActivation)iter.next();
                    if (!endpointName.equals(endpoint.m_endpointName)) continue;
                    removedEndpt = endpoint;
                    break;
                }
                this.m_endpointActivations.remove(removedEndpt);
            }
        }
        return removedEndpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEndpointActivation(MessageEndpointFactoryImpl endpointFactory, ActivationSpec spec, String endpointName, String listenerType) {
        EndpointActivation ea = new EndpointActivation(endpointFactory, spec, endpointName, listenerType);
        Set set = this.m_endpointActivations;
        synchronized (set) {
            this.m_endpointActivations.remove(ea);
            this.m_endpointActivations.add(ea);
        }
    }

    private void activateEndpoint(MessageEndpointFactory endpointFactory, ActivationSpec spec, String endpointName, String listenerType) throws ResourceException {
        m_logger.finest("Activating endpoint : " + endpointName);
        this.m_resourceAdapter.endpointActivation(endpointFactory, spec);
        if (this.m_connectorArchive.isMaintainMBeans()) {
            this.m_connectorArchive.addEndpointActivationMBean(endpointName);
            this.m_connectorArchive.addMessageEndpointFactoryMBean(endpointName, listenerType);
        }
    }

    private void deactivateEndpoint(MessageEndpointFactory endpointFactory, ActivationSpec spec, String endpointName) {
        m_logger.finest("Deactivating endpoint : " + endpointName);
        this.m_resourceAdapter.endpointDeactivation(endpointFactory, spec);
        if (this.m_connectorArchive.isMaintainMBeans()) {
            this.m_connectorArchive.removeEndpointActivationMBean(endpointName);
            this.m_connectorArchive.removeMessageEndpointFactoryMBean(endpointName, null);
        }
    }

    private boolean containsNameValueProperty(List propertyList, String propertyName) {
        if (propertyList == null || propertyName == null) {
            return false;
        }
        Iterator iter = propertyList.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            NameValueProperty configProperty = (NameValueProperty)iter.next();
            if (!propertyName.equals(configProperty.getName())) continue;
            found = true;
        }
        return found;
    }

    private TPCException makeTPCException(String endpointName, String msg) {
        return new TPCException("Unable to obtain an XAResource for JCA message endpoint " + endpointName + "from resource adapter " + this.m_resourceAdapter.toString() + ". " + msg);
    }

    static class EndpointActivation
    implements Serializable {
        private transient MessageEndpointFactoryImpl messageEndpointFactory;
        private transient ActivationSpec m_activationSpec;
        private String m_endpointName;
        private String m_listenerType;

        EndpointActivation(MessageEndpointFactoryImpl _messageEndpointFactory, ActivationSpec _aSpec) {
            this(_messageEndpointFactory, _aSpec, null, null);
        }

        EndpointActivation(MessageEndpointFactoryImpl _messageEndpointFactory, ActivationSpec _aSpec, String _endpointName, String _listenerType) {
            this.messageEndpointFactory = _messageEndpointFactory;
            this.m_activationSpec = _aSpec;
            this.m_endpointName = _endpointName;
            this.m_listenerType = _listenerType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EndpointActivation)) {
                return false;
            }
            EndpointActivation endpointActivation = (EndpointActivation)o;
            if (this.m_activationSpec != null ? !this.m_activationSpec.equals(endpointActivation.m_activationSpec) : endpointActivation.m_activationSpec != null) {
                return false;
            }
            return !(this.messageEndpointFactory != null ? !this.messageEndpointFactory.equals(endpointActivation.messageEndpointFactory) : endpointActivation.messageEndpointFactory != null);
        }
    }
}

