/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.j2ee.connector.logging.JCATraceLogger;
import oracle.j2ee.connector.work.ExecutionContextWrapper;
import oracle.j2ee.connector.work.WorkListenerWrapper;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.j2ee.connector.work.WorkRunner;

class WorkWrapper
implements Work {
    private static Logger m_logger = JCATraceLogger.getLogger(ApplicationConnectionManager.class);
    static final int MAX_TIMEOUT = 300000;
    private Work m_target;
    private boolean m_started = false;
    private boolean m_completed = false;
    private long m_timeTakenToStart;
    private long m_initialRequestTime;
    private long m_timeout;
    private WorkListener m_workListener;
    private ExecutionContextWrapper m_exContext;
    private ContextContainer m_contextContainer = null;
    private WorkRunner m_workRunner = null;
    private boolean m_threadAllocated = false;
    private boolean m_timedOut = false;
    private boolean m_notifyAfterStart = true;
    private volatile WorkCompletedException m_completedException = null;
    private long m_workStartDurationEventToken;
    private PhaseEventIntf m_workStartDurationEvent;

    WorkWrapper(Work target, long requestTime, long timeout, WorkListenerWrapper listener, ExecutionContext exContext, ContextContainer contextContainer, WorkRunner workRunner) throws WorkException {
        this.setStartTimeout(timeout);
        this.setListener(listener);
        this.m_target = target;
        this.m_initialRequestTime = requestTime;
        this.m_exContext = new ExecutionContextWrapper(exContext);
        this.m_contextContainer = contextContainer;
        this.m_workRunner = workRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:run");
        }
        this.setTimeTakenToStart();
        this.setupThreadState();
        try {
            this.doWork();
        }
        catch (WorkCompletedException workCompletedException) {
        }
        finally {
            this.resetThreadState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork() throws WorkCompletedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:doWork");
        }
        this.fireWorkStarted();
        try {
            this.m_exContext.push();
            try {
                this.setupExecutionContext();
                this.runTargetWork();
            }
            finally {
                this.m_exContext.pop();
            }
        }
        catch (WorkCompletedException e) {
            this.m_completedException = e;
            throw this.m_completedException;
        }
        finally {
            this.fireWorkCompleted(this.m_completedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTargetWork() throws WorkCompletedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:runTargetWork");
        }
        String errorCode = "0";
        try {
            this.m_target.run();
            errorCode = "-1";
        }
        catch (Throwable t) {
            this.throwAsWorkCompletedException(t, errorCode);
        }
        finally {
            this.m_exContext.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTimedOutEntry() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:runTimedOutEntry");
        }
        if (this.m_workRunner == null || !this.m_workRunner.runWork(this)) {
            WorkException we = new WorkException("Work Timed out in Queue");
            we.setErrorCode("1");
            WorkWrapper workWrapper = this;
            synchronized (workWrapper) {
                this.m_timedOut = true;
            }
            this.fireWorkRejected(we);
        }
    }

    private void setupExecutionContext() throws WorkCompletedException {
        try {
            this.m_exContext.setup();
        }
        catch (Throwable t) {
            this.throwAsWorkCompletedException(t, "-1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long blockUntilWorkStarted() throws WorkRejectedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:blockUntilWorkStarted");
        }
        WorkWrapper workWrapper = this;
        synchronized (workWrapper) {
            if (this.isStarted()) {
                return this.getTimeTakenToStart();
            }
            if (this.m_threadAllocated) {
                return this.blockWhenThreadAllocated();
            }
            return this.blockWhenWorkOnQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockUntilWorkCompleted() throws WorkException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:blockUntilWorkCompleted");
        }
        WorkWrapper workWrapper = this;
        synchronized (workWrapper) {
            this.m_notifyAfterStart = false;
            if (!this.isCompleted()) {
                if (this.m_threadAllocated) {
                    this.blockWhenThreadAllocated();
                } else {
                    this.blockWhenWorkOnQueue();
                }
            }
            if (this.m_completedException != null) {
                throw this.m_completedException;
            }
        }
    }

    private long blockWhenThreadAllocated() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:blockWhenThreadAllocated");
        }
        try {
            this.wait();
            return this.getTimeTakenToStart();
        }
        catch (InterruptedException ie) {
            return -1L;
        }
    }

    private long blockWhenWorkOnQueue() throws WorkRejectedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:blockWhenWorkOnQueue");
        }
        try {
            if (!this.m_timedOut) {
                this.wait();
            }
        }
        catch (InterruptedException ie) {
            this.failWorkRejected();
        }
        if (!this.isStarted()) {
            this.failWorkRejected();
        }
        return this.getTimeTakenToStart();
    }

    private void failWorkRejected() throws WorkRejectedException {
        WorkRejectedException ex = new WorkRejectedException();
        ex.setErrorCode("1");
        throw ex;
    }

    private void throwAsWorkCompletedException(Throwable t, String errorCode) throws WorkCompletedException {
        if (t instanceof WorkCompletedException) {
            throw (WorkCompletedException)t;
        }
        WorkCompletedException wce = new WorkCompletedException(t);
        wce.setErrorCode(errorCode);
        throw wce;
    }

    synchronized long clockTimeOnTimeout() {
        if (this.m_timeout == 0L) {
            return this.m_initialRequestTime + 100L;
        }
        if (this.m_timeout == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.m_initialRequestTime + this.m_timeout;
    }

    long millisUntilTimeout() {
        long time = this.clockTimeOnTimeout();
        if (time != Long.MAX_VALUE && (time -= System.currentTimeMillis()) < 0L) {
            time = 0L;
        }
        return time;
    }

    void fireWorkAccepted() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:fireWorkAccepted");
        }
        this.m_workListener.workAccepted(new WorkEvent((Object)this, 1, (Work)this, null));
        if (ApplicationServer.DMS_GATE) {
            this.m_workStartDurationEvent = WorkManagerImpl.getWorkStartDurationEvent();
            this.m_workStartDurationEventToken = this.m_workStartDurationEvent.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireWorkStarted() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:fireWorkStarted");
        }
        WorkWrapper workWrapper = this;
        synchronized (workWrapper) {
            this.m_started = true;
            if (this.m_notifyAfterStart) {
                this.notify();
            }
        }
        this.m_workListener.workStarted(new WorkEvent((Object)this, 3, (Work)this, null, this.m_timeTakenToStart));
        if (ApplicationServer.DMS_GATE && this.m_workStartDurationEvent != null) {
            this.m_workStartDurationEvent.stop(this.m_workStartDurationEventToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireWorkRejected(WorkException we) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:fireWorkRejected we = " + we);
        }
        this.m_workListener.workRejected(new WorkEvent((Object)this, 2, (Work)this, we));
        WorkWrapper workWrapper = this;
        synchronized (workWrapper) {
            this.notify();
        }
        if (ApplicationServer.DMS_GATE && this.m_workStartDurationEvent != null) {
            this.m_workStartDurationEvent.abort(this.m_workStartDurationEventToken);
            WorkManagerImpl.getWorkRejectedEvent().occurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireWorkCompleted(WorkCompletedException wce) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.finest("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "WorkWrapper:fireWorkCompleted workCompletedException = " + (Object)((Object)wce));
        }
        this.m_workListener.workCompleted(new WorkEvent((Object)this, 4, (Work)this, (WorkException)wce));
        WorkWrapper workWrapper = this;
        synchronized (workWrapper) {
            this.m_completed = true;
            this.notify();
        }
    }

    ExecutionContextWrapper getExContext() {
        return this.m_exContext;
    }

    Work getTarget() {
        return this.m_target;
    }

    long getTimeTakenToStart() {
        return this.m_timeTakenToStart;
    }

    private synchronized void setTimeTakenToStart() {
        this.m_timeTakenToStart = System.currentTimeMillis() - this.m_initialRequestTime;
    }

    public void release() {
        this.m_target.release();
    }

    long getTimeout() {
        return this.m_timeout;
    }

    private boolean isStarted() {
        return this.m_started;
    }

    private boolean isCompleted() {
        return this.m_completed;
    }

    void setThreadAllocated(boolean threadAllocated) {
        this.m_threadAllocated = threadAllocated;
    }

    private void setStartTimeout(long timeout) {
        this.m_timeout = timeout == Long.MAX_VALUE ? 300000L : timeout;
    }

    private void setupThreadState() {
        if (this.m_contextContainer == null) {
            return;
        }
        ThreadState.getCurrentState().contextContainer = this.m_contextContainer;
    }

    private void resetThreadState() {
        ThreadState.getCurrentState().reset();
    }

    private void setListener(WorkListener listener) {
        this.m_workListener = listener == null ? new WorkAdapter() : listener;
    }
}

