/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.corba.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.corba.security.CSIV2MessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class CSIV2Messages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.corba.security", CSIV2MessageBundle.class.getName());

    public static void finerThrowableNoMsg(Throwable t) {
        if (CSIV2Messages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE CORBA CSIV2 0002", t);
        }
    }

    public static void warningMsg(String message) {
        if (CSIV2Messages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE CORBA CSIV2 0003", new Object[]{message});
        }
    }

    static Logger getLogger() {
        return m_logger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void finestMsg(String s) {
        if (CSIV2Messages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE CORBA CSIV2 0004", new Object[]{s});
        }
    }

    public static void finerThrowableMsg(String msg, Throwable t) {
        if (CSIV2Messages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE CORBA CSIV2 0001", new Object[]{msg, t});
        }
    }

    public static void finerMsg(String s) {
        if (CSIV2Messages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE CORBA CSIV2 0005", new Object[]{s});
        }
    }

    public static void fineMsg(String s) {
        if (CSIV2Messages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CORBA CSIV2 0006", new Object[]{s});
        }
    }

    public static void severeMsg(String s) {
        if (CSIV2Messages.isLoggable(Level.SEVERE)) {
            m_logger.log(Level.SEVERE, "J2EE CORBA CSIV2 0007", new Object[]{s});
        }
    }
}

