/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.naming;

import com.evermind.util.ServerProperties;
import java.net.PasswordAuthentication;
import java.util.EmptyStackException;
import oracle.j2ee.jndi.JndiMessages;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.naming.ContextCredentialProvider;

public class SecurityContextHelper {
    private static boolean ASSOCIATE_USER_TO_THREAD = ServerProperties.getAssociateUserToThread();
    private static SecurityContextHelper SINGLETON_INSTANCE = new SecurityContextHelper(new StandardAssociateUserAccess());
    private final AssociateUserAccess m_associateUserAccess;

    protected SecurityContextHelper(AssociateUserAccess access) {
        this.m_associateUserAccess = access;
    }

    public static SecurityContextHelper getInstance() {
        return SINGLETON_INSTANCE;
    }

    public void associateUserToThread(String username, String password) {
        if (this.m_associateUserAccess.isAssociateUserToThreadEnabled()) {
            PasswordAuthentication pa = new PasswordAuthentication(username, password.toCharArray());
            this.m_associateUserAccess.pushPasswordAuthentication(pa);
        }
    }

    public void disassociateUserFromThread() {
        if (this.m_associateUserAccess.isAssociateUserToThreadEnabled()) {
            try {
                this.m_associateUserAccess.popPasswordAuthentication();
            }
            catch (EmptyStackException emptyStackException) {
                JndiMessages.warningEmptyStackAfterDisAssociateUser();
            }
        }
    }

    public String getCurrentPrincipal(ContextCredentialProvider credentialProvider) {
        if (this.m_associateUserAccess.isAssociateUserToThreadEnabled()) {
            try {
                PasswordAuthentication pa = this.m_associateUserAccess.getCurrentPasswordAuthentication();
                return pa.getUserName();
            }
            catch (EmptyStackException exception) {
                JndiMessages.warningEmptyStackWithAssociateUserEnabled();
                return credentialProvider.getUserName();
            }
        }
        return credentialProvider.getUserName();
    }

    public String getCurrentCredential(ContextCredentialProvider credentialProvider) {
        if (this.m_associateUserAccess.isAssociateUserToThreadEnabled()) {
            try {
                PasswordAuthentication pa = this.m_associateUserAccess.getCurrentPasswordAuthentication();
                return new String(pa.getPassword());
            }
            catch (EmptyStackException exception) {
                JndiMessages.warningEmptyStackWithAssociateUserEnabled();
                return credentialProvider.getPassword();
            }
        }
        return credentialProvider.getPassword();
    }

    public boolean isAssociateUserToThreadEnabled() {
        return this.m_associateUserAccess.isAssociateUserToThreadEnabled();
    }

    private static class StandardAssociateUserAccess
    implements AssociateUserAccess {
        private StandardAssociateUserAccess() {
        }

        public boolean isAssociateUserToThreadEnabled() {
            return ASSOCIATE_USER_TO_THREAD;
        }

        public void pushPasswordAuthentication(PasswordAuthentication passwdAuth) {
            CommonThreadState.getCurrent().pushPasswordAuthentication(passwdAuth);
        }

        public PasswordAuthentication popPasswordAuthentication() {
            return CommonThreadState.getCurrent().popPasswordAuthentication();
        }

        public PasswordAuthentication getCurrentPasswordAuthentication() {
            return CommonThreadState.getCurrent().getCurrentPasswordAuthentication();
        }
    }

    protected static interface AssociateUserAccess {
        public boolean isAssociateUserToThreadEnabled();

        public void pushPasswordAuthentication(PasswordAuthentication var1);

        public PasswordAuthentication popPasswordAuthentication();

        public PasswordAuthentication getCurrentPasswordAuthentication();
    }
}

