/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server.deployment;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceRefPortInfo
implements XMLizable {
    private Element wsmConfig;
    private Object m_runtimeData;
    private QName wsdlPort;
    private Set callProperties = new HashSet();
    private Set stubProperties = new HashSet();
    private String portComponentLinkName;
    private String serviceEndpointInterfaceName;

    ServiceRefPortInfo() {
    }

    ServiceRefPortInfo(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            this.parseNode(name, node);
        }
    }

    public void postInit() throws InstantiationException {
        if (this.getServiceEndpointInterface() == null) {
            throw new InstantiationException("service-endpoint-interface tag is missing from port-component-ref group ");
        }
    }

    private void parseNode(String name, Node node) {
        if (name.equals("service-endpoint-interface")) {
            this.setServiceEndpointInterface(XMLUtils.getStringValue(node));
        } else if (name.equals("port-component-link")) {
            this.portComponentLinkName = XMLUtils.getStringValue(node);
        }
    }

    void parseProprietaryNode(Node parent) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("wsdl-port")) {
                this.setWsdlPort(new QName(XMLUtils.getNodeAttribute(node, "namespaceURI"), XMLUtils.getNodeAttribute(node, "localpart")));
                continue;
            }
            if (name.equals("service-endpoint-interface")) {
                this.setServiceEndpointInterface(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("call-property")) {
                this.parseProperty("call-property", node);
                continue;
            }
            if (name.equals("stub-property")) {
                this.parseProperty("stub-property", node);
                continue;
            }
            if (!name.equals("runtime") && !name.equals("operations")) continue;
            this.appendToWsmConfig(node);
        }
    }

    private void appendToWsmConfig(Node node) {
        if (this.wsmConfig == null) {
            this.wsmConfig = node.getOwnerDocument().createElement("port");
        }
        this.wsmConfig.appendChild(node.cloneNode(true));
    }

    private void parseProperty(String type, Node parent) {
        NodeList nodes = parent.getChildNodes();
        String paramName = null;
        String paramValue = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("name")) {
                paramName = XMLUtils.getStringValue(node);
                continue;
            }
            if (!name.equals("value")) continue;
            paramValue = XMLUtils.getStringValue(node);
            HashMap<String, String> nvPair = new HashMap<String, String>();
            nvPair.put(paramName, paramValue);
            if (type.equals("call-property")) {
                this.addCallProperty(nvPair.entrySet().iterator().next());
                continue;
            }
            if (!type.equals("stub-property")) continue;
            this.addStubProperty(nvPair.entrySet().iterator().next());
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        if (!this.stubProperties.isEmpty() || !this.callProperties.isEmpty() || this.hasWsmConfig()) {
            Map.Entry entry;
            Iterator it;
            out.println(indention + "<port-info>");
            if (this.hasWsdlPort()) {
                out.println(indention + "\t<wsdl-port namespaceURI=\"" + XMLUtils.encode(this.getWsdlPort().getNamespaceURI()) + "\" localpart=\"" + XMLUtils.encode(this.getWsdlPort().getLocalPart()) + "\"/>");
            }
            if (this.hasServiceEndpointInterface()) {
                out.println(indention + "\t<service-endpoint-interface>" + this.getServiceEndpointInterface() + "</service-endpoint-interface>");
            }
            if (this.stubProperties != null) {
                it = this.stubProperties.iterator();
                while (it.hasNext()) {
                    out.println(indention + "\t<stub-property>");
                    entry = (Map.Entry)it.next();
                    out.println(indention + "\t\t<name>" + XMLUtils.encode((String)entry.getKey()) + "</name>");
                    out.println(indention + "\t\t<value>" + XMLUtils.encode((String)entry.getValue()) + "</value>");
                    out.println(indention + "\t</stub-property>");
                }
            }
            if (this.callProperties != null) {
                it = this.callProperties.iterator();
                while (it.hasNext()) {
                    out.println(indention + "\t<call-property>");
                    entry = (Map.Entry)it.next();
                    out.println(indention + "\t\t<name>" + XMLUtils.encode((String)entry.getKey()) + "</name>");
                    out.println(indention + "\t\t<value>" + XMLUtils.encode((String)entry.getValue()) + "</value>");
                    out.println(indention + "\t</call-property>");
                }
            }
            if (this.wsmConfig != null) {
                NodeList child = this.wsmConfig.getChildNodes();
                for (int i = 0; i < child.getLength(); ++i) {
                    Node node = child.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.printElement((Element)node, out, 4);
                }
            }
            if (this.hasWsdlPort() || this.stubProperties != null || this.callProperties != null) {
                out.println(indention + "</port-info>");
            }
        }
    }

    private void printElement(Element source, PrintWriter out, int indentLevel) {
        String thisIndent = "";
        for (int thisIndentLevel = indentLevel; thisIndentLevel > 0; --thisIndentLevel) {
            thisIndent = thisIndent + "\t";
        }
        out.print(thisIndent + "<" + source.getTagName());
        NamedNodeMap attr = source.getAttributes();
        for (int m = 0; m < attr.getLength(); ++m) {
            out.print(" ");
            out.print(attr.item(m).getNodeName() + "=\"" + attr.item(m).getNodeValue() + "\"");
        }
        if (source.hasChildNodes()) {
            out.print(">\n");
            boolean hasElementChild = false;
            NodeList list = source.getChildNodes();
            for (int p = 0; p < list.getLength(); ++p) {
                if (list.item(p).getNodeType() != 1) continue;
                hasElementChild = true;
            }
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    this.printElement((Element)node, out, indentLevel + 1);
                    continue;
                }
                if (node.getNodeType() != 3 || hasElementChild) continue;
                out.print(node.getNodeValue());
            }
            out.println(thisIndent + "</" + source.getTagName() + ">");
        } else {
            out.print("/>\n");
        }
    }

    public Object getRuntimeData() {
        return this.m_runtimeData;
    }

    public void setRuntimeData(Object runtimeData) {
        this.m_runtimeData = runtimeData;
    }

    public boolean hasWsmConfig() {
        return this.wsmConfig != null;
    }

    public Element getWsmConfig() {
        return this.wsmConfig;
    }

    public void setWsmConfig(Element wsmConfig) {
        this.wsmConfig = wsmConfig;
    }

    public boolean hasServiceEndpointInterface() {
        return this.serviceEndpointInterfaceName != null;
    }

    public void setServiceEndpointInterface(String sei) {
        this.serviceEndpointInterfaceName = sei;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterfaceName;
    }

    public boolean hasPortComponentLinkName() {
        return this.portComponentLinkName != null;
    }

    public String getPortComponentLinkName() {
        return this.portComponentLinkName;
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public Set getStubProperties() {
        return this.stubProperties;
    }

    public boolean hasStubProperty(String name) {
        return this.getStubPropertyValue(name) != null;
    }

    public String getStubPropertyValue(String name) {
        String value = null;
        Iterator iter = this.stubProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            if (!next.getKey().equals(name)) continue;
            value = (String)next.getValue();
            break;
        }
        return value;
    }

    public Map.Entry getStubPropertyByName(String name) {
        Map.Entry prop = null;
        Iterator iter = this.stubProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            if (!next.getKey().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    public void addStubProperty(Map.Entry property) {
        Map.Entry prop = this.getStubPropertyByName((String)property.getKey());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.stubProperties.add(property);
        }
    }

    public void removeStubProperty(Map.Entry property) {
        Map.Entry prop = this.getStubPropertyByName((String)property.getKey());
        if (prop != null) {
            this.stubProperties.remove(property);
        }
    }

    public void addStubProperty(String name, String value) {
        HashMap<String, String> nvPair = new HashMap<String, String>();
        nvPair.put(name, value);
        this.addStubProperty(nvPair.entrySet().iterator().next());
    }

    public Set getCallProperties() {
        return this.callProperties;
    }

    public boolean hasCallProperty(String name) {
        return this.getCallPropertyByName(name) != null;
    }

    public Map.Entry getCallPropertyByName(String name) {
        Map.Entry prop = null;
        Iterator iter = this.callProperties.iterator();
        while (iter.hasNext()) {
            Map.Entry next = (Map.Entry)iter.next();
            if (!next.getKey().equals(name)) continue;
            prop = next;
            break;
        }
        return prop;
    }

    public void addCallProperty(Map.Entry property) {
        Map.Entry prop = this.getCallPropertyByName((String)property.getKey());
        if (prop != null) {
            prop.setValue(property.getValue());
        } else {
            this.callProperties.add(property);
        }
    }

    public void removeCallProperty(Map.Entry property) {
        Map.Entry prop = this.getCallPropertyByName((String)property.getKey());
        if (prop != null) {
            this.callProperties.remove(property);
        }
    }

    public String toString() {
        Map.Entry calls;
        StringBuffer sb = new StringBuffer();
        sb.append("\n[debug]\t\t SEI               = " + this.serviceEndpointInterfaceName);
        sb.append("\n[debug]\t\t portComponentLink = " + this.portComponentLinkName);
        if (this.wsdlPort != null) {
            sb.append("\n[debug]\t\t wsdl-port         = " + this.wsdlPort);
        }
        Iterator itr = this.callProperties.iterator();
        while (itr.hasNext()) {
            calls = (Map.Entry)itr.next();
            sb.append("\n[debug]\t\t  Call props : name =" + calls.getKey() + ":value =" + calls.getValue());
        }
        itr = this.stubProperties.iterator();
        while (itr.hasNext()) {
            calls = (Map.Entry)itr.next();
            sb.append("\n[debug]\t\t  Stub props : name =" + calls.getKey() + ":value =" + calls.getValue());
        }
        return sb.toString();
    }
}

