/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.xml.XMLMessageBundle;
import org.xml.sax.SAXException;

public class XMLMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.xml", XMLMessageBundle.class.getName());

    public static void finerException(Throwable reason) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE XML-00005", reason);
        }
    }

    public static void warningException(Throwable reason) {
        if (XMLMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE XML-00005", reason);
        }
    }

    static Logger getLogger() {
        return m_logger;
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningEntityResolverConfigNotFound(String configFileName, FileNotFoundException fnfe) {
        if (XMLMessages.isLoggable(Level.WARNING)) {
            Object[] args = new Object[]{configFileName};
            m_logger.log(Level.WARNING, "J2EE XML-00001", args);
            XMLMessages.warningException(fnfe);
            System.err.println(MessageFormat.format(XMLMessageBundle.getBundle(XMLMessageBundle.class.getName()).getString("J2EE XML-00001"), args));
        }
    }

    public static void warningEntityResolverConfigNotReadable(String configFileName, IOException ex) {
        if (XMLMessages.isLoggable(Level.WARNING)) {
            Object[] args = new Object[]{configFileName};
            m_logger.log(Level.WARNING, "J2EE XML-00002", args);
            XMLMessages.warningException(ex);
            System.err.println(MessageFormat.format(XMLMessageBundle.getBundle(XMLMessageBundle.class.getName()).getString("J2EE XML-00002"), args));
        }
    }

    public static void finerRegisterEntityPublicId(String publicId, String location) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{publicId, location};
            m_logger.log(Level.FINER, "J2EE XML-00003", args);
        }
    }

    public static void finerRegisterEntitySystemId(String systemId, String location) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{systemId, location};
            m_logger.log(Level.FINER, "J2EE XML-00004", args);
        }
    }

    public static void finerSucessfullyResolvedEntity(String publicId, String systemId, String location) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{publicId, systemId, location};
            m_logger.log(Level.FINER, "J2EE XML-00006", args);
        }
    }

    public static void finerEntityFoundAsFile(String entity) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{entity};
            m_logger.log(Level.FINER, "J2EE XML-00008", args);
        }
    }

    public static void finerEntityNotFoundAsFileCheckClassPath(String entity) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{entity};
            m_logger.log(Level.FINER, "J2EE XML-00007", args);
        }
    }

    public static void finerEntityFoundInClasspath(String entity) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{entity};
            m_logger.log(Level.FINER, "J2EE XML-00009", args);
        }
    }

    public static void finerEntityNotFoundInClasspath(String entity) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{entity};
            m_logger.log(Level.FINER, "J2EE XML-00010", args);
        }
    }

    public static void finerCreatedEntityResolver(String entityResolverConfigFile) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{entityResolverConfigFile};
            m_logger.log(Level.FINER, "J2EE XML-00011", args);
        }
    }

    public static void finerCreatedEntityResolverFromClasspath(String url) {
        if (XMLMessages.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{url};
            m_logger.log(Level.FINER, "J2EE XML-00012", args);
        }
    }

    public static void configIOEInEntityResolverConfig(URL url, IOException e) {
        if (XMLMessages.isLoggable(Level.CONFIG)) {
            Object[] args = new Object[]{url, e};
            m_logger.log(Level.CONFIG, "J2EE XML-00013", args);
        }
    }

    public static void configSAXEInEntityResolverConfig(URL url, SAXException e) {
        if (XMLMessages.isLoggable(Level.CONFIG)) {
            Object[] args = new Object[]{url, e};
            m_logger.log(Level.CONFIG, "J2EE XML-00014", args);
        }
    }

    public static void finestIOEClosingEntityResolverConfigStream(IOException e, URL url) {
        if (XMLMessages.isLoggable(Level.FINEST)) {
            Object[] args = new Object[]{url, e};
            m_logger.log(Level.FINEST, "J2EE XML-00015", args);
        }
    }
}

