/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2eeLoggingXmlHelper {
    String xmlfile_ = null;
    DOMParser parser_ = null;
    String xmlns_ = null;
    private static Logger logger_ = TraceLogger.getLogger(J2eeLoggingXmlHelper.class);

    public J2eeLoggingXmlHelper(String fileName) {
        this.xmlfile_ = fileName;
    }

    public void updateLoggerLevel(String loggerName, String loggerLevel) {
        try {
            XMLDocument xmldoc = this.getXmlDoc();
            Element loggersElem = this.getChildElement(xmldoc.getDocumentElement(), "loggers", null, null, true);
            Element loggerElem = this.getChildElement(loggersElem, "logger", "name", loggerName, false);
            if (loggerLevel == null || "null".equalsIgnoreCase(loggerLevel) || loggerLevel.trim().length() == 0) {
                if (loggerElem != null) {
                    loggersElem.removeChild(loggerElem);
                    this.saveXml(xmldoc);
                }
            } else {
                if (loggerElem == null) {
                    loggerElem = this.insertChildElement(loggersElem, "logger", "name", loggerName);
                }
                loggerElem.setAttribute("level", loggerLevel);
                this.saveXml(xmldoc);
            }
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "update j2ee-logging.xml failed", e);
        }
    }

    private Element getHandlerElement(XMLDocument xmldoc, String handlerName) {
        try {
            NodeList nl = xmldoc.getDocumentElement().getElementsByTagName("log_handlers");
            if (nl.getLength() == 0) {
                return null;
            }
            Element handlers = (Element)nl.item(0);
            NodeList nl2 = handlers.getElementsByTagName("log_handler");
            for (int i = 0; i < nl2.getLength(); ++i) {
                Element handler = (Element)nl2.item(i);
                String name = handler.getAttribute("name");
                if (!handlerName.equals(name)) continue;
                return handler;
            }
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to get the specific log handler: " + handlerName, e);
        }
        return null;
    }

    public NodeList getHandlerElements() {
        try {
            NodeList nl = this.getXmlDoc().getDocumentElement().getElementsByTagName("log_handlers");
            if (nl.getLength() == 0) {
                return nl;
            }
            Element handlers = (Element)nl.item(0);
            return handlers.getElementsByTagName("log_handler");
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to get the list of handler names.", e);
            return null;
        }
    }

    public Properties getHandlerProperties(String handlerName) {
        try {
            XMLDocument xmldoc = this.getXmlDoc();
            Element parent = this.getHandlerElement(xmldoc, handlerName);
            Properties properties = new Properties();
            Element[] ps = this.getChildElements(parent, "property", null, null);
            for (int i = 0; i < ps.length; ++i) {
                properties.setProperty(ps[i].getAttribute("name"), ps[i].getAttribute("value"));
            }
            return properties;
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Failed to get the specific log handler: " + handlerName, e);
            return null;
        }
    }

    public void addHandlerProperty(String handlerName, String propertyName, String propertyValue) {
        try {
            XMLDocument xmldoc = this.getXmlDoc();
            Element handler = this.getHandlerElement(xmldoc, handlerName);
            NodeList nl = handler.getElementsByTagName("property");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element p = (Element)nl.item(i);
                if (!propertyName.equals(p.getAttribute("name"))) continue;
                p.setAttribute("value", propertyValue);
                this.saveXml(xmldoc);
                return;
            }
            Element p = xmldoc.createElement("property");
            p.setAttribute("name", propertyName);
            p.setAttribute("value", propertyValue);
            handler.appendChild(p);
            this.saveXml(xmldoc);
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "Failed to set the property " + propertyName + " for the handler: " + handlerName, e);
        }
    }

    public void removeHandlerProperty(String handlerName, String propertyName) {
        try {
            int i;
            XMLDocument xmldoc = this.getXmlDoc();
            Element handler = this.getHandlerElement(xmldoc, handlerName);
            Element[] props = this.getChildElements(handler, "property", null, null);
            ArrayList<Element> found = new ArrayList<Element>();
            for (i = 0; i < props.length; ++i) {
                if (!propertyName.equals(props[i].getAttribute("name"))) continue;
                found.add(props[i]);
            }
            if (found.size() == 0) {
                throw new IllegalArgumentException("handler " + handler.getAttribute("name") + " does not have property " + propertyName);
            }
            for (i = 0; i < found.size(); ++i) {
                handler.removeChild((Node)found.get(i));
            }
            this.saveXml(xmldoc);
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "Failed to set the property " + propertyName + " for the handler: " + handlerName, e);
        }
    }

    private void initParser() {
        if (this.parser_ != null) {
            return;
        }
        this.parser_ = new DOMParser();
        this.parser_.setPreserveWhitespace(false);
        this.parser_.setValidationMode(0);
        this.parser_.retainCDATASection(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XMLDocument getXmlDoc() throws Exception {
        XMLDocument xMLDocument;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.xmlfile_);
            this.initParser();
            this.parser_.parse((InputStream)fin);
            XMLDocument xmldoc = this.parser_.getDocument();
            this.xmlns_ = xmldoc.getDocumentElement().getNamespaceURI();
            xMLDocument = xmldoc;
            Object var5_5 = null;
            if (fin == null) return xMLDocument;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fin == null) throw throwable;
            try {
                fin.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return xMLDocument;
        }
        fin.close();
        return xMLDocument;
    }

    private Element[] getChildElements(Element element, String tagName, String attrName, String attrValue) {
        ArrayList<Element> elems = new ArrayList<Element>();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node;
            if (nodes.item(i).getNodeType() != 1 || !(node = (Element)nodes.item(i)).getNodeName().equals(tagName) || attrName != null && attrValue != null && !attrValue.equals(node.getAttribute(attrName))) continue;
            elems.add(node);
        }
        Element[] result = new Element[elems.size()];
        elems.toArray(result);
        return result;
    }

    private Element getChildElement(Element parent, String tagName, String attrName, String attrValue, boolean insert) {
        Element[] childElems = attrName == null || attrValue == null ? this.getChildElements(parent, tagName, null, null) : this.getChildElements(parent, tagName, attrName, attrValue);
        Element childElem = null;
        if (childElems.length > 0) {
            childElem = childElems[0];
        } else if (insert) {
            childElem = this.insertChildElement(parent, tagName, attrName, attrValue);
        }
        return childElem;
    }

    private Element insertChildElement(Element parent, String tagName, String attrName, String attrValue) {
        Element childElem = parent.getOwnerDocument().createElementNS(this.xmlns_, tagName);
        if (attrName != null && attrValue != null) {
            childElem.setAttribute(attrName, attrValue);
        }
        parent.appendChild(childElem);
        return childElem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveXml(XMLDocument xmldoc) throws Exception {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(this.xmlfile_);
            xmldoc.print((OutputStream)fout);
            Object var5_3 = null;
            if (fout == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fout == null) throw throwable;
            try {
                fout.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fout.close();
        return;
    }
}

