/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.deploy;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.InternalUploader;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.internal.UploaderStateKeeper;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.UploaderMBean;
import oracle.oc4j.admin.jmx.shared.deploy.Constants;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;

public class Uploader
extends NotificationBroadcasterSupport
implements UploaderMBean {
    public Integer beginUpload(String fileName) throws IOException {
        return InternalUploader.beginUpload(fileName);
    }

    public void endUpload(Integer id) throws IOException {
        InternalUploader.endUpload(id);
    }

    public void upload(Integer id, byte[] data) throws IOException {
        InternalUploader.upload(id, data);
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        this.sendNotification(id, locHelp.getLocalizedMessage("UPLOADING", this.getUploadFileName(id)));
    }

    public void cancel(Integer id) throws IOException {
        InternalUploader.clean(id);
        this.reportCancel(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Integer id, ObjectName mbean, String operation, Object[] params, String[] sigs) throws DeployerException {
        try {
            InternalUploader.install(id, mbean, operation, params, sigs);
            this.reportComplete(id);
        }
        catch (Throwable t) {
            this.reportFailed(id, t);
        }
        finally {
            try {
                InternalUploader.clean(id);
            }
            catch (IOException ex) {}
        }
    }

    public void install(String filePath, ObjectName mbean, String operation, Object[] params, String[] sigs) throws DeployerException {
        try {
            InternalUploader.install(filePath, mbean, operation, params, sigs);
            this.reportComplete(filePath);
        }
        catch (Throwable t) {
            this.reportFailed(filePath, t);
        }
    }

    private void sendNotification(Integer id, String msg) {
        Notification notification = new Notification("upload." + id, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), msg);
        this.sendNotification(notification);
    }

    private void reportCancel(Integer id) {
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        Notification notification = new Notification("upload." + id, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), locHelp.getLocalizedMessage("UPLOAD_CANCELLED", this.getUploadFileName(id)));
        NotificationUserData userData = new NotificationUserData(Constants.OC4J_UPLOADER_OBJECT_NAME, 100);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    private void reportComplete(Integer id) {
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        Notification notification = new Notification("upload." + id, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), locHelp.getLocalizedMessage("INSTALL_COMPLETE", this.getUploadFileName(id)));
        NotificationUserData userData = new NotificationUserData(Constants.OC4J_UPLOADER_OBJECT_NAME, 100);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    private void reportComplete(String name) {
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        Notification notification = new Notification("upload." + name, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), locHelp.getLocalizedMessage("INSTALL_COMPLETE", name));
        NotificationUserData userData = new NotificationUserData(Constants.OC4J_UPLOADER_OBJECT_NAME, 100);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    private void reportFailed(Integer id, Throwable t) {
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        Notification notification = new Notification("upload." + id, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), locHelp.getLocalizedMessage("INSTALL_FAILED", this.getUploadFileName(id)));
        NotificationUserData userData = new NotificationUserData(Constants.OC4J_UPLOADER_OBJECT_NAME, t);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    private void reportFailed(String name, Throwable t) {
        Locale localeForCall = JMXStateFactory.getJMXState().getLocale();
        MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(localeForCall);
        Notification notification = new Notification("upload." + name, Constants.OC4J_UPLOADER_OBJECT_NAME, Notifier.getNextMessageSequenceNumber(), new Date().getTime(), locHelp.getLocalizedMessage("INSTALL_FAILED", name));
        NotificationUserData userData = new NotificationUserData(Constants.OC4J_UPLOADER_OBJECT_NAME, t);
        notification.setUserData(userData);
        this.sendNotification(notification);
    }

    private String getUploadFileName(Integer id) {
        try {
            File uploadFile = (File)UploaderStateKeeper.getState(id);
            return uploadFile.getName();
        }
        catch (ClassCastException e) {
            return "";
        }
    }
}

