/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.model;

import com.evermind.server.ApplicationServer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.model.DefaultModelMBeanProvider;
import oracle.oc4j.admin.jmx.model.MBeanFactory;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.mbeans.model.DefaultModelMBeanImpl;

public class ModelMBeanFactory
implements MBeanFactory {
    private static MBeanFactory factory_ = null;

    private ModelMBeanFactory() {
    }

    public static synchronized MBeanFactory getInstance() {
        if (factory_ == null) {
            factory_ = new ModelMBeanFactory();
        }
        return factory_;
    }

    public final ModelMBean createModelMBean(ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException {
        return (ModelMBean)ModelMBeanFactory.getModelMBean(tgt);
    }

    public final ObjectInstance registerMBean(ObjectName name, ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanServer mbsrv = MBeanServerFactory.newMBeanServer();
        ModelMBean mbean = this.createModelMBean(tgt);
        return mbsrv.registerMBean(mbean, name);
    }

    public ModelMBeanInfo getMBeanInfo(ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException {
        return ModelMBeanFactory.getModelMBeanInfo(tgt);
    }

    public static Object getModelMBean(ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException {
        ModelMBeanInfo mbeanInfo = ModelMBeanFactory.getModelMBeanInfo(tgt);
        DefaultModelMBeanImpl mbean = new DefaultModelMBeanImpl(mbeanInfo, tgt);
        return mbean;
    }

    public static ModelMBeanInfo getModelMBeanInfo(ModelMBeanProvider tgt) throws RuntimeOperationsException, MBeanException {
        Set s = tgt.getModelMBeanAttributeInfos();
        if (s == null) {
            s = new HashSet();
        } else if (!ApplicationServer.DMS_GATE) {
            ModelMBeanFactory.doNotExposeJSR77Statistics(s);
        }
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfos = new ModelMBeanAttributeInfo[s.size()];
        Iterator iter = s.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            modelMBeanAttributeInfos[cnt++] = (ModelMBeanAttributeInfo)iter.next();
        }
        s = tgt.getModelMBeanOperationInfos();
        if (s == null) {
            s = new HashSet();
        }
        ModelMBeanOperationInfo[] modelMBeanOperationInfos = new ModelMBeanOperationInfo[s.size()];
        iter = s.iterator();
        cnt = 0;
        while (iter.hasNext()) {
            modelMBeanOperationInfos[cnt++] = (ModelMBeanOperationInfo)iter.next();
        }
        s = tgt.getModelMBeanNotificationInfos();
        if (s == null) {
            s = new HashSet();
        }
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfos = new ModelMBeanNotificationInfo[s.size()];
        iter = s.iterator();
        cnt = 0;
        while (iter.hasNext()) {
            modelMBeanNotificationInfos[cnt++] = (ModelMBeanNotificationInfo)iter.next();
        }
        s = tgt.getModelMBeanConstructorInfos();
        if (s == null) {
            s = new HashSet();
        }
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfos = new ModelMBeanConstructorInfo[s.size()];
        iter = s.iterator();
        cnt = 0;
        while (iter.hasNext()) {
            modelMBeanConstructorInfos[cnt++] = (ModelMBeanConstructorInfo)iter.next();
        }
        String className = "oracle.oc4j.admin.jmx.server.mbeans.model.DefaultModelMBeanImpl";
        ModelMBeanInfoSupport mbeanInfo = new ModelMBeanInfoSupport(className, tgt.getDescription(), modelMBeanAttributeInfos, modelMBeanConstructorInfos, modelMBeanOperationInfos, modelMBeanNotificationInfos, tgt.getDescriptor());
        if (tgt instanceof DefaultModelMBeanProvider) {
            DefaultModelMBeanProvider tgtImpl = (DefaultModelMBeanProvider)tgt;
            Descriptor mbeandesc = mbeanInfo.getMBeanDescriptor();
            Map extraDescriptorProperties = tgtImpl.getDescriptorProperties();
            if (extraDescriptorProperties != null) {
                Iterator it = extraDescriptorProperties.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry val = it.next();
                    mbeandesc.setField((String)val.getKey(), val.getValue());
                }
                mbeanInfo.setMBeanDescriptor(mbeandesc);
            }
        }
        return mbeanInfo;
    }

    private static void doNotExposeJSR77Statistics(Set attributes) {
        Iterator iter = attributes.iterator();
        ModelMBeanAttributeInfo statsInfo = null;
        while (iter.hasNext()) {
            ModelMBeanAttributeInfo info = (ModelMBeanAttributeInfo)iter.next();
            if (!"stats".equals(info.getName())) continue;
            statsInfo = info;
            break;
        }
        if (statsInfo != null) {
            attributes.remove(statsInfo);
        }
    }
}

