/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.web;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.JMXUtil;
import oracle.oc4j.admin.jmx.web.CompositeDataItem;
import oracle.oc4j.admin.jmx.web.Generator;
import oracle.oc4j.admin.jmx.web.HandlingException;
import oracle.oc4j.admin.jmx.web.ServletLocalizationHelper;

public class HtmlGenerator
implements Generator {
    private static Logger logger_ = TraceLogger.getLogger(HtmlGenerator.class);
    private static final String[] setableTypes_ = new String[]{"java.lang.Integer", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.lang.String", "int", "boolean", "byte", "char", "double", "float", "long", "short", "[Z", "[B", "[C", "[S", "[I", "[J", "[F", "[D", "Z", "B", "C", "S", "I", "J", "F", "D", "[Ljava.lang.Integer;", "[Ljava.lang.Boolean;", "[Ljava.lang.Byte;", "[Ljava.lang.Character;", "[Ljava.lang.Double;", "[Ljava.lang.Float;", "[Ljava.lang.Long;", "[Ljava.lang.Short;", "[Ljava.lang.String;", "java.util.Collection", "java.util.List", "java.util.Set", "java.util.Map", "java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.HashSet", "java.util.TreeSet", "java.util.LinkedHashSet", "java.util.HashMap", "java.util.Hashtable", "java.util.TreeMap", "java.util.Attributes", "java.util.IdentityHashMap", "java.util.WeakHashMap", "java.util.Properties", "javax.management.ObjectName", "javax.management.openmbean.CompositeData"};
    private static final String[] methodImpact_ = new String[]{"INFO (read-like operation)", "ACTION (write-like operation)", "ACTION_INFO (read/write-like operation)", "UNKNOWN"};
    private static final String[] methodImpactShort_ = new String[]{"INFO", "ACTION", "ACTION_INFO", "UNKNOWN"};
    private StringBuffer buf_ = new StringBuffer();
    private String domain_ = null;
    private static final String[] j2eeTypes_ = new String[]{"J2EEDomain", "J2EEServer", "JVM", "JVMProxy", "J2EEWebSite", "J2EEApplication", "WebModule", "EJBModule", "ResourceAdapterModule", "AppClientModule", "Servlet", "EntityBean", "MessageDrivenBean", "StatelessSessionBean", "StatefulSessionBean", "JavaMailResource", "JNDIResource", "JDBCResource", "JDBCDataSource", "JDBCDriver", "JCAResource", "JCAConnectionFactory", "JCAManagedConnectionFactory", "JTAResource", "J2EEServerGroup", "OHS", "JMSAdministratorResource", "JMSDestinationResource", "JMSResource", "JMSStoreResource", "JMSRequestHandlerResource", "JMSRemoteServerResource", "JMSConnectionResource", "JMSConnectionConsumerResource", "JMSSessionResource", "JMSProducerResource", "JMSBrowserResource", "JMSConsumerResource", "JMSDurableSubscriberResource", "JMSTemporaryDestinationResource", "JMSPersistenceResource", "WebService", "WebServiceOperation", "ThreadPool", "TaskManager", "EJBCompiler", "JSP", "JSPConfig", "OC4JWebModule", "Security", "ClassLoading", "J2EELogging", "JNDINamespace", "OracleASScheduler"};
    private TreeSet jt_ = null;
    private ServletLocalizationHelper locHelper_ = null;
    private String extraParam_ = null;
    private String extraParamName_ = null;
    private String extraParamValue_ = null;

    public HtmlGenerator(String domain, ServletLocalizationHelper locHelper) {
        this.domain_ = domain;
        this.locHelper_ = locHelper;
        this.jt_ = new TreeSet(new ObjectNameComparator());
        for (int i = 0; i < j2eeTypes_.length; ++i) {
            this.jt_.add(j2eeTypes_[i]);
        }
    }

    public void setExtraParam(String param) {
        this.extraParam_ = param;
        this.extraParamName_ = param.substring(0, param.indexOf(61));
        this.extraParamValue_ = param.substring(param.indexOf(61) + 1);
    }

    public String getContentType() {
        return "text/html";
    }

    public final void addHeader() {
        this.buf_.append("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
        this.buf_.append("<html>\n");
        this.buf_.append("<head>\n");
        this.buf_.append("<TITLE>JMX Console</TITLE>\n");
        this.buf_.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        this.buf_.append("<META content=global name=distribution><LINK href=\"blaf.css\" type=text/css rel=stylesheet>\n");
        this.buf_.append("<meta name=\"Author\" content=\"Oracle Corp.\">\n");
        this.buf_.append("</head>\n");
        this.buf_.append("<h1>\n");
        this.buf_.append(this.domain_ + " JMX Console\n");
        this.buf_.append("</h1>\n");
        this.buf_.append("<p>\n");
    }

    public final void addTrailer() {
        this.buf_.append("<H2></H2>\n");
        this.buf_.append("<P><FONT face=Arial size=1>Copyright\u00a9 2004 Oracle Corporation. All Rights Reserved.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</FONT>\n");
        this.buf_.append("<FONT face=Arial size=-2></FONT><FONT face=Arial size=1><BR></FONT>&nbsp;</P>\n");
        this.buf_.append("</body>\n");
        this.buf_.append("</html>\n");
    }

    public void addMBeanList(Set objMbeans, Set objDomains) {
        TreeSet mbeans = new TreeSet(new ObjectNameComparator());
        mbeans.addAll(objMbeans);
        TreeSet domains = new TreeSet(new ObjectNameComparator());
        domains.addAll(objDomains);
        this.buf_.append("<ul>\n");
        Iterator iterDomains = domains.iterator();
        while (iterDomains.hasNext()) {
            this.buf_.append("<li>\n");
            this.buf_.append("<h3>\n");
            String domain = iterDomains.next().toString();
            this.buf_.append(domain + "\n");
            this.buf_.append("</h3>\n");
            this.buf_.append("</li>\n");
            Iterator iterMbeans = mbeans.iterator();
            this.buf_.append("<ul>\n");
            while (iterMbeans.hasNext()) {
                ObjectName obj = (ObjectName)iterMbeans.next();
                if (!domain.equals(obj.getDomain())) continue;
                this.buf_.append("<li>\n");
                if (this.extraParam_ == null) {
                    this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWMBEAN&amp;mbean=" + this.format(obj.toString()) + "\">");
                } else {
                    this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWMBEAN&amp;mbean=" + this.format(obj.toString()) + "\">");
                }
                this.buf_.append(this.format(obj.toString()) + "</a>\n");
                this.buf_.append("</li>\n");
            }
            this.buf_.append("</ul>\n");
            this.buf_.append("<br>\n");
        }
        this.buf_.append("</ul>\n");
    }

    public void addQueryForm(String query) {
        this.addQueryForm(query, null, null, null);
    }

    public void addQueryForm(String query, String attr, String op, String val) {
        this.buf_.append("<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\">\n");
        this.buf_.append("<tr align=\"left\" valign=\"top\" >\n");
        for (int i = 0; i < 8; ++i) {
            this.buf_.append("<td></td>\n");
        }
        this.buf_.append("<td>");
        this.buf_.append("<form method=\"post\" name=\"QueryNames\" action=\"" + this.domain_.toLowerCase() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"QUERYNAMES\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("MBeansForPattern") + " </FONT><br>");
        this.buf_.append("<input type=\"text\" name=\"query\" size=50 value=\"" + this.format(query) + "\"><br><br>\n");
        this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Query") + " </FONT>");
        if (this.extraParam_ == null) {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWQUERYHELP\" >?</a><br>");
        } else {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWQUERYHELP\" >?</a><br>");
        }
        this.buf_.append(this.locHelper_.getLocalizedMessage("Attribute"));
        if (attr == null) {
            attr = "";
        }
        this.buf_.append("<input type=\"text\" name=\"attr\" size=10 value=\"" + attr + "\">\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("Operation"));
        this.buf_.append("<select name=\"op\">\n");
        try {
            int v = Integer.parseInt(op);
            switch (v) {
                case 4: {
                    this.buf_.append("<option selected value=\"4\">=</option selected>\n");
                    break;
                }
                case 2: {
                    this.buf_.append("<option selected value=\"2\">>=</option selected>\n");
                    break;
                }
                case 0: {
                    this.buf_.append("<option selected value=\"0\">></option selected>\n");
                    break;
                }
                case 3: {
                    this.buf_.append("<option selected value=\"3\"><=</option selected>\n");
                    break;
                }
                case 1: {
                    this.buf_.append("<option selected value=\"1\"><</option selected>\n");
                    break;
                }
                case 1000: {
                    this.buf_.append("<option selected value=\"1000\">" + this.locHelper_.getLocalizedMessage("QueryMatch") + "</option selected>\n");
                    break;
                }
                case 1001: {
                    this.buf_.append("<option selected value=\"1001\">" + this.locHelper_.getLocalizedMessage("QueryAnySubString") + "</option selected>\n");
                    break;
                }
                case 1002: {
                    this.buf_.append("<option selected value=\"1002\">" + this.locHelper_.getLocalizedMessage("QueryStartWithString") + "</option selected>\n");
                    break;
                }
                case 1003: {
                    this.buf_.append("<option selected value=\"1003\">" + this.locHelper_.getLocalizedMessage("QueryEndWithString") + "</option selected>\n");
                    break;
                }
                default: {
                    this.buf_.append("<option selected value=\"4\">=</option selected>\n");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            this.buf_.append("<option selected value=\"4\">=</option selected>\n");
        }
        this.buf_.append("<option value=\"4\">=\n");
        this.buf_.append("<option value=\"0\">>\n");
        this.buf_.append("<option value=\"2\">>=\n");
        this.buf_.append("<option value=\"1\"><\n");
        this.buf_.append("<option value=\"3\"><=\n");
        this.buf_.append("<option value=\"1000\">" + this.locHelper_.getLocalizedMessage("QueryMatch") + "\n");
        this.buf_.append("<option value=\"1001\">" + this.locHelper_.getLocalizedMessage("QueryAnySubString") + "\n");
        this.buf_.append("<option value=\"1002\">" + this.locHelper_.getLocalizedMessage("QueryStartWithString") + "\n");
        this.buf_.append("<option value=\"1003\">" + this.locHelper_.getLocalizedMessage("QueryEndWithString") + "\n");
        this.buf_.append("</select>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("Value"));
        if (val == null) {
            val = "";
        }
        this.buf_.append("<input type=\"text\" name=\"val\" size=10 value=\"" + val + "\"><br><br>");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("ApplyPattern") + "\">\n");
        this.buf_.append("</form>\n");
        this.buf_.append("</td>\n");
        for (int i = 0; i < 15; ++i) {
            this.buf_.append("<td></td>\n");
        }
        this.buf_.append("<td>");
        this.buf_.append("<form method=\"post\" name=\"JSR77Name\" action=\"" + this.domain_.toLowerCase() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"JSR77NAMES\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("MBeansForJ2eeType") + " </FONT><br>");
        this.buf_.append("<select name=\"jsr77name\">\n");
        this.buf_.append("<option selected value=\"All\">All</option selected>\n");
        Iterator iterjt = this.jt_.iterator();
        while (iterjt.hasNext()) {
            String jtype = iterjt.next().toString();
            this.buf_.append("<option value=\"" + jtype + "\">" + jtype + "\n");
        }
        this.buf_.append("</select><br><br>\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("Find") + "\">\n");
        this.buf_.append("</form>\n");
        this.buf_.append("</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("</table>\n");
    }

    public void queryHelp() {
        this.buf_.append(this.locHelper_.getLocalizedMessage("QueryHelpGeneral"));
        this.buf_.append("<br><br>");
        this.buf_.append(this.locHelper_.getLocalizedMessage("QueryHelpExpression"));
        this.buf_.append("<br><br>");
    }

    public void reportError(HandlingException e) {
        this.buf_ = new StringBuffer();
        this.addHeader();
        this.buf_.append("<H3>");
        this.buf_.append("ERROR: ");
        this.buf_.append("</H3>");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter pout = new PrintWriter(bout);
        e.printStackTrace(pout);
        pout.flush();
        String stackTrace = bout.toString();
        this.buf_.append("<PRE>");
        this.buf_.append("<FONT color=#996633>" + this.format(stackTrace) + "</FONT>");
        this.buf_.append("</PRE>");
        this.addTrailer();
    }

    public void addMBeanGeneralInfo(String mbean, String className, String desc, MBeanInfo info) {
        block5: {
            this.buf_.append("<H3>\n");
            this.buf_.append(this.locHelper_.getLocalizedMessage("MBeanGeneralInfo"));
            this.buf_.append(" ");
            if (this.extraParam_ == null) {
                this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWFULLMBEANINFO&amp;mbean=" + this.format(mbean) + "\">");
            } else {
                this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWFULLMBEANINFO&amp;mbean=" + this.format(mbean) + "\">");
            }
            this.buf_.append("(");
            this.buf_.append(this.locHelper_.getLocalizedMessage("FullMBeanInfo"));
            this.buf_.append(")");
            this.buf_.append("</a>\n");
            this.buf_.append("</H3>\n");
            this.buf_.append("<PRE>\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Name") + "        : </FONT><B>" + mbean + "</B>\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + desc + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Class") + "       : </FONT>" + className + "\n");
            this.buf_.append("</PRE>\n");
            try {
                ModelMBeanInfo minfo;
                Descriptor descriptor;
                if (info instanceof ModelMBeanInfo && (descriptor = (minfo = (ModelMBeanInfo)((Object)info)).getMBeanDescriptor()) != null && descriptor.getFieldNames().length > 0) {
                    this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("descriptor_properties") + "</FONT></br>\n");
                    this.buf_.append("<textarea cols=\"80\" rows=\"4\" name=\"descriptor-properties\">");
                    this.addDescriptorProperties(descriptor);
                    this.buf_.append("</textarea>");
                }
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block5;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void addDescriptorProperties(Descriptor desc) {
        String[] fieldNames = desc.getFieldNames();
        TreeSet<String> propNames = new TreeSet<String>();
        for (int i = 0; i < fieldNames.length; ++i) {
            propNames.add(fieldNames[i]);
        }
        Iterator iterNames = propNames.iterator();
        while (iterNames.hasNext()) {
            String name = (String)iterNames.next();
            this.buf_.append(name);
            this.buf_.append(":  ");
            this.buf_.append(desc.getFieldValue(name));
            this.buf_.append("\n");
        }
    }

    public void addAttributesInfo(MBeanAttributeInfo[] attribInf, String mbeanName) {
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("MBeanAttributes"));
        this.buf_.append("</H3>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<select name=\"attribute\">\n");
        TreeSet<String> info = new TreeSet<String>(new ObjectNameComparator());
        for (int i = 0; i < attribInf.length; ++i) {
            info.add(attribInf[i].getName());
        }
        Iterator iterInfo = info.iterator();
        while (iterInfo.hasNext()) {
            String attri = iterInfo.next().toString();
            this.buf_.append("<option value=\"" + attri + "\">" + attri + "\n");
        }
        this.buf_.append("</select>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWATTRIBUTE\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetDetails") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addOperationsInfo(MBeanOperationInfo[] operInf, String mbeanName) {
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("MBeanOperations"));
        this.buf_.append("</H3>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<select name=\"operation\">\n");
        TreeSet<String> info = new TreeSet<String>(new ObjectNameComparator());
        for (int i = 0; i < operInf.length; ++i) {
            info.add(this.buildMethodSignature(operInf[i]));
        }
        Iterator iterInfo = info.iterator();
        while (iterInfo.hasNext()) {
            String oper = iterInfo.next().toString();
            this.buf_.append("<option value=\"" + oper + "\">" + oper + "\n");
        }
        this.buf_.append("</select>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWOPERATION\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetDetails") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addNotificationInfo(MBeanNotificationInfo[] notifInf, String mbeanName) {
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("MBeanNotifications"));
        this.buf_.append("</H3>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<select name=\"notification\">\n");
        TreeSet<String> info = new TreeSet<String>(new ObjectNameComparator());
        for (int i = 0; i < notifInf.length; ++i) {
            info.add(notifInf[i].getName());
        }
        Iterator iterInfo = info.iterator();
        while (iterInfo.hasNext()) {
            String notif = iterInfo.next().toString();
            this.buf_.append("<option value=\"" + notif + "\">" + notif + "\n");
        }
        this.buf_.append("</select>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWNOTIFICATION\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetDetails") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addStats(Stats stats, String mbeanName) {
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("MBeanStatistics"));
        this.buf_.append("</H3>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<select name=\"statistic\">\n");
        String[] names = stats.getStatisticNames();
        TreeSet<String> info = new TreeSet<String>(new ObjectNameComparator());
        for (int i = 0; i < names.length; ++i) {
            info.add(names[i]);
        }
        Iterator iterInfo = info.iterator();
        while (iterInfo.hasNext()) {
            String name = iterInfo.next().toString();
            this.buf_.append("<option value=\"" + name + "\">" + name + "\n");
        }
        this.buf_.append("</select>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWSTATISTIC\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetDetails") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addQueryPageBackLink(String query) {
        if (this.extraParam_ == null) {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=QUERYNAMES&amp;query=" + query + "\">");
        } else {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=QUERYNAMES&amp;query=" + query + "\">");
        }
        this.buf_.append(this.locHelper_.getLocalizedMessage("BackToJMXMainPage"));
        this.buf_.append("</a>\n");
    }

    public void addAdminBackLink() {
        int i;
        this.buf_.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\n");
        this.buf_.append("<tr align=\"left\" valign=\"top\" >\n");
        this.buf_.append("<td>");
        this.buf_.append("<a href=\"index.html\">");
        this.buf_.append(this.locHelper_.getLocalizedMessage("BackToAdministrationMainPage"));
        this.buf_.append("</a>");
        this.buf_.append("</td>");
        for (i = 0; i < 10; ++i) {
            this.buf_.append("<td>");
            this.buf_.append("</td>");
        }
        this.buf_.append("<td>");
        if (this.extraParam_ == null) {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWEVENTS\">");
        } else {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWEVENTS\">");
        }
        this.buf_.append(this.locHelper_.getLocalizedMessage("Events"));
        this.buf_.append("</a>");
        this.buf_.append("</td>");
        for (i = 0; i < 10; ++i) {
            this.buf_.append("<td>");
            this.buf_.append("</td>");
        }
        this.buf_.append("<td>");
        if (this.extraParam_ == null) {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWLISTENERS\">");
        } else {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWLISTENERS\">");
        }
        this.buf_.append(this.locHelper_.getLocalizedMessage("Listeners"));
        this.buf_.append("</a>");
        this.buf_.append("</td>");
        this.buf_.append("</tr>");
        this.buf_.append("</table>");
    }

    public void displayReceivedEvents(Vector events) {
        int nev = events.size() * 5 > 25 ? 25 : events.size() * 5;
        nev = nev > 5 ? nev : 5;
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Events") + "</FONT></br>\n");
        this.buf_.append("<textarea cols=\"100\" rows=\"" + nev + "\" name=\"events\">");
        Iterator it = events.iterator();
        while (it.hasNext()) {
            Notification anotif;
            Notification notif = (Notification)it.next();
            this.buf_.append(new Date(notif.getTimeStamp()));
            this.buf_.append("   type: ");
            this.buf_.append(notif.getType());
            this.buf_.append("   source: ");
            this.buf_.append(notif.getSource());
            this.buf_.append("   data: ");
            this.buf_.append(notif.getUserData() == null ? "NULL" : notif.getUserData().toString());
            this.buf_.append("   msg: ");
            this.buf_.append(notif.getMessage());
            if (notif instanceof AttributeChangeNotification) {
                anotif = (AttributeChangeNotification)notif;
                this.buf_.append("   attr name: ");
                this.buf_.append(((AttributeChangeNotification)anotif).getAttributeName());
                this.buf_.append("   attr old value: ");
                this.buf_.append(((AttributeChangeNotification)anotif).getOldValue().toString());
                this.buf_.append("   attr new value: ");
                this.buf_.append(((AttributeChangeNotification)anotif).getNewValue().toString());
            }
            if (notif instanceof MBeanServerNotification) {
                anotif = (MBeanServerNotification)notif;
                this.buf_.append("   MBean: ");
                this.buf_.append(((MBeanServerNotification)anotif).getMBeanName().toString());
            }
            this.buf_.append("\n\n");
        }
        this.buf_.append("</textarea>");
        this.buf_.append("</br>");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"CLEAREVENTS\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("ClearEvents") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void displayRegisteredListeners(Hashtable listeners) {
        int nev = listeners.size() > 25 ? 25 : listeners.size();
        nev = nev > 5 ? nev : 5;
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Listeners") + "</FONT></br>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<select name=\"listener\">\n");
        TreeSet<ObjectName> info = new TreeSet<ObjectName>(new ObjectNameComparator());
        Iterator it = listeners.keySet().iterator();
        while (it.hasNext()) {
            info.add((ObjectName)it.next());
        }
        Iterator iterInfo = info.iterator();
        while (iterInfo.hasNext()) {
            String attri = iterInfo.next().toString();
            this.buf_.append("<option value=\"" + attri + "\">" + attri + "\n");
        }
        this.buf_.append("</select>\n</br></br>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"REMOVELISTENER\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("UnRegisterListener") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addAttributeInfo(MBeanAttributeInfo theAttrib, String mbean, Object value) {
        this.addAttributeInfo(theAttrib, mbean, value, true);
    }

    public void addAttributeInfo(MBeanAttributeInfo theAttrib, String mbean) {
        this.addAttributeInfo(theAttrib, mbean, null, false);
    }

    private void addAttributeInfo(MBeanAttributeInfo theAttrib, String mbean, Object value, boolean retrieved) {
        block33: {
            this.buf_.append("<H3>\n");
            this.buf_.append(theAttrib.getName());
            this.buf_.append("</H3>\n");
            this.buf_.append("<PRE>\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + theAttrib.getDescription() + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "       : </FONT>" + mbean + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + theAttrib.getType() + "\n");
            if (theAttrib.isReadable() && theAttrib.isWritable()) {
                this.buf_.append("<FONT color=#996633>Access      : </FONT>Read/Write\n");
            } else if (theAttrib.isReadable()) {
                this.buf_.append("<FONT color=#996633>Access      : </FONT>Read Only\n");
            } else if (theAttrib.isWritable()) {
                this.buf_.append("<FONT color=#996633>Access      : </FONT>Write Only\n");
            }
            this.buf_.append("</PRE>\n");
            try {
                ModelMBeanAttributeInfo minfo;
                Descriptor descriptor;
                if (theAttrib instanceof ModelMBeanAttributeInfo && (descriptor = (minfo = (ModelMBeanAttributeInfo)theAttrib).getDescriptor()) != null && descriptor.getFieldNames().length > 0) {
                    this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("descriptor_properties") + "</FONT></br>\n");
                    this.buf_.append("<textarea cols=\"80\" rows=\"4\" name=\"descriptor-properties\">");
                    this.addDescriptorProperties(descriptor);
                    this.buf_.append("</textarea>");
                    this.buf_.append("</br></br>");
                }
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block33;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.buf_.append("<fieldset>\n");
        this.buf_.append("<legend>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("Value"));
        this.buf_.append("</legend>\n");
        this.buf_.append("<pre>");
        if (value != null) {
            boolean isObjectName;
            boolean bl = isObjectName = theAttrib.getType().indexOf("javax.management.ObjectName") != -1;
            if (value instanceof Collection) {
                this.buf_.append("\n");
                this.buf_.append(this.print((Collection)value, " "));
            } else if (value instanceof Map) {
                if (value instanceof TabularData) {
                    this.buf_.append(this.print((TabularData)value, " "));
                } else {
                    this.buf_.append("\n");
                    this.buf_.append(this.print((Map)value, " "));
                }
            } else if (value.getClass().isArray()) {
                this.buf_.append(this.print(value, "", isObjectName));
            } else if (value instanceof CompositeData) {
                this.buf_.append(this.format(CompositeDataItem.toStringWithIndex((CompositeData)value)));
            } else if (isObjectName) {
                this.buf_.append(this.formatObjectName((ObjectName)value));
            } else {
                this.buf_.append(this.format(value.toString()));
            }
        } else if (retrieved) {
            this.buf_.append("Null");
        } else {
            this.buf_.append(this.locHelper_.getLocalizedMessage("NotRetrieved"));
        }
        this.buf_.append("</pre>");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWATTRIBUTE\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"getvalue\" value=\"y\">\n");
        this.buf_.append("<pre>  ");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetValue") + "\">\n");
        this.buf_.append("</pre>");
        this.buf_.append("</form>\n");
        this.buf_.append("</fieldset>\n");
        if (theAttrib.isWritable() && this.canSetType(theAttrib.getType())) {
            this.buf_.append("<fieldset>\n");
            this.buf_.append("<legend>\n");
            this.buf_.append(this.locHelper_.getLocalizedMessage("SetTo"));
            this.buf_.append("</legend>\n");
            this.buf_.append("<form>\n");
            this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SETATTRIBUTE\">\n");
            if (this.extraParam_ != null) {
                this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
            }
            this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
            this.buf_.append("<input type=\"hidden\" name=\"getvalue\" value=\"y\">\n");
            this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
            this.buf_.append("<pre>  ");
            String type = theAttrib.getType();
            if (type.startsWith("[L") && type.endsWith(";")) {
                this.buf_.append("\n");
                this.buf_.append("<input type=\"hidden\" name=\"value\" value=\"" + value + "\">\n");
                this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InputValues") + "\">\n");
                this.buf_.append("\n");
            } else if (type.startsWith("java.util") && (type.lastIndexOf("List") != -1 || type.equals("java.util.Vector") || type.lastIndexOf("Set") != -1)) {
                this.buf_.append("\n");
                this.buf_.append("<input type=\"hidden\" name=\"value\" value=\"" + value + "\">\n");
                this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InputValues") + "\">\n");
                this.buf_.append("\n");
            } else if (type.startsWith("java.util") && (type.lastIndexOf("Map") != -1 || type.equals("java.util.Properties") || type.lastIndexOf("Hash") != -1)) {
                this.buf_.append("\n");
                this.buf_.append("<input type=\"hidden\" name=\"value\" value=\"" + value + "\">\n");
                this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InputValuesForMap") + "\">\n");
                this.buf_.append("\n");
            } else {
                this.buf_.append("<input type=\"text\" name=\"value\" size=\"20\">\n");
            }
            this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("SetValue") + "\">\n");
            this.buf_.append("</pre>");
            this.buf_.append("</form>\n");
            this.buf_.append("</fieldset>\n");
        }
    }

    public void addOperationInfo(MBeanOperationInfo theOper, String mbeanName) {
        String type;
        String methodSign;
        block17: {
            methodSign = this.buildMethodSignature(theOper);
            this.buf_.append("<H3>\n");
            this.buf_.append(methodSign);
            this.buf_.append("</H3>\n");
            this.buf_.append("<PRE>\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + "   : </FONT>" + theOper.getDescription() + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "         : </FONT>" + mbeanName + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("ReturnType") + "   : </FONT>" + theOper.getReturnType() + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MethodImpact") + " : </FONT>" + methodImpact_[theOper.getImpact()] + "\n");
            this.buf_.append("</PRE>\n");
            try {
                ModelMBeanOperationInfo minfo;
                Descriptor descriptor;
                if (theOper instanceof ModelMBeanOperationInfo && (descriptor = (minfo = (ModelMBeanOperationInfo)theOper).getDescriptor()) != null && descriptor.getFieldNames().length > 0) {
                    this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("descriptor_properties") + "</FONT></br>\n");
                    this.buf_.append("<textarea cols=\"80\" rows=\"4\" name=\"descriptor-properties\">");
                    this.addDescriptorProperties(descriptor);
                    this.buf_.append("</textarea>");
                }
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block17;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.buf_.append("<form action=\"" + this.domain_.toLowerCase() + "\"  method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INVOKEOPERATION\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"operation\" value=\"" + methodSign + "\">\n");
        MBeanParameterInfo[] params = theOper.getSignature();
        this.buf_.append("<input type=\"hidden\" name=\"paramCount\" value=\"" + params.length + "\">\n");
        boolean canInvoke = true;
        for (int i = 0; i < params.length; ++i) {
            type = params[i].getType();
            canInvoke &= this.canSetType(type);
        }
        if (canInvoke) {
            if (params.length != 0) {
                this.buf_.append("\n<H3> " + this.locHelper_.getLocalizedMessage("SetUpParameter") + ": </H3>\n");
            }
            for (int j = 0; j < params.length; ++j) {
                type = params[j].getType();
                String description = params[j].getDescription();
                String name = params[j].getName();
                int i = j + 1;
                this.buf_.append("<PRE>\n");
                this.buf_.append("<STRONG>" + this.locHelper_.getLocalizedMessage("Parameter") + i + ": </STRONG>\n");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Name") + "        : </FONT>" + name + "\n");
                this.buf_.append("<br>");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + description + "\n");
                this.buf_.append("<br>");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + type + "\n");
                if (type.startsWith("[L") && type.endsWith(";")) {
                    this.buf_.append("\n");
                    this.buf_.append("<input type=\"hidden\" name=\"param" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"hidden\" name=\"textParam" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"submit\" name=\"submitAction" + j + "\" value=\"" + this.locHelper_.getLocalizedMessage("InputValues") + "\">\n");
                    this.buf_.append("\n");
                } else if (type.startsWith("java.util") && (type.lastIndexOf("List") != -1 || type.equals("java.util.Vector") || type.lastIndexOf("Set") != -1)) {
                    this.buf_.append("\n");
                    this.buf_.append("<input type=\"hidden\" name=\"param" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"hidden\" name=\"textParam" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"submit\" name=\"submitAction" + j + "\" value=\"" + this.locHelper_.getLocalizedMessage("InputValues") + "\">\n");
                    this.buf_.append("\n");
                } else if (type.startsWith("java.util") && (type.lastIndexOf("Map") != -1 || type.equals("java.util.Properties") || type.lastIndexOf("Hash") != -1)) {
                    this.buf_.append("\n");
                    this.buf_.append("<input type=\"hidden\" name=\"param" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"hidden\" name=\"textParam" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"submit\" name=\"submitAction" + j + "\" value=\"" + this.locHelper_.getLocalizedMessage("InputValuesForMap") + "\">\n");
                    this.buf_.append("\n");
                } else if (type.equals("javax.management.openmbean.CompositeData")) {
                    this.buf_.append("\n");
                    this.buf_.append("<input type=\"hidden\" name=\"param" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"hidden\" name=\"textParam" + j + "\" value=\"complex type\">\n");
                    this.buf_.append("<input type=\"submit\" name=\"submitAction" + j + "\" value=\"" + "Input values for CompositeData" + "\">\n");
                    this.buf_.append("\n");
                } else {
                    this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("ValueToSet") + ": </FONT> <input type=\"text\" name=\"param" + j + "\" " + "size=\"20\">\n\n");
                }
                this.buf_.append("<br>");
                this.buf_.append("</PRE>\n");
                this.buf_.append("<br>");
            }
            this.buf_.append("<br>");
            this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InvokeMethod") + "\">\n");
        } else {
            this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("CannotInvokeMethod") + "</FONT>\n");
        }
        this.buf_.append("</form>\n");
    }

    public void addMBeanPageBackLink(String mbean) {
        if (this.extraParam_ == null) {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWMBEAN&amp;mbean=" + this.format(mbean) + "\">");
        } else {
            this.buf_.append("<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWMBEAN&amp;mbean=" + this.format(mbean) + "\">");
        }
        this.buf_.append(this.locHelper_.getLocalizedMessage("BackToMBeanPage"));
        this.buf_.append("</a>\n");
    }

    public void addReturnValue(Object retval, boolean isVoid, boolean isObjectName) {
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("OperationExecutedSuccessfully"));
        this.buf_.append("</H3>\n");
        if (!isVoid) {
            if (retval != null) {
                this.buf_.append("<PRE>\n");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Result") + ": </FONT>");
                if (retval instanceof Collection) {
                    this.buf_.append("\n");
                    this.buf_.append(this.print((Collection)retval, " "));
                } else if (retval.getClass().isArray()) {
                    this.buf_.append("\n");
                    this.buf_.append(this.print(retval, "", isObjectName));
                    this.buf_.append("\n");
                } else if (retval instanceof CompositeData) {
                    this.buf_.append('\n').append(this.format(CompositeDataItem.toStringWithIndex((CompositeData)retval))).append('\n');
                } else if (isObjectName) {
                    this.buf_.append(this.formatObjectName((ObjectName)retval) + "\n");
                } else {
                    this.buf_.append(this.format(retval.toString()) + "\n");
                }
                this.buf_.append("</PRE>\n");
            } else {
                this.buf_.append("<PRE>\n");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Result") + ": </FONT>");
                this.buf_.append("null\n");
                this.buf_.append("</PRE>\n");
            }
        }
    }

    public void addNotification(MBeanNotificationInfo notifInf, String mbean) {
        block6: {
            this.buf_.append("<H3>\n");
            this.buf_.append(this.locHelper_.getLocalizedMessage("Meta-dataForNotification") + ": " + notifInf.getName());
            this.buf_.append("</H3>\n");
            this.buf_.append("<PRE>\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + notifInf.getDescription() + "\n");
            this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "       : </FONT>" + mbean + "\n");
            this.buf_.append("</PRE>\n");
            try {
                ModelMBeanNotificationInfo minfo;
                Descriptor descriptor;
                if (notifInf instanceof ModelMBeanNotificationInfo && (descriptor = (minfo = (ModelMBeanNotificationInfo)notifInf).getDescriptor()) != null && descriptor.getFieldNames().length > 0) {
                    this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("descriptor_properties") + "</FONT></br>\n");
                    this.buf_.append("<textarea cols=\"80\" rows=\"4\" name=\"descriptor-properties\">");
                    this.addDescriptorProperties(descriptor);
                    this.buf_.append("</textarea>");
                }
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block6;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        String[] notifTypes = notifInf.getNotifTypes();
        this.buf_.append("<H3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("SupportedNotificationType"));
        this.buf_.append("</H3>\n");
        for (int i = 0; i < notifTypes.length; ++i) {
            this.buf_.append(notifTypes[i] + "<BR>\n");
        }
        this.buf_.append("<BR>");
        this.buf_.append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"12\">\n");
        this.buf_.append("<tr align=\"left\" valign=\"top\" >\n");
        this.buf_.append("<td>");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"RLISTENER\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"notification\" value=\"" + notifInf.getName() + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("RegisterListener") + "\">\n");
        this.buf_.append("</form>\n");
        this.buf_.append("</td>");
        this.buf_.append("<td>");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"URLISTENER\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"notification\" value=\"" + notifInf.getName() + "\">\n");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("UnRegisterListener") + "\">\n");
        this.buf_.append("</form>\n");
        this.buf_.append("</td>");
        this.buf_.append("</tr>");
        this.buf_.append("</table>");
    }

    public void addCompleteMBeanDescriptionPage(MBeanInfo info, String mbean, Stats stats) {
        this.buf_.append("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
        this.buf_.append("<html>\n");
        this.buf_.append("<head>\n");
        this.buf_.append("<TITLE>JMX MBean Documentation Page</TITLE>\n");
        this.buf_.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        this.buf_.append("<META content=global name=distribution><LINK href=\"blaf.css\" type=text/css rel=stylesheet>\n");
        this.buf_.append("<meta name=\"Author\" content=\"Oracle Corp.\">\n");
        this.buf_.append("</head>\n");
        this.buf_.append("<body>");
        this.addCompleteMBeanDescription(info, mbean, stats);
        this.buf_.append("<H2></H2>\n");
        this.buf_.append("<P><FONT face=Arial size=1>Copyright\u00a9 2004 Oracle Corporation. All Rights Reserved.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</FONT>\n");
        this.buf_.append("<FONT face=Arial size=-2></FONT><FONT face=Arial size=1><BR></FONT>&nbsp;</P>\n");
        this.buf_.append("</body>\n");
        this.buf_.append("</html>\n");
    }

    public void generateCompleteMBeanDescriptionPageIndex(Set j2eeTypes) {
        this.buf_.append("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
        this.buf_.append("<html>\n");
        this.buf_.append("<head>\n");
        this.buf_.append("<TITLE>JMX MBean Documentation Page</TITLE>\n");
        this.buf_.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        this.buf_.append("<META content=global name=distribution><LINK href=\"blaf.css\" type=text/css rel=stylesheet>\n");
        this.buf_.append("<meta name=\"Author\" content=\"Oracle Corp.\">\n");
        this.buf_.append("</head>\n");
        this.buf_.append("<body>");
        this.buf_.append("<h1>\n");
        this.buf_.append("OC4J MBeans Documentation (Organized by j2eeType)\n");
        this.buf_.append("</h1>\n");
        this.buf_.append("<p>\n");
        TreeSet orderedInfo = new TreeSet(new ObjectNameComparator());
        orderedInfo.addAll(j2eeTypes);
        Iterator it = orderedInfo.iterator();
        this.buf_.append("<ul>\n");
        while (it.hasNext()) {
            String j2eeType = (String)it.next();
            this.buf_.append("<li>\n");
            this.buf_.append("<a href=\"" + j2eeType + ".html\">");
            this.buf_.append(j2eeType + "</a>\n");
            this.buf_.append("</li>\n");
        }
        this.buf_.append("</ul>\n");
        this.buf_.append("<br>\n");
        this.buf_.append("<H2></H2>\n");
        this.buf_.append("<P><FONT face=Arial size=1>Copyright\u00a9 2004 Oracle Corporation. All Rights Reserved.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</FONT>\n");
        this.buf_.append("<FONT face=Arial size=-2></FONT><FONT face=Arial size=1><BR></FONT>&nbsp;</P>\n");
        this.buf_.append("</body>\n");
        this.buf_.append("</html>\n");
    }

    public void addCompleteMBeanDescription(MBeanInfo info, String mbean, Stats stats) {
        Statistic[] statistics;
        MBeanNotificationInfo[] notifInfo;
        MBeanOperationInfo[] operInfo;
        this.buf_.append("<H3><B>\n");
        this.buf_.append(mbean);
        this.buf_.append("</B></H3>\n");
        this.buf_.append("<b>");
        this.buf_.append(this.locHelper_.getLocalizedMessage("Description") + ": </b>");
        this.buf_.append(info.getDescription());
        this.buf_.append("<br><br>");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo != null & attrInfo.length > 0) {
            this.buf_.append("<table border=\"3\" cellspacing=\"1\" cellpadding=\"1\">\n");
            this.buf_.append("<caption><H3>" + this.locHelper_.getLocalizedMessage("MBeanAttributes") + "</H3></caption>\n");
            this.buf_.append("<tr>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Name") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Type") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Access") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Description") + "</b></td>\n");
            this.buf_.append("</tr>\n");
            HashMap<String, MBeanAttributeInfo> nameToAttrInf = new HashMap<String, MBeanAttributeInfo>();
            TreeSet<String> orderedInfo = new TreeSet<String>(new ObjectNameComparator());
            for (int j = 0; j < attrInfo.length; ++j) {
                orderedInfo.add(attrInfo[j].getName());
                nameToAttrInf.put(attrInfo[j].getName(), attrInfo[j]);
            }
            Iterator iterInfo = orderedInfo.iterator();
            while (iterInfo.hasNext()) {
                MBeanAttributeInfo inf = (MBeanAttributeInfo)nameToAttrInf.get(iterInfo.next());
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\">");
                this.buf_.append("<a href=\"" + this.domain_.toLowerCase());
                if (this.extraParam_ == null) {
                    this.buf_.append("?command=SHOWATTRIBUTE&amp;attribute=" + inf.getName());
                } else {
                    this.buf_.append("?" + this.extraParam_ + "&amp;command=SHOWATTRIBUTE&amp;attribute=" + inf.getName());
                }
                this.buf_.append("&amp;mbean=" + this.format(mbean) + "\">");
                this.buf_.append(inf.getName() + "</a></td>\n");
                this.buf_.append("<td align=\"left\">" + HtmlGenerator.getTypeName(inf.getType()) + "</td>\n");
                String access = inf.isReadable() & inf.isWritable() ? "R/W" : (inf.isReadable() ? "R" : "W");
                this.buf_.append("<td align=\"left\">" + access + "</td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getDescription() + "</td>\n");
                this.buf_.append("</tr>\n");
            }
            this.buf_.append("</table><br><br><br>\n");
        }
        if ((operInfo = info.getOperations()) != null & operInfo.length > 0) {
            this.buf_.append("<table border=\"3\" cellspacing=\"1\" cellpadding=\"1\">\n");
            this.buf_.append("<caption><H3>" + this.locHelper_.getLocalizedMessage("MBeanOperations") + "</H3></caption>\n");
            this.buf_.append("<tr>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Name") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Impact") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Description") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("OperationParameter") + "</b></td>\n");
            this.buf_.append("</tr>\n");
            HashMap<String, MBeanOperationInfo> nameToAttrInf = new HashMap<String, MBeanOperationInfo>();
            TreeSet<String> orderedInfo = new TreeSet<String>(new ObjectNameComparator());
            for (int j = 0; j < operInfo.length; ++j) {
                orderedInfo.add(operInfo[j].getName());
                nameToAttrInf.put(operInfo[j].getName(), operInfo[j]);
            }
            Iterator iterInfo = orderedInfo.iterator();
            while (iterInfo.hasNext()) {
                MBeanOperationInfo inf = (MBeanOperationInfo)nameToAttrInf.get(iterInfo.next());
                String signature = this.buildMethodSignature(inf);
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\">");
                this.buf_.append("<a href=\"" + this.domain_.toLowerCase());
                if (this.extraParam_ == null) {
                    this.buf_.append("?command=SHOWOPERATION&amp;operation=" + signature);
                } else {
                    this.buf_.append("?" + this.extraParam_ + "&amp;command=SHOWOPERATION&amp;operation=" + signature);
                }
                this.buf_.append("&amp;mbean=" + this.format(mbean) + "\">");
                this.buf_.append(inf.getName() + "</a></td>\n");
                this.buf_.append("<td align=\"left\">" + methodImpactShort_[inf.getImpact()] + "</td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getDescription() + "</td>\n");
                MBeanParameterInfo[] params = inf.getSignature();
                this.buf_.append("<td align=\"left\">\n");
                this.buf_.append("<table width=\"100%\" border=\"1\" cellspacing=\"1\" cellpadding=\"1\">\n");
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Name") + "</b></td>\n");
                this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Type") + "</b></td>\n");
                this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Description") + "</b></td>\n");
                this.buf_.append("</tr>\n");
                for (int j = 0; j < params.length; ++j) {
                    this.buf_.append("<tr>\n");
                    this.buf_.append("<td align=\"left\">" + params[j].getName() + "</td>\n");
                    this.buf_.append("<td align=\"left\">" + HtmlGenerator.getTypeName(params[j].getType()) + "</td>\n");
                    this.buf_.append("<td align=\"left\">" + params[j].getDescription() + "</td>\n");
                    this.buf_.append("</tr>\n");
                }
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\">");
                this.buf_.append(this.locHelper_.getLocalizedMessage("ReturnType") + "</td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getReturnType() + "</td>\n");
                this.buf_.append("<td align=\"left\"> </td>\n");
                this.buf_.append("</tr>\n");
                this.buf_.append("</table>\n");
                this.buf_.append("</td>\n");
                this.buf_.append("</tr>\n");
            }
            this.buf_.append("</table><br><br><br>\n");
        }
        if ((notifInfo = info.getNotifications()) != null & notifInfo.length > 0) {
            this.buf_.append("<table border=\"3\" cellspacing=\"1\" cellpadding=\"1\">\n");
            this.buf_.append("<caption><H3>" + this.locHelper_.getLocalizedMessage("MBeanNotifications") + "</H3></caption>\n");
            this.buf_.append("<tr>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Description") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Class") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Types") + "</b></td>\n");
            this.buf_.append("</tr>\n");
            HashMap<String, MBeanNotificationInfo> nameToNotifInf = new HashMap<String, MBeanNotificationInfo>();
            TreeSet<String> orderedInfo = new TreeSet<String>(new ObjectNameComparator());
            for (int j = 0; j < notifInfo.length; ++j) {
                orderedInfo.add(notifInfo[j].getName());
                nameToNotifInf.put(notifInfo[j].getName(), notifInfo[j]);
            }
            Iterator iterInfo = orderedInfo.iterator();
            while (iterInfo.hasNext()) {
                MBeanNotificationInfo inf = (MBeanNotificationInfo)nameToNotifInf.get(iterInfo.next());
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\">" + inf.getDescription() + "</td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getName() + "</td>\n");
                String[] types = inf.getNotifTypes();
                if (types != null && types.length > 0) {
                    this.buf_.append("<td align=\"left\">");
                    for (int u = 0; u < types.length; ++u) {
                        this.buf_.append(types[u] + "<br>");
                    }
                    this.buf_.append("</td>");
                }
                this.buf_.append("</tr>\n");
            }
            this.buf_.append("</table><br><br><br>\n");
        }
        if (stats != null && (statistics = stats.getStatistics()) != null & statistics.length > 0) {
            this.buf_.append("<table border=\"3\" cellspacing=\"1\" cellpadding=\"1\">\n");
            this.buf_.append("<caption><H3>" + this.locHelper_.getLocalizedMessage("MBeanStatistics") + "</H3></caption>\n");
            this.buf_.append("<tr>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Name") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Description") + "</b></td>\n");
            this.buf_.append("<td align=\"left\"><b>" + this.locHelper_.getLocalizedMessage("Unit") + "</b></td>\n");
            this.buf_.append("</tr>\n");
            HashMap<String, Statistic> nameToStat = new HashMap<String, Statistic>();
            TreeSet<String> orderedInfo = new TreeSet<String>(new ObjectNameComparator());
            for (int j = 0; j < statistics.length; ++j) {
                orderedInfo.add(statistics[j].getName());
                nameToStat.put(statistics[j].getName(), statistics[j]);
            }
            Iterator iterInfo = orderedInfo.iterator();
            while (iterInfo.hasNext()) {
                Statistic inf = (Statistic)nameToStat.get(iterInfo.next());
                this.buf_.append("<tr>\n");
                this.buf_.append("<td align=\"left\">");
                this.buf_.append("<a href=\"" + this.domain_.toLowerCase());
                if (this.extraParam_ == null) {
                    this.buf_.append("?command=SHOWSTATISTIC&amp;statistic=" + inf.getName());
                } else {
                    this.buf_.append("?" + this.extraParam_ + "&amp;command=SHOWSTATISTIC&amp;statistic=" + inf.getName());
                }
                this.buf_.append("&amp;mbean=" + this.format(mbean) + "\">");
                this.buf_.append(inf.getName() + "</a></td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getDescription() + "</td>\n");
                this.buf_.append("<td align=\"left\">" + inf.getUnit() + "</td>\n");
                this.buf_.append("</tr>\n");
            }
            this.buf_.append("</table><br><br><br>\n");
        }
    }

    public void addStatistic(Statistic stat, String mbean) {
        this.buf_.append("<table border=\"3\" cellspacing=\"1\" cellpadding=\"1\">\n");
        this.buf_.append("<caption>" + stat.getDescription() + "</caption>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("StatName") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getName() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("Unit") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getUnit() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("MeasurementStartTime") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + new Date(stat.getStartTime()) + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("MeasurementLastSamplingTime") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + new Date(stat.getLastSampleTime()) + "</td>\n");
        this.buf_.append("</tr>\n");
        if (stat instanceof CountStatistic) {
            this.dealWithCountStatistic((CountStatistic)stat);
        }
        if (stat instanceof TimeStatistic) {
            this.dealWithTimeStatistic((TimeStatistic)stat);
        }
        if (stat instanceof RangeStatistic) {
            this.dealWithRangeStatistic((RangeStatistic)stat);
        }
        if (stat instanceof BoundaryStatistic) {
            this.dealWithBoundaryStatistic((BoundaryStatistic)stat);
        }
        this.buf_.append("</table>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWSTATISTIC\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"statistic\" value=\"" + stat.getName() + "\">\n");
        this.buf_.append("<pre>  ");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("Reload") + "\">\n");
        this.buf_.append("</pre>");
        this.buf_.append("</form>\n");
    }

    private void dealWithCountStatistic(CountStatistic stat) {
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("NumberOfOccurrence") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getCount() + "</td>\n");
        this.buf_.append("</tr>\n");
    }

    private void dealWithRangeStatistic(RangeStatistic stat) {
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("HighestValueHeld") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getHighWaterMark() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("LowestValueHeld") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getLowWaterMark() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("CurrentValue") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getCurrent() + "</td>\n");
        this.buf_.append("</tr>\n");
    }

    private void dealWithBoundaryStatistic(BoundaryStatistic stat) {
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("UpperLimitValue") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getUpperBound() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("LowerLimitValue") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getLowerBound() + "</td>\n");
        this.buf_.append("</tr>\n");
    }

    private void dealWithTimeStatistic(TimeStatistic stat) {
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("NumberOfOccurrence") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getCount() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("MaximumTimeForOccurrence") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getMaxTime() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("MinimumTimeForOccurrence") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getMinTime() + "</td>\n");
        this.buf_.append("</tr>\n");
        this.buf_.append("<tr>\n");
        this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("TotalTimeForAllOccurrence") + "</td>\n");
        this.buf_.append("<td align=\"left\">" + stat.getTotalTime() + "</td>\n");
        this.buf_.append("</tr>\n");
        if (stat.getCount() != 0L) {
            this.buf_.append("<tr>\n");
            this.buf_.append("<td align=\"left\">" + this.locHelper_.getLocalizedMessage("AverageTimePerOccurrence") + "</td>\n");
            this.buf_.append("<td align=\"left\">" + stat.getTotalTime() / stat.getCount() + "</td>\n");
            this.buf_.append("</tr>\n");
        }
    }

    public String getContent() {
        return this.buf_.toString();
    }

    public String buildMethodSignature(MBeanOperationInfo operInf) {
        StringBuffer res = new StringBuffer();
        res.append(operInf.getName());
        res.append("(");
        MBeanParameterInfo[] params = operInf.getSignature();
        for (int i = 0; i < params.length; ++i) {
            String tp = params[i].getType();
            String name = params[i].getName();
            if (tp.startsWith("java.lang.")) {
                tp = tp.substring(tp.lastIndexOf(".") + 1);
            }
            if (tp.startsWith("java.util.")) {
                tp = tp.substring(tp.lastIndexOf(".") + 1);
            }
            res.append(tp + " " + name);
            if (i == params.length - 1) continue;
            res.append(", ");
        }
        res.append(")");
        return res.toString();
    }

    private boolean canSetType(String type) {
        for (int i = 0; i < setableTypes_.length; ++i) {
            if (!type.equals(setableTypes_[i])) continue;
            return true;
        }
        return false;
    }

    private String format(String s) {
        StringBuffer res = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    res.append("&lt;");
                    continue block7;
                }
                case '>': {
                    res.append("&gt;");
                    continue block7;
                }
                case '&': {
                    res.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    res.append("&quot;");
                    continue block7;
                }
                case '@': {
                    res.append("&copy;");
                    continue block7;
                }
                default: {
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    private String formatObjectName(ObjectName o) {
        String name = this.format(o.toString());
        return this.formatObjectName(name);
    }

    private String formatObjectName(String name) {
        String res = null;
        res = this.extraParam_ == null ? "<a href=\"" + this.domain_.toLowerCase() + "?command=SHOWMBEAN&amp;mbean=" + name + "\">" + name + "</a>" : "<a href=\"" + this.domain_.toLowerCase() + "?" + this.extraParam_ + "&amp;command=SHOWMBEAN&amp;mbean=" + name + "\">" + name + "</a>";
        return res;
    }

    private String print(Collection c, String indent) {
        StringBuffer buf = new StringBuffer();
        String name = c.getClass().getName();
        String name1 = name.substring(name.lastIndexOf(".") + 1, name.length()) + ": ";
        buf.append(indent + name1);
        int len = name1.length();
        while (len-- != 0) {
            indent = indent + " ";
        }
        indent = indent + " ";
        Iterator iterator = c.iterator();
        buf.append("[\n");
        int maxIndex = c.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object element = iterator.next();
            if (element instanceof Map) {
                buf.append(String.valueOf(this.print((Map)element, indent)));
            } else if (element instanceof Set) {
                String eName = element.getClass().getName();
                String elementName = eName.substring(eName.lastIndexOf(".") + 1, eName.length()) + ": ";
                buf.append(indent + elementName + String.valueOf(element));
            } else if (element instanceof Collection) {
                buf.append(this.print((Collection)element, indent));
            } else if (element instanceof CompositeData) {
                buf.append(this.print((CompositeData)element, indent));
            } else if (element.getClass().isArray()) {
                buf.append(this.print(element, indent, false));
            } else {
                buf.append(String.valueOf(indent + element));
            }
            if (i >= maxIndex) continue;
            buf.append(",\n");
        }
        buf.append("\n" + indent.substring(0, indent.length() - 1) + "]");
        return buf.toString();
    }

    private String print(Map m, String indent) {
        StringBuffer buf = new StringBuffer();
        String name = m.getClass().getName();
        String name1 = name.substring(name.lastIndexOf(".") + 1, name.length()) + ": ";
        buf.append(indent + name1);
        int len = name1.length();
        while (len-- != 0) {
            indent = indent + " ";
        }
        indent = indent + " ";
        Iterator iterator = m.entrySet().iterator();
        buf.append("{\n");
        int maxIndex = m.size() - 1;
        for (int j = 0; j <= maxIndex; ++j) {
            Map.Entry e = iterator.next();
            buf.append(indent + e.getKey() + " = " + e.getValue());
            if (j >= maxIndex) continue;
            buf.append(", \n");
        }
        buf.append("\n" + indent.substring(0, indent.length() - 1) + "}");
        return buf.toString();
    }

    private String print(CompositeData cd, String indent) {
        StringBuffer buf = new StringBuffer();
        String name = cd.getClass().getName();
        buf.append(indent + name);
        buf.append("\n");
        buf.toString();
        TreeMap<String, Object> contents = new TreeMap<String, Object>();
        CompositeType types = cd.getCompositeType();
        Set<String> keyNames = types.keySet();
        Iterator<String> nameIterator = keyNames.iterator();
        while (nameIterator.hasNext()) {
            String keyName = nameIterator.next();
            contents.put(keyName, cd.get(keyName));
        }
        return this.print(contents, indent);
    }

    private String print(TabularData td, String indent) {
        StringBuffer buf = new StringBuffer();
        String name = td.getClass().getName();
        buf.append(indent + name);
        buf.append("\n");
        buf.toString();
        Collection<?> collection = td.values();
        return this.print(collection, indent);
    }

    private String print(Object o, String indent, boolean isObjectName) {
        StringBuffer buf = new StringBuffer();
        int length = Array.getLength(o);
        boolean isPrimitiveType = false;
        indent = indent + "  ";
        buf.append("\n" + indent + "{");
        indent = indent + " ";
        for (int i = 0; i < length; ++i) {
            if (o.getClass().getComponentType().isArray()) {
                buf.append(this.print(Array.get(o, i), indent, isObjectName));
                continue;
            }
            Object newO = Array.get(o, i);
            if (newO instanceof Collection) {
                buf.append("\n" + this.print((Collection)newO, indent));
                if (i < length - 1) {
                    buf.append(",\n");
                    continue;
                }
                buf.append("\n");
                continue;
            }
            isPrimitiveType = this.isPrimitive(newO);
            if (isPrimitiveType) {
                buf.append(Array.get(o, i));
                if (i >= length - 1) continue;
                buf.append(",");
                continue;
            }
            if (newO.getClass().isArray()) {
                buf.append(this.print(newO, indent, isObjectName));
            } else {
                String element = null;
                element = isObjectName ? this.formatObjectName((ObjectName)Array.get(o, i)) : Array.get(o, i).toString();
                if (i == 0) {
                    buf.append("\n" + indent + element);
                } else {
                    buf.append(indent + element);
                }
            }
            if (i < length - 1) {
                buf.append(",\n");
                continue;
            }
            buf.append("\n");
        }
        indent = indent.substring(1);
        if (isPrimitiveType) {
            buf.append("}\n");
        } else {
            buf.append(indent + "}\n");
        }
        return buf.toString();
    }

    private boolean isPrimitive(Object object) {
        if (object instanceof Boolean) {
            return true;
        }
        if (object instanceof Short) {
            return true;
        }
        if (object instanceof Byte) {
            return true;
        }
        if (object instanceof Character) {
            return true;
        }
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof Float) {
            return true;
        }
        if (object instanceof Class) {
            return true;
        }
        if (object instanceof Long) {
            return true;
        }
        return object instanceof Double;
    }

    public void addInputArrayForm(String mbeanName, MBeanOperationInfo theOper, int pageNum, int elemNum, String pageVector, int paramNum, String paramVector, int paramcnt) {
        String methodSign = this.buildMethodSignature(theOper);
        this.buf_.append("<h3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("SetValueForEachElement") + "\n");
        this.buf_.append("</h3>\n");
        this.buf_.append("<form  action=\"" + this.domain_.toLowerCase() + "\" method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INPUTARRAY\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"operation\" value=\"" + methodSign + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageNum\" value=\"" + pageNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"elemNum\" value=\"" + elemNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageVector\" value=\"" + pageVector + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramNum\" value=\"" + paramNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramVector\" value=\"" + paramVector + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramCount\" value=\"" + paramcnt + "\">\n");
        MBeanParameterInfo[] params = theOper.getSignature();
        this.buf_.append("<PRE>\n");
        this.buf_.append("<STRONG>" + this.locHelper_.getLocalizedMessage("Parameter") + (paramNum + 1) + ": </STRONG>\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Name") + "        : </FONT>" + params[paramNum].getName() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + params[paramNum].getDescription() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + params[paramNum].getType() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("\n");
        if (!params[paramNum].getType().startsWith("[L") || !params[paramNum].getType().endsWith(";")) {
            this.buf_.append(this.locHelper_.getLocalizedMessage("SelectTypeOfElementsOf") + " " + params[paramNum].getType() + ": \n");
            this.buf_.append("              <select name=\"typeOfCollection\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
            this.buf_.append("\n");
        }
        Vector thePageVector = null;
        Vector thePage = null;
        try {
            thePageVector = (Vector)JMXUtil.deserialize(pageVector);
            if (pageNum < thePageVector.size()) {
                thePage = (Vector)thePageVector.elementAt(pageNum);
            }
        }
        catch (HandlingException e) {
            // empty catch block
        }
        int i = elemNum - 10;
        int j = 0;
        while (i < elemNum) {
            this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
            if (thePage != null && j < thePage.size()) {
                this.buf_.append("<input type=\"text\" name=\"param[" + i + "]\" value=\"" + thePage.elementAt(j) + "\"><br>\n");
            } else {
                this.buf_.append("<input type=\"text\" name=\"param[" + i + "]\"><br>\n");
            }
            ++i;
            ++j;
        }
        this.buf_.append("</PRE>\n");
        if (pageNum != 0) {
            this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Pre") + "\">        ");
        }
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Next") + "\">        ");
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Done") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addInputMapForm(String mbeanName, MBeanOperationInfo theOper, int pageNum, int elemNum, String pageVector, int paramNum, String paramVector, int paramcnt) {
        String methodSign = this.buildMethodSignature(theOper);
        this.buf_.append("<h3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("SetValueForEachElement") + "\n");
        this.buf_.append("</h3>\n");
        this.buf_.append("<form  action=\"" + this.domain_.toLowerCase() + "\" method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INPUTMAP\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"operation\" value=\"" + methodSign + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageNum\" value=\"" + pageNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"elemNum\" value=\"" + elemNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageVector\" value=\"" + pageVector + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramNum\" value=\"" + paramNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramVector\" value=\"" + paramVector + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramCount\" value=\"" + paramcnt + "\">\n");
        MBeanParameterInfo[] params = theOper.getSignature();
        this.buf_.append("<PRE>\n");
        this.buf_.append("<STRONG>" + this.locHelper_.getLocalizedMessage("Parameter") + (paramNum + 1) + ": </STRONG>\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Name") + "        : </FONT>" + params[paramNum].getName() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + params[paramNum].getDescription() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + params[paramNum].getType() + "\n");
        this.buf_.append("<br>");
        this.buf_.append("\n");
        this.buf_.append("                " + this.locHelper_.getLocalizedMessage("TypeOfKeys") + "               " + this.locHelper_.getLocalizedMessage("TypeOfValues") + " \n");
        if (params[paramNum].getType().equals("java.util.Properties")) {
            this.buf_.append("               <select name=\"typeOfEntryKey\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("             ");
            this.buf_.append("<select name=\"typeOfEntryValue\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
        } else {
            this.buf_.append("               <select name=\"typeOfEntryKey\"");
            this.buf_.append("<br>");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("             ");
            this.buf_.append("<select name=\"typeOfEntryValue\"");
            this.buf_.append("<br>");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
        }
        this.buf_.append("\n");
        this.buf_.append("<STRONG><FONT color=#996633 size=+1>                  " + this.locHelper_.getLocalizedMessage("EntryKey") + "                  " + this.locHelper_.getLocalizedMessage("EntryValue") + " </FONT></STRONG><br><br>\n");
        Vector thePageVector = null;
        HashMap thePage = null;
        try {
            thePageVector = (Vector)JMXUtil.deserialize(pageVector);
            if (pageNum < thePageVector.size()) {
                thePage = (HashMap)thePageVector.elementAt(pageNum);
            }
        }
        catch (HandlingException e) {
            // empty catch block
        }
        if (thePage != null) {
            Set keySet = thePage.keySet();
            Iterator iterator = keySet.iterator();
            for (int i = elemNum - 10; i < elemNum; ++i) {
                this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
                if (iterator.hasNext()) {
                    Object tmpKey = iterator.next();
                    Object tmpValue = thePage.get(tmpKey);
                    this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\" value=\"" + tmpKey + "\">");
                    this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                    this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\" value=\"" + tmpValue + "\"><br><br>\n");
                    continue;
                }
                this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\">");
                this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\"><br><br>\n");
            }
        } else {
            for (int i = elemNum - 10; i < elemNum; ++i) {
                this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\">");
                this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\"><br><br>\n");
            }
        }
        this.buf_.append("</PRE>\n");
        if (pageNum != 0) {
            this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Pre") + "\">        ");
        }
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Next") + "\">        ");
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Done") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addInputCompositeDataForm(String mbeanName, MBeanOperationInfo theOper, int pageNum, int elemNum, String compositeStoreStr, String compositePosStr, int paramNum, String paramVector, int paramcnt, boolean dumpData) {
        int i;
        String methodSign = this.buildMethodSignature(theOper);
        this.buf_.append("<h3>\n").append(this.locHelper_.getLocalizedMessage("SetValueForEachElement") + "\n").append("</h3>\n").append("<form  action=\"" + this.domain_.toLowerCase() + "\" method=post>\n").append("<input type=\"hidden\" name=\"command\" ").append("value=\"INPUTCOMPOSITEDATA\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"").append(this.format(mbeanName)).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"operation\" value=\"").append(methodSign).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageNum\" value=\"").append(pageNum).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"elemNum\" value=\"").append(elemNum).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"compositeStore\" value=\"").append(compositeStoreStr).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"compositePos\" value=\"").append(compositePosStr).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramNum\" value=\"").append(paramNum).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramVector\" value=\"").append(paramVector).append("\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramCount\" value=\"").append(paramcnt).append("\">\n");
        MBeanParameterInfo[] params = theOper.getSignature();
        CompositeDataItem[] compositeStore = null;
        Vector compositePos = null;
        try {
            compositeStore = (CompositeDataItem[])JMXUtil.deserialize(compositeStoreStr);
            compositePos = (Vector)JMXUtil.deserialize(compositePosStr);
        }
        catch (HandlingException e) {
            this.buf_.append("\n<br><br>" + e);
            return;
        }
        this.buf_.append("<PRE>\n");
        this.buf_.append("<STRONG>").append(this.locHelper_.getLocalizedMessage("Parameter")).append(paramNum + 1).append(": </STRONG>\n");
        this.buf_.append("<FONT color=#996633>").append(this.locHelper_.getLocalizedMessage("Name")).append("        : </FONT>").append(params[paramNum].getName()).append("\n");
        this.buf_.append("<br><FONT color=#996633>").append(this.locHelper_.getLocalizedMessage("Description")).append(" : </FONT>").append(params[paramNum].getDescription()).append("\n");
        this.buf_.append("<br><FONT color=#996633>").append(this.locHelper_.getLocalizedMessage("Type")).append("        : </FONT>").append(params[paramNum].getType()).append("\n");
        this.buf_.append("<br><FONT color=#996633>").append(this.locHelper_.getLocalizedMessage("CompositeDataPath")).append(" : </FONT>").append(compositePos.isEmpty() ? "Top" : compositePos.toString()).append("\n");
        this.buf_.append("<br>\n");
        this.buf_.append("<STRONG><FONT color=#996633 size=+1>              ").append(this.locHelper_.getLocalizedMessage("ItemName")).append("     ").append(this.locHelper_.getLocalizedMessage("Type")).append("         ").append(this.locHelper_.getLocalizedMessage("Value")).append("                 ").append(this.locHelper_.getLocalizedMessage("Description")).append(" </FONT></STRONG><br><br>\n");
        CompositeDataItem[] current = compositeStore;
        for (i = 0; i < compositePos.size(); ++i) {
            int posIndex = (Integer)compositePos.get(i);
            current = (CompositeDataItem[])current[posIndex].getValue();
        }
        if (current == null || current.length < elemNum) {
            this.buf_.append("\n<br><br> couldn't locate position: " + compositePos).append("\n<br>composite data: \n").append(CompositeDataItem.toString(compositeStore));
            return;
        }
        for (i = elemNum - 10; i < elemNum; ++i) {
            this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + i + " : </FONT>");
            CompositeDataItem item = current[i];
            if (item != null) {
                this.buf_.append("<input type=\"text\" name=\"entryKey" + i + "\" value=\"" + (item.getName() == null ? "" : item.getName()) + "\">");
                this.buf_.append(" <select name=\"entryType" + i + "\">").append("<option ").append(item.getType().endsWith("String") ? "selected " : "").append("value=\"java.lang.String\">String").append("<option ").append(item.getType().endsWith("CompositeData") ? "selected " : "").append("value=\"javax.management.openmbean.CompositeData\">CompositeData").append("</select>");
                Object tmpValue = item.getType().endsWith("CompositeData") ? null : item.getValue();
                this.buf_.append(" <input type=\"text\" name=\"entryValue" + i + "\" " + "value=\"" + (tmpValue == null ? "" : tmpValue) + "\">");
                this.buf_.append(" <input type=\"submit\" name=\"SubmitAction" + i + "\" ").append("value=\"Input Composite\">");
                this.buf_.append(" <input type=\"text\" name=\"entryDesc" + i + "\" value=\"" + (item.getDesc() == null ? "" : item.getDesc()) + "\">");
                this.buf_.append("<br><br>\n");
                continue;
            }
            this.buf_.append("<input type=\"text\" name=\"entryKey" + i + "\" value=\"\">");
            this.buf_.append(" <select name=\"entryType" + i + "\">").append("<option selected value=\"java.lang.String\">String").append("<option value=\"javax.management.openmbean.CompositeData\">CompositeData").append("</select>");
            this.buf_.append(" <input type=\"text\" name=\"entryValue" + i + "\" value=\"\">");
            this.buf_.append(" <input type=\"submit\" name=\"SubmitAction" + i + "\" value=\"Input Composite\">");
            this.buf_.append(" <input type=\"text\" name=\"entryDesc" + i + "\" value=\"\">");
            this.buf_.append("<br>\n");
        }
        this.buf_.append("</PRE>\n");
        this.buf_.append("<input type=\"checkbox\" name=\"dumpData\" value=\"true\"").append(dumpData ? " CHECKED" : "").append(">").append(this.locHelper_.getLocalizedMessage("DumpData")).append(" &nbsp;&nbsp;&nbsp;");
        if (pageNum != 0) {
            this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Pre") + "\">        ");
        }
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Next") + "\">        ");
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Done") + "\">\n");
        this.buf_.append("</form>\n");
        if (dumpData) {
            this.buf_.append("<FONT color=#996633 size=+1>").append(this.locHelper_.getLocalizedMessage("CompositeDataDump")).append(": </FONT>").append("\n<pre>\n").append(this.format(CompositeDataItem.toStringWithIndex(compositeStore))).append("</pre><br>\n");
        }
    }

    public void addOperationWithComplexParamsInfo(String mbeanName, MBeanOperationInfo theOper, int paramNum, Vector paramVector) {
        String type;
        String methodSign = this.buildMethodSignature(theOper);
        this.buf_.append("<H3>\n");
        this.buf_.append(methodSign);
        this.buf_.append("</H3>\n");
        this.buf_.append("<PRE>\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + "   : </FONT>" + theOper.getDescription() + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "         : </FONT>" + mbeanName + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("ReturnType") + "   : </FONT>" + theOper.getReturnType() + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MethodImpact") + " : </FONT>" + methodImpact_[theOper.getImpact()] + "\n");
        this.buf_.append("</PRE>\n");
        this.buf_.append("<form action=\"" + this.domain_.toLowerCase() + "\" method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INVOKEOPERATION\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"operation\" value=\"" + methodSign + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"paramVector\" value=\"" + paramVector + "\">\n");
        MBeanParameterInfo[] params = theOper.getSignature();
        this.buf_.append("<input type=\"hidden\" name=\"paramCount\" value=\"" + params.length + "\">\n");
        boolean canInvoke = true;
        for (int i = 0; i < params.length; ++i) {
            type = params[i].getType();
            canInvoke &= this.canSetType(type);
        }
        if (canInvoke) {
            if (params.length != 0) {
                this.buf_.append("\n<H3> " + this.locHelper_.getLocalizedMessage("SetUpParameter") + ": </H3>\n");
            }
            this.buf_.append("<PRE>\n");
            for (int j = 0; j < params.length; ++j) {
                type = params[j].getType();
                String description = params[j].getDescription();
                String name = params[j].getName();
                int i = j + 1;
                this.buf_.append("<STRONG>" + this.locHelper_.getLocalizedMessage("Parameter") + i + ": </STRONG>\n");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Name") + "        : </FONT>" + name + "\n");
                this.buf_.append("<br>");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + description + "\n");
                this.buf_.append("<br>");
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + type + "\n");
                this.buf_.append("<br>");
                if (type.startsWith("[L") && type.endsWith(";")) {
                    this.showComplexType(paramVector, j, this.locHelper_.getLocalizedMessage("InputValues"));
                    continue;
                }
                if (type.startsWith("java.util") && (type.lastIndexOf("List") != -1 || type.equals("java.util.Vector") || type.lastIndexOf("Set") != -1)) {
                    this.showComplexType(paramVector, j, this.locHelper_.getLocalizedMessage("InputValues"));
                    continue;
                }
                if (type.startsWith("java.util") && (type.lastIndexOf("Map") != -1 || type.equals("java.util.Properties") || type.lastIndexOf("Hash") != -1)) {
                    this.showComplexType(paramVector, j, this.locHelper_.getLocalizedMessage("InputValuesForMap"));
                    continue;
                }
                if (type.endsWith("CompositeData")) {
                    this.showComplexType(paramVector, j, this.locHelper_.getLocalizedMessage("InputValuesForCompositeData"));
                    continue;
                }
                this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("ValueToSet") + ": </FONT> <input " + "type=\"text\" name=\"param" + j + "\" size=\"60\" value=\"" + String.valueOf(paramVector.elementAt(j)) + "\">\n\n");
            }
            this.buf_.append("</PRE>\n");
            this.buf_.append("<br>");
            this.buf_.append("<br>");
            this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InvokeMethod") + "\">\n");
        } else {
            this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("CannotInvokeMethod") + "</FONT>\n");
        }
        this.buf_.append("</form>\n");
    }

    private void showComplexType(Vector paramVector, int paramIdx, String submitText) {
        Object plainParam = null;
        try {
            plainParam = JMXUtil.deserialize(paramVector.elementAt(paramIdx).toString());
        }
        catch (HandlingException e) {
            plainParam = paramVector.elementAt(paramIdx);
        }
        if (!plainParam.toString().equals("complex type")) {
            this.buf_.append("<input type=\"hidden\" name=\"param" + paramIdx + "\"size=\"60\"  value=\"" + paramVector.elementAt(paramIdx) + "\">\n");
            if (plainParam instanceof CompositeDataItem[]) {
                this.buf_.append("<textarea name=\"textParam" + paramIdx + "\" cols=70 rows=4 readonly>" + CompositeDataItem.toStringWithIndex((CompositeDataItem[])plainParam) + "</textarea>\n");
            } else {
                this.buf_.append("<textarea name=\"textParam" + paramIdx + "\" cols=56 rows=4 readonly>" + plainParam.toString() + "</textarea>\n");
            }
        } else {
            this.buf_.append("<input type=\"hidden\" name=\"param" + paramIdx + "\" value=\"complex type\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"paramNum\" value=\"" + (paramIdx + 1) + "\">\n");
        this.buf_.append("<input type=\"submit\" name=\"submitAction" + paramIdx + "\" value=\"" + submitText + "\">\n");
    }

    public void addInputArrayFormForAttribute(String mbeanName, MBeanAttributeInfo theAttrib, int pageNum, int elemNum, String pageVector) {
        this.buf_.append("<h3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("SetValueForEachElement") + "\n");
        this.buf_.append("</h3>\n");
        this.buf_.append("<form  action=\"" + this.domain_.toLowerCase() + "\" method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INPUTARRAYFORATTRIBUTE\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageNum\" value=\"" + pageNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"elemNum\" value=\"" + elemNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageVector\" value=\"" + pageVector + "\">\n");
        this.buf_.append("<PRE>\n");
        this.buf_.append("<H3>" + theAttrib.getName() + "</H3>\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + theAttrib.getDescription() + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "       : </FONT>" + mbeanName + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + theAttrib.getType() + "\n");
        this.buf_.append("<br>");
        if (theAttrib.isReadable() && theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read/Write\n");
        } else if (theAttrib.isReadable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read Only\n");
        } else if (theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Write Only\n");
        }
        this.buf_.append("\n");
        if (!theAttrib.getType().startsWith("[L") || !theAttrib.getType().endsWith(";")) {
            this.buf_.append(this.locHelper_.getLocalizedMessage("SelectTypeOfElementsOf") + " " + theAttrib.getType() + ": \n");
            this.buf_.append("              <select name=\"typeOfCollection\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
            this.buf_.append("\n");
        }
        Vector thePageVector = null;
        Vector thePage = null;
        try {
            thePageVector = (Vector)JMXUtil.deserialize(pageVector);
            if (pageNum < thePageVector.size()) {
                thePage = (Vector)thePageVector.elementAt(pageNum);
            }
        }
        catch (HandlingException e) {
            // empty catch block
        }
        int i = elemNum - 10;
        int j = 0;
        while (i < elemNum) {
            this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
            if (thePage != null && j < thePage.size()) {
                this.buf_.append("<input type=\"text\" name=\"param[" + i + "]\" value=\"" + thePage.elementAt(j) + "\"><br>\n");
            } else {
                this.buf_.append("<input type=\"text\" name=\"param[" + i + "]\"><br>\n");
            }
            ++i;
            ++j;
        }
        this.buf_.append("</PRE>\n");
        if (pageNum != 0) {
            this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Pre") + "\">        ");
        }
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Next") + "\">        ");
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Done") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addInputMapFormForAttribute(String mbeanName, MBeanAttributeInfo theAttrib, int pageNum, int elemNum, String pageVector) {
        this.buf_.append("<h3>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("SetValueForEachElement") + "\n");
        this.buf_.append("</h3>\n");
        this.buf_.append("<form  action=\"" + this.domain_.toLowerCase() + "\" method=post>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"INPUTMAPFORATTRIBUTE\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbeanName) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageNum\" value=\"" + pageNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"elemNum\" value=\"" + elemNum + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"pageVector\" value=\"" + pageVector + "\">\n");
        this.buf_.append("<PRE>\n");
        this.buf_.append("<H3>" + theAttrib.getName() + "</H3>\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + theAttrib.getDescription() + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "       : </FONT>" + mbeanName + "\n");
        this.buf_.append("<br>");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + theAttrib.getType() + "\n");
        this.buf_.append("<br>");
        if (theAttrib.isReadable() && theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read/Write\n");
        } else if (theAttrib.isReadable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read Only\n");
        } else if (theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Write Only\n");
        }
        this.buf_.append("<br>");
        this.buf_.append("\n");
        this.buf_.append("                " + this.locHelper_.getLocalizedMessage("TypeOfKeys") + "               " + this.locHelper_.getLocalizedMessage("TypeOfValues") + " \n");
        if (theAttrib.getType().equals("java.util.Properties")) {
            this.buf_.append("               <select name=\"typeOfEntryKey\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("             ");
            this.buf_.append("<select name=\"typeOfEntryValue\"");
            this.buf_.append("<br>");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
        } else {
            this.buf_.append("               <select name=\"typeOfEntryKey\"");
            this.buf_.append("<br>");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("             ");
            this.buf_.append("<select name=\"typeOfEntryValue\"");
            this.buf_.append("<br>");
            this.buf_.append("<option value=\"java.lang.Boolean\">java.lang.Boolean");
            this.buf_.append("<option value=\"java.lang.Byte\">java.lang.Byte");
            this.buf_.append("<option value=\"java.lang.Charactor\">java.lang.Charactor");
            this.buf_.append("<option value=\"java.lang.Double\">java.lang.Double");
            this.buf_.append("<option value=\"java.lang.Float\">java.lang.Float");
            this.buf_.append("<option value=\"java.lang.Integer\">java.lang.Integer");
            this.buf_.append("<option value=\"java.lang.Long\">java.lang.Long");
            this.buf_.append("<option value=\"java.lang.Short\">java.lang.Short");
            this.buf_.append("<option selected value=\"java.lang.String\">java.lang.String");
            this.buf_.append("</select>");
            this.buf_.append("<br>");
        }
        this.buf_.append("\n");
        this.buf_.append("<STRONG><FONT color=#996633 size=+1>                  " + this.locHelper_.getLocalizedMessage("EntryKey") + "                  " + this.locHelper_.getLocalizedMessage("EntryValue") + " </FONT></STRONG><br><br>\n");
        Vector thePageVector = null;
        HashMap thePage = null;
        try {
            thePageVector = (Vector)JMXUtil.deserialize(pageVector);
            if (pageNum < thePageVector.size()) {
                thePage = (HashMap)thePageVector.elementAt(pageNum);
            }
        }
        catch (HandlingException e) {
            // empty catch block
        }
        if (thePage != null) {
            Set keySet = thePage.keySet();
            Iterator iterator = keySet.iterator();
            for (int i = elemNum - 10; i < elemNum; ++i) {
                this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
                if (iterator.hasNext()) {
                    Object tmpKey = iterator.next();
                    Object tmpValue = thePage.get(tmpKey);
                    this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\" value=\"" + tmpKey + "\">");
                    this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                    this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\" value=\"" + tmpValue + "\"><br><br>\n");
                    continue;
                }
                this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\">");
                this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\"><br><br>\n");
            }
        } else {
            for (int i = elemNum - 10; i < elemNum; ++i) {
                this.buf_.append("<FONT color=#996633 size=+1>" + this.locHelper_.getLocalizedMessage("Element") + " " + (i + 1) + "   : </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryKey[" + i + "]\">");
                this.buf_.append("<FONT color=#996633 size=+1>      =     </FONT>");
                this.buf_.append("<input type=\"text\" name=\"entryValue[" + i + "]\"><br><br>\n");
            }
        }
        this.buf_.append("</PRE>\n");
        if (pageNum != 0) {
            this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Pre") + "\">        ");
        }
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Next") + "\">        ");
        this.buf_.append("<input type=\"submit\" name=\"SubmitAction\" value=\"" + this.locHelper_.getLocalizedMessage("Done") + "\">\n");
        this.buf_.append("</form>\n");
    }

    public void addAttributeWithComplexTypeInfo(MBeanAttributeInfo theAttrib, String mbean, String theValue, boolean retrieved) {
        this.buf_.append("<H3>\n");
        this.buf_.append(theAttrib.getName());
        this.buf_.append("</H3>\n");
        this.buf_.append("<PRE>\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Description") + " : </FONT>" + theAttrib.getDescription() + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("MBean") + "       : </FONT>" + mbean + "\n");
        this.buf_.append("<FONT color=#996633>" + this.locHelper_.getLocalizedMessage("Type") + "        : </FONT>" + theAttrib.getType() + "\n");
        if (theAttrib.isReadable() && theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read/Write\n");
        } else if (theAttrib.isReadable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Read Only\n");
        } else if (theAttrib.isWritable()) {
            this.buf_.append("<FONT color=#996633>Access      : </FONT>Write Only\n");
        }
        this.buf_.append("</PRE>\n");
        this.buf_.append("<fieldset>\n");
        this.buf_.append("<legend>\n");
        this.buf_.append(this.locHelper_.getLocalizedMessage("Value"));
        this.buf_.append("</legend>\n");
        this.buf_.append("<form>\n");
        this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SHOWATTRIBUTE\">\n");
        if (this.extraParam_ != null) {
            this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
        }
        this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
        this.buf_.append("<input type=\"hidden\" name=\"getvalue\" value=\"y\">\n");
        this.buf_.append("<pre>  ");
        this.buf_.append("<input type=\"submit\" value=\"" + this.locHelper_.getLocalizedMessage("GetValue") + "\">\n");
        this.buf_.append("</pre>");
        this.buf_.append("</form>\n");
        this.buf_.append("</fieldset>\n");
        Object value = new Object();
        try {
            value = JMXUtil.deserialize(theValue);
        }
        catch (HandlingException e) {
            value = theValue;
        }
        if (theAttrib.isWritable() && this.canSetType(theAttrib.getType())) {
            this.buf_.append("<fieldset>\n");
            this.buf_.append("<legend>\n");
            this.buf_.append(this.locHelper_.getLocalizedMessage("SetTo"));
            this.buf_.append("</legend>\n");
            this.buf_.append("<form>\n");
            this.buf_.append("<input type=\"hidden\" name=\"command\" value=\"SETATTRIBUTE\">\n");
            if (this.extraParam_ != null) {
                this.buf_.append("<input type=\"hidden\" name=\"" + this.extraParamName_ + "\" value=\"" + this.extraParamValue_ + "\">\n");
            }
            this.buf_.append("<input type=\"hidden\" name=\"mbean\" value=\"" + this.format(mbean) + "\">\n");
            this.buf_.append("<input type=\"hidden\" name=\"getvalue\" value=\"y\">\n");
            this.buf_.append("<input type=\"hidden\" name=\"attribute\" value=\"" + theAttrib.getName() + "\">\n");
            this.buf_.append("<pre>  ");
            this.buf_.append("<pre>");
            if (value != null) {
                if (value instanceof Collection) {
                    this.buf_.append("\n");
                    this.buf_.append(this.print((Collection)value, " "));
                } else if (value instanceof Map) {
                    this.buf_.append("\n");
                    this.buf_.append(this.print((Map)value, " "));
                } else if (value.getClass().isArray()) {
                    this.buf_.append(this.print(value, "", false));
                }
            } else if (retrieved) {
                this.buf_.append("Null");
            } else {
                this.buf_.append(this.locHelper_.getLocalizedMessage("NotRetrieved"));
            }
            this.buf_.append("</pre>");
            String type = theAttrib.getType();
            if (type.startsWith("[L") && type.endsWith(";") || type.startsWith("java.util") && (type.lastIndexOf("List") != -1 || type.equals("java.util.Vector") || type.lastIndexOf("Set") != -1)) {
                this.buf_.append("\n");
                this.buf_.append("<input type=\"hidden\" name=\"value\" value=\"" + theValue + "\">\n");
                this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InputValues") + "\">\n");
                this.buf_.append("\n");
            } else if (type.startsWith("java.util") && (type.lastIndexOf("Map") != -1 || type.equals("java.util.Properties") || type.lastIndexOf("Hash") != -1)) {
                this.buf_.append("\n");
                this.buf_.append("<input type=\"hidden\" name=\"value\" value=\"" + theValue + "\">\n");
                this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("InputValuesForMap") + "\">\n");
                this.buf_.append("\n");
            } else {
                this.buf_.append("<input type=\"text\" name=\"value\" size=\"20\">\n");
            }
            this.buf_.append("<input type=\"submit\" name=\"submitAction\" value=\"" + this.locHelper_.getLocalizedMessage("SetValue") + "\">\n");
            this.buf_.append("</pre>");
            this.buf_.append("</form>\n");
            this.buf_.append("</fieldset>\n");
        }
    }

    private static String getTypeName(String typeInfo) {
        String result = typeInfo;
        int arrayDimensions = 0;
        while (result.startsWith("[")) {
            result = result.substring(1);
            ++arrayDimensions;
        }
        boolean object = result.startsWith("L");
        if (object) {
            result = result.substring(1);
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.length() == 1) {
            char c = result.charAt(0);
            switch (c) {
                case 'B': {
                    result = "byte";
                    break;
                }
                case 'C': {
                    result = "char";
                    break;
                }
                case 'D': {
                    result = "double";
                    break;
                }
                case 'F': {
                    result = "float";
                    break;
                }
                case 'I': {
                    result = "int";
                    break;
                }
                case 'J': {
                    result = "long";
                    break;
                }
                case 'S': {
                    result = "short";
                    break;
                }
                case 'Z': {
                    result = "boolean";
                }
            }
        }
        while (arrayDimensions > 0) {
            result = result + "[]";
            --arrayDimensions;
        }
        return result;
    }

    class ObjectNameComparator
    implements Comparator {
        ObjectNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectNameComparator;
        }
    }
}

