/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.web;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletLocalizationHelper {
    private ResourceBundle resourceBundle_ = null;
    private HttpServletResponse resp_ = null;
    private Locale loc_ = null;
    private static Map map = null;

    public ServletLocalizationHelper(String bundleLocation, HttpServletRequest req, HttpServletResponse res) throws MissingResourceException {
        this.resp_ = res;
        this.loc_ = Locale.getDefault();
        String acceptLanguage = req.getHeader("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = this.loc_.getLanguage();
        }
        this.resourceBundle_ = this.getResourceBundleForAcceptLanguage(bundleLocation, acceptLanguage);
        String charset = "UTF-8";
        if (charset != null) {
            res.setContentType("text/html; charset=" + charset);
            res.setHeader("Vary", "Accept-Language");
        } else {
            res.setContentType("text/html");
        }
        res.setHeader("Content-Language", this.loc_.getLanguage());
    }

    public ServletLocalizationHelper(String bundleLocation, Locale loc) {
        this.loc_ = loc;
        this.resourceBundle_ = ResourceBundle.getBundle(bundleLocation, loc);
    }

    public Locale getLocale() {
        return this.loc_;
    }

    private ResourceBundle getResourceBundleForAcceptLanguage(String bundleLocation, String acceptLanguage) throws MissingResourceException {
        ResourceBundle def;
        ResourceBundle bundle = def = ResourceBundle.getBundle(bundleLocation, new Locale("dumy", ""));
        this.loc_ = Locale.getDefault();
        StringTokenizer tok = new StringTokenizer(acceptLanguage, ",");
        while (tok.hasMoreTokens()) {
            String lang = tok.nextToken();
            int qvalue = lang.indexOf(59);
            if (qvalue != -1) {
                lang = lang.substring(0, qvalue);
            }
            lang = lang.trim();
            Locale loc = null;
            int country = lang.indexOf(45);
            loc = country == -1 ? new Locale(lang, "") : new Locale(lang.substring(0, country), lang.substring(country + 1));
            try {
                bundle = ResourceBundle.getBundle(bundleLocation, loc);
                if (this.getCharset(loc) != null) {
                    if (bundle != def) {
                        this.loc_ = loc;
                        break;
                    }
                    if (!loc.getLanguage().equals(Locale.getDefault().getLanguage())) continue;
                    this.loc_ = loc;
                    break;
                }
                bundle = def;
            }
            catch (MissingResourceException e) {}
        }
        return bundle;
    }

    private String getCharset(Locale loc) {
        String charset = (String)map.get(loc.toString());
        if (charset != null) {
            return charset;
        }
        return (String)map.get(loc.getLanguage());
    }

    public String getLocalizedMessage(String name) {
        return this.resourceBundle_.getString(name);
    }

    public String getLocalizedMessage(String name, String param) {
        String[] params = new String[]{param};
        return this.getLocalizedMessage(name, params);
    }

    public String getLocalizedMessage(String name, String param1, String param2) {
        String[] params = new String[]{param1, param2};
        return this.getLocalizedMessage(name, params);
    }

    public String getLocalizedMessage(String name, String[] params) {
        String message = this.resourceBundle_.getString(name);
        return MessageFormat.format(message, params);
    }

    static {
        map = new HashMap();
        map.put("ar", "ISO-8859-6");
        map.put("be", "ISO-8859-5");
        map.put("bg", "ISO-8859-5");
        map.put("ca", "ISO-8859-1");
        map.put("cs", "ISO-8859-2");
        map.put("da", "ISO-8859-1");
        map.put("de", "ISO-8859-1");
        map.put("el", "ISO-8859-7");
        map.put("en", "ISO-8859-1");
        map.put("es", "ISO-8859-1");
        map.put("et", "ISO-8859-2");
        map.put("fi", "ISO-8859-1");
        map.put("fr", "ISO-8859-1");
        map.put("he", "ISO-8859-8");
        map.put("hr", "ISO-8859-2");
        map.put("hu", "ISO-8859-2");
        map.put("is", "ISO-8859-1");
        map.put("it", "ISO-8859-1");
        map.put("iw", "ISO-8859-8");
        map.put("ja", "Shift_JIS");
        map.put("ko", "EUC-KR");
        map.put("lt", "ISO-8859-2");
        map.put("lv", "ISO-8859-2");
        map.put("mk", "ISO-8859-5");
        map.put("nl", "ISO-8859-1");
        map.put("no", "ISO-8859-1");
        map.put("pl", "ISO-8859-2");
        map.put("pt", "ISO-8859-1");
        map.put("ro", "ISO-8859-2");
        map.put("ru", "ISO-8859-5");
        map.put("sh", "ISO-8859-5");
        map.put("sk", "ISO-8859-2");
        map.put("sl", "ISO-8859-2");
        map.put("sq", "ISO-8859-2");
        map.put("sr", "ISO-8859-5");
        map.put("sv", "ISO-8859-1");
        map.put("tr", "ISO-8859-9");
        map.put("uk", "ISO-8859-5");
        map.put("zh", "GB2312");
        map.put("zh_TW", "Big5");
    }
}

