/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.management.mbeans.J2EEResourceBase;
import oracle.oc4j.admin.management.mbeans.JCAResourceMBean;

public class JCAResource
extends J2EEResourceBase
implements JCAResourceMBean {
    private String connectionFactoryPattern = null;
    private String adminObjectInstancePattern = null;
    private String resourceAdapterPattern = null;

    public JCAResource(String connectorName, String moduleName, String j2eeAppName, String j2eeServerName, String domain) {
        super(domain, j2eeServerName, "JCAResource");
        this.setBaseObjectName(":j2eeType=JCAResource,name=JCAResource,ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName);
        this.init();
        this.initPatterns(connectorName, moduleName, j2eeAppName, j2eeServerName);
    }

    public JCAResource(String connectorName, String moduleName, String j2eeAppName) {
        super("JCAResource");
        this.setBaseObjectName(":j2eeType=JCAResource,name=JCAResource,ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
        this.initPatterns(connectorName, moduleName, j2eeAppName, this.getJ2eeServerName());
    }

    public JCAResource(Locale loc) {
        super(loc);
        this.init();
    }

    private void initPatterns(String connectorName, String moduleName, String applicationName, String j2eeServerName) {
        String stdSuffix = "ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + applicationName + ",J2EEServer=" + j2eeServerName + ",*";
        this.connectionFactoryPattern = "*:j2eeType=JCAConnectionFactory," + stdSuffix;
        this.adminObjectInstancePattern = "*:j2eeType=JCAAdminObjectInstance," + stdSuffix;
        this.resourceAdapterPattern = "*:j2eeType=ResourceAdapter,ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + applicationName + ",J2EEServer=" + j2eeServerName + ",*";
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionFactories", "[Ljava.lang.String;", this.getLocalizedMessage("jcaresource_connectionFactories"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adminObjectInstances", "[Ljava.lang.String;", this.getLocalizedMessage("jcaresource_adminObjectInstances"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resourceAdapter", "java.lang.String", this.getLocalizedMessage("jcaresource_resourceAdapter"), true, false, false));
    }

    public String[] getconnectionFactories() throws JMXException {
        ObjectName[] res = null;
        res = this.getObjectNameForPattern(this.connectionFactoryPattern);
        String[] list = new String[res.length];
        for (int i = 0; i < res.length; ++i) {
            list[i] = res[i].toString();
        }
        return list;
    }

    public String[] getadminObjectInstances() throws JMXException {
        ObjectName[] res = null;
        res = this.getObjectNameForPattern(this.adminObjectInstancePattern);
        String[] list = new String[res.length];
        for (int i = 0; i < res.length; ++i) {
            list[i] = res[i].toString();
        }
        return list;
    }

    public String getresourceAdapter() throws JMXException {
        ObjectName[] res = null;
        res = this.getObjectNameForPattern(this.resourceAdapterPattern);
        if (res.length == 1) {
            return res[0].toString();
        }
        return null;
    }
}

