/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JMSSessionCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JMSSessionMBean;
import oracle.oc4j.admin.management.shared.statistic.JMSSessionStatsImpl;

public class JMSSession
extends J2EEServerDependentObjectBase
implements JMSSessionMBean {
    private JMSSessionCallBackIf m_callback;
    private String m_domain;
    private boolean m_isXA;
    private boolean m_isTransacted;
    private String m_ackMode;

    public JMSSession(JMSSessionCallBackIf callback, String id, String connId, String domain, boolean isXA, boolean isTransacted, String ackMode) {
        this.m_callback = callback;
        this.m_domain = domain;
        this.m_isXA = isXA;
        this.m_isTransacted = isTransacted;
        this.m_ackMode = ackMode;
        this.setBaseObjectName(":j2eeType=JMSSessionResource,name=" + ObjectNameUtil.quote((String)id) + ",JMSConnectionResource=" + ObjectNameUtil.quote((String)connId) + ",JMSResource=" + ObjectNameUtil.quote((String)"JMS") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JMSSession(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("jms_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("domain", "java.lang.String", this.getLocalizedMessage("jmssession_domain"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("acknowledgeMode", "java.lang.String", this.getLocalizedMessage("jmssession_acknowledgemode"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("txid", "java.lang.String", this.getLocalizedMessage("jmssession_txid"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("xid", "java.lang.String", this.getLocalizedMessage("jmssession_xid"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("sessionListener", "java.lang.String", this.getLocalizedMessage("jmssession_sessionlistener"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("isXA", "boolean", this.getLocalizedMessage("jmssession_isxa"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transacted", "boolean", this.getLocalizedMessage("jmssession_transacted"), true, false, true));
    }

    public final boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        return new JMSSessionStatsImpl(J2EEManagedObjectBase.getLocaleForCall(), this.m_callback.getMetricPath(), (JMSSessionStatsImpl)this.m_callback.getJSR77Stats());
    }

    public String getdomain() {
        return this.m_domain;
    }

    public String getacknowledgeMode() {
        return this.m_ackMode;
    }

    public boolean getisXA() {
        return this.m_isXA;
    }

    public boolean istransacted() {
        return this.m_isTransacted;
    }

    public String gettxid() {
        return this.m_callback.getTXID();
    }

    public String getxid() {
        return this.m_callback.getXID();
    }

    public String getsessionListener() {
        return this.m_callback.getSessionListener();
    }
}

