/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.OC4JServer;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JVMCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.JVMMBean;
import oracle.oc4j.admin.management.shared.statistic.JVMStatsImpl;

public class JVM
extends J2EEManagedObjectBase
implements JVMMBean {
    private static Logger logger_ = TraceLogger.getLogger(JVM.class);
    private String name_ = null;
    private String j2eeServerName_ = null;
    private String asInstance_ = null;
    private JVMCallBackIf callback_ = null;

    public JVM(JVMCallBackIf callback, String domain, String jvmName, String j2eeServerName, String asInstance) {
        super(domain);
        this.callback_ = callback;
        this.name_ = jvmName;
        this.j2eeServerName_ = j2eeServerName;
        this.asInstance_ = asInstance;
        this.setBaseObjectName(":j2eeType=JVM,name=" + this.name_ + ",J2EEServer=" + this.j2eeServerName_ + ",ASInstance=" + this.asInstance_);
        this.init();
    }

    public JVM(JVMCallBackIf callback, String jvmName, String j2eeServerName) {
        this.callback_ = callback;
        this.name_ = jvmName;
        this.j2eeServerName_ = j2eeServerName;
        this.setBaseObjectName(":j2eeType=JVM,name=" + this.name_ + ",J2EEServer=" + this.j2eeServerName_);
        this.init();
    }

    public JVM(JVMCallBackIf callback, String jvmName) {
        this.callback_ = callback;
        this.name_ = jvmName;
        this.j2eeServerName_ = "standalone";
        this.setBaseObjectName(":j2eeType=JVM,name=" + this.name_ + ",J2EEServer=" + this.j2eeServerName_);
        this.init();
    }

    public JVM(JVMCallBackIf callback) {
        this.callback_ = callback;
        this.name_ = "single";
        this.j2eeServerName_ = "standalone";
        this.setBaseObjectName(":j2eeType=JVM,name=" + this.name_ + ",J2EEServer=" + this.j2eeServerName_);
        this.init();
    }

    public JVM(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("javaVersion", "java.lang.String", this.getLocalizedMessage("jvm_javaVersion"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("userDefinedMBeanServerNames", "[Ljava.lang.String;", this.getLocalizedMessage("jvm_userDefinedMBeanServerNames"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("javaVendor", "java.lang.String", this.getLocalizedMessage("jvm_javaVendor"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("node", "java.lang.String", this.getLocalizedMessage("jvm_node"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("rmiServerAddress", "java.lang.String", this.getLocalizedMessage("jvm_rmiServerAddress"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("properties", "java.lang.String", this.getLocalizedMessage("jvm_properties"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("executingUsers", "java.util.Set", this.getLocalizedMessage("jvm_executingUsers"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectedUsers", "java.util.Set", this.getLocalizedMessage("jvm_executingUsers"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("applicationsInUse", "java.util.Map", this.getLocalizedMessage("jvm_ApplicationsInUse"), true, false, false));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", this.getLocalizedMessage("jvm_getproperty_key"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getproperty", this.getLocalizedMessage("jvm_getproperty"), params, "java.lang.String", 0));
        params[0] = new MBeanParameterInfo("applicationName", "java.lang.String", this.getLocalizedMessage("jvm_removeApplicationFromRuntime_appName"));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeApplicationFromRuntime", this.getLocalizedMessage("jvm_removeApplicationFromRuntime"), params, "void", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("key", "java.lang.String", this.getLocalizedMessage("jvm_getproperty_key")), new MBeanParameterInfo("value", "java.lang.String", this.getLocalizedMessage("jvm_setproperty_value"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setproperty", this.getLocalizedMessage("jvm_setproperty"), params, "void", 1));
        params[0] = new MBeanParameterInfo("applicationName", "java.lang.String", this.getLocalizedMessage("jvm_addApplicationToRuntime_appName"));
        params[1] = new MBeanParameterInfo("params", "java.util.Map", this.getLocalizedMessage("jvm_addApplicationToRuntime_params"));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addApplicationToRuntime", this.getLocalizedMessage("jvm_addApplicationToRuntime"), params, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("totalMemory", "long", this.getLocalizedMessage("jvm_totalMemory"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("freeMemory", "long", this.getLocalizedMessage("jvm_freeMemory"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("rungc", this.getLocalizedMessage("jvm_rungc"), null, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("opmnEnabled", "boolean", this.getLocalizedMessage("jvm_opmnenabled"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("forceCheckForUpdates", this.getLocalizedMessage("jvm_forcecheckforupdates"), null, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("rmiPort", "int", this.getLocalizedMessage("jvm_rmiport"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("rmisPort", "int", this.getLocalizedMessage("jvm_rmisport"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("ready", "boolean", this.getLocalizedMessage("jvm_ready"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("jvm_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("runningClusterMBeanServer", "boolean", this.getLocalizedMessage("jvm_runningClusterMBeanServer"), true, false, true));
    }

    public String getDescription() {
        return this.getLocalizedMessage("jvm_description");
    }

    public String getjavaVersion() {
        return System.getProperty("java.version");
    }

    public String getjavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getnode() throws UnknownHostException, SecurityException {
        return this.callback_.getRmiServerAddress().getCanonicalHostName();
    }

    public String getrmiServerAddress() throws UnknownHostException, SecurityException {
        return this.callback_.getRmiServerAddress().getHostAddress();
    }

    public String getproperties() {
        StringBuffer res = new StringBuffer();
        Properties prop = System.getProperties();
        Set<Map.Entry<Object, Object>> keys = prop.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = keys.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            res.append(entry.getKey() + " = " + entry.getValue() + "\n");
        }
        return res.toString();
    }

    public String getproperty(String key) {
        return System.getProperty(key);
    }

    public void setproperty(String key, String value) {
        System.setProperty(key, value);
    }

    public long gettotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getfreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public void rungc() {
        for (int i = 0; i < 5; ++i) {
            System.gc();
        }
    }

    public boolean getopmnEnabled() {
        return OC4JServer.getOPMNEnabled();
    }

    public final boolean getstatisticsProvider() {
        return true;
    }

    protected final void setCallBackInterface(JVMCallBackIf clbk) {
        this.callback_ = clbk;
    }

    public void forceCheckForUpdates() {
        if (logger_.isLoggable(Level.INFO)) {
            logger_.log(Level.INFO, "JVM MBean forceCheckForUpdates synchronization start");
        }
        this.callback_.forceCheckForUpdates();
    }

    public int getrmiPort() {
        return this.callback_.getRMIPort();
    }

    public int getrmisPort() {
        return this.callback_.getrmisPort();
    }

    public boolean getready() {
        return this.callback_.isReady();
    }

    public Stats getstats() {
        return new JVMStatsImpl(J2EEManagedObjectBase.getLocaleForCall());
    }

    public Set getconnectedUsers() {
        return this.getexecutingUsers();
    }

    public Set getexecutingUsers() {
        try {
            HashSet allUsers = new HashSet();
            String threadpoolPattern = "*:j2eeType=ThreadPool,J2EEServer=" + this.j2eeServerName_ + ",ASInstance=" + this.asInstance_ + ",*";
            ObjectName[] threadPoolMBeans = this.getObjectNameForPattern(threadpoolPattern);
            String domain = this.getDomain();
            MBeanServer mbeanServer = this.getMBeanServer(domain);
            for (int i = 0; i < threadPoolMBeans.length; ++i) {
                Set threadPoolUsers = (Set)mbeanServer.getAttribute(threadPoolMBeans[i], "executingUsers");
                if (threadPoolUsers == null) continue;
                allUsers.addAll(threadPoolUsers);
            }
            return allUsers;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public Map getapplicationsInUse() {
        try {
            HashMap allApps = new HashMap();
            String threadpoolPattern = "*:j2eeType=ThreadPool,J2EEServer=" + this.j2eeServerName_ + ",ASInstance=" + this.asInstance_ + ",*";
            ObjectName[] threadPoolMBeans = this.getObjectNameForPattern(threadpoolPattern);
            String domain = this.getDomain();
            MBeanServer mbeanServer = this.getMBeanServer(domain);
            for (int i = 0; i < threadPoolMBeans.length; ++i) {
                Map threadPoolApps = (Map)mbeanServer.getAttribute(threadPoolMBeans[i], "applicationsInUse");
                if (threadPoolApps == null) continue;
                Iterator it = threadPoolApps.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry t = it.next();
                    Set currVal = (Set)allApps.get(t.getKey());
                    if (currVal != null) {
                        currVal.addAll((Set)t.getValue());
                        allApps.put(t.getKey(), currVal);
                        continue;
                    }
                    allApps.put(t.getKey(), (Set<Object>)t.getValue());
                }
            }
            return allApps;
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void addApplicationToRuntime(String applicationName, Map params) {
        try {
            if (logger_.isLoggable(Level.INFO)) {
                logger_.log(Level.INFO, "Adding application: " + applicationName + " to container runtime");
            }
            this.callback_.addApplicationToRuntime(applicationName, params);
        }
        catch (DeployerException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "Error while adding application: " + applicationName + " to container runtime: " + e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public void removeApplicationFromRuntime(String applicationName) {
        try {
            if (logger_.isLoggable(Level.INFO)) {
                logger_.log(Level.INFO, "Removing application: " + applicationName + " from container runtime");
            }
            this.callback_.removeApplicationFromRuntime(applicationName);
        }
        catch (DeployerException e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "Error while removing application: " + applicationName + " from container runtime: " + e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public String[] getuserDefinedMBeanServerNames() {
        HashSet<String> domains = new HashSet<String>();
        String[] res = null;
        String oc4jMBeanServerDefaultDomain = Oc4jMBeanServerFactory.getMBeanServer().getDefaultDomain();
        ArrayList<MBeanServer> allMBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (allMBeanServers == null || allMBeanServers.size() == 0) {
            return res;
        }
        Iterator it = allMBeanServers.iterator();
        while (it.hasNext()) {
            MBeanServer mbsrv = (MBeanServer)it.next();
            String defaultDomain = mbsrv.getDefaultDomain();
            if (defaultDomain == null || defaultDomain.equals(oc4jMBeanServerDefaultDomain) || defaultDomain.equals("ias") || defaultDomain.equals("oc4j")) continue;
            domains.add(defaultDomain);
        }
        if (domains.size() == 0) {
            return res;
        }
        res = new String[domains.size()];
        it = domains.iterator();
        int i = 0;
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    public boolean isrunningClusterMBeanServer() {
        try {
            Class<?> cl = Class.forName("oracle.oc4j.admin.ias.runtime.TopologyMonitor");
            Method isStopped = cl.getMethod("isStopped", null);
            Boolean stopped = (Boolean)isStopped.invoke(null, null);
            return stopped == false;
        }
        catch (NoClassDefFoundError er) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

