/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.HashMap;
import java.util.Locale;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.management.callbackinterfaces.StatefulSessionBeanCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.SessionBeanBase;
import oracle.oc4j.admin.management.mbeans.StatefulSessionBeanMBean;
import oracle.oc4j.admin.management.shared.statistic.StatefulSessionBeanStatsImpl;

public class StatefulSessionBean
extends SessionBeanBase
implements StatefulSessionBeanMBean {
    public StatefulSessionBean(StatefulSessionBeanCallBackIf callBackIf, String domain, String j2eeServerName, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, domain, j2eeServerName, j2eeAppName, moduleName, compName, 4);
        this.init();
    }

    public StatefulSessionBean(StatefulSessionBeanCallBackIf callBackIf, String j2eeServerName, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, j2eeServerName, j2eeAppName, moduleName, compName, 4);
        this.init();
    }

    public StatefulSessionBean(StatefulSessionBeanCallBackIf callBackIf, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, "standalone", j2eeAppName, moduleName, compName, 4);
        this.init();
    }

    public StatefulSessionBean(Locale loc) {
        super(loc);
        this.init();
    }

    public String getDescription() {
        return this.getLocalizedMessage("statefulSessionBean_description");
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("passivationIdleTimeout", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_passivationIdleTimeout"), true, true, false), this.getDescriptorPersistConfigProperty());
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("maxInstances", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_max_instances"), true, true, false), this.getDescriptorPersistConfigProperty());
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("minInstances", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_min_instances"), true, true, false), this.getDescriptorPersistConfigProperty());
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("activeInstancesHighWaterMark", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_active_instances_high_water_mark"), true, false, false), null);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("activeInstances", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_active_instances"), true, false, false), null);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionTimeout", Integer.TYPE.getName(), this.getLocalizedMessage("statefulsessionbean_transaction_timeout"), true, true, false), null);
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("persistPolicy", "OnUpdate");
        metaData.put("requireRestart", "applicationRestart");
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("triggerName", "java.lang.String", this.getLocalizedMessage("statefulsessionbean_setReplicationPolicy_triggerName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setReplicationPolicy", this.getLocalizedMessage("statefulsessionbean_setReplicationPolicy"), params, "void", 1), metaData);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getReplicationPolicyTrigger", this.getLocalizedMessage("statefulsessionbean_getReplicationPolicyTrigger"), new MBeanParameterInfo[0], "java.lang.String", 0));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getReplicationPolicyScope", this.getLocalizedMessage("statefulsessionbean_getReplicationPolicyScope"), new MBeanParameterInfo[0], "java.lang.String", 0));
    }

    protected final StatefulSessionBeanCallBackIf getStatefulSessionBeanCallBackIf() {
        return (StatefulSessionBeanCallBackIf)this.getCallBackIf();
    }

    public int getpassivationIdleTimeout() throws JMXException {
        return this.getStatefulSessionBeanCallBackIf().getPassivationIdleTimeout();
    }

    public void setpassivationIdleTimeout(int _min) throws JMXException {
        this.getStatefulSessionBeanCallBackIf().setPassivationIdleTimeout(_min);
    }

    public Stats getstats() {
        return new StatefulSessionBeanStatsImpl(this.getApplicationName(), this.getDmsModuleId(), this.getComponentName(), J2EEManagedObjectBase.getLocaleForCall());
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        this.getStatefulSessionBeanCallBackIf().persistChanges();
    }

    public String getReplicationPolicyTrigger() {
        return this.getStatefulSessionBeanCallBackIf().getReplicationPolicyTrigger();
    }

    public String getReplicationPolicyScope() {
        return this.getStatefulSessionBeanCallBackIf().getReplicationPolicyScope();
    }

    public void setReplicationPolicy(String triggerName) {
        this.getStatefulSessionBeanCallBackIf().setReplicationPolicy(triggerName);
    }
}

