/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import oracle.oc4j.corba.ClientOrbManager;
import org.omg.CORBA.portable.ObjectImpl;

public class IiopHandleDelegateImpl
implements HandleDelegate {
    public void writeEJBObject(EJBObject ejbObject, ObjectOutputStream ostream) throws IOException {
        ostream.writeObject(ejbObject);
    }

    public void writeEJBHome(EJBHome ejbHome, ObjectOutputStream ostream) throws IOException {
        ostream.writeObject(ejbHome);
    }

    public EJBObject readEJBObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        return (EJBObject)this.getStub(istream, EJBObject.class);
    }

    public EJBHome readEJBHome(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        Object ejbHome = istream.readObject();
        if (ejbHome instanceof EJBHome) {
            this.connect(ejbHome);
            return (EJBHome)ejbHome;
        }
        String bindingPath = (String)ejbHome;
        try {
            InitialContext ctx = new InitialContext();
            return (EJBHome)ctx.lookup(bindingPath);
        }
        catch (NamingException e) {
            throw new IOException("Lookup failed: " + e);
        }
    }

    private void connect(Object obj) throws RemoteException {
        if (obj instanceof Stub) {
            Stub stub = (Stub)obj;
            try {
                stub.connect(ClientOrbManager.getClientOrb());
            }
            catch (RemoteException e) {
            }
            catch (RuntimeException e) {
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }

    private Object getStub(ObjectInputStream istream, Class stubClass) throws IOException, ClassNotFoundException {
        Object result = istream.readObject();
        if (result instanceof ObjectImpl && !ClientOrbManager.objectsReadAreAlreadyConnected(istream)) {
            this.connect(result);
        }
        return PortableRemoteObject.narrow((Object)result, (Class)stubClass);
    }
}

