/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.server;

import com.oracle.corba.ee.impl.orb.ORBManagerImpl;
import com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.ee.spi.legacy.interceptor.UnknownType;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.corba.iiop.CSIV2TaggedComponentInfo;
import oracle.oc4j.corba.iiop.server.CSIv2Policy;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.OTSPolicy;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class TxSecIORInterceptor
extends LocalObject
implements IORInterceptor {
    private static Logger traceLogger = TraceLogger.getLogger(TxSecIORInterceptor.class);
    static final int OTS_POLICY_TYPE = 1398079611;
    static final int CSIv2_POLICY_TYPE = 1398079612;
    private Codec codec;

    public TxSecIORInterceptor(Codec c) {
        this.codec = c;
    }

    public void destroy() {
    }

    public String name() {
        return "TxSecIORInterceptor";
    }

    public void establish_components(IORInfo iorInfo) {
        try {
            OTSPolicy otsPolicy = null;
            try {
                otsPolicy = (OTSPolicy)iorInfo.get_effective_policy(1398079611);
            }
            catch (INV_POLICY ex) {
                // empty catch block
            }
            if (otsPolicy != null) {
                this.addOTSComponents(iorInfo);
            }
            CSIv2Policy csiv2Policy = null;
            try {
                csiv2Policy = (CSIv2Policy)iorInfo.get_effective_policy(1398079612);
            }
            catch (INV_POLICY ex) {
                traceLogger.log(Level.FINER, "Invalid policy exception for 1398079612", ex);
            }
            this.addCSIv2Components(iorInfo, csiv2Policy);
        }
        catch (Exception e) {
            traceLogger.log(Level.WARNING, "Exception in establish_components", e);
        }
    }

    private void addOTSComponents(IORInfo iorInfo) {
        short invPolicyValue = 1;
        short otsPolicyValue = 3;
        Any otsAny = ORB.init().create_any();
        Any invAny = ORB.init().create_any();
        otsAny.insert_short(otsPolicyValue);
        invAny.insert_short(invPolicyValue);
        byte[] otsCompValue = null;
        byte[] invCompValue = null;
        try {
            otsCompValue = this.codec.encode_value(otsAny);
            invCompValue = this.codec.encode_value(invAny);
        }
        catch (InvalidTypeForEncoding e) {
            throw new INTERNAL("InvalidTypeForEncoding " + e.getMessage());
        }
        TaggedComponent otsComp = new TaggedComponent(31, otsCompValue);
        iorInfo.add_ior_component(otsComp);
        TaggedComponent invComp = new TaggedComponent(32, invCompValue);
        iorInfo.add_ior_component(invComp);
    }

    private void addCSIv2Components(IORInfo iorInfo, CSIv2Policy policy) {
        ORB orb = ORBManagerImpl.getORBManager().getORBReference();
        int sslMutualAuthPort = -1;
        try {
            sslMutualAuthPort = ((IORInfoExt)iorInfo).getServerPort("SSL_MUTUALAUTH");
        }
        catch (UnknownType unknownType) {
            traceLogger.fine("Unable to obtain mutual auth port");
        }
        CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb);
        ctc.setSSLMutualAuthPort(sslMutualAuthPort);
        int sslport = -1;
        try {
            sslport = ((IORInfoExt)iorInfo).getServerPort("SSL");
        }
        catch (UnknownType ute) {
            traceLogger.log(Level.FINE, "UnknownType exception", ute);
        }
        TaggedComponent csiv2Comp = null;
        if (policy != null) {
            csiv2Comp = ctc.createSecurityTaggedComponent(sslport, policy.getEjbIORDescriptorSet());
        } else {
            String sslUsed = ORBManagerImpl.getORBManager().getORBConfig().getORBProperties().getProperty("com.oracle.corba.ee.security.ssl.port");
            traceLogger.log(Level.FINEST, "SSL Used: ", sslUsed);
            boolean useSSL = Boolean.valueOf(sslUsed);
            csiv2Comp = ctc.createSecurityTaggedComponent(sslport, useSSL);
        }
        iorInfo.add_ior_component(csiv2Comp);
    }
}

