/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.server.ApplicationContextClassLoader;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.logging.EJBIiopMessages;
import java.security.AccessController;
import oracle.j2ee.util.SetContextClassLoaderAction;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.corba.transport.HomeLocator;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;

abstract class BaseServantLocator
extends LocalObject
implements ServantLocator {
    private ThreadLocal m_contextContainer = new ThreadLocal();
    private ClassLoader m_ejbClassLoader;

    protected BaseServantLocator() {
    }

    protected BaseServantLocator(ClassLoader classloader) {
        this.m_ejbClassLoader = classloader;
    }

    public Servant preinvoke(byte[] oid, POA poa, String method, CookieHolder cookie) throws ForwardRequest {
        EJBObjectID objectID = this.getObjectID(oid);
        CorbaEJBHome home = HomeLocator.getHome(objectID);
        this.pushHomeContextContainer(home);
        return this.getSelectedServant(home, objectID);
    }

    public void postinvoke(byte[] oid, POA poa, String s, Object o, Servant servant) {
        this.popHomeContextContainer();
    }

    protected abstract Servant getSelectedServant(CorbaEJBHome var1, EJBObjectID var2);

    private void pushHomeContextContainer(CorbaEJBHome home) {
        ThreadState state = this.getThreadState();
        if (state != null) {
            this.m_contextContainer.set(state.contextContainer);
            state.contextContainer = home;
            this.setContextClassLoader();
        }
    }

    private void setContextClassLoader() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof ApplicationServerThread)) {
            AccessController.doPrivileged(new SetContextClassLoaderAction(thread, ApplicationContextClassLoader.getThreadLocalApplicationContextClassLoader()));
        }
    }

    private void popHomeContextContainer() {
        ThreadState state = this.getThreadState();
        if (state != null) {
            state.contextContainer = (ContextContainer)this.m_contextContainer.get();
        }
    }

    private ThreadState getThreadState() {
        CommonThreadState state = CommonThreadState.getCurrent();
        if (state instanceof ThreadState) {
            return (ThreadState)state;
        }
        return null;
    }

    private EJBObjectID getObjectID(byte[] oid) {
        try {
            return (EJBObjectID)EJBObjectID.extract(oid, this.m_ejbClassLoader);
        }
        catch (Throwable t) {
            EJBIiopMessages.severeUnableToReadEJBObjectID(t);
            throw new OBJ_ADAPTER("EjbServantLocator could not read object ID");
        }
    }
}

