/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import javax.ejb.EJBObject;
import oracle.j2ee.corba.iiop.IIOPMessages;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.ServerOrbManager;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.CorbaEJBObject;
import oracle.oc4j.corba.transport.CorbaReferenceGenerator;
import oracle.oc4j.corba.transport.CorbaReferenceGeneratorImpl;
import oracle.oc4j.corba.transport.ORBSystemException;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class CorbaTransportManager {
    private static CorbaTransportManager s_manager = null;
    private CorbaReferenceGeneratorImpl m_referenceGenerator;

    private CorbaTransportManager() {
    }

    public static CorbaTransportManager getInstance() {
        if (s_manager == null) {
            s_manager = new CorbaTransportManager();
        }
        return s_manager;
    }

    public CorbaReferenceGenerator deployHome(CorbaEJBHome home) throws ORBInitializationException {
        this.getReferenceGenerator().deployHome(home);
        return this.getReferenceGenerator();
    }

    public EJBObject deployEjb(CorbaEJBHome home, EJBObject ejbObject) throws ORBInitializationException {
        EJBObject remoteReference = this.getReferenceGenerator().deployEjb(home, ejbObject);
        ((CorbaEJBObject)ejbObject).setCorbaReference(remoteReference);
        return remoteReference;
    }

    public void undeployApplication(String appName) {
        if (this.m_referenceGenerator != null) {
            this.m_referenceGenerator.undeployApplication(appName);
        }
    }

    private CorbaReferenceGeneratorImpl getReferenceGenerator() {
        if (this.m_referenceGenerator == null) {
            try {
                POA rootPoa = POAHelper.narrow((Object)ServerOrbManager.getOrb().resolve_initial_references("RootPOA"));
                rootPoa.the_POAManager().activate();
                this.m_referenceGenerator = new CorbaReferenceGeneratorImpl(rootPoa, ServerOrbManager.getPOAPolicyCreationStrategy());
            }
            catch (InvalidName e) {
                IIOPMessages.severeUnableToGetRootPOA(e);
                throw new ORBSystemException("Could not get reference to root POA");
            }
            catch (AdapterInactive e) {
                IIOPMessages.severeUnableToActivatePOA(e);
                throw new ORBSystemException("Could not activate POAManager for root POA");
            }
            catch (ORBConfigurationException e) {
                IIOPMessages.severeUnableToGetOrb(e);
                throw new ORBSystemException("Could not obtain orb reference: " + e);
            }
        }
        return this.m_referenceGenerator;
    }

    public void reinit() {
        this.m_referenceGenerator = null;
    }
}

