/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.extensions;

import java.io.File;
import java.io.FileWriter;
import oracle.classloader.ClassLoaderQuery;
import oracle.hooks.Extension;
import oracle.hooks.Hook;
import oracle.oc4j.hooks.ServerProtocol;

public class CreateStartupCheckpointFile
implements Extension {
    public Class[] getDependentProtocols() {
        return new Class[]{ServerProtocol.class};
    }

    public void activate(final String[] args) {
        if (args.length != 1) {
            throw new RuntimeException("CreateStartupCheckpointFile requires one argument which is the name of the checkpoint file to create; received: " + args.length + " arguments.");
        }
        final File cpFile = new File(new File(ClassLoaderQuery.getHomeDirectory(), "log/"), args[0]);
        ServerProtocol.SERVER_INITIALIZED.addHook("CreateStartupCheckpointFile", new Hook.Read1(){

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void execute(Object applicationServer) {
                FileWriter out = null;
                out = new FileWriter(cpFile);
                out.write("" + System.currentTimeMillis());
                out.close();
                Object var5_3 = null;
                cpFile.deleteOnExit();
                if (null == out) return;
                try {
                    out.close();
                    return;
                }
                catch (Throwable t) {
                    System.err.println("Unable to close checkpoint file: " + args[0] + " during error recovery.");
                }
                return;
                {
                    catch (Exception e) {
                        throw new RuntimeException("Unable to write to startup checkpoint file: " + args[0] + "; error: " + e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    cpFile.deleteOnExit();
                    if (null == out) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        System.err.println("Unable to close checkpoint file: " + args[0] + " during error recovery.");
                    }
                    throw throwable;
                }
            }
        });
    }
}

