/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.config.xml;

import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.oc4j.configuration.XMLSerializable;
import oracle.oc4j.loader.config.ImportSharedLibraryType;
import oracle.oc4j.loader.config.ImportedSharedLibrariesType;
import oracle.oc4j.loader.config.xml.ComparisonUtils;
import oracle.oc4j.loader.config.xml.ImportSharedLibraryElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportedSharedLibrariesElement
implements ImportedSharedLibrariesType,
XMLSerializable {
    private List m_imports = new ArrayList();
    private List m_removals = new ArrayList();

    public synchronized boolean equals(Object other) {
        try {
            ImportedSharedLibrariesElement it = (ImportedSharedLibrariesElement)other;
            if (!ComparisonUtils.equal(this.m_imports, it.m_imports)) {
                return false;
            }
            return ComparisonUtils.equal(this.m_removals, it.m_removals);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public synchronized ImportSharedLibraryType[] getImports() {
        ImportSharedLibraryType[] imports = new ImportSharedLibraryType[this.m_imports.size()];
        return this.m_imports.toArray(imports);
    }

    public synchronized void setImports(ImportSharedLibraryType[] imports) {
        if (imports == null) {
            imports = new ImportSharedLibraryType[]{};
        }
        this.m_imports.clear();
        for (int i = 0; i < imports.length; ++i) {
            ImportSharedLibraryType library = imports[i];
            this.m_imports.add(library);
        }
    }

    public boolean hasImport(String libraryName) {
        boolean foundStat = false;
        if (libraryName != null) {
            for (int i = 0; i < this.m_imports.size(); ++i) {
                ImportSharedLibraryType sharedImport = (ImportSharedLibraryType)this.m_imports.get(i);
                if (!sharedImport.getName().equals(libraryName)) continue;
                return true;
            }
        }
        return foundStat;
    }

    public ImportSharedLibraryType deleteImport(String libraryName) {
        if (libraryName != null) {
            for (int i = 0; i < this.m_imports.size(); ++i) {
                ImportSharedLibraryType sharedImport = (ImportSharedLibraryType)this.m_imports.get(i);
                if (!sharedImport.getName().equals(libraryName)) continue;
                this.m_imports.remove(i);
                return sharedImport;
            }
        }
        return null;
    }

    public String deleteRemove(String libraryName) {
        if (libraryName != null) {
            for (int i = 0; i < this.m_removals.size(); ++i) {
                String removeImport = (String)this.m_removals.get(i);
                if (!removeImport.equals(libraryName)) continue;
                this.m_removals.remove(i);
                return removeImport;
            }
        }
        return null;
    }

    public synchronized boolean addImport(ImportSharedLibraryType oneImport) {
        if (oneImport == null) {
            return false;
        }
        if (this.hasImport(oneImport.getName())) {
            return false;
        }
        this.m_imports.add(oneImport);
        return true;
    }

    public synchronized String[] getRemovals() {
        String[] removals = new String[this.m_removals.size()];
        return this.m_removals.toArray(removals);
    }

    public synchronized void setRemovals(String[] removals) {
        if (removals == null) {
            removals = new String[]{};
        }
        this.m_removals.clear();
        for (int i = 0; i < removals.length; ++i) {
            String oneRemoval = removals[i];
            this.m_removals.add(oneRemoval);
        }
    }

    public synchronized boolean addRemoval(String removal) {
        if (removal == null) {
            return false;
        }
        if (this.hasRemoval(removal)) {
            return false;
        }
        this.m_removals.add(removal);
        return true;
    }

    public boolean hasRemoval(String removeName) {
        boolean foundRemoval = false;
        if (removeName != null) {
            for (int i = 0; i < this.m_removals.size(); ++i) {
                String removeSharedLibName = (String)this.m_removals.get(i);
                if (!removeSharedLibName.equals(removeName)) continue;
                return true;
            }
        }
        return foundRemoval;
    }

    public synchronized void read(Node node) throws DOMException {
        NodeList list = node.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.startsWith("#")) continue;
                if (nodeName.equals("import-shared-library")) {
                    ImportSharedLibraryElement e = new ImportSharedLibraryElement();
                    e.read(child);
                    this.m_imports.add(e);
                    continue;
                }
                if (!nodeName.equals("remove-inherited")) continue;
                String name = XMLUtils.getNodeAttribute(child, "name");
                this.m_removals.add(name);
            }
        }
    }

    public synchronized void write(PrintWriter out, String indent) throws IOException {
        out.print(indent);
        out.println("<imported-shared-libraries>");
        String subIndent = indent + "\t";
        for (int i = 0; i < this.m_imports.size(); ++i) {
            ImportSharedLibraryType e = (ImportSharedLibraryType)this.m_imports.get(i);
            e.write(out, subIndent);
        }
        for (int j = 0; j < this.m_removals.size(); ++j) {
            String name = (String)this.m_removals.get(j);
            out.print(subIndent);
            out.println("<remove-inherited name=\"" + name + "\"/>");
        }
        out.print(indent);
        out.println("</imported-shared-libraries>");
    }
}

