/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.naming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import oracle.oc4j.naming.SimpleName;

public class ContextBinding {
    private static final int RAW_BYTE_ARRAY = 0;
    private static final int SERIALIZED_OBJECT = 1;
    private Object m_value;
    private Serializable m_serializable;
    private byte[] m_streamedValue;

    public ContextBinding(Object value) {
        if (value instanceof Reference) {
            this.m_serializable = (Serializable)value;
        } else {
            this.m_value = value;
        }
    }

    public ContextBinding(DataInput input) throws IOException {
        int type = input.readInt();
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        if (type == 0) {
            this.m_value = bytes;
        } else {
            this.m_streamedValue = bytes;
        }
    }

    public Object getValue() throws NamingException {
        return this.getValue((Name)null, null, null);
    }

    public Object getValue(String name, Context context, Hashtable environment) throws NamingException {
        return this.getValue(this.toName(name), context, environment);
    }

    private SimpleName toName(String name) {
        return name == null ? null : new SimpleName(name);
    }

    public Object getValue(Name name, Context context, Hashtable environment) throws NamingException {
        if (this.m_value != null) {
            return this.m_value;
        }
        if (this.m_streamedValue == null && this.m_serializable == null) {
            return null;
        }
        try {
            if (this.m_serializable == null) {
                this.m_serializable = this.deserialize(this.m_streamedValue);
            }
            return !(this.m_serializable instanceof Reference) ? this.m_serializable : this.resolve(this.m_serializable, name, context, environment);
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Error deserializing bound value");
            ne.setRootCause(e);
            throw ne;
        }
        catch (ClassNotFoundException e) {
            NamingException ne = new NamingException("Error deserializing bound value");
            ne.setRootCause(e);
            throw ne;
        }
    }

    private Serializable deserialize(byte[] streamedValue) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(streamedValue);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Serializable serializable = (Serializable)ois.readObject();
        return serializable;
    }

    private Object resolve(Object reference, Name name, Context context, Hashtable environment) throws NamingException {
        try {
            return NamingManager.getObjectInstance(reference, name, context, environment);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Error resolving reference <" + reference + "> : " + e);
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void write(DataOutput output) throws IOException, NamingException {
        if (this.m_streamedValue != null) {
            this.write(output, this.m_streamedValue);
        } else if (this.m_value instanceof byte[]) {
            this.write(output, (byte[])this.m_value);
        } else {
            Serializable serializable = this.getSerializable();
            if (serializable == null) {
                throw new RuntimeException("May not convert " + this.m_value + " to byte array");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            this.m_streamedValue = baos.toByteArray();
            this.write(output, this.m_streamedValue);
        }
    }

    private void write(DataOutput output, byte[] streamValue) throws IOException {
        output.writeInt(this.getSerializationType());
        output.writeInt(streamValue.length);
        output.write(streamValue);
    }

    private int getSerializationType() {
        return this.isByteArray() ? 0 : 1;
    }

    private boolean isByteArray() {
        return this.m_streamedValue == null && this.m_value instanceof byte[];
    }

    public boolean isSerializableValue() {
        try {
            return this.m_streamedValue != null || this.getSerializable() != null;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.getClass() + " [ value=" + this.getValue() + " ]";
        }
        catch (NamingException e) {
            return this.getClass() + "  unable to resolve value... " + e;
        }
    }

    protected Reference getReference(Object value) throws NamingException {
        return value instanceof Referenceable ? ((Referenceable)value).getReference() : null;
    }

    public Serializable getSerializable() throws NamingException {
        if (this.m_serializable != null) {
            return this.m_serializable;
        }
        if (this.m_value == null) {
            try {
                if (this.m_streamedValue == null) {
                    return null;
                }
                this.m_serializable = this.deserialize(this.m_streamedValue);
                return this.m_serializable;
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        this.m_serializable = this.m_value instanceof Serializable ? (Serializable)this.m_value : this.getReference(this.m_value);
        return this.m_serializable;
    }
}

