/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.PolicyClassLoader;
import oracle.oc4j.loader.config.OC4JClassLoaderScope;
import oracle.oc4j.peek.LoaderHandler;
import oracle.oc4j.peek.TreeHandler;
import oracle.oc4j.query.util.LoaderComparator;

public class LoaderTreeHandler
extends TreeHandler {
    private static final String HEADER = "<h3>Class Loaders</h3>\n";
    private static final LoaderComparator LOADER_COMPARATOR = new LoaderComparator();

    public String getURISuffix() {
        return "loader-tree";
    }

    protected void writeTree(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        ((Writer)out).write(HEADER);
        PolicyClassLoader root = ClassLoaderQuery.getRootLoader();
        LoaderTreeHandler.writeNode(out, root, false, new boolean[128], 0);
    }

    private static void writeNode(Writer out, PolicyClassLoader loader, boolean parentsLastChild, boolean[] parentDepth, int depth) throws Exception {
        String title = LoaderTreeHandler.getTitle(loader);
        String text = LoaderHandler.getLinkTo(loader, title);
        LoaderTreeHandler.startNode(text, out, parentsLastChild, parentDepth, depth);
        PolicyClassLoader[] children = loader.getChildren();
        Arrays.sort(children, LOADER_COMPARATOR);
        int childCount = children.length;
        int lastChild = childCount - 1;
        for (int i = 0; i < childCount; ++i) {
            PolicyClassLoader child = children[i];
            if (child == null) continue;
            LoaderTreeHandler.writeNode(out, child, i == lastChild, parentDepth, depth + 1);
        }
        LoaderTreeHandler.endNode(out, parentDepth, depth);
    }

    static String getTitle(PolicyClassLoader loader) {
        StringBuffer buf = new StringBuffer();
        ClassLoaderScope scope = loader.getScope();
        if (loader.isSharedLoader()) {
            buf.append("Shared library");
        } else if (scope == ClassLoaderScope.ROOT) {
            buf.append("JRE native loader wrapper");
        } else if (scope == ClassLoaderScope.EXTENSION) {
            buf.append("JRE extensions loader");
        } else if (scope == ClassLoaderScope.GLOBAL) {
            buf.append("Global loader");
        } else if (scope == ClassLoaderScope.APPLICATION) {
            buf.append("Application root loader");
        } else if (scope == OC4JClassLoaderScope.APPLICATION_CLIENT) {
            buf.append("Application client loader");
        } else if (scope == OC4JClassLoaderScope.APPLICATION_WEB) {
            buf.append("Web module loader");
        } else if (scope == OC4JClassLoaderScope.APPLICATION_JSP) {
            buf.append("JSP loader");
        } else if (scope == ClassLoaderScope.MAIN) {
            buf.append("Internal loader");
        }
        buf.append(' ');
        buf.append(loader.getDisplayName());
        buf.append(" (");
        buf.append(Integer.toHexString(System.identityHashCode(loader)));
        buf.append(')');
        return buf.toString();
    }
}

