/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.ResourceHandler;
import oracle.oc4j.peek.Skin;

public class SkinHandler
extends ResourceHandler {
    private static final String CONTENT_TYPE = "text/css";
    private static final String URI_SUFFIX = "skin";
    private static final String SESSION_KEY = "skin";
    private static final String COOKIE_NAME = "peek.skin";

    public String getURISuffix() {
        return "skin";
    }

    public void handleRequest(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (pathArgument.startsWith("=")) {
            String skinName = pathArgument.substring(1);
            SkinHandler.setCookie(COOKIE_NAME, skinName, response);
            HttpSession session = request.getSession(true);
            session.removeAttribute("skin");
            response.sendRedirect(Peek.getContextRoot());
        } else {
            Skin skin = Skin.getSkin(pathArgument);
            byte[] bytes = skin.getCSSFileData();
            response.setHeader("Last-Modified", SELF_LAST_MODIFIED);
            response.setHeader("Expires", ONE_YEAR_FROM_NOW);
            response.setContentLength(bytes.length);
            response.setContentType(CONTENT_TYPE);
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            out.flush();
            out.close();
        }
    }

    public static String getRelativeURI(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String skinName = (String)session.getAttribute("skin");
        if (skinName == null) {
            skinName = SkinHandler.getCookieValue(COOKIE_NAME, Skin.getDefaultSkinName(), request);
            session.setAttribute("skin", (Object)skinName);
        }
        return Peek.getContextRoot() + "skin" + "/" + skinName;
    }

    static {
        new Skin("halloween", "peek-hw.png", "f9aa33", "ff8927", "10/30", "10/31");
    }
}

