/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.rmi.RemoteException;

public class OracleRemoteException
extends RemoteException {
    public static final long serialVersionUID = 5676799332747648091L;
    private String serverStackTrace;
    private String serverDetailStackTrace;
    private Throwable preservedDetail;

    public OracleRemoteException() {
    }

    public OracleRemoteException(String message) {
        super(message);
    }

    public OracleRemoteException(String message, Throwable detail) {
        super(message);
        this.detail = detail;
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(new PrintWriter((Writer)new OutputStreamWriter(out), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        this.preservedDetail = this.detail;
        this.detail = null;
        try {
            this.writeWithDetail(out, this.serverStackTrace, this);
            if (this.preservedDetail != null) {
                out.println("\n\tNested exception is:");
                this.writeWithDetail(out, this.serverDetailStackTrace, this.preservedDetail);
            }
        }
        finally {
            this.detail = this.preservedDetail;
            this.preservedDetail = null;
        }
    }

    public void writeWithDetail(PrintWriter out, String detail, Throwable t) {
        if (detail == null) {
            if (t == this) {
                super.printStackTrace(out);
            } else {
                t.printStackTrace(out);
            }
        } else {
            out.print(detail);
            this.writeStripped(out, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        this.preservedDetail = this.detail;
        this.detail = null;
        try {
            CharArrayWriter arrayWriter = new CharArrayWriter();
            super.printStackTrace(new PrintWriter((Writer)arrayWriter, true));
            String message = new String(arrayWriter.toCharArray());
            this.serverStackTrace = this.serverStackTrace != null ? this.serverStackTrace + message : message;
            if (this.preservedDetail != null) {
                arrayWriter = new CharArrayWriter();
                this.preservedDetail.printStackTrace(new PrintWriter((Writer)arrayWriter, true));
                message = new String(arrayWriter.toCharArray());
                this.serverDetailStackTrace = this.serverDetailStackTrace != null ? this.serverDetailStackTrace + message : message;
            }
        }
        finally {
            this.detail = this.preservedDetail;
            this.preservedDetail = null;
        }
    }

    public void receive(InetAddress remote) {
        this.fillInStackTrace();
        if (this.serverStackTrace != null) {
            this.serverStackTrace = this.serverStackTrace + "at connection to " + remote + "\n";
        }
        if (this.serverDetailStackTrace != null) {
            this.serverDetailStackTrace = this.serverDetailStackTrace + "at connection to " + remote + "\n";
        }
        if (this.detail != null) {
            this.detail.fillInStackTrace();
        }
    }

    public void writeStripped(PrintWriter out, Throwable t) {
        try {
            String line;
            CharArrayWriter arrayWriter = new CharArrayWriter();
            if (t == this) {
                super.printStackTrace(new PrintWriter((Writer)arrayWriter, true));
            } else {
                t.printStackTrace(new PrintWriter((Writer)arrayWriter, true));
            }
            boolean first = true;
            BufferedReader in = new BufferedReader(new CharArrayReader(arrayWriter.toCharArray()));
            while ((line = in.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace(out);
        }
    }

    public Throwable getOriginal() {
        return this.detail;
    }
}

