/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import oracle.oc4j.security.CryptoException;
import oracle.oc4j.security.KeyExchangeParameterSpec;

class KeyExchange
implements Serializable {
    private static KeyExchangeParameterSpec s_defaultParameterSpec = KeyExchangeParameterSpec.DH1024.getInstance();
    private KeyExchangeParameterSpec m_parameterSpec;
    private String m_encryptionAlg;
    private KeyPair m_localKeyPair;
    private PublicKey m_remotePublicKey;
    private KeyAgreement m_keyAgreement;
    private SecretKey m_secretKey;

    private KeyExchange(String encryptionAlgorithm) {
        this.m_encryptionAlg = encryptionAlgorithm;
        this.m_parameterSpec = this.getDefaultParameterSpec();
    }

    private KeyExchange(String encryptionAlgorithm, KeyExchangeParameterSpec parameterSpec) {
        this.m_encryptionAlg = encryptionAlgorithm;
        this.m_parameterSpec = null == parameterSpec ? this.getDefaultParameterSpec() : parameterSpec;
    }

    private KeyExchangeParameterSpec getDefaultParameterSpec() {
        return s_defaultParameterSpec;
    }

    private KeyExchangeParameterSpec getParameterSpec() {
        return this.m_parameterSpec;
    }

    public static KeyExchange create(String encryptionAlgorithm) {
        return new KeyExchange(encryptionAlgorithm);
    }

    public static KeyExchange create(String encryptionAlgorithm, KeyExchangeParameterSpec parameterSpec) {
        return new KeyExchange(encryptionAlgorithm, parameterSpec);
    }

    public String getEncryptionAlgorithm() {
        return this.m_encryptionAlg;
    }

    public String getKeyExchangeAlgorithm() {
        return this.getParameterSpec().getExchangeAlgorithm();
    }

    public int getKeyExchangeBitLength() {
        return this.getParameterSpec().getL();
    }

    public PublicKey getLocalPublicKey() throws CryptoException {
        return this.getLocalKeyPair().getPublic();
    }

    public void setRemotePublicKey(byte[] encodedKey) throws CryptoException {
        this.m_remotePublicKey = this.toPublicKey(encodedKey);
    }

    public SecretKey getSecretKey() throws CryptoException {
        if (null == this.getRemotePublicKey()) {
            throw new KeyExchangeException("not ready to negiotiate the secret key");
        }
        try {
            if (null == this.m_secretKey) {
                this.m_secretKey = this.getKeyAgreement().generateSecret(this.getEncryptionAlgorithm());
            }
            return this.m_secretKey;
        }
        catch (Exception e) {
            throw new KeyExchangeException(e);
        }
    }

    PublicKey getRemotePublicKey() throws CryptoException {
        return this.m_remotePublicKey;
    }

    PrivateKey getLocalPrivateKey() throws CryptoException {
        return this.getLocalKeyPair().getPrivate();
    }

    private KeyPair getLocalKeyPair() throws CryptoException {
        if (null == this.m_localKeyPair) {
            this.m_localKeyPair = this.createKeyPairGenerator().generateKeyPair();
        }
        return this.m_localKeyPair;
    }

    private KeyPairGenerator createKeyPairGenerator() throws CryptoException {
        try {
            KeyExchangeParameterSpec ps = this.getParameterSpec();
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.getKeyExchangeAlgorithm());
            keyGen.initialize(ps.value());
            return keyGen;
        }
        catch (Exception e) {
            throw new KeyExchangeException(e);
        }
    }

    private PublicKey toPublicKey(byte[] encoded) throws CryptoException {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encoded);
            KeyFactory keyFact = KeyFactory.getInstance(this.getKeyExchangeAlgorithm());
            return keyFact.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            throw new KeyExchangeException(e);
        }
    }

    private KeyAgreement getKeyAgreement() throws CryptoException {
        if (null == this.m_keyAgreement) {
            this.m_keyAgreement = this.createKeyAgreement();
        }
        return this.m_keyAgreement;
    }

    private KeyAgreement createKeyAgreement() throws CryptoException {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.getKeyExchangeAlgorithm());
            keyAgreement.init(this.getLocalPrivateKey());
            keyAgreement.doPhase(this.getRemotePublicKey(), true);
            return keyAgreement;
        }
        catch (Exception e) {
            throw new KeyExchangeException(e);
        }
    }

    public static class KeyExchangeException
    extends CryptoException {
        public KeyExchangeException(String e) {
            super(e);
        }

        public KeyExchangeException(Exception e) {
            super(e);
        }
    }
}

