/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public abstract class KeyExchangeParameterSpec
implements Serializable {
    static final String DEFAULT_KEY_EXCHANGE_ALG = "DH";
    private transient AlgorithmParameterSpec m_algSpecValue;

    public abstract BigInteger getP();

    public abstract BigInteger getG();

    public abstract int getL();

    public String getExchangeAlgorithm() {
        return DEFAULT_KEY_EXCHANGE_ALG;
    }

    public AlgorithmParameterSpec value() {
        if (null == this.m_algSpecValue) {
            this.m_algSpecValue = new DHParameterSpec(this.getP(), this.getG(), this.getL());
        }
        return this.m_algSpecValue;
    }

    public static class DH1024
    extends KeyExchangeParameterSpec {
        private static DH1024 s_singleton = new DH1024();
        private static BigInteger DH_P = new BigInteger("174021862413480995296462583613697229554011409812506077234105950122833513692558691806302781729113143294467060369699639472667529237416127158753711427109208487093464901155739065429804207063194043296296514628683760097536970066528102106908386555310105091784853074007439171831190862237487739686042062078089476434833");
        private static BigInteger DH_G = new BigInteger("59413854171370651441885451714811838115937239327220778445661384713366692936269728230046464148738321677701406739642647498650338787223579060572794350278236388263463967035827460434751698629797616612532008850848184463717758555418404614673119853505881726708576334320582634468510739118787926056434645422784326952665");
        public static final int DH_L = 1023;

        private DH1024() {
        }

        public static DH1024 getInstance() {
            return s_singleton;
        }

        public BigInteger getP() {
            return DH_P;
        }

        public BigInteger getG() {
            return DH_G;
        }

        public int getL() {
            return 1023;
        }
    }

    public static class DH512
    extends KeyExchangeParameterSpec {
        private static DH512 s_singleton = new DH512();
        private static BigInteger DH_P = new BigInteger("9035767127886609306461802803478165400868361598280247357835714397335191774377223378802965628609388894253499598113268699173701416007486810790362824101072871");
        private static BigInteger DH_G = new BigInteger("1180773790970467698071746863864254571768826516102464146803679174725243103267051498792623311544165765278621418617206312143587340384327379405051599729527185");
        public static final int DH_L = 511;

        private DH512() {
        }

        public static DH512 getInstance() {
            return s_singleton;
        }

        public BigInteger getP() {
            return DH_P;
        }

        public BigInteger getG() {
            return DH_G;
        }

        public int getL() {
            return 511;
        }
    }
}

