/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtils;

public class OC4JSSLSocketFactory
implements HostnameVerifier {
    public static final String DEFAULT_PROTOCOL = "TLS";
    public static final char[] DEFAULT_PASSWORD = "".toCharArray();
    public static final String ORACLE_SECURITY_PROVIDER = "oracle.security.pki.OraclePKIProvider";
    public static final String DEFAULT_ORACLE_KEY_ALGORITHM = "OracleX509";
    public static final String PKCS12 = "PKCS12";
    public static final String WALLET_FILE_EXT = ".p12";
    public static final String[] s_anonCipherSuites = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5"};
    private static Logger s_logger = TraceLogger.getLogger(OC4JSSLSocketFactory.class);
    private String m_categoryName;
    private SSLUtils.Values m_sslConfigValues;
    private KeyStore m_keyStore;
    private KeyStore m_trustStore;
    private KeyManager[] m_keyManager;
    private TrustManager[] m_trustManager;
    private SSLContext m_sslContext;
    private static HashMap m_instancesByCategory = new HashMap();

    public OC4JSSLSocketFactory(String categoryName, SSLUtilValues values) {
        this.m_categoryName = categoryName;
        this.m_sslConfigValues = new SSLUtils.Values(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OC4JSSLSocketFactory getDefault(String categoryName) throws IOException {
        HashMap hashMap = m_instancesByCategory;
        synchronized (hashMap) {
            OC4JSSLSocketFactory factory = (OC4JSSLSocketFactory)m_instancesByCategory.get(categoryName);
            if (null != factory) {
                return factory;
            }
        }
        return new OC4JSSLSocketFactory(categoryName, SSLUtils.getDefaultValues(categoryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OC4JSSLSocketFactory registerSSLUtilValues(String categoryName, SSLUtils.Values values) {
        HashMap hashMap = m_instancesByCategory;
        synchronized (hashMap) {
            if (m_instancesByCategory.containsKey(categoryName) && null == values) {
                m_instancesByCategory.remove(categoryName);
                return null;
            }
            if (null == values) {
                return null;
            }
            OC4JSSLSocketFactory factory = new OC4JSSLSocketFactory(categoryName, values);
            m_instancesByCategory.put(categoryName, factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAll() {
        HashMap hashMap = m_instancesByCategory;
        synchronized (hashMap) {
            m_instancesByCategory.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(String categoryName) {
        HashMap hashMap = m_instancesByCategory;
        synchronized (hashMap) {
            m_instancesByCategory.remove(categoryName);
        }
    }

    public SSLUtils.Values getConfigValues() {
        return this.m_sslConfigValues;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        try {
            return this.configureSocket((SSLSocket)this.getSocketFactory().createSocket(address, port));
        }
        catch (Exception e) {
            s_logger.throwing(this.getClass().toString(), "createSocket", e);
            OC4JSSLSocketFactory.reset(this.m_categoryName);
            throw new IOException(e.getMessage());
        }
    }

    Socket configureSocket(SSLSocket socket) throws IOException {
        if (this.needPeerAuth()) {
            socket.setNeedClientAuth(true);
        } else if (this.wantPeerAuth()) {
            socket.setWantClientAuth(true);
        }
        if (this.isAnonymousPermitted()) {
            socket.setEnabledCipherSuites(s_anonCipherSuites);
        }
        return socket;
    }

    boolean wantPeerAuth() {
        return true;
    }

    boolean needPeerAuth() {
        return null != this.m_trustStore;
    }

    boolean isAnonymousPermitted() {
        return !this.needPeerAuth();
    }

    public SocketFactory getSocketFactory() throws GeneralSecurityException, IOException {
        SSLContext sslContext = this.getSSLContext();
        if (null == sslContext) {
            return SocketFactory.getDefault();
        }
        return sslContext.getSocketFactory();
    }

    public static SocketFactory createSSLSocketFactory(SSLUtilValues sslValues) throws GeneralSecurityException, IOException {
        OC4JSSLSocketFactory socketFactory = new OC4JSSLSocketFactory(null, sslValues);
        return socketFactory.getSocketFactory();
    }

    protected synchronized KeyStore getKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException {
        if (null != this.m_keyStore) {
            return this.m_keyStore;
        }
        if (null == this.getConfigValues().getKeyStoreLocation()) {
            return null;
        }
        this.m_keyStore = OC4JSSLSocketFactory.getStore(this.getConfigValues().getStoreType(), this.getConfigValues().getProvider(), OC4JSSLSocketFactory.getStoreIn(this.getConfigValues().getKeyStoreLocation()), OC4JSSLSocketFactory.getPassword(this.getConfigValues().getKeyStorePassword()));
        return this.m_keyStore;
    }

    protected synchronized KeyStore getTrustStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException {
        if (null != this.m_trustStore) {
            return this.m_trustStore;
        }
        if (null == this.getConfigValues().getTrustStoreLocation()) {
            return null;
        }
        this.m_trustStore = OC4JSSLSocketFactory.getStore(this.getConfigValues().getStoreType(), this.getConfigValues().getProvider(), OC4JSSLSocketFactory.getStoreIn(this.getConfigValues().getTrustStoreLocation()), OC4JSSLSocketFactory.getPassword(this.getConfigValues().getTrustStorePassword()));
        return this.m_trustStore;
    }

    public static char[] getPassword(String password) {
        return null == password ? DEFAULT_PASSWORD : password.toCharArray();
    }

    public static char[] getPassword(char[] password) {
        return null == password ? DEFAULT_PASSWORD : password;
    }

    public static KeyStore getStore(String storeType, String provider, InputStream storeIn, char[] password) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore store = null;
        if (null == storeIn) {
            return null;
        }
        if (null == storeType) {
            storeType = KeyStore.getDefaultType();
        }
        store = null == provider ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, provider);
        store.load(storeIn, OC4JSSLSocketFactory.getPassword(password));
        return store;
    }

    public static InputStream getStoreIn(String fileName) throws IOException {
        if (null == fileName) {
            return null;
        }
        if (OC4JSSLSocketFactory.isURL(fileName)) {
            URL url = new URL(fileName);
            return new FileInputStream(url.getFile());
        }
        File file = new File(fileName);
        if (!file.exists() && !file.isAbsolute()) {
            fileName = SSLUtils.getJ2eeConfigDir().append(fileName).toString();
        }
        return new FileInputStream(fileName);
    }

    static boolean isURL(String fileName) {
        return fileName.indexOf("://") >= 0;
    }

    protected synchronized KeyManager[] getKeyManager() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        if (null != this.m_keyManager) {
            return this.m_keyManager;
        }
        this.m_keyManager = OC4JSSLSocketFactory.getKeyManagers(this.getKeyStore(), OC4JSSLSocketFactory.getPassword(this.getConfigValues().getKeyStorePassword()), this.getConfigValues().getStoreType(), this.getConfigValues().getProvider(), null);
        return this.m_keyManager;
    }

    public static KeyManager[] getKeyManagers(KeyStore store, char[] password, String storeType, String provider, String keyAlgorithmType) throws NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException, KeyStoreException {
        keyAlgorithmType = OC4JSSLSocketFactory.getAlgorithm(keyAlgorithmType, storeType);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyAlgorithmType);
        keyManagerFactory.init(store, OC4JSSLSocketFactory.getPassword(password));
        return keyManagerFactory.getKeyManagers();
    }

    protected synchronized TrustManager[] getTrustManager() throws NoSuchAlgorithmException, NoSuchProviderException, IOException, CertificateException, KeyStoreException {
        if (null != this.m_trustManager) {
            return this.m_trustManager;
        }
        SSLUtils.Values sslVals = this.getConfigValues();
        this.m_trustManager = null == this.getTrustStore() ? (null == sslVals.getNeedsClientAuth() || !Boolean.valueOf(sslVals.getNeedsClientAuth()).booleanValue() ? new TrustManager[]{new TrustingManager()} : OC4JSSLSocketFactory.getTrustManagers(this.getKeyStore(), OC4JSSLSocketFactory.getPassword(sslVals.getKeyStorePassword()), sslVals.getStoreType(), sslVals.getProvider(), null)) : OC4JSSLSocketFactory.getTrustManagers(this.getTrustStore(), OC4JSSLSocketFactory.getPassword(this.getConfigValues().getTrustStorePassword()), sslVals.getStoreType(), sslVals.getProvider(), null);
        return this.m_trustManager;
    }

    public static TrustManager[] getTrustManagers(KeyStore store, char[] password, String storeType, String provider, String _keyAlgorithmType) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        if (null == store) {
            return null;
        }
        String trustAlgorithmType = OC4JSSLSocketFactory.getAlgorithm(_keyAlgorithmType, storeType);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustAlgorithmType);
        trustManagerFactory.init(store);
        return trustManagerFactory.getTrustManagers();
    }

    static String getAlgorithm(String algorithm, String storeType) {
        if (null == algorithm) {
            algorithm = null != storeType && storeType.equalsIgnoreCase(PKCS12) ? DEFAULT_ORACLE_KEY_ALGORITHM : KeyManagerFactory.getDefaultAlgorithm();
        }
        return algorithm;
    }

    protected synchronized SSLContext getSSLContext() throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        if (null != this.m_sslContext) {
            return this.m_sslContext;
        }
        this.initSecurityProvider();
        this.m_sslContext = OC4JSSLSocketFactory.getSSLContext(DEFAULT_PROTOCOL, this.getConfigValues().getProvider(), this.getKeyManager(), this.getTrustManager());
        return this.m_sslContext;
    }

    public static SSLContext getSSLContext(String protocol, String provider, KeyManager[] keyManagers, TrustManager[] trustManagers) throws KeyManagementException, NoSuchAlgorithmException {
        if (null == protocol) {
            protocol = DEFAULT_PROTOCOL;
        }
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    void initSecurityProvider() throws IOException {
        if (null == this.getConfigValues().getStoreType() && this.isWalletFileType()) {
            this.getConfigValues().setProperty("ssl.storeType", PKCS12);
            if (null == this.getConfigValues().getProvider()) {
                this.getConfigValues().setProperty("ssl.provider", ORACLE_SECURITY_PROVIDER);
            }
        }
        if (this.isInitializationNeeded()) {
            this.getConfigValues().setProperty("ssl.provider", OC4JSSLSocketFactory.createSecurityProvider(this.getConfigValues().getProvider()).getName());
        }
    }

    boolean isInitializationNeeded() {
        return null != this.getConfigValues().getProvider() && this.getConfigValues().getProvider().indexOf(46) > 0;
    }

    boolean isWalletFileType() {
        return OC4JSSLSocketFactory.isWalletFileType(this.getConfigValues().getKeyStoreLocation(), this.getConfigValues().getTrustStoreLocation());
    }

    public static boolean isWalletFileType(String keyStorePath, String trustStorePath) {
        return null != keyStorePath && keyStorePath.endsWith(WALLET_FILE_EXT) || null != trustStorePath && trustStorePath.endsWith(WALLET_FILE_EXT);
    }

    public static Provider createSecurityProvider(String providerName) throws IOException {
        if (null == providerName) {
            return null;
        }
        Provider provider = null;
        try {
            Class<?> spClass = Class.forName(providerName);
            provider = (Provider)spClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("unable to initialize security provider class: " + providerName);
        }
        if (null == Security.getProvider(provider.getName())) {
            s_logger.log(Level.FINE, "initializing security provider: {0}", provider);
            Security.addProvider(provider);
        }
        return provider;
    }

    public boolean verify(String s, SSLSession sslSession) {
        return true;
    }

    private static class TrustingManager
    implements TrustManager,
    X509TrustManager {
        private TrustingManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

