/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.security.AccessController;
import oracle.oc4j.security.DelegatingSecurityManager;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.OC4JSecurityStrategy;

public class OC4JSecurityStrategyInternalCaller
implements OC4JSecurityStrategy {
    private DelegatingSecurityManager m_dsm;
    private Class m_ignoreClazz;

    public OC4JSecurityStrategyInternalCaller(DelegatingSecurityManager dsm, Class ignoreClazz) {
        this.m_dsm = dsm;
        this.m_ignoreClazz = ignoreClazz;
    }

    private static Object internalDoPrivileged(OC4JPrivilegedAction action) throws Exception {
        return AccessController.doPrivileged(action);
    }

    public boolean isUnsafe() {
        return OC4JSecurityStrategyInternalCaller.isUnsafe(this.m_ignoreClazz, this.m_dsm.getClassContext());
    }

    static boolean isUnsafe(Class ignoreClazz, Class[] classCallStack) {
        Class callerClass;
        Class ourClass = classCallStack[1];
        int i = 2;
        do {
            callerClass = classCallStack[i++];
        } while (i < classCallStack.length && (callerClass == ourClass || callerClass == ignoreClazz));
        while (i < classCallStack.length && (callerClass == classCallStack[i] || callerClass == ignoreClazz)) {
            ++i;
        }
        Class unknownClass = i >= classCallStack.length ? null : classCallStack[i];
        Context ctx = new Context();
        try {
            ctx.get(ourClass, callerClass, unknownClass);
        }
        catch (Exception e) {
            OC4JSecurity.s_logger.throwing(OC4JSecurity.class.toString(), Context.class + ".get()", e);
            return true;
        }
        boolean isUnsafe = ctx.callerClassLoader != ctx.ourClassLoader || ctx.unknownClassLoader != null && ctx.unknownClassLoader != ctx.ourClassLoader;
        return isUnsafe;
    }

    public void assertIsSafeContext() {
        boolean safe = this.isSafeContext();
        if (!safe) {
            throw new SecurityException("untrusted call context");
        }
    }

    public boolean isSafeContext() {
        return !this.isUnsafe();
    }

    private static final class Context {
        ClassLoader ourClassLoader;
        ClassLoader callerClassLoader;
        ClassLoader unknownClassLoader;

        private Context() {
        }

        public void get(final Class ourClass, final Class callerClass, final Class unknownClass) throws Exception {
            if (OC4JSecurity.isSecurityOn()) {
                OC4JSecurityStrategyInternalCaller.internalDoPrivileged(new OC4JPrivilegedAction(){

                    public Object oc4jRun() throws Exception {
                        ourClassLoader = ourClass.getClassLoader();
                        callerClassLoader = callerClass.getClassLoader();
                        unknownClassLoader = null == unknownClass ? null : unknownClass.getClassLoader();
                        return null;
                    }
                });
            } else {
                this.ourClassLoader = ourClass.getClassLoader();
                this.callerClassLoader = callerClass.getClassLoader();
                this.unknownClassLoader = null == unknownClass ? null : unknownClass.getClassLoader();
            }
        }
    }
}

