/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.HashMap;
import oracle.oc4j.security.SigningAlias;
import oracle.oc4j.security.SigningKey;

public final class SigningContext {
    private HashMap m_aliasToKeyMap;
    private SigningAlias m_singleton_alias;
    private SigningKey m_singleton_key;

    SigningContext() {
        this.m_aliasToKeyMap = new HashMap();
    }

    SigningContext(String contextId, String signer, byte[] signerSecret) {
        this.m_singleton_alias = new SigningAlias(contextId, signer);
        this.m_singleton_key = new SigningKey(signerSecret);
    }

    SigningContext(String contextId, String signer, PrivateKey privKey, PublicKey pubKey) {
        this.m_singleton_alias = new SigningAlias(contextId, signer);
        this.m_singleton_key = new SigningKey(privKey, pubKey);
    }

    public static SigningContext create(String contextId, String signer, byte[] signerSecret) throws SignatureException {
        return new SigningContext(contextId, signer, signerSecret);
    }

    public static SigningContext create(String contextId, String signer, PrivateKey privKey, PublicKey pubKey) throws SignatureException {
        return new SigningContext(contextId, signer, privKey, pubKey);
    }

    void registerContext(SigningContext userContext) throws SignatureException {
        this.registerContext(userContext.m_singleton_alias, userContext.m_singleton_key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerContext(SigningAlias key, SigningKey secret) throws SignatureException {
        if (null == key || null == secret) {
            throw new SignatureException("invalid arguments");
        }
        HashMap hashMap = this.m_aliasToKeyMap;
        synchronized (hashMap) {
            if (null != this.m_aliasToKeyMap.put(key, secret)) {
                throw new SignatureException(key + " has already been registered");
            }
        }
    }

    public SigningAlias getAlias() {
        return this.m_singleton_alias;
    }

    SigningKey getKey() {
        return this.m_singleton_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SigningKey getKey(SigningAlias key) {
        HashMap hashMap = this.m_aliasToKeyMap;
        synchronized (hashMap) {
            return (SigningKey)this.m_aliasToKeyMap.get(key);
        }
    }
}

