/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.server;

import java.util.Map;
import oracle.dms.spy.Spy;
import oracle.oc4j.api.MetricCollector;

public class DMSMetricCollector
implements MetricCollector {
    public static final String KEY_HISTORY_PROPORTION = "history-proportion";
    public static final float DEFAULT_HISTORY_PROPORTION = 0.33333334f;
    private float m_historyProportion = 0.33333334f;
    public static final String KEY_DMS_NOUN = "dms-noun";
    public static final String KEY_CUMULATIVE = "cumulative";
    public static final String KEY_LOWER_BETTER = "lower-better";
    public static final String KEY_RANGE_MEDIAN_PROPERTY = "range-median";
    public static final String KEY_DEBUG = "debug";
    boolean m_debug = false;
    private String m_dmsNoun;
    private boolean m_cumulative = true;
    private boolean m_lowerBetter = true;
    private boolean m_rangeMedian;
    float m_range;
    private float m_previousDmsMeasurement = -1.0f;
    private boolean m_enabled = false;
    private boolean m_configured = false;
    private boolean m_warned = false;
    private int m_previousMetric = -1;

    public void setParameters(Map params) throws IllegalArgumentException {
        String sLowerBetter;
        if (params == null) {
            String err = "No parameters specified for DMSMetricCollector";
            System.err.println(err);
            throw new IllegalArgumentException(err);
        }
        if (DEBUG) {
            this.m_debug = true;
        } else {
            String sDebug = (String)params.get(KEY_DEBUG);
            if (sDebug != null && sDebug.length() > 0) {
                this.m_debug = Boolean.valueOf(sDebug);
            }
        }
        String historyProportionString = (String)params.get(KEY_HISTORY_PROPORTION);
        if (this.m_debug) {
            System.out.println("DMSMetricCollector: parameter history-proportion is " + historyProportionString);
        }
        if (historyProportionString != null) {
            try {
                float historyProportion = Float.parseFloat(historyProportionString);
                if (historyProportion <= 0.0f) {
                    String err = "DMSMetricCollector: parameter " + historyProportionString + " is incorrect (should be a floating point value between 0.0 and 1.0)";
                    System.err.println(err);
                    throw new IllegalArgumentException(err);
                }
                this.m_historyProportion = historyProportion;
            }
            catch (NumberFormatException e) {
                System.err.println("LatencyMetricCollector: parameter " + historyProportionString + " is incorrect (should be a floating point value between 0.0 and 1.0)");
            }
        }
        this.m_dmsNoun = (String)params.get(KEY_DMS_NOUN);
        if (this.m_dmsNoun == null || this.m_dmsNoun.length() == 0) {
            String err = "DMSMetricCollector:dms-noun not supplied";
            System.err.println(err);
            throw new IllegalArgumentException(err);
        }
        String sCumulative = (String)params.get(KEY_CUMULATIVE);
        if (sCumulative != null && sCumulative.length() > 0) {
            this.m_cumulative = Boolean.valueOf(sCumulative);
        }
        if ((sLowerBetter = (String)params.get(KEY_LOWER_BETTER)) != null && sLowerBetter.length() > 0) {
            this.m_lowerBetter = Boolean.valueOf(sLowerBetter);
        }
        this.m_previousMetric = 50;
        this.m_previousDmsMeasurement = -1.0f;
        this.m_configured = true;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_debug) {
            System.out.println("DMSMetricCollector.setEnabled to " + enabled);
        }
        this.m_enabled = enabled;
    }

    private float getMeasurementFromDMS() {
        Number value = (Number)Spy.getMetricValue((String)this.m_dmsNoun);
        if (this.m_debug) {
            System.out.println("DMSMetricCollector: raw measurement for " + this.m_dmsNoun + " is " + value);
        }
        if (value == null) {
            System.err.println("DMSMetricCollector: null returned for the DMS metric:" + this.m_dmsNoun);
            return -1.0f;
        }
        float fValue = value.floatValue();
        return fValue;
    }

    public int getMetric() {
        if (!this.m_configured && !this.m_warned) {
            if (!this.m_warned) {
                System.err.println("The DMSMetricCollector.getMetric() called, but configuration not done. Skipping.");
                this.m_warned = true;
            }
            return -1;
        }
        float dmsValue = this.getMeasurementFromDMS();
        if (dmsValue < 0.0f) {
            return -1;
        }
        float dmsAdjustedValue = dmsValue;
        if (this.m_cumulative) {
            if (this.m_previousDmsMeasurement < 0.0f) {
                if (this.m_debug) {
                    System.out.println("Previous measurement was not available for cumulative setting. Acquired and recorded for next metric.");
                }
                this.m_previousDmsMeasurement = dmsValue;
                return -1;
            }
            dmsAdjustedValue -= this.m_previousDmsMeasurement;
        }
        double normalized = Math.log(1.0f + dmsAdjustedValue);
        normalized = 1.0 / (1.0 + normalized);
        if (!this.m_lowerBetter) {
            normalized = 1.0 - normalized;
        }
        int metricThisRound = (int)Math.round(100.0 * normalized);
        if (this.m_historyProportion > 0.0f && this.m_previousMetric < 0) {
            if (this.m_debug) {
                System.out.println("Previous metric was not available. Acquired and recorded for next metric.");
            }
            this.m_previousMetric = metricThisRound;
            return -1;
        }
        int returnedMetric = Math.round((1.0f - this.m_historyProportion) * (float)metricThisRound + this.m_historyProportion * (float)this.m_previousMetric);
        if (this.m_debug) {
            System.out.println("Metric: dmsValue=" + dmsValue);
            System.out.println("Metric: normalized=" + normalized);
            System.out.println("Metric: previous metric=" + this.m_previousMetric);
            System.out.println("Metric: metric this round=" + metricThisRound);
        }
        this.m_previousMetric = returnedMetric;
        this.m_previousDmsMeasurement = dmsValue;
        return returnedMetric;
    }
}

