/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.sql.Connection;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnection;
import oracle.j2ee.util.TraceLogger;

public class ManagedDataSourceDebugInfo {
    private static Object m_countLockObject = new Object();
    private static Logger m_logger = TraceLogger.getLogger(ManagedDataSourceDebugInfo.class);
    private static int m_unclosedConnectionCount = 0;
    private static int m_connectionsOpenedCount = 0;
    private static int m_connectionsClosedCount = 0;
    private static int m_physicalConnectionsActiveCount = 0;
    private static int m_physicalConnectionsObtainedCount = 0;
    private static int m_physicalConnectionsReleasedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened(Connection connection) {
        Object object = m_countLockObject;
        synchronized (object) {
            m_logger.finer("connectionOpened : " + connection.toString() + " : opened " + ++m_connectionsOpenedCount + " : unclosed " + ++m_unclosedConnectionCount + " : thread=" + Thread.currentThread().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Object object = m_countLockObject;
        synchronized (object) {
            m_logger.finer("connectionClosed : " + connection.toString() + " : closed " + ++m_connectionsClosedCount + " : unclosed " + --m_unclosedConnectionCount + " : thread=" + Thread.currentThread().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalConnectionObtained(ManagedConnection connection) {
        Object object = m_countLockObject;
        synchronized (object) {
            m_logger.finer("physicalConnectionObtained : " + connection.toString() + "  : obtained " + ++m_physicalConnectionsObtainedCount + " : active " + ++m_physicalConnectionsActiveCount + " : thread=" + Thread.currentThread().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalConnectionReleased(ManagedConnection connection) {
        Object object = m_countLockObject;
        synchronized (object) {
            m_logger.finer("physicalConnectionReleased : " + connection.toString() + " : released " + ++m_physicalConnectionsReleasedCount + " : active " + --m_physicalConnectionsActiveCount + " : thread=" + Thread.currentThread().toString());
        }
    }
}

