/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import com.evermind.security.SecuritySensitive;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.DataSource;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.config.PropertyConfig;

public class NativeDataSourceWrapper
implements DataSource,
Serializable {
    public static final String PROPERTY_NAME_WRAPPED_DATA_SOURCE_CLASS = "wrappedDataSourceClass";
    private transient DataSource m_wrappedDataSource = null;
    private String m_user = null;
    private String m_password = null;
    private String m_url = null;
    private int m_loginTimeout = 0;
    private String m_wrappedDataSourceClass = null;
    private PropertyConfig[] m_properties = new PropertyConfig[0];

    public Connection getConnection() throws SQLException {
        if (this.m_wrappedDataSource == null) {
            throw new SQLException("The wrapped data source is null.");
        }
        return this.m_wrappedDataSource.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.m_wrappedDataSource == null) {
            throw new SQLException("The wrapped data source is null.");
        }
        return this.m_wrappedDataSource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.m_wrappedDataSource == null) {
            throw new SQLException("The wrapped data source is null.");
        }
        return this.m_wrappedDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.m_wrappedDataSource == null) {
            throw new SQLException("The wrapped data source is null.");
        }
        this.m_wrappedDataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.m_wrappedDataSource == null) {
            throw new SQLException("The wrapped data source is null.");
        }
        this.m_loginTimeout = seconds;
        this.m_wrappedDataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_loginTimeout;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) throws DataSourceException {
        this.m_user = user;
        DataSourceUtils.setUser(this.m_wrappedDataSource, user);
    }

    public void setPassword(String password) throws DataSourceException {
        this.m_password = password;
        SecuritySensitive securitySensitive = SecuritySensitive.global();
        if (securitySensitive != null) {
            password = securitySensitive.decode(password, null);
        }
        DataSourceUtils.setPassword(this.m_wrappedDataSource, password);
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) throws DataSourceException {
        this.m_url = url;
        DataSourceUtils.setUrl(this.m_wrappedDataSource, url);
    }

    public DataSource getWrappedDataSource() {
        return this.m_wrappedDataSource;
    }

    public void setWrappedDataSource(DataSource wrappedDataSource) {
        if (wrappedDataSource == null) {
            throw new IllegalArgumentException("The wrapped data source cannot be null.");
        }
        this.m_wrappedDataSource = wrappedDataSource;
    }

    public void setWrappedDataSourceClass(String wrappedDataSourceClass) throws DataSourceException {
        if (wrappedDataSourceClass == null || wrappedDataSourceClass.length() == 0) {
            throw new IllegalArgumentException("The wrapped data source class cannot be empty.");
        }
        this.m_wrappedDataSourceClass = wrappedDataSourceClass;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(wrappedDataSourceClass, true, loader);
            Object object = clazz.newInstance();
            if (!(object instanceof DataSource)) {
                throw new DataSourceException(wrappedDataSourceClass + " is not an instance of javax.sql.DataSource.");
            }
            this.m_wrappedDataSource = (DataSource)object;
        }
        catch (ClassNotFoundException e) {
            throw new DataSourceException("ClassNotFoundException for: " + wrappedDataSourceClass, e);
        }
        catch (InstantiationException e) {
            throw new DataSourceException("InstantiationException for: " + wrappedDataSourceClass, e);
        }
        catch (IllegalAccessException e) {
            throw new DataSourceException("IllegalAccessException for: " + wrappedDataSourceClass, e);
        }
    }

    public PropertyConfig[] getProperties() {
        return this.m_properties;
    }

    public void setProperties(PropertyConfig[] properties) throws DataSourceException {
        boolean found = false;
        Vector<PropertyConfig> tempProps = new Vector<PropertyConfig>();
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].getName().equals(PROPERTY_NAME_WRAPPED_DATA_SOURCE_CLASS)) {
                this.setWrappedDataSourceClass(properties[i].getValue());
                found = true;
                continue;
            }
            tempProps.add(properties[i]);
        }
        if (!found) {
            throw new DataSourceException("Missing wrappedDataSourceClass property for native data source.");
        }
        PropertyConfig[] newProperties = new PropertyConfig[tempProps.size()];
        tempProps.toArray(newProperties);
        this.m_properties = newProperties;
        this.setProperties();
    }

    private void setProperties() throws DataSourceException {
        DataSourceUtils.setProperties(this.m_wrappedDataSource, this.m_properties);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        try {
            this.setWrappedDataSourceClass(this.m_wrappedDataSourceClass);
            this.setUser(this.getUser());
            this.setPassword(this.getPassword());
            this.setUrl(this.getUrl());
            this.setLoginTimeout(this.getLoginTimeout());
            this.setProperties();
        }
        catch (DataSourceException e) {
            throw new IOException(e.toString());
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }
}

