/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.JDBCDriver;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.ConnectionPropertiesConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.ErrorCodeConfig;
import oracle.oc4j.sql.config.FatalErrorCodesConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.config.ProxyInterfaceConfig;
import oracle.oc4j.sql.config.XARecoveryConfig;
import oracle.oc4j.sql.mbean.ConnectionFactoryJDBCDriverCallBack;
import oracle.oc4j.sql.mbean.ConnectionFactoryJDBCDriverMBean;

public class ConnectionFactoryJDBCDriver
extends JDBCDriver
implements ConnectionFactoryJDBCDriverMBean {
    private ConnectionFactoryJDBCDriverCallBack m_callBack;
    private Object m_connectionFactory;
    private ConnectionFactoryConfig m_connectionFactoryConfig;

    public ConnectionFactoryJDBCDriver(String name, ConnectionFactoryJDBCDriverCallBack callBack) throws IllegalArgumentException {
        super(name, callBack.getJ2EEApplicationCallBackIf());
        this.init(callBack);
    }

    private ConnectionFactoryJDBCDriver(Locale locale, ConnectionFactoryJDBCDriverCallBack callBack) {
        super(locale);
        this.init(callBack);
    }

    public ModelMBeanInfo getMBeanInfo(Locale locale) {
        try {
            return ModelMBeanFactory.getModelMBeanInfo(new ConnectionFactoryJDBCDriver(locale, this.m_callBack));
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void init(ConnectionFactoryJDBCDriverCallBack callBack) throws IllegalArgumentException {
        if (callBack == null) {
            throw new IllegalArgumentException("The connection factory callback cannot be null.");
        }
        this.m_callBack = callBack;
        if (this.m_callBack.getConnectionFactory() == null) {
            throw new IllegalArgumentException("The data source connection factory cannot be null.");
        }
        this.m_connectionFactoryConfig = this.m_callBack.getConnectionFactory().getConnectionFactoryConfig();
        if (this.m_connectionFactoryConfig == null) {
            throw new IllegalArgumentException("The connection factory configuration cannot be null.");
        }
        if (this.m_callBack.getDataSourceConnectionPool() == null) {
            throw new IllegalArgumentException("The data source connection pool configuration cannot be null.");
        }
        this.m_connectionFactory = this.m_callBack.getConnectionFactory().getConnectionFactory();
        if (this.m_connectionFactory == null) {
            throw new IllegalArgumentException("The connection factory cannot be null.");
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("factoryClass", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_FactoryClass"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("user", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_User"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("password", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_Password"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("url", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_Url"), true, true, false), ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("loginTimeout", "java.lang.Integer", this.getLocalizedMessage("connectionfactoryjdbcdriver_LoginTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("proxyInterfaceSQLObjects", "[Ljava.lang.String;", this.getLocalizedMessage("connectionfactoryjdbcdriver_ProxyInterfaceSQLObjects"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("xaRecoveryUsername", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_xaRecoveryUsername"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("xaRecoveryPassword", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_xaRecoveryPassword"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addProperty", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("jdbc_addProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setProperty", this.getLocalizedMessage("connectionfactoryjdbcdriver_setProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("jdbc_removeProperty_propertyName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeProperty", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getProperties", this.getLocalizedMessage("connectionfactoryjdbcdriver_getProperties"), null, Map.class.getName(), 0), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("properties", "java.util.Map", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceproperties_properties"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("replaceProperties", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceProperties"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getProxyInterfaces", this.getLocalizedMessage("connectionfactoryjdbcdriver_getProxyInterfaces"), null, Map.class.getName(), 0), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlObject", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProxyInterface_sqlObject")), new MBeanParameterInfo("theInterface", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProxyInterface_interface"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addProxyInterface", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProxyInterface"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlObject", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProxyInterface_sqlObject")), new MBeanParameterInfo("theInterface", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addProxyInterface_interface"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeProxyInterface", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeProxyInterface"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params[0] = new MBeanParameterInfo("proxyInterfaces", "java.util.Map", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceproxyInterfaces_proxyInterfaces"));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("replaceProxyInterfaces", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceProxyInterfaces"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement")), new MBeanParameterInfo("user", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_user")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_password"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("code", "java.lang.Integer", this.getLocalizedMessage("connectionfactoryjdbcdriver_addFatalErrorCode_code"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addFatalErrorCode", this.getLocalizedMessage("connectionfactoryjdbcdriver_addFatalErrorCode"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("code", "java.lang.Integer", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeFatalErrorCode_code"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeFatalErrorCode", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeFatalErrorCode"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getFatalErrorCodes", this.getLocalizedMessage("connectionfactoryjdbcdriver_getFatalErrorCodes"), null, "[Ljava.lang.Integer;", 0), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("codes", "[Ljava.lang.Integer;", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceFatalErrorCodes_codes"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("replaceFatalErrorCodes", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceFatalErrorCodes"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addConnectionProperty_name")), new MBeanParameterInfo("value", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_addConnectionProperty_value"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addConnectionProperty", this.getLocalizedMessage("connectionfactoryjdbcdriver_addConnectionProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeConnectionPropety_name"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeConnectionProperty", this.getLocalizedMessage("connectionfactoryjdbcdriver_removeConnectionProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getConnectionProperties", this.getLocalizedMessage("connectionfactoryjdbcdriver_getConnectionProperties"), null, "java.util.HashMap", 0), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("connectionProperties", "java.util.HashMap", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceConnectionProperties_connectionProperties"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("replaceConnectionProperties", this.getLocalizedMessage("connectionfactoryjdbcdriver_replaceConnectionProperties"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
    }

    public synchronized void addProperty(String propertyName, String propertyValue) throws MBeanException {
        try {
            this.m_connectionFactoryConfig.addPropertyConfig(new PropertyConfig(propertyName, propertyValue));
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setProperty(String propertyName, String propertyValue) throws MBeanException {
        this.setProperty(this.m_connectionFactory, propertyName, propertyValue);
    }

    public synchronized void removeProperty(String propertyName) throws MBeanException {
        this.m_connectionFactoryConfig.removePropertyConfig(propertyName);
    }

    public Map getProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        PropertyConfig[] properties = this.m_connectionFactoryConfig.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            map.put(properties[i].getName(), properties[i].getValue());
        }
        return map;
    }

    public synchronized void replaceProperties(Map properties) throws DataSourceConfigException, MBeanException {
        if (properties != null) {
            int numProperties = properties.size();
            int propertyNum = 0;
            PropertyConfig[] propertyConfigs = new PropertyConfig[numProperties];
            Iterator iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)properties.get(name);
                propertyConfigs[propertyNum++] = new PropertyConfig(name, value);
            }
            this.m_connectionFactoryConfig.setProperties(propertyConfigs);
            for (int i = 0; i < propertyConfigs.length; ++i) {
                this.setProperty(propertyConfigs[i].getName(), propertyConfigs[i].getValue());
            }
        }
    }

    public Map getProxyInterfaces() {
        LinkedHashMap<String, Vector<String>> vectorMap = new LinkedHashMap<String, Vector<String>>();
        ProxyInterfaceConfig[] proxyInterfaceConfigs = this.m_connectionFactoryConfig.getProxyInterfaces();
        for (int i = 0; i < proxyInterfaceConfigs.length; ++i) {
            String sqlObject = proxyInterfaceConfigs[i].getSqlObject();
            Vector<String> theInterfaces = (Vector<String>)vectorMap.get(sqlObject);
            if (theInterfaces == null) {
                theInterfaces = new Vector<String>();
            }
            theInterfaces.add(proxyInterfaceConfigs[i].getInterface());
            vectorMap.put(sqlObject, theInterfaces);
        }
        LinkedHashMap<String, Object[]> arrayMap = new LinkedHashMap<String, Object[]>();
        Iterator iter = vectorMap.keySet().iterator();
        while (iter.hasNext()) {
            String sqlObject = (String)iter.next();
            Vector theInterfaces = (Vector)vectorMap.get(sqlObject);
            arrayMap.put(sqlObject, theInterfaces.toArray());
        }
        return arrayMap;
    }

    public synchronized void addProxyInterface(String sqlObject, String theInterface) throws MBeanException {
        try {
            this.m_connectionFactoryConfig.addProxyInterfaceConfig(new ProxyInterfaceConfig(sqlObject, theInterface));
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void removeProxyInterface(String sqlObject, String theInterface) throws MBeanException {
        this.m_connectionFactoryConfig.removeProxyInterfaceConfig(sqlObject, theInterface);
    }

    public synchronized void replaceProxyInterfaces(Map proxyInterfaces) throws DataSourceConfigException, MBeanException {
        if (proxyInterfaces != null) {
            int i;
            Vector<ProxyInterfaceConfig> proxyInterfacesVector = new Vector<ProxyInterfaceConfig>();
            Iterator iter = proxyInterfaces.keySet().iterator();
            while (iter.hasNext()) {
                String sqlObject = (String)iter.next();
                Object[] theInterfaces = (Object[])proxyInterfaces.get(sqlObject);
                for (i = 0; i < theInterfaces.length; ++i) {
                    proxyInterfacesVector.add(new ProxyInterfaceConfig(sqlObject, (String)theInterfaces[i]));
                }
            }
            int count = proxyInterfacesVector.size();
            ProxyInterfaceConfig[] configs = new ProxyInterfaceConfig[count];
            for (i = 0; i < count; ++i) {
                configs[i] = (ProxyInterfaceConfig)proxyInterfacesVector.get(i);
            }
            this.m_connectionFactoryConfig.setProxyInterfaces(configs);
        }
    }

    public String[] getproxyInterfaceSQLObjects() {
        return DataSourceUtils.getproxyInterfaceSQLObjects();
    }

    public String testConnection(String sqlStatement) {
        return this.m_callBack.getConnectionFactory().testConnection(sqlStatement);
    }

    public String testConnection(String sqlStatement, String user, String password) {
        return this.m_callBack.getConnectionFactory().testConnection(sqlStatement, user, password);
    }

    public String getfactoryClass() {
        return this.m_connectionFactoryConfig.getFactoryClass();
    }

    public String getuser() {
        return this.m_connectionFactoryConfig.getUser();
    }

    public synchronized void setuser(String user) throws MBeanException {
        try {
            DataSourceUtils.setUser(this.m_connectionFactory, user);
            this.m_connectionFactoryConfig.setUser(user);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String getpassword() {
        return this.m_connectionFactoryConfig.getPassword();
    }

    public synchronized void setpassword(String password) throws MBeanException {
        try {
            DataSourceUtils.setPassword(this.m_connectionFactory, password);
            this.m_connectionFactoryConfig.setPassword(password);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String geturl() {
        return this.m_connectionFactoryConfig.getUrl();
    }

    public synchronized void seturl(String url) throws MBeanException {
        try {
            DataSourceUtils.setUrl(this.m_connectionFactory, url);
            this.m_connectionFactoryConfig.setUrl(url);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public int getloginTimeout() throws MBeanException {
        try {
            return this.m_connectionFactoryConfig.getLoginTimeout();
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setloginTimeout(Integer loginTimeout) throws MBeanException {
        try {
            this.setProperty(this.m_connectionFactory, "loginTimeout", loginTimeout.toString());
            this.m_connectionFactoryConfig.setLoginTimeout(loginTimeout);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String getxaRecoveryUsername() {
        XARecoveryConfig xaRecoveryConfig = this.m_connectionFactoryConfig.getXARecoveryConfig();
        if (xaRecoveryConfig == null) {
            return null;
        }
        return xaRecoveryConfig.getUsername();
    }

    public synchronized void setxaRecoveryUsername(String username) throws MBeanException {
        try {
            XARecoveryConfig xaRecoveryConfig = this.m_connectionFactoryConfig.getXARecoveryConfig();
            if (xaRecoveryConfig == null) {
                xaRecoveryConfig = new XARecoveryConfig(username, "");
            } else {
                xaRecoveryConfig.setUsername(username);
            }
            this.m_connectionFactoryConfig.setXARecoveryConfig(xaRecoveryConfig);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public String getxaRecoveryPassword() {
        XARecoveryConfig xaRecoveryConfig = this.m_connectionFactoryConfig.getXARecoveryConfig();
        if (xaRecoveryConfig == null) {
            return null;
        }
        return xaRecoveryConfig.getPassword();
    }

    public synchronized void setxaRecoveryPassword(String password) throws MBeanException {
        try {
            XARecoveryConfig xaRecoveryConfig = this.m_connectionFactoryConfig.getXARecoveryConfig();
            if (xaRecoveryConfig == null) {
                xaRecoveryConfig = new XARecoveryConfig("", password);
            } else {
                xaRecoveryConfig.setPassword(password);
            }
            this.m_connectionFactoryConfig.setXARecoveryConfig(xaRecoveryConfig);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void addFatalErrorCode(Integer code) throws MBeanException {
        try {
            FatalErrorCodesConfig fecc = this.m_connectionFactoryConfig.getFatalErrorCodesConfig();
            fecc.addErrorCode(code);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void removeFatalErrorCode(Integer code) throws MBeanException {
        try {
            FatalErrorCodesConfig fecc = this.m_connectionFactoryConfig.getFatalErrorCodesConfig();
            fecc.removeErrorCode(code);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized Integer[] getFatalErrorCodes() {
        FatalErrorCodesConfig fecc = this.m_connectionFactoryConfig.getFatalErrorCodesConfig();
        ErrorCodeConfig[] ecc = fecc.getErrorCodes();
        Integer[] errorCodes = new Integer[ecc.length];
        for (int i = 0; i < ecc.length; ++i) {
            errorCodes[i] = new Integer(ecc[i].getCode());
        }
        return errorCodes;
    }

    public synchronized void replaceFatalErrorCodes(Integer[] codes) throws MBeanException {
        try {
            FatalErrorCodesConfig fecc = this.m_connectionFactoryConfig.getFatalErrorCodesConfig();
            ErrorCodeConfig[] ecc = new ErrorCodeConfig[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                ecc[i] = new ErrorCodeConfig(codes[i]);
            }
            fecc.setErrorCodes(ecc);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void addConnectionProperty(String name, String value) throws MBeanException {
        try {
            ConnectionPropertiesConfig cpc = this.m_connectionFactoryConfig.getConnectionPropertiesConfig();
            cpc.addProperty(name, value);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void removeConnectionProperty(String name) throws MBeanException {
        try {
            ConnectionPropertiesConfig cpc = this.m_connectionFactoryConfig.getConnectionPropertiesConfig();
            cpc.removeProperty(name);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized HashMap getConnectionProperties() {
        LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
        PropertyConfig[] props = this.m_connectionFactoryConfig.getConnectionPropertiesConfig().getProperties();
        int numProps = props.length;
        for (int i = 0; i < numProps; ++i) {
            propsMap.put(props[i].getName(), props[i].getValue());
        }
        return propsMap;
    }

    public synchronized void replaceConnectionProperties(HashMap connectionProperties) throws MBeanException {
        try {
            Set entries = connectionProperties.entrySet();
            int numProps = entries.size();
            PropertyConfig[] props = new PropertyConfig[numProps];
            int propNum = 0;
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                props[propNum] = new PropertyConfig((String)entry.getKey(), (String)entry.getValue());
                ++propNum;
            }
            ConnectionPropertiesConfig cpc = this.m_connectionFactoryConfig.getConnectionPropertiesConfig();
            cpc.setProperties(props);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.m_connectionFactoryConfig;
    }
}

