/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import java.util.Locale;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.JDBCResource;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.mbean.ConnectionFactoryJDBCDriver;
import oracle.oc4j.sql.mbean.ConnectionFactoryJDBCDriverCallBack;
import oracle.oc4j.sql.mbean.ConnectionFactoryJDBCDriverCallBackImpl;
import oracle.oc4j.sql.mbean.ConnectionPoolJDBCResourceCallBack;
import oracle.oc4j.sql.mbean.ConnectionPoolJDBCResourceMBean;
import oracle.oc4j.sql.mbean.EmptyJDBCConnectionPoolStats;
import oracle.oc4j.sql.mbean.JDBCStatsImpl;
import oracle.oc4j.sql.mbean.MBeanUtils;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSource;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;

public class ConnectionPoolJDBCResource
extends JDBCResource
implements ConnectionPoolJDBCResourceMBean {
    private ConnectionPoolJDBCResourceCallBack m_callBack = null;
    private DataSourceConnectionPool m_connectionPool = null;

    public ConnectionPoolJDBCResource(String name, ConnectionPoolJDBCResourceCallBack callBack) throws IllegalArgumentException {
        super(name, callBack.getJ2EEApplicationCallBackIf());
        this.init(callBack);
    }

    private ConnectionPoolJDBCResource(Locale locale, ConnectionPoolJDBCResourceCallBack callBack) {
        super(locale);
        this.init(callBack);
    }

    public ModelMBeanInfo getMBeanInfo(Locale locale) {
        try {
            return ModelMBeanFactory.getModelMBeanInfo(new ConnectionPoolJDBCResource(locale, this.m_callBack));
        }
        catch (MBeanException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private void init(ConnectionPoolJDBCResourceCallBack callBack) throws IllegalArgumentException {
        this.m_callBack = callBack;
        if (this.m_callBack == null) {
            throw new IllegalArgumentException("The connection pool jdbc resource callback cannot be null.");
        }
        this.m_connectionPool = callBack.getConnectionPool();
        if (this.m_connectionPool == null) {
            throw new IllegalArgumentException("The connection pool cannot be null.");
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.JDBCConnectionPoolStats", this.getLocalizedMessage("connectionpooljdbcresource_stats"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jdbcDriver", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_jdbcDriver"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionPoolName", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_ConnectionPoolName"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("minConnections", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_MinConnections"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("maxConnections", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_MaxConnections"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("usedConnectionWaitTimeout", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_UsedConnectionWaitTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("inactivityTimeout", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_InactivityTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionRetryInterval", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_ConnectionRetryInterval"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("maxConnectAttempts", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_MaxConnectAttempts"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("numCachedStatements", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_NumCachedStatements"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("initialLimit", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_InitialLimit"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        if (this.m_connectionPool.isICC()) {
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("timeToLiveTimeout", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_TimeToLiveTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("validateConnection", "java.lang.Boolean", this.getLocalizedMessage("connectionpooljdbcresource_ValidateConnection"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("abandonedConnectionTimeout", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_AbandonedConnectionTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("propertyCheckInterval", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_PropertyCheckInterval"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
            this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("lowerThresholdLimit", "java.lang.Integer", this.getLocalizedMessage("connectionpooljdbcresource_LowerThresholdLimit"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        }
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("factoryClass", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_FactoryClass"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("url", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_Url"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("implicitConnectionCache", "java.lang.Boolean", this.getLocalizedMessage("connectionpooljdbcresource_ImplicitConnectionCache"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("newName", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_copyConnectionPool_newName")), new MBeanParameterInfo("newFactoryClass", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_copyConnectionPool_newFactoryClass"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("copyConnectionPool", this.getLocalizedMessage("connectionpooljdbcresource_copyConnectionPool"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("refreshConnectionPool", this.getLocalizedMessage("connectionpooljdbcresource_refreshConnectionPool"), params, "void", 1), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("deleteConnectionPool", this.getLocalizedMessage("connectionpooljdbcresource_deleteConnectionPool"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_addConnectionFactoryProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_addConnectionFactoryProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addConnectionFactoryProperty", this.getLocalizedMessage("connectionpooljdbcresource_addConnectionFactoryProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("propertyName", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_addConnectionFactoryProperty_propertyName")), new MBeanParameterInfo("propertyValue", "java.lang.String", this.getLocalizedMessage("connectionpooljdbcresource_addConnectionFactoryProperty_propertyValue"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setConnectionFactoryProperty", this.getLocalizedMessage("connectionpooljdbcresource_setConnectionFactoryProperty"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement")), new MBeanParameterInfo("user", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_user")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_password"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
    }

    private String getConnectionFactoryName() {
        return this.m_connectionPool.getName() + MBeanUtils.JDBC_DRIVER_MBEAN_NAME_SUFFIX;
    }

    public String getdisplayName() {
        return this.m_connectionPool.getName();
    }

    public synchronized void registerMBean() throws MBeanException {
        super.registerMBean();
        ConnectionFactoryJDBCDriverCallBackImpl callBack = new ConnectionFactoryJDBCDriverCallBackImpl(this.getApplicationCallBack(), this.m_connectionPool.getConnectionFactory(), this.m_connectionPool);
        ConnectionFactoryJDBCDriver mbean = new ConnectionFactoryJDBCDriver(this.getConnectionFactoryName(), (ConnectionFactoryJDBCDriverCallBack)callBack);
        mbean.registerMBean();
    }

    public synchronized void unregisterDependents() {
        try {
            this.unregisterMBeans(new ObjectName(this.getDomain() + ":j2eeType=JDBCDriver,name=" + ObjectName.quote(this.getConnectionFactoryName()) + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*"));
        }
        catch (MalformedObjectNameException e) {
            DataSourceMessages.warningUnregisterDependentsException(this.getName(), e);
            throw new JMXRuntimeException((Throwable)e);
        }
        super.unregisterDependents();
    }

    public String getjdbcDriver() throws JMXException {
        return MBeanUtils.getJdbcDriver(this.m_connectionPool.getName(), this, this.getApplicationName());
    }

    public synchronized void copyConnectionPool(String newName, String newFactoryClass) throws MBeanException {
        try {
            this.getApplicationCallBack().copyDataSourceConnectionPool(this.m_connectionPool.getName(), newName, newFactoryClass);
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void refreshConnectionPool() throws DataSourceException {
        this.m_connectionPool.refreshConnectionPool();
    }

    public synchronized void deleteConnectionPool() throws DataSourceException, MBeanException {
        this.getApplicationCallBack().removeDataSourceConnectionPool(this.m_connectionPool.getName());
    }

    public synchronized void addConnectionFactoryProperty(String propertyName, String propertyValue) throws MBeanException {
        try {
            Object connectionFactory = this.m_connectionPool.getConnectionFactory().getConnectionFactory();
            if (!DataSourceUtils.isPropertySettable(connectionFactory, propertyName)) {
                throw new MBeanException(new DataSourceException("The connection factory does not have a setter for The property: " + propertyName + "  Property names are case sensitive."));
            }
            ConnectionFactoryConfig connectionFactoryConfig = this.m_connectionPool.getConnectionFactory().getConnectionFactoryConfig();
            connectionFactoryConfig.addPropertyConfig(new PropertyConfig(propertyName, propertyValue));
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
        this.setConnectionFactoryProperty(propertyName, propertyValue);
    }

    public synchronized void setConnectionFactoryProperty(String propertyName, String propertyValue) throws MBeanException {
        this.setProperty(this.m_connectionPool.getConnectionFactory().getConnectionFactory(), propertyName, propertyValue);
    }

    public String testConnection(String sqlStatement) {
        return this.m_connectionPool.getConnectionFactory().testConnection(sqlStatement);
    }

    public String testConnection(String sqlStatement, String user, String password) {
        return this.m_connectionPool.getConnectionFactory().testConnection(sqlStatement, user, password);
    }

    public String getconnectionPoolName() {
        return this.m_connectionPool.getName();
    }

    public int getminConnections() throws DataSourceException {
        return this.m_connectionPool.getMinConnections();
    }

    public synchronized void setminConnections(Integer minConnections) throws DataSourceException, MBeanException {
        this.m_connectionPool.setMinConnections(minConnections);
    }

    public int getmaxConnections() throws DataSourceException {
        return this.m_connectionPool.getMaxConnections();
    }

    public synchronized void setmaxConnections(Integer maxConnections) throws DataSourceException, MBeanException {
        this.m_connectionPool.setMaxConnections(maxConnections);
    }

    public int getinitialLimit() throws DataSourceException {
        return this.m_connectionPool.getInitialLimit();
    }

    public synchronized void setinitialLimit(Integer limit) throws DataSourceException, MBeanException {
        this.m_connectionPool.setInitialLimit(limit);
    }

    public int getusedConnectionWaitTimeout() throws DataSourceException {
        return this.m_connectionPool.getUsedConnectionWaitTimeout();
    }

    public synchronized void setusedConnectionWaitTimeout(Integer timeout) throws DataSourceException, MBeanException {
        this.m_connectionPool.setUsedConnectionWaitTimeout(timeout);
    }

    public int getinactivityTimeout() throws DataSourceException {
        return this.m_connectionPool.getInactivityTimeout();
    }

    public synchronized void setinactivityTimeout(Integer timeout) throws DataSourceException, MBeanException {
        this.m_connectionPool.setInactivityTimeout(timeout);
    }

    public int getlowerThresholdLimit() throws DataSourceException {
        return this.m_connectionPool.getLowerThresholdLimit();
    }

    public synchronized void setlowerThresholdLimit(Integer lowerThresholdLimit) throws DataSourceException, MBeanException {
        this.m_connectionPool.setLowerThresholdLimit(lowerThresholdLimit);
    }

    public int getconnectionRetryInterval() throws DataSourceException {
        return this.m_connectionPool.getConnectionRetryInterval();
    }

    public synchronized void setconnectionRetryInterval(Integer interval) throws DataSourceException, MBeanException {
        this.m_connectionPool.setConnectionRetryInterval(interval);
    }

    public int getmaxConnectAttempts() throws DataSourceException {
        return this.m_connectionPool.getMaxConnectAttempts();
    }

    public synchronized void setmaxConnectAttempts(Integer attempts) throws DataSourceException, MBeanException {
        this.m_connectionPool.setMaxConnectAttempts(attempts);
    }

    public boolean getvalidateConnection() throws DataSourceException {
        return this.m_connectionPool.getValidateConnection();
    }

    public synchronized void setvalidateConnection(Boolean validate) throws DataSourceException, MBeanException {
        this.m_connectionPool.setValidateConnection(validate);
    }

    public int getnumCachedStatements() throws DataSourceException {
        return this.m_connectionPool.getNumCachedStatements();
    }

    public synchronized void setnumCachedStatements(Integer numStatements) throws DataSourceException, MBeanException {
        this.m_connectionPool.setNumCachedStatements(numStatements);
    }

    public int gettimeToLiveTimeout() throws DataSourceException {
        return this.m_connectionPool.getTimeToLiveTimeout();
    }

    public synchronized void settimeToLiveTimeout(Integer timeout) throws DataSourceException, MBeanException {
        this.m_connectionPool.setTimeToLiveTimeout(timeout);
    }

    public int getabandonedConnectionTimeout() throws DataSourceException {
        return this.m_connectionPool.getAbandonedConnectionTimeout();
    }

    public synchronized void setabandonedConnectionTimeout(Integer timeout) throws DataSourceException, MBeanException {
        this.m_connectionPool.setAbandonedConnectionTimeout(timeout);
    }

    public int getpropertyCheckInterval() throws DataSourceException {
        return this.m_connectionPool.getPropertyCheckInterval();
    }

    public synchronized void setpropertyCheckInterval(Integer interval) throws DataSourceException, MBeanException {
        this.m_connectionPool.setPropertyCheckInterval(interval);
    }

    public ConnectionPoolJDBCResourceCallBack getCallBack() {
        return this.m_callBack;
    }

    protected DataSourceConnectionPool getDataSourceConnectionPool() {
        return this.m_connectionPool;
    }

    public String getfactoryClass() throws DataSourceException {
        return this.m_connectionPool.getFactoryClass();
    }

    public String geturl() throws DataSourceException {
        return this.m_connectionPool.getUrl();
    }

    public synchronized void seturl(String url) throws DataSourceException, MBeanException {
        try {
            this.m_connectionPool.setUrl(url);
            this.refreshConnectionPool();
        }
        catch (DataSourceConfigException e) {
            throw new DataSourceException(e.toString(), e);
        }
    }

    public boolean getimplicitConnectionCache() {
        return this.m_connectionPool.isICC();
    }

    public boolean getstatisticsProvider() {
        return true;
    }

    public JDBCConnectionPoolStats getstats() throws MBeanException {
        EmptyJDBCConnectionPoolStats connectionPoolStats;
        ManagedJDBCDataSource managedJDBCDataSource = this.getAManagedDataSourceMBean();
        if (managedJDBCDataSource == null) {
            connectionPoolStats = new EmptyJDBCConnectionPoolStats();
        } else {
            JDBCStatsImpl jdbcStats = new JDBCStatsImpl(managedJDBCDataSource);
            connectionPoolStats = jdbcStats.getConnectionPools()[0];
        }
        return connectionPoolStats;
    }

    private ManagedJDBCDataSource getAManagedDataSourceMBean() {
        ManagedJDBCDataSource mbean = null;
        ResourceAdapterImpl resourceAdapter = this.m_connectionPool.getResourceAdapter();
        ManagedConnectionFactoryImpl[] managedConnectionFactories = resourceAdapter.getConnectionPoolConnectionFactories(this.getName());
        if (managedConnectionFactories.length > 0) {
            mbean = managedConnectionFactories[0].getManagedDataSource().getMBean();
        }
        return mbean;
    }
}

