/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.j2ee.statistics.JDBCConnectionStats;
import javax.management.j2ee.statistics.JDBCStats;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionStats;
import oracle.oc4j.sql.mbean.JDBCConnectionPoolStatsImpl;
import oracle.oc4j.sql.mbean.JDBCConnectionStatsImpl;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSource;

public class JDBCStatsImpl
extends DMSStatsImpl
implements JDBCStats {
    private transient ManagedJDBCDataSource m_jdbcDataSourceMBean;
    private JDBCConnectionStats[] m_connectionStats = null;
    private JDBCConnectionPoolStatsImpl[] m_connectionPoolStats = null;

    public JDBCStatsImpl(ManagedJDBCDataSource jdbcDataSourceMBean) {
        if (jdbcDataSourceMBean == null) {
            throw new IllegalArgumentException("The managed data source mbean cannot be null.");
        }
        this.m_jdbcDataSourceMBean = jdbcDataSourceMBean;
        this.initStats();
        this.captureStats();
    }

    private void captureStats() {
        ManagedDataSource managedDataSource = this.m_jdbcDataSourceMBean.getManagedDataSource();
        DMSJDBCConnectionStats[] dmsStats = managedDataSource.getDmsConnectionStats();
        JDBCConnectionStats[] jdbcStats = new JDBCConnectionStats[dmsStats.length];
        for (int i = 0; i < dmsStats.length; ++i) {
            jdbcStats[i] = new JDBCConnectionStatsImpl(this.m_jdbcDataSourceMBean, dmsStats[i]);
        }
        this.m_connectionStats = jdbcStats;
        JDBCConnectionPoolStatsImpl[] stats = new JDBCConnectionPoolStatsImpl[]{new JDBCConnectionPoolStatsImpl(this.m_jdbcDataSourceMBean, this.m_jdbcDataSourceMBean.getDmsConnectionPoolStats())};
        this.m_connectionPoolStats = stats;
    }

    public final JDBCConnectionStats[] getConnections() {
        return this.m_connectionStats;
    }

    public final JDBCConnectionPoolStats[] getConnectionPools() {
        return this.m_connectionPoolStats;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.m_connectionPoolStats != null && this.m_connectionPoolStats.length > 0) {
            ManagedJDBCDataSource jdbcDataSourceMBean = this.m_connectionPoolStats[0].getJdbcDataSourceMBean();
            if (jdbcDataSourceMBean != null) {
                buf.append("Connection Pool: " + jdbcDataSourceMBean.getConnectionPoolName() + "\n");
            }
            buf.append(this.m_connectionPoolStats[0].toString() + "\n\n");
        }
        if (this.m_connectionStats != null) {
            for (int i = 0; i < this.m_connectionStats.length; ++i) {
                buf.append("Connection " + i + "\n");
                buf.append(this.m_connectionStats[i].toString() + "\n\n");
            }
        }
        return buf.toString();
    }
}

