/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DocumentSemantics {
    private static final Class[] NO_ARG_CLASSES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("d-MMM-yyyy");

    public static void build(Document document, Object documentRoot, String documentName) {
        try {
            DocumentSemantics.interpretNode(DocumentSemantics.getRootNode(document), documentRoot);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error interpreting document: " + documentName + ": " + e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException("Error interpreting document: " + documentName + ": " + e);
        }
    }

    public static void build(Node rootNode, Object rootObject, String documentName) {
        try {
            DocumentSemantics.interpretNode(rootNode, rootObject);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error interpreting document: " + documentName + ": " + e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException("Error interpreting document: " + documentName + ": " + e);
        }
    }

    public static Node getRootNode(Document document) {
        Node node;
        for (node = document.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        if (node != null) {
            return node;
        }
        throw new RuntimeException("Document has no root node");
    }

    private static void interpretNode(Node node, Object elementObject) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> elementClass = elementObject.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(elementClass, Object.class);
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attribute = nnm.item(i);
                DocumentSemantics.setProperty(elementObject, beanInfo, DocumentSemantics.toPropertyName(attribute.getNodeName()), attribute.getNodeValue());
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 1) {
                DocumentSemantics.interpretNestedElement(elementClass, elementObject, beanInfo, child);
                continue;
            }
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            DocumentSemantics.setContentsAsProperty(elementObject, beanInfo, node, "text");
        }
    }

    private static String toPropertyName(String attributeName) {
        int index;
        if (attributeName.indexOf(45) < 0) {
            return attributeName;
        }
        while ((index = attributeName.indexOf(45)) > 0) {
            attributeName = attributeName.substring(0, index) + Character.toUpperCase(attributeName.charAt(index + 1)) + attributeName.substring(index + 2);
        }
        return attributeName;
    }

    private static void interpretNestedElement(Class elementClass, Object elementObject, BeanInfo beanInfo, Node child) throws IllegalAccessException, InvocationTargetException, IntrospectionException {
        try {
            Method method = elementClass.getMethod(DocumentSemantics.getCreateMethodName(child.getNodeName()), NO_ARG_CLASSES);
            Object subElement = method.invoke(elementObject, NO_ARGS);
            DocumentSemantics.interpretNode(child, subElement);
        }
        catch (NoSuchMethodException e) {
            DocumentSemantics.setContentsAsProperty(elementObject, beanInfo, child, DocumentSemantics.toPropertyName(child.getNodeName()));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private static String getCreateMethodName(String nodeName) {
        nodeName = DocumentSemantics.toPropertyName(nodeName);
        StringBuffer sb = new StringBuffer("create");
        sb.append(Character.toUpperCase(nodeName.charAt(0)));
        sb.append(nodeName.substring(1));
        return sb.toString();
    }

    private static void setContentsAsProperty(Object elementObject, BeanInfo beanInfo, Node propertyNode, String propertyName) throws IllegalAccessException, InvocationTargetException {
        for (Node child = propertyNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            DocumentSemantics.setProperty(elementObject, beanInfo, propertyName, child.getNodeValue().trim());
            return;
        }
    }

    private static void setProperty(Object elementObject, BeanInfo beanInfo, String propertyName, String propertyValue) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = DocumentSemantics.getProperty(beanInfo, propertyName);
        if (descriptor == null || descriptor.getWriteMethod() == null) {
            return;
        }
        Class<?> propertyType = descriptor.getPropertyType();
        Method writeMethod = descriptor.getWriteMethod();
        Object[] args = DocumentSemantics.toPropertyArgumentArray(propertyType, propertyValue);
        writeMethod.invoke(elementObject, args);
    }

    private static Object[] toPropertyArgumentArray(Class propertyType, String nodeValue) {
        if (propertyType.equals(String.class)) {
            return new Object[]{nodeValue};
        }
        if (propertyType.equals(Integer.TYPE)) {
            return new Object[]{new Integer(nodeValue)};
        }
        if (propertyType.equals(Date.class)) {
            return new Object[]{new Date(nodeValue)};
        }
        if (propertyType.equals(Boolean.TYPE)) {
            return new Object[]{Boolean.valueOf(nodeValue)};
        }
        throw new RuntimeException(propertyType + " attributes not supported");
    }

    public static PropertyDescriptor getProperty(BeanInfo beanInfo, String propertyName) {
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public static String getStringProperty(String propertyName, Object template) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(template.getClass(), Object.class);
            PropertyDescriptor propertyDescriptor = DocumentSemantics.getProperty(beanInfo, propertyName);
            if (propertyDescriptor == null) {
                return "";
            }
            Object result = propertyDescriptor.getReadMethod().invoke(template, NO_ARGS);
            if (result instanceof Date) {
                result = DATE_FORMAT.format((Date)result);
            }
            return result == null ? "" : result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to get '" + propertyName + "' property: " + e);
        }
    }

    public static Document parseDocument(File file) throws SAXException, IOException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to create a parser for XML documents: " + e);
        }
    }
}

