/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import com.evermind.naming.archive.ArchiveContext;
import com.evermind.util.LogEvent;
import com.evermind.util.ServerProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.util.FileLockUtil;

public class FileUtils {
    private static Logger m_logger = Logger.getLogger(FileUtils.class.getName());

    public static File[] listFilesOnly(File directory) {
        return FileUtils.listOnly(directory, true);
    }

    public static File[] listDirectoriesOnly(File directory) {
        return FileUtils.listOnly(directory, false);
    }

    private static File[] listOnly(File directory, boolean files) {
        if (directory.isFile()) {
            return new File[0];
        }
        File[] allFiles = directory.listFiles();
        ArrayList<File> list = new ArrayList<File>(allFiles.length);
        for (int i = 0; i < allFiles.length; ++i) {
            File file = allFiles[i];
            if (files) {
                if (!file.isFile()) continue;
                list.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        File[] result = new File[list.size()];
        list.toArray(result);
        return result;
    }

    public static void createNewFileRecursive(File destFile) throws IOException {
        FileUtils.createNewFileRecursive(destFile, null);
    }

    public static void createNewFileRecursive(File destFile, HashMap dirKeys) throws IOException {
        String fileName = destFile.getPath();
        StringBuffer partialPath = new StringBuffer("");
        ArrayList<String> pathList = new ArrayList<String>();
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            partialPath.append(fileName.charAt(0));
        }
        StringTokenizer st = new StringTokenizer(fileName, "/\\");
        int totalToken = st.countTokens();
        int num = 1;
        while (st.hasMoreTokens()) {
            partialPath.append(st.nextToken());
            if (totalToken > num) {
                pathList.add(partialPath.toString());
            }
            partialPath.append(File.separator);
            ++num;
        }
        FileUtils.recursiveCreateDirs(pathList, dirKeys);
        if (!destFile.createNewFile()) {
            throw new IOException("Cannot create file " + destFile.toString());
        }
    }

    private static void recursiveCreateDirs(ArrayList pathList, HashMap dirKeys) throws IOException {
        block8: {
            block7: {
                File file;
                ArrayList<String> neededmkdirList = new ArrayList<String>();
                for (int i = pathList.size(); i > 0; --i) {
                    String tempDir = (String)pathList.get(i - 1);
                    if (dirKeys != null && dirKeys.get(tempDir) != null) continue;
                    file = new File(tempDir);
                    if (file.isDirectory()) {
                        if (dirKeys == null) break;
                        dirKeys.put(tempDir, tempDir);
                        break;
                    }
                    neededmkdirList.add(tempDir);
                }
                if (neededmkdirList.isEmpty()) break block7;
                for (int j = neededmkdirList.size(); j > 0; --j) {
                    String neededDir = (String)neededmkdirList.get(j - 1);
                    file = new File(neededDir);
                    if (!file.mkdir()) {
                        throw new IOException("Cannot create directory " + file);
                    }
                    if (dirKeys == null) continue;
                    dirKeys.put(neededDir, neededDir);
                }
                break block8;
            }
            if (dirKeys != null && !dirKeys.isEmpty()) break block8;
            File file = new File((String)pathList.get(pathList.size() - 1));
            if (!file.mkdirs()) {
                throw new IOException("Cannot create directory " + file);
            }
            if (dirKeys != null) {
                for (int j = 0; j < pathList.size(); ++j) {
                    String createdDir = (String)pathList.get(j);
                    dirKeys.put(createdDir, createdDir);
                }
            }
        }
    }

    public static File createTempDir() throws IOException {
        try {
            File tmpFile = File.createTempFile("dir", "tmp");
            File tmpDir = new File(tmpFile.getAbsolutePath());
            tmpFile.delete();
            if (!tmpDir.mkdir()) {
                throw new IOException("Cannot create temp directory " + tmpDir.getAbsolutePath());
            }
            return tmpDir;
        }
        catch (Exception e) {
            throw new IOException("Cannot create temp directory: " + e.getMessage());
        }
    }

    public static void recursiveRemove(File file) throws IOException {
        boolean deleted;
        if (file == null) {
            if (ServerProperties.getApplicationServerDebug()) {
                System.err.println("FileUtils.recursiveRemove(): file is null");
            }
            return;
        }
        if (!file.exists()) {
            if (ServerProperties.getApplicationServerDebug()) {
                System.err.println("FileUtils.recursiveRemove(): file " + file.getAbsolutePath() + " does not exist");
            }
            return;
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.err.println("FileUtils.recursiveRemove(" + file.getAbsolutePath() + ")");
        }
        boolean success = true;
        if (file.isDirectory()) {
            File[] xfiles = file.listFiles();
            for (int i = 0; i < xfiles.length; ++i) {
                if (xfiles[i].isDirectory()) {
                    try {
                        FileUtils.recursiveRemove(xfiles[i]);
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    continue;
                }
                deleted = FileUtils.attemptDelete(xfiles[i]);
                if (deleted) continue;
                success = false;
            }
        }
        if (!(deleted = FileUtils.attemptDelete(file))) {
            success = false;
        }
        if (!success) {
            throw new IOException("Unable to remove " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unjar(File archive, String dirName) throws IllegalArgumentException, IOException, FileNotFoundException, SecurityException {
        File directory;
        if (m_logger.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "Unjar " + archive.getAbsolutePath() + " in " + dirName);
        }
        if ((directory = new File(dirName)).exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(dirName + " already exist, but is not a directory");
            }
        } else if (!directory.mkdir()) {
            throw new IOException("Cannot create directory " + dirName);
        }
        if (!directory.canWrite()) {
            throw new IOException("Cannot write to directory " + dirName);
        }
        if (dirName.charAt(dirName.length() - 1) != File.separatorChar) {
            dirName = dirName + File.separatorChar;
        }
        if (!archive.exists()) {
            throw new FileNotFoundException("Archive file " + archive + " does not exist");
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(archive);
            byte[] buf = new byte[4096];
            HashMap dirKeys = new HashMap();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                InputStream entryStream;
                block19: {
                    Object var14_13;
                    JarEntry entry = new JarEntry((ZipEntry)e.nextElement());
                    String entryName = dirName + entry.getName();
                    if (entry.isDirectory()) {
                        new File(entryName).mkdir();
                        continue;
                    }
                    File entryFile = new File(entryName);
                    if (!entryFile.exists()) {
                        FileUtils.createNewFileRecursive(entryFile, dirKeys);
                    }
                    entryStream = null;
                    FileOutputStream fileStream = null;
                    try {
                        int bytes;
                        entryStream = jarFile.getInputStream(entry);
                        fileStream = new FileOutputStream(entryFile);
                        while ((bytes = entryStream.read(buf)) != -1) {
                            fileStream.write(buf, 0, bytes);
                        }
                        var14_13 = null;
                        if (fileStream == null) break block19;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (entryStream == null) throw throwable;
                        entryStream.close();
                        throw throwable;
                        return;
                    }
                    fileStream.close();
                }
                if (entryStream == null) continue;
                entryStream.close();
                {
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void unjar(FileChannel channel, String dirName) throws IOException, IllegalArgumentException, FileNotFoundException, SecurityException {
        File directory = new File(dirName);
        HashMap dirKeys = new HashMap();
        byte[] buf = new byte[4096];
        ZipInputStream jarStream = null;
        try {
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    throw new IllegalArgumentException(dirName + " already exist, but is not a directory");
                }
            } else if (!directory.mkdir()) {
                throw new IOException("Cannot create directory " + dirName);
            }
            if (!directory.canWrite()) {
                throw new IOException("Cannot write to directory " + dirName);
            }
            if (dirName.charAt(dirName.length() - 1) != File.separatorChar) {
                dirName = dirName + File.separatorChar;
            }
            jarStream = new ZipInputStream(new BufferedInputStream(Channels.newInputStream(channel), buf.length));
            ZipEntry entry = jarStream.getNextEntry();
            while (entry != null) {
                String entryName = dirName + entry.getName();
                File entryFile = new File(entryName);
                if (entry.isDirectory()) {
                    entryFile.mkdir();
                } else {
                    if (!entryFile.exists()) {
                        FileUtils.createNewFileRecursive(entryFile, dirKeys);
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(entryFile);
                        int len = jarStream.read(buf, 0, buf.length);
                        while (len > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                            len = jarStream.read(buf, 0, buf.length);
                        }
                    }
                    finally {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                }
                jarStream.closeEntry();
                entry = jarStream.getNextEntry();
            }
            Object var13_12 = null;
            if (jarStream == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (jarStream == null) throw throwable;
            try {
                jarStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jarStream.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static URL autoUnpack(URL url, boolean unpack, com.evermind.util.Logger logger) {
        block70: {
            if (!unpack) {
                return url;
            }
            if (url.getProtocol().equals("file") && new File(url.getFile()).isDirectory()) {
                return url;
            }
            Notifier notifier = Notifier.getNotifier();
            if ((url.getFile().endsWith(".ear") || url.getFile().endsWith(".jar") || url.getFile().endsWith(".war") || url.getFile().endsWith(".rar")) && unpack) {
                IOException e922;
                FileLockUtil fileLockUtil;
                AbstractInterruptibleChannel archiveChannel;
                RandomAccessFile archiveAccess;
                File archiveFile;
                block66: {
                    String[] params;
                    String[] params2;
                    String name = url.getFile();
                    name = name.substring(0, name.lastIndexOf(46));
                    File target = new File(name);
                    archiveFile = new File(url.getFile());
                    unpack = false;
                    archiveAccess = null;
                    archiveChannel = null;
                    fileLockUtil = null;
                    int maxTryLockCount = ServerProperties.getAutoUnpackLockCount();
                    if (archiveFile.exists() && maxTryLockCount > -1) {
                        archiveAccess = new RandomAccessFile(archiveFile, "rw");
                        archiveChannel = archiveAccess.getChannel();
                        fileLockUtil = new FileLockUtil((FileChannel)archiveChannel, m_logger, maxTryLockCount);
                        try {
                            fileLockUtil.acquire();
                        }
                        catch (IOException e2) {
                            FileUtils.debugMessage("fileLockUtil.acquire() throws exception " + e2 + " for " + archiveFile.getName());
                            FileUtils.debugMessage("Continuing to autoUnpack without lock.");
                        }
                        if (!fileLockUtil.isLocked() && m_logger.isLoggable(Level.WARNING)) {
                            m_logger.log(Level.WARNING, "Failed to acquire lock for " + archiveFile + ". It may fail to share the application with multiple oc4j instances.");
                        }
                    }
                    if (!target.exists()) {
                        unpack = true;
                    } else if (target.lastModified() < archiveFile.lastModified()) {
                        unpack = true;
                        try {
                            if (notifier != null) {
                                try {
                                    params2 = new String[]{target.toString()};
                                    notifier.sendNotification("REMOVING_EVERYTHING_UNDER", params2);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            FileUtils.recursiveRemove(target);
                        }
                        catch (IOException e3) {
                            if (notifier != null) {
                                params = new String[]{target.toString()};
                                notifier.sendNotification("WARNING_APPLICATIONSERVER_AUTOUNPACK", params);
                            }
                            System.err.println("WARNING: FileUtils.autoUnpack(): " + e3.getMessage());
                        }
                    }
                    if (unpack && archiveFile.exists()) {
                        if (m_logger.isLoggable(Level.INFO)) {
                            m_logger.log(Level.INFO, "Auto-unpacking " + archiveFile + "... ");
                        }
                        if (logger != null) {
                            logger.log(new LogEvent("Auto-unpacking " + archiveFile + "... "));
                        }
                        target.mkdir();
                        try {
                            if (notifier != null) {
                                try {
                                    params2 = new String[]{archiveFile.getName()};
                                    notifier.sendNotification("UNPACKING", params2);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            if (archiveChannel != null) {
                                if (m_logger.isLoggable(Level.INFO)) {
                                    m_logger.log(Level.INFO, "Unjar " + archiveFile.getAbsolutePath() + " in " + target.getAbsolutePath());
                                }
                                FileUtils.unjar((FileChannel)archiveChannel, target.getAbsolutePath());
                            } else {
                                FileUtils.unjar(archiveFile, target.getAbsolutePath());
                            }
                            if (notifier != null) {
                                try {
                                    params2 = new String[]{archiveFile.getName()};
                                    notifier.sendNotification("DONE_UNPACKING", params2);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                            }
                            if (m_logger.isLoggable(Level.INFO)) {
                                m_logger.log(Level.INFO, "Finished auto-unpacking " + archiveFile);
                            }
                            if (logger != null) {
                                logger.log(new LogEvent("Auto-unpacking " + archiveFile + "... done."));
                            }
                        }
                        catch (IllegalArgumentException e4) {
                            if (notifier != null) {
                                params = new String[]{archiveFile.getName()};
                                notifier.sendNotification("ERROR_UNPACKING", params, e4);
                            }
                            System.err.println("Error unpacking: " + e4.getMessage());
                        }
                        catch (FileNotFoundException e5) {
                            if (notifier != null) {
                                params = new String[]{archiveFile.getName()};
                                notifier.sendNotification("ERROR_UNPACKING", params, e5);
                            }
                            System.err.println("Error unpacking: " + e5.getMessage());
                        }
                        catch (SecurityException e6) {
                            if (notifier != null) {
                                params = new String[]{archiveFile.getName()};
                                notifier.sendNotification("ERROR_UNPACKING", params, e6);
                            }
                            System.err.println("Error unpacking: " + e6.getMessage());
                        }
                        catch (IOException e7) {
                            if (notifier != null) {
                                params = new String[]{archiveFile.getName()};
                                notifier.sendNotification("ERROR_UNPACKING", params, e7);
                            }
                            System.err.println("Error unpacking: " + e7.getMessage());
                        }
                        target.setLastModified(archiveFile.lastModified());
                    }
                    try {
                        url = target.toURL();
                    }
                    catch (MalformedURLException e8) {
                    }
                    Object var14_25 = null;
                    if (fileLockUtil == null || !fileLockUtil.isLocked()) break block66;
                    try {
                        fileLockUtil.release();
                    }
                    catch (IOException e922) {
                        // empty catch block
                    }
                }
                if (archiveChannel != null) {
                    try {
                        archiveChannel.close();
                    }
                    catch (IOException e922) {
                        // empty catch block
                    }
                }
                if (archiveAccess != null) {
                    try {
                        archiveAccess.close();
                    }
                    catch (IOException e922) {}
                }
                break block70;
                {
                    catch (IOException e10) {
                        IOException e922;
                        if (notifier != null) {
                            String[] params = new String[]{archiveFile.getName()};
                            notifier.sendNotification("ERROR_UNPACKING", params, e10);
                        }
                        System.err.println("Error unpacking: " + e10.getMessage());
                        Object var14_26 = null;
                        if (fileLockUtil != null && fileLockUtil.isLocked()) {
                            try {
                                fileLockUtil.release();
                            }
                            catch (IOException e922) {
                                // empty catch block
                            }
                        }
                        if (archiveChannel != null) {
                            try {
                                archiveChannel.close();
                            }
                            catch (IOException e922) {
                                // empty catch block
                            }
                        }
                        if (archiveAccess != null) {
                            try {
                                archiveAccess.close();
                            }
                            catch (IOException e922) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException e922;
                    Object var14_27 = null;
                    if (fileLockUtil != null && fileLockUtil.isLocked()) {
                        try {
                            fileLockUtil.release();
                        }
                        catch (IOException e922) {
                            // empty catch block
                        }
                    }
                    if (archiveChannel != null) {
                        try {
                            archiveChannel.close();
                        }
                        catch (IOException e922) {
                            // empty catch block
                        }
                    }
                    if (archiveAccess != null) {
                        try {
                            archiveAccess.close();
                        }
                        catch (IOException e922) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        return url;
    }

    private static boolean attemptDelete(File xfile) {
        boolean closed = ArchiveContext.close(xfile);
        boolean deleted = xfile.delete();
        if (!deleted && ServerProperties.getApplicationServerDebug()) {
            System.err.print(xfile.getAbsolutePath() + " could not be deleted ...");
            System.err.print("ArchiveContext.close() returns " + closed);
            System.err.println(" Read: " + xfile.canRead() + " Write: " + xfile.canWrite());
            System.err.flush();
        }
        return deleted;
    }

    private static void debugMessage(String msg) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.err.println(msg);
        }
    }
}

