/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HexDisplay {
    public static InputStream wrap(InputStream is) {
        return new HexDisplayInputStream(is);
    }

    public static OutputStream wrap(OutputStream os) {
        return new HexDisplayOutputStream(os);
    }

    public static String format(byte[] bytes) {
        HexBuffer display = new HexBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            display.addByte(bytes[i]);
        }
        return display.toString();
    }

    public static class HexBuffer {
        private StringBuffer m_buffer = new StringBuffer("\n");
        private byte[] _bytes = new byte[32];
        private int _count;

        public String toString() {
            if (this._count != 0) {
                this.formatBytes();
            }
            return this.m_buffer.toString();
        }

        void addByte(byte b) {
            if (this._count == this._bytes.length) {
                this.formatBytes();
            }
            this._bytes[this._count++] = b;
        }

        private void formatBytes() {
            int i;
            for (i = 0; i < this._count; ++i) {
                byte aByte = this._bytes[i];
                this.formatOneByte(aByte);
                if (i % 8 != 7) continue;
                this.m_buffer.append(' ');
            }
            for (i = this._count; i < 32; ++i) {
                this.m_buffer.append("  ");
            }
            for (i = this._count / 8; i < 4; ++i) {
                this.m_buffer.append(' ');
            }
            this.m_buffer.append("  ");
            for (i = 0; i < this._count; ++i) {
                if (this._bytes[i] >= 32) continue;
                this._bytes[i] = 0;
            }
            this.m_buffer.append(new String(this._bytes, 0, this._count));
            this.m_buffer.append('\n');
            this._count = 0;
        }

        private void formatOneByte(byte aByte) {
            int value = aByte & 0xFF;
            if (value < 16) {
                this.m_buffer.append('0');
            }
            this.m_buffer.append(Integer.toHexString(value));
        }
    }

    private static class HexDisplayOutputStream
    extends OutputStream {
        private HexBuffer m_display = new HexBuffer();
        private OutputStream m_stream;

        public HexDisplayOutputStream(OutputStream stream) {
            this.m_stream = stream;
        }

        public void flush() throws IOException {
            this.m_stream.flush();
            System.out.println("flushing output stream:" + this.m_display);
            this.m_display = new HexBuffer();
        }

        public void close() throws IOException {
            this.m_stream.close();
            System.out.println("closing output stream:" + this.m_display);
        }

        public void write(int b) throws IOException {
            this.m_display.addByte((byte)b);
            this.m_stream.write(b);
        }
    }

    private static class HexDisplayInputStream
    extends BufferedInputStream {
        public HexDisplayInputStream(InputStream stream) {
            super(stream);
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int numRead = super.read(b, off, len);
            if (numRead <= 0) {
                return numRead;
            }
            HexBuffer display = new HexBuffer();
            for (int i = 0; i < numRead; ++i) {
                display.addByte(b[i + off]);
            }
            System.out.println("Read in (" + numRead + " bytes):" + display);
            return numRead;
        }
    }
}

